/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.driver;

import com.google.common.util.concurrent.SettableFuture;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.mpp.execution.driver.DataDriverContext;
import org.apache.iotdb.db.mpp.execution.driver.Driver;
import org.apache.iotdb.db.mpp.execution.driver.DriverContext;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.source.DataSourceOperator;

@NotThreadSafe
public class DataDriver
extends Driver {
    private boolean init;
    private final long estimatedMemorySize;

    public DataDriver(Operator root, DriverContext driverContext, long estimatedMemorySize) {
        super(root, driverContext);
        this.estimatedMemorySize = estimatedMemorySize;
    }

    @Override
    protected boolean init(SettableFuture<?> blockedFuture) {
        if (!this.init) {
            try {
                this.initialize();
            }
            catch (Throwable t) {
                LOGGER.error("Failed to do the initialization for driver {} ", (Object)this.driverContext.getDriverTaskID(), (Object)t);
                this.driverContext.failed(t);
                blockedFuture.setException(t);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() throws QueryProcessException {
        long startTime = System.nanoTime();
        try {
            List<DataSourceOperator> sourceOperators = ((DataDriverContext)this.driverContext).getSourceOperators();
            if (sourceOperators != null && !sourceOperators.isEmpty()) {
                QueryDataSource dataSource = this.initQueryDataSource();
                if (dataSource == null) {
                    throw new IllegalStateException("QueryDataSource should never be null!");
                }
                sourceOperators.forEach(sourceOperator -> {
                    QueryDataSource queryDataSource = new QueryDataSource(dataSource.getSeqResources(), dataSource.getUnseqResources());
                    queryDataSource.setDataTTL(dataSource.getDataTTL());
                    sourceOperator.initQueryDataSource(queryDataSource);
                });
            }
            this.init = true;
        }
        finally {
            this.QUERY_EXECUTION_METRICS.recordExecutionCost("query_resource_init", System.nanoTime() - startTime);
        }
    }

    @Override
    protected void releaseResource() {
        this.driverContext.getFragmentInstanceContext().decrementNumOfUnClosedDriver();
    }

    private QueryDataSource initQueryDataSource() throws QueryProcessException {
        return ((DataDriverContext)this.driverContext).getSharedQueryDataSource();
    }

    @Override
    public long getEstimatedMemorySize() {
        return this.estimatedMemorySize;
    }
}

