/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.execute.performer.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.execute.performer.ICrossCompactionPerformer;
import org.apache.iotdb.db.engine.compaction.execute.performer.ISeqCompactionPerformer;
import org.apache.iotdb.db.engine.compaction.execute.performer.IUnseqCompactionPerformer;
import org.apache.iotdb.db.engine.compaction.execute.task.CompactionTaskSummary;
import org.apache.iotdb.db.engine.compaction.execute.task.subtask.FastCompactionPerformerSubTask;
import org.apache.iotdb.db.engine.compaction.execute.task.subtask.FastCompactionTaskSummary;
import org.apache.iotdb.db.engine.compaction.execute.utils.CompactionUtils;
import org.apache.iotdb.db.engine.compaction.execute.utils.MultiTsFileDeviceIterator;
import org.apache.iotdb.db.engine.compaction.execute.utils.writer.AbstractCompactionWriter;
import org.apache.iotdb.db.engine.compaction.execute.utils.writer.FastCrossCompactionWriter;
import org.apache.iotdb.db.engine.compaction.execute.utils.writer.FastInnerCompactionWriter;
import org.apache.iotdb.db.engine.compaction.schedule.CompactionTaskManager;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.tsfile.exception.write.PageException;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastCompactionPerformer
implements ICrossCompactionPerformer,
ISeqCompactionPerformer,
IUnseqCompactionPerformer {
    private final Logger LOGGER = LoggerFactory.getLogger((String)"COMPACTION");
    private List<TsFileResource> seqFiles = Collections.emptyList();
    private List<TsFileResource> unseqFiles = Collections.emptyList();
    private List<TsFileResource> sortedSourceFiles = new ArrayList<TsFileResource>();
    private static final int subTaskNum = IoTDBDescriptor.getInstance().getConfig().getSubCompactionTaskNum();
    public Map<TsFileResource, TsFileSequenceReader> readerCacheMap = new ConcurrentHashMap<TsFileResource, TsFileSequenceReader>();
    private FastCompactionTaskSummary subTaskSummary;
    private List<TsFileResource> targetFiles;
    public Map<TsFileResource, List<Modification>> modificationCache = new ConcurrentHashMap<TsFileResource, List<Modification>>();
    private boolean isCrossCompaction;

    public FastCompactionPerformer(List<TsFileResource> seqFiles, List<TsFileResource> unseqFiles, List<TsFileResource> targetFiles) {
        this.seqFiles = seqFiles;
        this.unseqFiles = unseqFiles;
        this.targetFiles = targetFiles;
        this.isCrossCompaction = !seqFiles.isEmpty() && !unseqFiles.isEmpty();
    }

    public FastCompactionPerformer(boolean isCrossCompaction) {
        this.isCrossCompaction = isCrossCompaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform() throws Exception {
        this.subTaskSummary.setTemporalFileNum(this.targetFiles.size());
        try (MultiTsFileDeviceIterator deviceIterator = new MultiTsFileDeviceIterator(this.seqFiles, this.unseqFiles, this.readerCacheMap);
             AbstractCompactionWriter compactionWriter = this.isCrossCompaction ? new FastCrossCompactionWriter(this.targetFiles, this.seqFiles, this.readerCacheMap) : new FastInnerCompactionWriter(this.targetFiles.get(0));){
            while (deviceIterator.hasNextDevice()) {
                this.checkThreadInterrupted();
                Pair<String, Boolean> deviceInfo = deviceIterator.nextDevice();
                String device = (String)deviceInfo.left;
                boolean isAligned = (Boolean)deviceInfo.right;
                this.sortedSourceFiles.addAll(this.seqFiles);
                this.sortedSourceFiles.addAll(this.unseqFiles);
                this.sortedSourceFiles.removeIf(x -> !x.mayContainsDevice(device));
                this.sortedSourceFiles.sort(Comparator.comparingLong(x -> x.getStartTime(device)));
                compactionWriter.startChunkGroup(device, isAligned);
                if (isAligned) {
                    this.compactAlignedSeries(device, deviceIterator, compactionWriter);
                } else {
                    this.compactNonAlignedSeries(device, deviceIterator, compactionWriter);
                }
                compactionWriter.endChunkGroup();
                compactionWriter.checkAndMayFlushChunkMetadata();
                this.subTaskSummary.setTemporalFileSize(compactionWriter.getWriterSize());
                this.sortedSourceFiles.clear();
            }
            compactionWriter.endFile();
            CompactionUtils.updatePlanIndexes(this.targetFiles, this.seqFiles, this.unseqFiles);
        }
        finally {
            this.sortedSourceFiles = null;
            this.readerCacheMap = null;
            this.modificationCache = null;
        }
    }

    private void compactAlignedSeries(String deviceId, MultiTsFileDeviceIterator deviceIterator, AbstractCompactionWriter fastCrossCompactionWriter) throws PageException, IOException, WriteProcessException, IllegalPathException {
        LinkedHashMap<String, Map<TsFileResource, Pair<Long, Long>>> timeseriesMetadataOffsetMap = new LinkedHashMap<String, Map<TsFileResource, Pair<Long, Long>>>();
        ArrayList<IMeasurementSchema> measurementSchemas = new ArrayList<IMeasurementSchema>();
        for (Map.Entry<String, Pair<MeasurementSchema, Map<TsFileResource, Pair<Long, Long>>>> entry : deviceIterator.getTimeseriesSchemaAndMetadataOffsetOfCurrentDevice().entrySet()) {
            measurementSchemas.add((IMeasurementSchema)entry.getValue().left);
            timeseriesMetadataOffsetMap.put(entry.getKey(), (Map)entry.getValue().right);
        }
        FastCompactionTaskSummary taskSummary = new FastCompactionTaskSummary();
        new FastCompactionPerformerSubTask(fastCrossCompactionWriter, timeseriesMetadataOffsetMap, this.readerCacheMap, this.modificationCache, this.sortedSourceFiles, measurementSchemas, deviceId, taskSummary).call();
        this.subTaskSummary.increase(taskSummary);
    }

    private void compactNonAlignedSeries(String deviceID, MultiTsFileDeviceIterator deviceIterator, AbstractCompactionWriter fastCrossCompactionWriter) throws IOException, InterruptedException {
        int i;
        Map<String, Map<TsFileResource, Pair<Long, Long>>> timeseriesMetadataOffsetMap = deviceIterator.getTimeseriesMetadataOffsetOfCurrentDevice();
        ArrayList<String> allMeasurements = new ArrayList<String>(timeseriesMetadataOffsetMap.keySet());
        allMeasurements.sort(String::compareTo);
        int subTaskNums = Math.min(allMeasurements.size(), subTaskNum);
        ArrayList[] measurementsForEachSubTask = new ArrayList[subTaskNums];
        for (int idx = 0; idx < allMeasurements.size(); ++idx) {
            if (measurementsForEachSubTask[idx % subTaskNums] == null) {
                measurementsForEachSubTask[idx % subTaskNums] = new ArrayList();
            }
            measurementsForEachSubTask[idx % subTaskNums].add((String)allMeasurements.get(idx));
        }
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        ArrayList<FastCompactionTaskSummary> taskSummaryList = new ArrayList<FastCompactionTaskSummary>();
        for (i = 0; i < subTaskNums; ++i) {
            FastCompactionTaskSummary taskSummary = new FastCompactionTaskSummary();
            futures.add(CompactionTaskManager.getInstance().submitSubTask(new FastCompactionPerformerSubTask(fastCrossCompactionWriter, timeseriesMetadataOffsetMap, this.readerCacheMap, this.modificationCache, this.sortedSourceFiles, measurementsForEachSubTask[i], deviceID, taskSummary, i)));
            taskSummaryList.add(taskSummary);
        }
        for (i = 0; i < subTaskNums; ++i) {
            try {
                ((Future)futures.get(i)).get();
                this.subTaskSummary.increase((FastCompactionTaskSummary)taskSummaryList.get(i));
                continue;
            }
            catch (ExecutionException e) {
                this.LOGGER.error("[Compaction] SubCompactionTask meet errors ", (Throwable)e);
                throw new IOException(e);
            }
        }
    }

    @Override
    public void setTargetFiles(List<TsFileResource> targetFiles) {
        this.targetFiles = targetFiles;
    }

    @Override
    public void setSummary(CompactionTaskSummary summary) {
        if (!(summary instanceof FastCompactionTaskSummary)) {
            throw new RuntimeException("CompactionTaskSummary for FastCompactionPerformer should be FastCompactionTaskSummary");
        }
        this.subTaskSummary = (FastCompactionTaskSummary)summary;
    }

    @Override
    public void setSourceFiles(List<TsFileResource> seqFiles, List<TsFileResource> unseqFiles) {
        this.seqFiles = seqFiles;
        this.unseqFiles = unseqFiles;
    }

    private void checkThreadInterrupted() throws InterruptedException {
        if (Thread.interrupted() || this.subTaskSummary.isCancel()) {
            throw new InterruptedException(String.format("[Compaction] compaction for target file %s abort", this.targetFiles.toString()));
        }
    }

    public FastCompactionTaskSummary getSubTaskSummary() {
        return this.subTaskSummary;
    }

    public List<TsFileResource> getUnseqFiles() {
        return this.unseqFiles;
    }

    public List<TsFileResource> getSeqFiles() {
        return this.seqFiles;
    }

    @Override
    public void setSourceFiles(List<TsFileResource> unseqFiles) {
        this.seqFiles = unseqFiles;
    }
}

