/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.iot;

import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.consensus.iot.IoTConsensusServerImpl;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.impl.DoNothingMetricManager;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.type.Histogram;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class IoTConsensusServerMetrics
implements IMetricSet {
    private final IoTConsensusServerImpl impl;
    private Histogram getStateMachineLockHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram checkingBeforeWriteHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram writeStateMachineHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram offerRequestToQueueHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram consensusWriteHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;

    public IoTConsensusServerMetrics(IoTConsensusServerImpl impl) {
        this.impl = impl;
    }

    public void bindTo(AbstractMetricService metricService) {
        this.bindAutoGauge(metricService);
        this.bindStageHistogram(metricService);
    }

    public void unbindFrom(AbstractMetricService metricService) {
        this.unbindAutoGauge(metricService);
        this.unbindStageHistogram(metricService);
    }

    private void bindAutoGauge(AbstractMetricService metricService) {
        metricService.createAutoGauge(Metric.IOT_CONSENSUS.toString(), MetricLevel.IMPORTANT, (Object)this.impl, IoTConsensusServerImpl::getSearchIndex, new String[]{Tag.NAME.toString(), "ioTConsensusServerImpl", Tag.REGION.toString(), this.impl.getThisNode().getGroupId().toString(), Tag.TYPE.toString(), "searchIndex"});
        metricService.createAutoGauge(Metric.IOT_CONSENSUS.toString(), MetricLevel.IMPORTANT, (Object)this.impl, IoTConsensusServerImpl::getCurrentSafelyDeletedSearchIndex, new String[]{Tag.NAME.toString(), "ioTConsensusServerImpl", Tag.REGION.toString(), this.impl.getThisNode().getGroupId().toString(), Tag.TYPE.toString(), "safeIndex"});
        metricService.createAutoGauge(Metric.IOT_CONSENSUS.toString(), MetricLevel.IMPORTANT, (Object)this.impl, IoTConsensusServerImpl::getSyncLag, new String[]{Tag.NAME.toString(), "ioTConsensusServerImpl", Tag.REGION.toString(), this.impl.getThisNode().getGroupId().toString(), Tag.TYPE.toString(), "syncLag"});
        metricService.createAutoGauge(Metric.IOT_CONSENSUS.toString(), MetricLevel.IMPORTANT, (Object)this.impl, IoTConsensusServerImpl::getLogEntriesFromWAL, new String[]{Tag.NAME.toString(), "ioTConsensusServerImpl", Tag.REGION.toString(), this.impl.getThisNode().getGroupId().toString(), Tag.TYPE.toString(), "LogEntriesFromWAL"});
        metricService.createAutoGauge(Metric.IOT_CONSENSUS.toString(), MetricLevel.IMPORTANT, (Object)this.impl, IoTConsensusServerImpl::getLogEntriesFromQueue, new String[]{Tag.NAME.toString(), "ioTConsensusServerImpl", Tag.REGION.toString(), this.impl.getThisNode().getGroupId().toString(), Tag.TYPE.toString(), "LogEntriesFromQueue"});
    }

    private void bindStageHistogram(AbstractMetricService metricService) {
        this.getStateMachineLockHistogram = metricService.getOrCreateHistogram(Metric.STAGE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), Metric.IOT_CONSENSUS.toString(), Tag.TYPE.toString(), "getStateMachineLock", Tag.REGION.toString(), this.impl.getConsensusGroupId()});
        this.checkingBeforeWriteHistogram = metricService.getOrCreateHistogram(Metric.STAGE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), Metric.IOT_CONSENSUS.toString(), Tag.TYPE.toString(), "checkingBeforeWrite", Tag.REGION.toString(), this.impl.getConsensusGroupId()});
        this.writeStateMachineHistogram = metricService.getOrCreateHistogram(Metric.STAGE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), Metric.IOT_CONSENSUS.toString(), Tag.TYPE.toString(), "writeStateMachine", Tag.REGION.toString(), this.impl.getConsensusGroupId()});
        this.offerRequestToQueueHistogram = metricService.getOrCreateHistogram(Metric.STAGE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), Metric.IOT_CONSENSUS.toString(), Tag.TYPE.toString(), "offerRequestToQueue", Tag.REGION.toString(), this.impl.getConsensusGroupId()});
        this.consensusWriteHistogram = metricService.getOrCreateHistogram(Metric.STAGE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), Metric.IOT_CONSENSUS.toString(), Tag.TYPE.toString(), "consensusWrite", Tag.REGION.toString(), this.impl.getConsensusGroupId()});
    }

    private void unbindAutoGauge(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, Metric.IOT_CONSENSUS.toString(), new String[]{Tag.NAME.toString(), "ioTConsensusServerImpl", Tag.REGION.toString(), this.impl.getThisNode().getGroupId().toString(), Tag.TYPE.toString(), "searchIndex"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.IOT_CONSENSUS.toString(), new String[]{Tag.NAME.toString(), "ioTConsensusServerImpl", Tag.REGION.toString(), this.impl.getThisNode().getGroupId().toString(), Tag.TYPE.toString(), "safeIndex"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.IOT_CONSENSUS.toString(), new String[]{Tag.NAME.toString(), "ioTConsensusServerImpl", Tag.REGION.toString(), this.impl.getThisNode().getGroupId().toString(), Tag.TYPE.toString(), "syncLag"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.IOT_CONSENSUS.toString(), new String[]{Tag.NAME.toString(), "ioTConsensusServerImpl", Tag.REGION.toString(), this.impl.getThisNode().getGroupId().toString(), Tag.TYPE.toString(), "LogEntriesFromWAL"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.IOT_CONSENSUS.toString(), new String[]{Tag.NAME.toString(), "ioTConsensusServerImpl", Tag.REGION.toString(), this.impl.getThisNode().getGroupId().toString(), Tag.TYPE.toString(), "LogEntriesFromQueue"});
    }

    private void unbindStageHistogram(AbstractMetricService metricService) {
        this.getStateMachineLockHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
        this.checkingBeforeWriteHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
        this.writeStateMachineHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
        this.offerRequestToQueueHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
        this.consensusWriteHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
        metricService.remove(MetricType.HISTOGRAM, Metric.STAGE.toString(), new String[]{Tag.NAME.toString(), Metric.IOT_CONSENSUS.toString(), Tag.TYPE.toString(), "getStateMachineLock", Tag.REGION.toString(), this.impl.getConsensusGroupId()});
        metricService.remove(MetricType.HISTOGRAM, Metric.STAGE.toString(), new String[]{Tag.NAME.toString(), Metric.IOT_CONSENSUS.toString(), Tag.TYPE.toString(), "checkingBeforeWrite", Tag.REGION.toString(), this.impl.getConsensusGroupId()});
        metricService.remove(MetricType.HISTOGRAM, Metric.STAGE.toString(), new String[]{Tag.NAME.toString(), Metric.IOT_CONSENSUS.toString(), Tag.TYPE.toString(), "writeStateMachine", Tag.REGION.toString(), this.impl.getConsensusGroupId()});
        metricService.remove(MetricType.HISTOGRAM, Metric.STAGE.toString(), new String[]{Tag.NAME.toString(), Metric.IOT_CONSENSUS.toString(), Tag.TYPE.toString(), "offerRequestToQueue", Tag.REGION.toString(), this.impl.getConsensusGroupId()});
        metricService.remove(MetricType.HISTOGRAM, Metric.STAGE.toString(), new String[]{Tag.NAME.toString(), Metric.IOT_CONSENSUS.toString(), Tag.TYPE.toString(), "consensusWrite", Tag.REGION.toString(), this.impl.getConsensusGroupId()});
    }

    public void recordGetStateMachineLockTime(long time) {
        this.getStateMachineLockHistogram.update(time);
    }

    public void recordCheckingBeforeWriteTime(long time) {
        this.checkingBeforeWriteHistogram.update(time);
    }

    public void recordWriteStateMachineTime(long time) {
        this.writeStateMachineHistogram.update(time);
    }

    public void recordOfferRequestToQueueTime(long time) {
        this.offerRequestToQueueHistogram.update(time);
    }

    public void recordConsensusWriteTime(long time) {
        this.consensusWriteHistogram.update(time);
    }
}

