/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.view.viewExpression.leaf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpressionType;
import org.apache.iotdb.commons.schema.view.viewExpression.leaf.LeafViewOperand;
import org.apache.iotdb.commons.schema.view.viewExpression.visitor.ViewExpressionVisitor;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class TimeSeriesViewOperand
extends LeafViewOperand {
    private String pathString;

    public TimeSeriesViewOperand(String path) {
        this.pathString = path;
    }

    public TimeSeriesViewOperand(ByteBuffer byteBuffer) {
        this.pathString = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
    }

    public TimeSeriesViewOperand(InputStream inputStream) {
        try {
            this.pathString = ReadWriteIOUtils.readString((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <R, C> R accept(ViewExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitTimeSeriesOperand(this, context);
    }

    @Override
    public ViewExpressionType getExpressionType() {
        return ViewExpressionType.TIMESERIES;
    }

    @Override
    public String toString(boolean isRoot) {
        return this.pathString;
    }

    @Override
    protected void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((String)this.pathString, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serialize(OutputStream stream) throws IOException {
        ReadWriteIOUtils.write((String)this.pathString, (OutputStream)stream);
    }

    public String getPathString() {
        return this.pathString;
    }

    public void setPathString(String path) {
        this.pathString = path;
    }
}

