/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.path.fa.dfa;

import java.util.Objects;
import org.apache.iotdb.commons.path.fa.IFAState;

public class DFAState
implements IFAState {
    private final int index;
    private final boolean isFinal;

    public DFAState(int state) {
        this.index = state;
        this.isFinal = false;
    }

    public DFAState(int state, boolean isFinal) {
        this.index = state;
        this.isFinal = isFinal;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean isInitial() {
        return this.index == 0;
    }

    @Override
    public boolean isFinal() {
        return this.isFinal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DFAState state = (DFAState)o;
        return this.index == state.index && this.isFinal == state.isFinal;
    }

    public int hashCode() {
        return Objects.hash(this.index, this.isFinal);
    }
}

