/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.pipe;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.pipe.task.meta.PipeMeta;
import org.apache.iotdb.commons.pipe.task.meta.PipeMetaKeeper;
import org.apache.iotdb.commons.pipe.task.meta.PipeStatus;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.snapshot.SnapshotProcessor;
import org.apache.iotdb.confignode.consensus.request.write.pipe.runtime.PipeHandleLeaderChangePlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.runtime.PipeHandleMetaChangePlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.task.CreatePipePlanV2;
import org.apache.iotdb.confignode.consensus.request.write.pipe.task.DropPipePlanV2;
import org.apache.iotdb.confignode.consensus.request.write.pipe.task.SetPipeStatusPlanV2;
import org.apache.iotdb.confignode.consensus.response.pipe.task.PipeTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TCreatePipeReq;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeTaskInfo
implements SnapshotProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTaskInfo.class);
    private static final String SNAPSHOT_FILE_NAME = "pipe_task_info.bin";
    private final ReentrantLock pipeTaskInfoLock = new ReentrantLock(true);
    private final PipeMetaKeeper pipeMetaKeeper = new PipeMetaKeeper();

    public void acquirePipeTaskInfoLock() {
        this.pipeTaskInfoLock.lock();
    }

    public void releasePipeTaskInfoLock() {
        this.pipeTaskInfoLock.unlock();
    }

    public void checkBeforeCreatePipe(TCreatePipeReq createPipeRequest) throws PipeException {
        if (!this.isPipeExisted(createPipeRequest.getPipeName())) {
            return;
        }
        String exceptionMessage = String.format("Failed to create pipe %s, the pipe with the same name has been created", createPipeRequest.getPipeName());
        LOGGER.info(exceptionMessage);
        throw new PipeException(exceptionMessage);
    }

    public void checkBeforeStartPipe(String pipeName) throws PipeException {
        if (!this.isPipeExisted(pipeName)) {
            String exceptionMessage = String.format("Failed to start pipe %s, the pipe does not exist", pipeName);
            LOGGER.info(exceptionMessage);
            throw new PipeException(exceptionMessage);
        }
        PipeStatus pipeStatus = this.getPipeStatus(pipeName);
        if (pipeStatus == PipeStatus.RUNNING) {
            String exceptionMessage = String.format("Failed to start pipe %s, the pipe is already running", pipeName);
            LOGGER.info(exceptionMessage);
            throw new PipeException(exceptionMessage);
        }
        if (pipeStatus == PipeStatus.DROPPED) {
            String exceptionMessage = String.format("Failed to start pipe %s, the pipe is already dropped", pipeName);
            LOGGER.info(exceptionMessage);
            throw new PipeException(exceptionMessage);
        }
    }

    public void checkBeforeStopPipe(String pipeName) throws PipeException {
        if (!this.isPipeExisted(pipeName)) {
            String exceptionMessage = String.format("Failed to stop pipe %s, the pipe does not exist", pipeName);
            LOGGER.info(exceptionMessage);
            throw new PipeException(exceptionMessage);
        }
        PipeStatus pipeStatus = this.getPipeStatus(pipeName);
        if (pipeStatus == PipeStatus.STOPPED) {
            String exceptionMessage = String.format("Failed to stop pipe %s, the pipe is already stop", pipeName);
            LOGGER.info(exceptionMessage);
            throw new PipeException(exceptionMessage);
        }
        if (pipeStatus == PipeStatus.DROPPED) {
            String exceptionMessage = String.format("Failed to stop pipe %s, the pipe is already dropped", pipeName);
            LOGGER.info(exceptionMessage);
            throw new PipeException(exceptionMessage);
        }
    }

    public void checkBeforeDropPipe(String pipeName) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Check before drop pipe {}, pipe exists: {}.", (Object)pipeName, (Object)(this.isPipeExisted(pipeName) ? "true" : "false"));
        }
    }

    public boolean isPipeExisted(String pipeName) {
        return this.pipeMetaKeeper.containsPipeMeta(pipeName);
    }

    private PipeStatus getPipeStatus(String pipeName) {
        return (PipeStatus)this.pipeMetaKeeper.getPipeMeta(pipeName).getRuntimeMeta().getStatus().get();
    }

    public TSStatus createPipe(CreatePipePlanV2 plan) {
        this.pipeMetaKeeper.addPipeMeta(plan.getPipeStaticMeta().getPipeName(), new PipeMeta(plan.getPipeStaticMeta(), plan.getPipeRuntimeMeta()));
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    public TSStatus setPipeStatus(SetPipeStatusPlanV2 plan) {
        this.pipeMetaKeeper.getPipeMeta(plan.getPipeName()).getRuntimeMeta().getStatus().set(plan.getPipeStatus());
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    public TSStatus dropPipe(DropPipePlanV2 plan) {
        this.pipeMetaKeeper.removePipeMeta(plan.getPipeName());
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    public DataSet showPipes() {
        return new PipeTableResp(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()), StreamSupport.stream(this.getPipeMetaList().spliterator(), false).collect(Collectors.toList()));
    }

    public Iterable<PipeMeta> getPipeMetaList() {
        return this.pipeMetaKeeper.getPipeMetaList();
    }

    public boolean isEmpty() {
        return this.pipeMetaKeeper.isEmpty();
    }

    public TSStatus handleLeaderChange(PipeHandleLeaderChangePlan plan) {
        plan.getConsensusGroupId2NewDataRegionLeaderIdMap().forEach((dataRegionGroupId, newDataRegionLeader) -> this.pipeMetaKeeper.getPipeMetaList().forEach(pipeMeta -> {
            Map consensusGroupIdToTaskMetaMap = pipeMeta.getRuntimeMeta().getConsensusGroupIdToTaskMetaMap();
            if (consensusGroupIdToTaskMetaMap.containsKey(dataRegionGroupId)) {
                if (newDataRegionLeader != -1) {
                    ((PipeTaskMeta)consensusGroupIdToTaskMetaMap.get(dataRegionGroupId)).setLeaderDataNodeId(newDataRegionLeader.intValue());
                } else {
                    consensusGroupIdToTaskMetaMap.remove(dataRegionGroupId);
                }
            } else if (newDataRegionLeader != -1) {
                consensusGroupIdToTaskMetaMap.put(dataRegionGroupId, new PipeTaskMeta((ProgressIndex)new MinimumProgressIndex(), newDataRegionLeader.intValue()));
            }
        }));
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    public TSStatus handleMetaChanges(PipeHandleMetaChangePlan plan) {
        LOGGER.info("Handling pipe meta changes ...");
        this.pipeMetaKeeper.clear();
        plan.getPipeMetaList().forEach(pipeMeta -> {
            this.pipeMetaKeeper.addPipeMeta(pipeMeta.getStaticMeta().getPipeName(), pipeMeta);
            LOGGER.info("Recording pipe meta: {}", pipeMeta);
        });
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    public boolean processTakeSnapshot(File snapshotDir) throws IOException {
        File snapshotFile = new File(snapshotDir, SNAPSHOT_FILE_NAME);
        if (snapshotFile.exists() && snapshotFile.isFile()) {
            LOGGER.error("Failed to take snapshot, because snapshot file [{}] is already exist.", (Object)snapshotFile.getAbsolutePath());
            return false;
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(snapshotFile);){
            this.pipeMetaKeeper.processTakeSnapshot(fileOutputStream);
        }
        return true;
    }

    public void processLoadSnapshot(File snapshotDir) throws IOException {
        File snapshotFile = new File(snapshotDir, SNAPSHOT_FILE_NAME);
        if (!snapshotFile.exists() || !snapshotFile.isFile()) {
            LOGGER.error("Failed to load snapshot,snapshot file [{}] is not exist.", (Object)snapshotFile.getAbsolutePath());
            return;
        }
        try (FileInputStream fileInputStream = new FileInputStream(snapshotFile);){
            this.pipeMetaKeeper.processLoadSnapshot(fileInputStream);
        }
    }

    public int hashCode() {
        return this.pipeMetaKeeper.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PipeTaskInfo other = (PipeTaskInfo)obj;
        return this.pipeMetaKeeper.equals((Object)other.pipeMetaKeeper);
    }

    public String toString() {
        return this.pipeMetaKeeper.toString();
    }
}

