/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.read.partition;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.commons.utils.BasicStructureSerDeUtil;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.rpc.thrift.TDataPartitionReq;
import org.apache.iotdb.confignode.rpc.thrift.TTimeSlotList;

public class GetDataPartitionPlan
extends ConfigPhysicalPlan {
    protected Map<String, Map<TSeriesPartitionSlot, TTimeSlotList>> partitionSlotsMap;

    public GetDataPartitionPlan() {
        super(ConfigPhysicalPlanType.GetDataPartition);
    }

    public GetDataPartitionPlan(ConfigPhysicalPlanType configPhysicalPlanType) {
        super(configPhysicalPlanType);
    }

    public GetDataPartitionPlan(Map<String, Map<TSeriesPartitionSlot, TTimeSlotList>> partitionSlotsMap) {
        this();
        this.partitionSlotsMap = partitionSlotsMap;
    }

    public Map<String, Map<TSeriesPartitionSlot, TTimeSlotList>> getPartitionSlotsMap() {
        return this.partitionSlotsMap;
    }

    public static GetDataPartitionPlan convertFromRpcTDataPartitionReq(TDataPartitionReq req) {
        return new GetDataPartitionPlan(new ConcurrentHashMap<String, Map<TSeriesPartitionSlot, TTimeSlotList>>(req.getPartitionSlotsMap()));
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        stream.writeInt(this.partitionSlotsMap.size());
        for (Map.Entry<String, Map<TSeriesPartitionSlot, TTimeSlotList>> entry : this.partitionSlotsMap.entrySet()) {
            String storageGroup = entry.getKey();
            Map<TSeriesPartitionSlot, TTimeSlotList> seriesPartitionTimePartitionSlots = entry.getValue();
            BasicStructureSerDeUtil.write((String)storageGroup, (DataOutputStream)stream);
            stream.writeInt(seriesPartitionTimePartitionSlots.size());
            for (Map.Entry<TSeriesPartitionSlot, TTimeSlotList> e : seriesPartitionTimePartitionSlots.entrySet()) {
                TSeriesPartitionSlot seriesPartitionSlot = e.getKey();
                TTimeSlotList timePartitionSlotList = e.getValue();
                ThriftCommonsSerDeUtils.serializeTSeriesPartitionSlot((TSeriesPartitionSlot)seriesPartitionSlot, (DataOutputStream)stream);
                ThriftCommonsSerDeUtils.serializeTTimePartitionSlotList((TTimeSlotList)timePartitionSlotList, (DataOutputStream)stream);
            }
        }
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) {
        this.partitionSlotsMap = new HashMap<String, Map<TSeriesPartitionSlot, TTimeSlotList>>();
        int storageGroupNum = buffer.getInt();
        for (int i = 0; i < storageGroupNum; ++i) {
            String storageGroup = BasicStructureSerDeUtil.readString((ByteBuffer)buffer);
            this.partitionSlotsMap.put(storageGroup, new HashMap());
            int seriesPartitionSlotNum = buffer.getInt();
            for (int j = 0; j < seriesPartitionSlotNum; ++j) {
                TSeriesPartitionSlot seriesPartitionSlot = ThriftCommonsSerDeUtils.deserializeTSeriesPartitionSlot((ByteBuffer)buffer);
                TTimeSlotList timePartitionSlotList = ThriftCommonsSerDeUtils.deserializeTTimePartitionSlotList((ByteBuffer)buffer);
                this.partitionSlotsMap.get(storageGroup).put(seriesPartitionSlot, timePartitionSlotList);
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetDataPartitionPlan that = (GetDataPartitionPlan)o;
        return this.partitionSlotsMap.equals(that.partitionSlotsMap);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.partitionSlotsMap);
    }
}

