/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.compress.IUnCompressor;
import org.apache.iotdb.tsfile.encoding.decoder.Decoder;
import org.apache.iotdb.tsfile.exception.TsFileRuntimeException;
import org.apache.iotdb.tsfile.exception.TsFileStatisticsMistakesException;
import org.apache.iotdb.tsfile.file.header.ChunkGroupHeader;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.AlignedTimeSeriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.ChunkGroupMetadata;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.ITimeSeriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.MetadataIndexEntry;
import org.apache.iotdb.tsfile.file.metadata.MetadataIndexNode;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.TsFileMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.MetadataIndexNodeType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.TsFileDeviceIterator;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.controller.CachedChunkLoaderImpl;
import org.apache.iotdb.tsfile.read.controller.MetadataQuerierByFileImpl;
import org.apache.iotdb.tsfile.read.reader.TsFileInput;
import org.apache.iotdb.tsfile.read.reader.page.PageReader;
import org.apache.iotdb.tsfile.read.reader.page.TimePageReader;
import org.apache.iotdb.tsfile.read.reader.page.ValuePageReader;
import org.apache.iotdb.tsfile.utils.BloomFilter;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.ReadWriteForEncodingUtils;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileSequenceReader
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(TsFileSequenceReader.class);
    private static final Logger resourceLogger = LoggerFactory.getLogger((String)"FileMonitor");
    protected static final TSFileConfig config = TSFileDescriptor.getInstance().getConfig();
    private static final String METADATA_INDEX_NODE_DESERIALIZE_ERROR = "Something error happened while deserializing MetadataIndexNode of file {}";
    private static final int MAX_READ_BUFFER_SIZE = 0x400000;
    protected String file;
    protected TsFileInput tsFileInput;
    protected long fileMetadataPos;
    protected int fileMetadataSize;
    private ByteBuffer markerBuffer = ByteBuffer.allocate(1);
    protected volatile TsFileMetadata tsFileMetaData;
    private Map<String, Map<String, TimeseriesMetadata>> cachedDeviceMetadata = new ConcurrentHashMap<String, Map<String, TimeseriesMetadata>>();
    private static final ReadWriteLock cacheLock = new ReentrantReadWriteLock();
    private boolean cacheDeviceMetadata;
    private long minPlanIndex = Long.MAX_VALUE;
    private long maxPlanIndex = Long.MIN_VALUE;

    public TsFileSequenceReader(String file) throws IOException {
        this(file, true);
    }

    public TsFileSequenceReader(String file, boolean loadMetadataSize) throws IOException {
        if (resourceLogger.isDebugEnabled()) {
            resourceLogger.debug("{} reader is opened. {}", (Object)file, (Object)this.getClass().getName());
        }
        this.file = file;
        this.tsFileInput = FSFactoryProducer.getFileInputFactory().getTsFileInput(file);
        try {
            if (loadMetadataSize) {
                this.loadMetadataSize();
            }
        }
        catch (Throwable e) {
            this.tsFileInput.close();
            throw e;
        }
    }

    public TsFileSequenceReader(String file, boolean loadMetadata, boolean cacheDeviceMetadata) throws IOException {
        this(file, loadMetadata);
        this.cacheDeviceMetadata = cacheDeviceMetadata;
    }

    public TsFileSequenceReader(TsFileInput input) throws IOException {
        this(input, true);
    }

    public TsFileSequenceReader(TsFileInput input, boolean loadMetadataSize) throws IOException {
        this.tsFileInput = input;
        this.file = input.getFilePath();
        try {
            if (loadMetadataSize) {
                this.loadMetadataSize();
            }
        }
        catch (Throwable e) {
            this.tsFileInput.close();
            throw e;
        }
    }

    public TsFileSequenceReader(TsFileInput input, long fileMetadataPos, int fileMetadataSize) {
        this.tsFileInput = input;
        this.fileMetadataPos = fileMetadataPos;
        this.fileMetadataSize = fileMetadataSize;
    }

    public void loadMetadataSize() throws IOException {
        ByteBuffer metadataSize = ByteBuffer.allocate(4);
        if (this.readTailMagic().equals("TsFile")) {
            this.tsFileInput.read(metadataSize, this.tsFileInput.size() - (long)"TsFile".getBytes().length - 4L);
            metadataSize.flip();
            this.fileMetadataSize = ReadWriteIOUtils.readInt(metadataSize);
            this.fileMetadataPos = this.tsFileInput.size() - (long)"TsFile".getBytes().length - 4L - (long)this.fileMetadataSize;
        }
    }

    public long getFileMetadataPos() {
        return this.fileMetadataPos;
    }

    public int getTsFileMetadataSize() {
        return this.fileMetadataSize;
    }

    public long getFileMetadataSize() throws IOException {
        return this.tsFileInput.size() - this.getFileMetadataPos();
    }

    public String readTailMagic() throws IOException {
        long totalSize = this.tsFileInput.size();
        ByteBuffer magicStringBytes = ByteBuffer.allocate("TsFile".getBytes().length);
        this.tsFileInput.read(magicStringBytes, totalSize - (long)"TsFile".getBytes().length);
        magicStringBytes.flip();
        return new String(magicStringBytes.array());
    }

    public boolean isComplete() throws IOException {
        long size = this.tsFileInput.size();
        if (size >= (long)("TsFile".getBytes().length * 2 + 1)) {
            String tailMagic = this.readTailMagic();
            String headMagic = this.readHeadMagic();
            return tailMagic.equals(headMagic);
        }
        return false;
    }

    public String readHeadMagic() throws IOException {
        ByteBuffer magicStringBytes = ByteBuffer.allocate("TsFile".getBytes().length);
        this.tsFileInput.read(magicStringBytes, 0L);
        magicStringBytes.flip();
        return new String(magicStringBytes.array());
    }

    public byte readVersionNumber() throws IOException {
        ByteBuffer versionNumberByte = ByteBuffer.allocate(1);
        this.tsFileInput.read(versionNumberByte, "TsFile".getBytes().length);
        versionNumberByte.flip();
        return versionNumberByte.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TsFileMetadata readFileMetadata() throws IOException {
        block6: {
            try {
                if (this.tsFileMetaData != null) break block6;
                TsFileSequenceReader tsFileSequenceReader = this;
                synchronized (tsFileSequenceReader) {
                    if (this.tsFileMetaData == null) {
                        this.tsFileMetaData = TsFileMetadata.deserializeFrom(this.readData(this.fileMetadataPos, this.fileMetadataSize));
                    }
                }
            }
            catch (Exception e) {
                logger.error("Something error happened while reading file metadata of file {}", (Object)this.file);
                throw e;
            }
        }
        return this.tsFileMetaData;
    }

    public BloomFilter readBloomFilter() throws IOException {
        this.readFileMetadata();
        return this.tsFileMetaData.getBloomFilter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, TimeseriesMetadata> readDeviceMetadata(String device) throws IOException {
        if (!this.cacheDeviceMetadata) {
            return this.readDeviceMetadataFromDisk(device);
        }
        cacheLock.readLock().lock();
        try {
            if (this.cachedDeviceMetadata.containsKey(device)) {
                Map<String, TimeseriesMetadata> map = this.cachedDeviceMetadata.get(device);
                return map;
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
        cacheLock.writeLock().lock();
        try {
            if (this.cachedDeviceMetadata.containsKey(device)) {
                Map<String, TimeseriesMetadata> map = this.cachedDeviceMetadata.get(device);
                return map;
            }
            this.readFileMetadata();
            Map<String, TimeseriesMetadata> deviceMetadata = this.readDeviceMetadataFromDisk(device);
            this.cachedDeviceMetadata.put(device, deviceMetadata);
            Map<String, TimeseriesMetadata> map = deviceMetadata;
            return map;
        }
        finally {
            cacheLock.writeLock().unlock();
        }
    }

    private Map<String, TimeseriesMetadata> readDeviceMetadataFromDisk(String device) throws IOException {
        this.readFileMetadata();
        List<TimeseriesMetadata> timeseriesMetadataList = this.getDeviceTimeseriesMetadataWithoutChunkMetadata(device);
        HashMap<String, TimeseriesMetadata> deviceMetadata = new HashMap<String, TimeseriesMetadata>();
        for (TimeseriesMetadata timeseriesMetadata : timeseriesMetadataList) {
            deviceMetadata.put(timeseriesMetadata.getMeasurementId(), timeseriesMetadata);
        }
        return deviceMetadata;
    }

    public TimeseriesMetadata readTimeseriesMetadata(Path path, boolean ignoreNotExists) throws IOException {
        this.readFileMetadata();
        MetadataIndexNode deviceMetadataIndexNode = this.tsFileMetaData.getMetadataIndex();
        Pair<MetadataIndexEntry, Long> metadataIndexPair = this.getMetadataAndEndOffset(deviceMetadataIndexNode, path.getDevice(), true, true);
        if (metadataIndexPair == null) {
            if (ignoreNotExists) {
                return null;
            }
            throw new IOException("Device {" + path.getDevice() + "} is not in tsFileMetaData");
        }
        ByteBuffer buffer = this.readData(((MetadataIndexEntry)metadataIndexPair.left).getOffset(), (Long)metadataIndexPair.right);
        MetadataIndexNode metadataIndexNode = deviceMetadataIndexNode;
        if (!metadataIndexNode.getNodeType().equals((Object)MetadataIndexNodeType.LEAF_MEASUREMENT)) {
            try {
                metadataIndexNode = MetadataIndexNode.deserializeFrom(buffer);
            }
            catch (Exception e) {
                logger.error(METADATA_INDEX_NODE_DESERIALIZE_ERROR, (Object)this.file);
                throw e;
            }
            metadataIndexPair = this.getMetadataAndEndOffset(metadataIndexNode, path.getMeasurement(), false, false);
        }
        if (metadataIndexPair == null) {
            return null;
        }
        ArrayList<TimeseriesMetadata> timeseriesMetadataList = new ArrayList<TimeseriesMetadata>();
        buffer = this.readData(((MetadataIndexEntry)metadataIndexPair.left).getOffset(), (Long)metadataIndexPair.right);
        while (buffer.hasRemaining()) {
            try {
                timeseriesMetadataList.add(TimeseriesMetadata.deserializeFrom(buffer, true));
            }
            catch (Exception e) {
                logger.error("Something error happened while deserializing TimeseriesMetadata of file {}", (Object)this.file);
                throw e;
            }
        }
        int searchResult = this.binarySearchInTimeseriesMetadataList(timeseriesMetadataList, path.getMeasurement());
        return searchResult >= 0 ? (TimeseriesMetadata)timeseriesMetadataList.get(searchResult) : null;
    }

    public ITimeSeriesMetadata readITimeseriesMetadata(Path path, boolean ignoreNotExists) throws IOException {
        MetadataIndexNode metadataIndexNode;
        this.readFileMetadata();
        MetadataIndexNode deviceMetadataIndexNode = this.tsFileMetaData.getMetadataIndex();
        Pair<MetadataIndexEntry, Long> metadataIndexPair = this.getMetadataAndEndOffset(deviceMetadataIndexNode, path.getDevice(), true, true);
        if (metadataIndexPair == null) {
            if (ignoreNotExists) {
                return null;
            }
            throw new IOException("Device {" + path.getDevice() + "} is not in tsFileMetaData");
        }
        ByteBuffer buffer = this.readData(((MetadataIndexEntry)metadataIndexPair.left).getOffset(), (Long)metadataIndexPair.right);
        try {
            metadataIndexNode = MetadataIndexNode.deserializeFrom(buffer);
        }
        catch (Exception e) {
            logger.error(METADATA_INDEX_NODE_DESERIALIZE_ERROR, (Object)this.file);
            throw e;
        }
        TimeseriesMetadata firstTimeseriesMetadata = this.tryToGetFirstTimeseriesMetadata(metadataIndexNode);
        metadataIndexPair = this.getMetadataAndEndOffset(metadataIndexNode, path.getMeasurement(), false, false);
        if (metadataIndexPair == null) {
            return null;
        }
        ArrayList<TimeseriesMetadata> timeseriesMetadataList = new ArrayList<TimeseriesMetadata>();
        buffer = this.readData(((MetadataIndexEntry)metadataIndexPair.left).getOffset(), (Long)metadataIndexPair.right);
        while (buffer.hasRemaining()) {
            try {
                timeseriesMetadataList.add(TimeseriesMetadata.deserializeFrom(buffer, true));
            }
            catch (Exception e) {
                logger.error("Something error happened while deserializing TimeseriesMetadata of file {}", (Object)this.file);
                throw e;
            }
        }
        int searchResult = this.binarySearchInTimeseriesMetadataList(timeseriesMetadataList, path.getMeasurement());
        if (searchResult >= 0) {
            if (firstTimeseriesMetadata != null) {
                ArrayList<TimeseriesMetadata> valueTimeseriesMetadataList = new ArrayList<TimeseriesMetadata>();
                valueTimeseriesMetadataList.add((TimeseriesMetadata)timeseriesMetadataList.get(searchResult));
                return new AlignedTimeSeriesMetadata(firstTimeseriesMetadata, valueTimeseriesMetadataList);
            }
            return (ITimeSeriesMetadata)timeseriesMetadataList.get(searchResult);
        }
        return null;
    }

    public List<TimeseriesMetadata> readTimeseriesMetadata(Path path, Set<String> allSensors) throws IOException {
        Pair<MetadataIndexEntry, Long> metadataIndexPair = this.getLeafMetadataIndexPair(path);
        if (metadataIndexPair == null) {
            return Collections.emptyList();
        }
        ArrayList<TimeseriesMetadata> timeseriesMetadataList = new ArrayList<TimeseriesMetadata>();
        ByteBuffer buffer = this.readData(((MetadataIndexEntry)metadataIndexPair.left).getOffset(), (Long)metadataIndexPair.right);
        while (buffer.hasRemaining()) {
            TimeseriesMetadata timeseriesMetadata;
            try {
                timeseriesMetadata = TimeseriesMetadata.deserializeFrom(buffer, true);
            }
            catch (Exception e) {
                logger.error("Something error happened while deserializing TimeseriesMetadata of file {}", (Object)this.file);
                throw e;
            }
            if (!allSensors.contains(timeseriesMetadata.getMeasurementId())) continue;
            timeseriesMetadataList.add(timeseriesMetadata);
        }
        return timeseriesMetadataList;
    }

    private Pair<MetadataIndexEntry, Long> getLeafMetadataIndexPair(Path path) throws IOException {
        this.readFileMetadata();
        MetadataIndexNode deviceMetadataIndexNode = this.tsFileMetaData.getMetadataIndex();
        Pair<MetadataIndexEntry, Long> metadataIndexPair = this.getMetadataAndEndOffset(deviceMetadataIndexNode, path.getDevice(), true, true);
        if (metadataIndexPair == null) {
            return null;
        }
        ByteBuffer buffer = this.readData(((MetadataIndexEntry)metadataIndexPair.left).getOffset(), (Long)metadataIndexPair.right);
        MetadataIndexNode metadataIndexNode = deviceMetadataIndexNode;
        if (!metadataIndexNode.getNodeType().equals((Object)MetadataIndexNodeType.LEAF_MEASUREMENT)) {
            try {
                metadataIndexNode = MetadataIndexNode.deserializeFrom(buffer);
            }
            catch (Exception e) {
                logger.error(METADATA_INDEX_NODE_DESERIALIZE_ERROR, (Object)this.file);
                throw e;
            }
            metadataIndexPair = this.getMetadataAndEndOffset(metadataIndexNode, path.getMeasurement(), false, false);
        }
        return metadataIndexPair;
    }

    public List<ITimeSeriesMetadata> readITimeseriesMetadata(String device, Set<String> measurements) throws IOException {
        MetadataIndexNode measurementMetadataIndexNode;
        this.readFileMetadata();
        MetadataIndexNode deviceMetadataIndexNode = this.tsFileMetaData.getMetadataIndex();
        Pair<MetadataIndexEntry, Long> metadataIndexPair = this.getMetadataAndEndOffset(deviceMetadataIndexNode, device, true, false);
        if (metadataIndexPair == null) {
            return Collections.emptyList();
        }
        ArrayList<ITimeSeriesMetadata> resultTimeseriesMetadataList = new ArrayList<ITimeSeriesMetadata>();
        ArrayList<String> measurementList = new ArrayList<String>(measurements);
        HashSet<String> measurementsHadFound = new HashSet<String>();
        ByteBuffer buffer = this.readData(((MetadataIndexEntry)metadataIndexPair.left).getOffset(), (Long)metadataIndexPair.right);
        Pair<MetadataIndexEntry, Long> measurementMetadataIndexPair = metadataIndexPair;
        ArrayList<TimeseriesMetadata> timeseriesMetadataList = new ArrayList<TimeseriesMetadata>();
        try {
            measurementMetadataIndexNode = MetadataIndexNode.deserializeFrom(buffer);
        }
        catch (Exception e) {
            logger.error(METADATA_INDEX_NODE_DESERIALIZE_ERROR, (Object)this.file);
            throw e;
        }
        TimeseriesMetadata firstTimeseriesMetadata = this.tryToGetFirstTimeseriesMetadata(measurementMetadataIndexNode);
        for (int i = 0; i < measurementList.size(); ++i) {
            if (measurementsHadFound.contains(measurementList.get(i))) continue;
            timeseriesMetadataList.clear();
            measurementMetadataIndexPair = this.getMetadataAndEndOffset(measurementMetadataIndexNode, (String)measurementList.get(i), false, false);
            if (measurementMetadataIndexPair == null) continue;
            buffer = this.readData(((MetadataIndexEntry)measurementMetadataIndexPair.left).getOffset(), (Long)measurementMetadataIndexPair.right);
            while (buffer.hasRemaining()) {
                try {
                    timeseriesMetadataList.add(TimeseriesMetadata.deserializeFrom(buffer, true));
                }
                catch (Exception e) {
                    logger.error("Something error happened while deserializing TimeseriesMetadata of file {}", (Object)this.file);
                    throw e;
                }
            }
            for (int j = i; j < measurementList.size(); ++j) {
                int searchResult;
                String current = (String)measurementList.get(j);
                if (!measurementsHadFound.contains(current) && (searchResult = this.binarySearchInTimeseriesMetadataList(timeseriesMetadataList, current)) >= 0) {
                    if (firstTimeseriesMetadata != null) {
                        ArrayList<TimeseriesMetadata> valueTimeseriesMetadataList = new ArrayList<TimeseriesMetadata>();
                        valueTimeseriesMetadataList.add((TimeseriesMetadata)timeseriesMetadataList.get(searchResult));
                        resultTimeseriesMetadataList.add(new AlignedTimeSeriesMetadata(firstTimeseriesMetadata, valueTimeseriesMetadataList));
                    } else {
                        resultTimeseriesMetadataList.add((ITimeSeriesMetadata)timeseriesMetadataList.get(searchResult));
                    }
                    measurementsHadFound.add(current);
                }
                if (measurementsHadFound.size() != measurements.size()) continue;
                return resultTimeseriesMetadataList;
            }
        }
        return resultTimeseriesMetadataList;
    }

    protected int binarySearchInTimeseriesMetadataList(List<TimeseriesMetadata> timeseriesMetadataList, String key) {
        int low = 0;
        int high = timeseriesMetadataList.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            TimeseriesMetadata midVal = timeseriesMetadataList.get(mid);
            int cmp = midVal.getMeasurementId().compareTo(key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    public List<String> getAllDevices() throws IOException {
        if (this.tsFileMetaData == null) {
            this.readFileMetadata();
        }
        return this.getAllDevices(this.tsFileMetaData.getMetadataIndex());
    }

    private List<String> getAllDevices(MetadataIndexNode metadataIndexNode) throws IOException {
        ArrayList<String> deviceList = new ArrayList<String>();
        if (metadataIndexNode.getNodeType().equals((Object)MetadataIndexNodeType.LEAF_DEVICE)) {
            deviceList.addAll(metadataIndexNode.getChildren().stream().map(x -> x.getName().intern()).collect(Collectors.toList()));
            return deviceList;
        }
        int metadataIndexListSize = metadataIndexNode.getChildren().size();
        for (int i = 0; i < metadataIndexListSize; ++i) {
            long endOffset = metadataIndexNode.getEndOffset();
            if (i != metadataIndexListSize - 1) {
                endOffset = metadataIndexNode.getChildren().get(i + 1).getOffset();
            }
            ByteBuffer buffer = this.readData(metadataIndexNode.getChildren().get(i).getOffset(), endOffset);
            MetadataIndexNode node = MetadataIndexNode.deserializeFrom(buffer);
            deviceList.addAll(this.getAllDevices(node));
        }
        return deviceList;
    }

    public TsFileDeviceIterator getAllDevicesIteratorWithIsAligned() throws IOException {
        this.readFileMetadata();
        LinkedList<Pair<String, long[]>> queue = new LinkedList<Pair<String, long[]>>();
        ArrayList<long[]> leafDeviceNodeOffsets = new ArrayList<long[]>();
        MetadataIndexNode metadataIndexNode = this.tsFileMetaData.getMetadataIndex();
        if (metadataIndexNode.getNodeType().equals((Object)MetadataIndexNodeType.LEAF_DEVICE)) {
            this.getDevicesOfLeafNode(metadataIndexNode, queue);
        } else {
            this.getAllDeviceLeafNodeOffset(metadataIndexNode, leafDeviceNodeOffsets);
        }
        return new TsFileDeviceIterator(this, leafDeviceNodeOffsets, queue);
    }

    public void getDevicesAndEntriesOfOneLeafNode(Long startOffset, Long endOffset, Queue<Pair<String, long[]>> measurementNodeOffsetQueue) throws IOException {
        try {
            ByteBuffer nextBuffer = this.readData((long)startOffset, endOffset);
            MetadataIndexNode deviceLeafNode = MetadataIndexNode.deserializeFrom(nextBuffer);
            this.getDevicesOfLeafNode(deviceLeafNode, measurementNodeOffsetQueue);
        }
        catch (Exception e) {
            logger.error("Something error happened while getting all devices of file {}", (Object)this.file);
            throw e;
        }
    }

    private void getDevicesOfLeafNode(MetadataIndexNode deviceLeafNode, Queue<Pair<String, long[]>> measurementNodeOffsetQueue) {
        if (!deviceLeafNode.getNodeType().equals((Object)MetadataIndexNodeType.LEAF_DEVICE)) {
            throw new RuntimeException("the first param should be device leaf node.");
        }
        List<MetadataIndexEntry> childrenEntries = deviceLeafNode.getChildren();
        for (int i = 0; i < childrenEntries.size(); ++i) {
            MetadataIndexEntry deviceEntry = childrenEntries.get(i);
            long childStartOffset = deviceEntry.getOffset();
            long childEndOffset = i == childrenEntries.size() - 1 ? deviceLeafNode.getEndOffset() : childrenEntries.get(i + 1).getOffset();
            long[] offset = new long[]{childStartOffset, childEndOffset};
            measurementNodeOffsetQueue.add(new Pair<String, long[]>(deviceEntry.getName(), offset));
        }
    }

    private void getAllDeviceLeafNodeOffset(MetadataIndexNode deviceInternalNode, List<long[]> leafDeviceNodeOffsets) throws IOException {
        if (!deviceInternalNode.getNodeType().equals((Object)MetadataIndexNodeType.INTERNAL_DEVICE)) {
            throw new RuntimeException("the first param should be device internal node.");
        }
        try {
            int metadataIndexListSize = deviceInternalNode.getChildren().size();
            boolean isCurrentLayerLeafNode = false;
            for (int i = 0; i < metadataIndexListSize; ++i) {
                MetadataIndexEntry entry = deviceInternalNode.getChildren().get(i);
                long startOffset = entry.getOffset();
                long endOffset = deviceInternalNode.getEndOffset();
                if (i != metadataIndexListSize - 1) {
                    endOffset = deviceInternalNode.getChildren().get(i + 1).getOffset();
                }
                if (i == 0) {
                    MetadataIndexNodeType nodeType = MetadataIndexNodeType.deserialize(ReadWriteIOUtils.readByte(this.readData(endOffset - 1L, endOffset)));
                    isCurrentLayerLeafNode = nodeType.equals((Object)MetadataIndexNodeType.LEAF_DEVICE);
                }
                if (isCurrentLayerLeafNode) {
                    long[] offset = new long[]{startOffset, endOffset};
                    leafDeviceNodeOffsets.add(offset);
                    continue;
                }
                ByteBuffer nextBuffer = this.readData(startOffset, endOffset);
                this.getAllDeviceLeafNodeOffset(MetadataIndexNode.deserializeFrom(nextBuffer), leafDeviceNodeOffsets);
            }
        }
        catch (Exception e) {
            logger.error("Something error happened while getting all devices of file {}", (Object)this.file);
            throw e;
        }
    }

    public Map<String, List<ChunkMetadata>> readChunkMetadataInDevice(String device) throws IOException {
        this.readFileMetadata();
        List<TimeseriesMetadata> timeseriesMetadataMap = this.getDeviceTimeseriesMetadata(device);
        if (timeseriesMetadataMap.isEmpty()) {
            return new HashMap<String, List<ChunkMetadata>>();
        }
        LinkedHashMap<String, List<ChunkMetadata>> seriesMetadata = new LinkedHashMap<String, List<ChunkMetadata>>();
        for (TimeseriesMetadata timeseriesMetadata : timeseriesMetadataMap) {
            seriesMetadata.put(timeseriesMetadata.getMeasurementId(), timeseriesMetadata.getChunkMetadataList().stream().map(chunkMetadata -> (ChunkMetadata)chunkMetadata).collect(Collectors.toList()));
        }
        return seriesMetadata;
    }

    public List<Path> getAllPaths() throws IOException {
        ArrayList<Path> paths = new ArrayList<Path>();
        for (String device : this.getAllDevices()) {
            Map<String, TimeseriesMetadata> timeseriesMetadataMap = this.readDeviceMetadata(device);
            for (String measurementId : timeseriesMetadataMap.keySet()) {
                paths.add(new Path(device, measurementId, true));
            }
        }
        return paths;
    }

    public Iterator<List<Path>> getPathsIterator() throws IOException {
        this.readFileMetadata();
        MetadataIndexNode metadataIndexNode = this.tsFileMetaData.getMetadataIndex();
        List<MetadataIndexEntry> metadataIndexEntryList = metadataIndexNode.getChildren();
        final LinkedList<Pair<String, Pair<Long, Long>>> queue = new LinkedList<Pair<String, Pair<Long, Long>>>();
        for (int i = 0; i < metadataIndexEntryList.size(); ++i) {
            MetadataIndexEntry metadataIndexEntry = metadataIndexEntryList.get(i);
            long endOffset = metadataIndexNode.getEndOffset();
            if (i != metadataIndexEntryList.size() - 1) {
                endOffset = metadataIndexEntryList.get(i + 1).getOffset();
            }
            ByteBuffer buffer = this.readData(metadataIndexEntry.getOffset(), endOffset);
            this.getAllPaths(metadataIndexEntry, buffer, null, metadataIndexNode.getNodeType(), queue);
        }
        return new Iterator<List<Path>>(){

            @Override
            public boolean hasNext() {
                return !queue.isEmpty();
            }

            @Override
            public List<Path> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Pair startEndPair = (Pair)queue.remove();
                ArrayList<Path> paths = new ArrayList<Path>();
                try {
                    ByteBuffer nextBuffer = TsFileSequenceReader.this.readData((long)((Long)((Pair)startEndPair.right).left), (Long)((Pair)startEndPair.right).right);
                    while (nextBuffer.hasRemaining()) {
                        paths.add(new Path((String)startEndPair.left, TimeseriesMetadata.deserializeFrom(nextBuffer, false).getMeasurementId(), true));
                    }
                    return paths;
                }
                catch (IOException e) {
                    throw new TsFileRuntimeException("Error occurred while reading a time series metadata block.");
                }
            }
        };
    }

    private void getAllPaths(MetadataIndexEntry metadataIndex, ByteBuffer buffer, String deviceId, MetadataIndexNodeType type, Queue<Pair<String, Pair<Long, Long>>> queue) throws IOException {
        try {
            if (type.equals((Object)MetadataIndexNodeType.LEAF_DEVICE)) {
                deviceId = metadataIndex.getName();
            }
            MetadataIndexNode metadataIndexNode = MetadataIndexNode.deserializeFrom(buffer);
            int metadataIndexListSize = metadataIndexNode.getChildren().size();
            for (int i = 0; i < metadataIndexListSize; ++i) {
                long startOffset = metadataIndexNode.getChildren().get(i).getOffset();
                long endOffset = metadataIndexNode.getEndOffset();
                if (i != metadataIndexListSize - 1) {
                    endOffset = metadataIndexNode.getChildren().get(i + 1).getOffset();
                }
                if (metadataIndexNode.getNodeType().equals((Object)MetadataIndexNodeType.LEAF_MEASUREMENT)) {
                    queue.add(new Pair<String, Pair<Long, Long>>(deviceId, new Pair<Long, Long>(startOffset, endOffset)));
                    continue;
                }
                ByteBuffer nextBuffer = this.readData(metadataIndexNode.getChildren().get(i).getOffset(), endOffset);
                this.getAllPaths(metadataIndexNode.getChildren().get(i), nextBuffer, deviceId, metadataIndexNode.getNodeType(), queue);
            }
        }
        catch (Exception e) {
            logger.error("Something error happened while getting all paths of file {}", (Object)this.file);
            throw e;
        }
    }

    public boolean isAlignedDevice(MetadataIndexNode measurementNode) {
        return "".equals(measurementNode.getChildren().get(0).getName());
    }

    TimeseriesMetadata tryToGetFirstTimeseriesMetadata(MetadataIndexNode measurementNode) throws IOException {
        if (!"".equals(measurementNode.getChildren().get(0).getName())) {
            return null;
        }
        if (measurementNode.getNodeType().equals((Object)MetadataIndexNodeType.LEAF_MEASUREMENT)) {
            ByteBuffer buffer = measurementNode.getChildren().size() > 1 ? this.readData(measurementNode.getChildren().get(0).getOffset(), measurementNode.getChildren().get(1).getOffset()) : this.readData(measurementNode.getChildren().get(0).getOffset(), measurementNode.getEndOffset());
            return TimeseriesMetadata.deserializeFrom(buffer, true);
        }
        if (measurementNode.getNodeType().equals((Object)MetadataIndexNodeType.INTERNAL_MEASUREMENT)) {
            ByteBuffer buffer = this.readData(measurementNode.getChildren().get(0).getOffset(), measurementNode.getChildren().get(1).getOffset());
            MetadataIndexNode metadataIndexNode = MetadataIndexNode.deserializeFrom(buffer);
            return this.tryToGetFirstTimeseriesMetadata(metadataIndexNode);
        }
        return null;
    }

    public Map<String, Pair<List<IChunkMetadata>, Pair<Long, Long>>> getTimeseriesMetadataOffsetByDevice(MetadataIndexNode measurementNode, Set<String> excludedMeasurementIds, boolean needChunkMetadata) throws IOException {
        LinkedHashMap<String, Pair<List<IChunkMetadata>, Pair<Long, Long>>> timeseriesMetadataOffsetMap = new LinkedHashMap<String, Pair<List<IChunkMetadata>, Pair<Long, Long>>>();
        List<MetadataIndexEntry> childrenEntryList = measurementNode.getChildren();
        for (int i = 0; i < childrenEntryList.size(); ++i) {
            long startOffset = childrenEntryList.get(i).getOffset();
            long endOffset = i == childrenEntryList.size() - 1 ? measurementNode.getEndOffset() : childrenEntryList.get(i + 1).getOffset();
            ByteBuffer nextBuffer = this.readData(startOffset, endOffset);
            if (measurementNode.getNodeType().equals((Object)MetadataIndexNodeType.LEAF_MEASUREMENT)) {
                while (nextBuffer.hasRemaining()) {
                    int metadataStartOffset = nextBuffer.position();
                    TimeseriesMetadata timeseriesMetadata = TimeseriesMetadata.deserializeFrom(nextBuffer, excludedMeasurementIds, needChunkMetadata);
                    timeseriesMetadataOffsetMap.put(timeseriesMetadata.getMeasurementId(), new Pair<List<IChunkMetadata>, Pair<Long, Long>>(timeseriesMetadata.getChunkMetadataList(), new Pair<Long, Long>(startOffset + (long)metadataStartOffset, startOffset + (long)nextBuffer.position())));
                }
                continue;
            }
            MetadataIndexNode nextLayerMeasurementNode = MetadataIndexNode.deserializeFrom(nextBuffer);
            timeseriesMetadataOffsetMap.putAll(this.getTimeseriesMetadataOffsetByDevice(nextLayerMeasurementNode, excludedMeasurementIds, needChunkMetadata));
        }
        return timeseriesMetadataOffsetMap;
    }

    public List<IChunkMetadata> getChunkMetadataListByTimeseriesMetadataOffset(long startOffset, long endOffset) throws IOException {
        ByteBuffer timeseriesMetadataBuffer = this.readData(startOffset, endOffset);
        TimeseriesMetadata timeseriesMetadata = TimeseriesMetadata.deserializeFrom(timeseriesMetadataBuffer, true);
        return timeseriesMetadata.getChunkMetadataList();
    }

    public void getDeviceTimeseriesMetadata(List<TimeseriesMetadata> timeseriesMetadataList, MetadataIndexNode measurementNode, Set<String> excludedMeasurementIds, boolean needChunkMetadata) throws IOException {
        int metadataIndexListSize = measurementNode.getChildren().size();
        for (int i = 0; i < metadataIndexListSize; ++i) {
            long endOffset = measurementNode.getEndOffset();
            if (i != metadataIndexListSize - 1) {
                endOffset = measurementNode.getChildren().get(i + 1).getOffset();
            }
            ByteBuffer nextBuffer = this.readData(measurementNode.getChildren().get(i).getOffset(), endOffset);
            if (measurementNode.getNodeType().equals((Object)MetadataIndexNodeType.LEAF_MEASUREMENT)) {
                while (nextBuffer.hasRemaining()) {
                    TimeseriesMetadata timeseriesMetadata = TimeseriesMetadata.deserializeFrom(nextBuffer, excludedMeasurementIds, needChunkMetadata);
                    if (excludedMeasurementIds.contains(timeseriesMetadata.getMeasurementId())) continue;
                    timeseriesMetadataList.add(timeseriesMetadata);
                }
                continue;
            }
            MetadataIndexNode nextLayerMeasurementNode = MetadataIndexNode.deserializeFrom(nextBuffer);
            this.getDeviceTimeseriesMetadata(timeseriesMetadataList, nextLayerMeasurementNode, excludedMeasurementIds, needChunkMetadata);
        }
    }

    private void generateMetadataIndex(MetadataIndexEntry metadataIndex, ByteBuffer buffer, String deviceId, MetadataIndexNodeType type, Map<String, List<TimeseriesMetadata>> timeseriesMetadataMap, boolean needChunkMetadata) throws IOException {
        try {
            if (type.equals((Object)MetadataIndexNodeType.LEAF_MEASUREMENT)) {
                ArrayList<TimeseriesMetadata> timeseriesMetadataList = new ArrayList<TimeseriesMetadata>();
                while (buffer.hasRemaining()) {
                    timeseriesMetadataList.add(TimeseriesMetadata.deserializeFrom(buffer, needChunkMetadata));
                }
                timeseriesMetadataMap.computeIfAbsent(deviceId, k -> new ArrayList()).addAll(timeseriesMetadataList);
            } else {
                if (type.equals((Object)MetadataIndexNodeType.LEAF_DEVICE)) {
                    deviceId = metadataIndex.getName();
                }
                MetadataIndexNode metadataIndexNode = MetadataIndexNode.deserializeFrom(buffer);
                int metadataIndexListSize = metadataIndexNode.getChildren().size();
                for (int i = 0; i < metadataIndexListSize; ++i) {
                    long endOffset = metadataIndexNode.getEndOffset();
                    if (i != metadataIndexListSize - 1) {
                        endOffset = metadataIndexNode.getChildren().get(i + 1).getOffset();
                    }
                    ByteBuffer nextBuffer = this.readData(metadataIndexNode.getChildren().get(i).getOffset(), endOffset);
                    this.generateMetadataIndex(metadataIndexNode.getChildren().get(i), nextBuffer, deviceId, metadataIndexNode.getNodeType(), timeseriesMetadataMap, needChunkMetadata);
                }
            }
        }
        catch (Exception e) {
            logger.error("Something error happened while generating MetadataIndex of file {}", (Object)this.file);
            throw e;
        }
    }

    public Map<String, List<TimeseriesMetadata>> getAllTimeseriesMetadata(boolean needChunkMetadata) throws IOException {
        if (this.tsFileMetaData == null) {
            this.readFileMetadata();
        }
        HashMap<String, List<TimeseriesMetadata>> timeseriesMetadataMap = new HashMap<String, List<TimeseriesMetadata>>();
        MetadataIndexNode metadataIndexNode = this.tsFileMetaData.getMetadataIndex();
        List<MetadataIndexEntry> metadataIndexEntryList = metadataIndexNode.getChildren();
        for (int i = 0; i < metadataIndexEntryList.size(); ++i) {
            MetadataIndexEntry metadataIndexEntry = metadataIndexEntryList.get(i);
            long endOffset = metadataIndexNode.getEndOffset();
            if (i != metadataIndexEntryList.size() - 1) {
                endOffset = metadataIndexEntryList.get(i + 1).getOffset();
            }
            ByteBuffer buffer = this.readData(metadataIndexEntry.getOffset(), endOffset);
            this.generateMetadataIndex(metadataIndexEntry, buffer, null, metadataIndexNode.getNodeType(), timeseriesMetadataMap, needChunkMetadata);
        }
        return timeseriesMetadataMap;
    }

    private List<TimeseriesMetadata> getDeviceTimeseriesMetadataWithoutChunkMetadata(String device) throws IOException {
        MetadataIndexNode metadataIndexNode = this.tsFileMetaData.getMetadataIndex();
        Pair<MetadataIndexEntry, Long> metadataIndexPair = this.getMetadataAndEndOffset(metadataIndexNode, device, true, true);
        if (metadataIndexPair == null) {
            return Collections.emptyList();
        }
        ByteBuffer buffer = this.readData(((MetadataIndexEntry)metadataIndexPair.left).getOffset(), (Long)metadataIndexPair.right);
        TreeMap<String, List<TimeseriesMetadata>> timeseriesMetadataMap = new TreeMap<String, List<TimeseriesMetadata>>();
        this.generateMetadataIndex((MetadataIndexEntry)metadataIndexPair.left, buffer, device, MetadataIndexNodeType.INTERNAL_MEASUREMENT, timeseriesMetadataMap, false);
        ArrayList<TimeseriesMetadata> deviceTimeseriesMetadata = new ArrayList<TimeseriesMetadata>();
        for (List timeseriesMetadataList : timeseriesMetadataMap.values()) {
            deviceTimeseriesMetadata.addAll(timeseriesMetadataList);
        }
        return deviceTimeseriesMetadata;
    }

    private List<TimeseriesMetadata> getDeviceTimeseriesMetadata(String device) throws IOException {
        MetadataIndexNode metadataIndexNode = this.tsFileMetaData.getMetadataIndex();
        Pair<MetadataIndexEntry, Long> metadataIndexPair = this.getMetadataAndEndOffset(metadataIndexNode, device, true, true);
        if (metadataIndexPair == null) {
            return Collections.emptyList();
        }
        ByteBuffer buffer = this.readData(((MetadataIndexEntry)metadataIndexPair.left).getOffset(), (Long)metadataIndexPair.right);
        TreeMap<String, List<TimeseriesMetadata>> timeseriesMetadataMap = new TreeMap<String, List<TimeseriesMetadata>>();
        this.generateMetadataIndex((MetadataIndexEntry)metadataIndexPair.left, buffer, device, MetadataIndexNodeType.INTERNAL_MEASUREMENT, timeseriesMetadataMap, true);
        ArrayList<TimeseriesMetadata> deviceTimeseriesMetadata = new ArrayList<TimeseriesMetadata>();
        for (List timeseriesMetadataList : timeseriesMetadataMap.values()) {
            deviceTimeseriesMetadata.addAll(timeseriesMetadataList);
        }
        return deviceTimeseriesMetadata;
    }

    protected Pair<MetadataIndexEntry, Long> getMetadataAndEndOffset(MetadataIndexNode metadataIndex, String name, boolean isDeviceLevel, boolean exactSearch) throws IOException {
        try {
            if (isDeviceLevel && !metadataIndex.getNodeType().equals((Object)MetadataIndexNodeType.INTERNAL_DEVICE) || !isDeviceLevel && !metadataIndex.getNodeType().equals((Object)MetadataIndexNodeType.INTERNAL_MEASUREMENT)) {
                return metadataIndex.getChildIndexEntry(name, exactSearch);
            }
            Pair<MetadataIndexEntry, Long> childIndexEntry = metadataIndex.getChildIndexEntry(name, false);
            ByteBuffer buffer = this.readData(((MetadataIndexEntry)childIndexEntry.left).getOffset(), (Long)childIndexEntry.right);
            return this.getMetadataAndEndOffset(MetadataIndexNode.deserializeFrom(buffer), name, isDeviceLevel, exactSearch);
        }
        catch (Exception e) {
            logger.error("Something error happened while deserializing MetadataIndex of file {}", (Object)this.file);
            throw e;
        }
    }

    public ChunkGroupHeader readChunkGroupHeader() throws IOException {
        return ChunkGroupHeader.deserializeFrom(this.tsFileInput.wrapAsInputStream(), true);
    }

    public ChunkGroupHeader readChunkGroupHeader(long position, boolean markerRead) throws IOException {
        return ChunkGroupHeader.deserializeFrom(this.tsFileInput, position, markerRead);
    }

    public void readPlanIndex() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        if (ReadWriteIOUtils.readAsPossible(this.tsFileInput, buffer) == 0) {
            throw new IOException("reach the end of the file.");
        }
        buffer.flip();
        this.minPlanIndex = buffer.getLong();
        buffer.clear();
        if (ReadWriteIOUtils.readAsPossible(this.tsFileInput, buffer) == 0) {
            throw new IOException("reach the end of the file.");
        }
        buffer.flip();
        this.maxPlanIndex = buffer.getLong();
    }

    public ChunkHeader readChunkHeader(byte chunkType) throws IOException {
        try {
            return ChunkHeader.deserializeFrom(this.tsFileInput.wrapAsInputStream(), chunkType);
        }
        catch (Throwable t) {
            logger.warn("Exception {} happened while reading chunk header of {}", (Object)t.getMessage(), (Object)this.file);
            throw t;
        }
    }

    private ChunkHeader readChunkHeader(long position, int chunkHeaderSize) throws IOException {
        try {
            return ChunkHeader.deserializeFrom(this.tsFileInput, position, chunkHeaderSize);
        }
        catch (Throwable t) {
            logger.warn("Exception {} happened while reading chunk header of {}", (Object)t.getMessage(), (Object)this.file);
            throw t;
        }
    }

    public ByteBuffer readChunk(long position, int dataSize) throws IOException {
        try {
            return this.readData(position, dataSize);
        }
        catch (Throwable t) {
            logger.warn("Exception {} happened while reading chunk of {}", (Object)t.getMessage(), (Object)this.file);
            throw t;
        }
    }

    public Chunk readMemChunk(ChunkMetadata metaData) throws IOException {
        try {
            int chunkHeadSize = ChunkHeader.getSerializedSize(metaData.getMeasurementUid());
            ChunkHeader header = this.readChunkHeader(metaData.getOffsetOfChunkHeader(), chunkHeadSize);
            ByteBuffer buffer = this.readChunk(metaData.getOffsetOfChunkHeader() + (long)header.getSerializedSize(), header.getDataSize());
            return new Chunk(header, buffer, metaData.getDeleteIntervalList(), metaData.getStatistics());
        }
        catch (Throwable t) {
            logger.warn("Exception {} happened while reading chunk of {}", (Object)t.getMessage(), (Object)this.file);
            throw t;
        }
    }

    public Chunk readMemChunk(CachedChunkLoaderImpl.ChunkCacheKey chunkCacheKey) throws IOException {
        int chunkHeadSize = ChunkHeader.getSerializedSize(chunkCacheKey.getMeasurementUid());
        ChunkHeader header = this.readChunkHeader(chunkCacheKey.getOffsetOfChunkHeader(), chunkHeadSize);
        ByteBuffer buffer = this.readChunk(chunkCacheKey.getOffsetOfChunkHeader() + (long)header.getSerializedSize(), header.getDataSize());
        return new Chunk(header, buffer, chunkCacheKey.getDeleteIntervalList(), chunkCacheKey.getStatistics());
    }

    public Pair<CompressionType, TSEncoding> readTimeseriesCompressionTypeAndEncoding(TimeseriesMetadata timeseriesMetadata) throws IOException {
        String measurementId = timeseriesMetadata.getMeasurementId();
        int measurementIdLength = measurementId.getBytes(TSFileConfig.STRING_CHARSET).length;
        this.position(timeseriesMetadata.getChunkMetadataList().get(0).getOffsetOfChunkHeader() + 1L + (long)ReadWriteForEncodingUtils.varIntSize(measurementIdLength) + (long)measurementIdLength);
        return ChunkHeader.deserializeCompressionTypeAndEncoding(this.tsFileInput.wrapAsInputStream());
    }

    public MeasurementSchema getMeasurementSchema(List<IChunkMetadata> chunkMetadataList) throws IOException {
        if (chunkMetadataList.isEmpty()) {
            return null;
        }
        IChunkMetadata lastChunkMetadata = chunkMetadataList.get(chunkMetadataList.size() - 1);
        int chunkHeadSize = ChunkHeader.getSerializedSize(lastChunkMetadata.getMeasurementUid());
        ChunkHeader header = this.readChunkHeader(lastChunkMetadata.getOffsetOfChunkHeader(), chunkHeadSize);
        return new MeasurementSchema(lastChunkMetadata.getMeasurementUid(), header.getDataType(), header.getEncodingType(), header.getCompressionType());
    }

    public PageHeader readPageHeader(TSDataType type, boolean hasStatistic) throws IOException {
        try {
            return PageHeader.deserializeFrom(this.tsFileInput.wrapAsInputStream(), type, hasStatistic);
        }
        catch (Throwable t) {
            logger.warn("Exception {} happened while reading page header of {}", (Object)t.getMessage(), (Object)this.file);
            throw t;
        }
    }

    public long position() throws IOException {
        return this.tsFileInput.position();
    }

    public void position(long offset) throws IOException {
        this.tsFileInput.position(offset);
    }

    public void skipPageData(PageHeader header) throws IOException {
        this.tsFileInput.position(this.tsFileInput.position() + (long)header.getCompressedSize());
    }

    public ByteBuffer readCompressedPage(PageHeader header) throws IOException {
        return this.readData(-1L, header.getCompressedSize());
    }

    public ByteBuffer readPage(PageHeader header, CompressionType type) throws IOException {
        ByteBuffer buffer = this.readData(-1L, header.getCompressedSize());
        if (header.getUncompressedSize() == 0 || type == CompressionType.UNCOMPRESSED) {
            return buffer;
        }
        IUnCompressor unCompressor = IUnCompressor.getUnCompressor(type);
        ByteBuffer uncompressedBuffer = ByteBuffer.allocate(header.getUncompressedSize());
        unCompressor.uncompress(buffer.array(), buffer.position(), buffer.remaining(), uncompressedBuffer.array(), 0);
        return uncompressedBuffer;
    }

    public byte readMarker() throws IOException {
        this.markerBuffer.clear();
        if (ReadWriteIOUtils.readAsPossible(this.tsFileInput, this.markerBuffer) == 0) {
            throw new IOException("reach the end of the file.");
        }
        this.markerBuffer.flip();
        return this.markerBuffer.get();
    }

    @Override
    public void close() throws IOException {
        if (resourceLogger.isDebugEnabled()) {
            resourceLogger.debug("{} reader is closed.", (Object)this.file);
        }
        this.tsFileInput.close();
    }

    public String getFileName() {
        return this.file;
    }

    public long fileSize() throws IOException {
        return this.tsFileInput.size();
    }

    protected ByteBuffer readData(long position, int totalSize) throws IOException {
        int allocateSize = Math.min(0x400000, totalSize);
        int allocateNum = (int)Math.ceil((double)totalSize / (double)allocateSize);
        ByteBuffer buffer = ByteBuffer.allocate(totalSize);
        int bufferLimit = 0;
        for (int i = 0; i < allocateNum; ++i) {
            if (i == allocateNum - 1) {
                allocateSize = totalSize - allocateSize * (allocateNum - 1);
            }
            buffer.limit(bufferLimit += allocateSize);
            if (position < 0L) {
                if (ReadWriteIOUtils.readAsPossible(this.tsFileInput, buffer) == allocateSize) continue;
                throw new IOException("reach the end of the data");
            }
            long actualReadSize = ReadWriteIOUtils.readAsPossible(this.tsFileInput, buffer, position, allocateSize);
            if (actualReadSize != (long)allocateSize) {
                throw new IOException(String.format("reach the end of the data. Size of data that want to read: %s,actual read size: %s, position: %s", allocateSize, actualReadSize, position));
            }
            position += (long)allocateSize;
        }
        buffer.flip();
        return buffer;
    }

    protected ByteBuffer readData(long start, long end) throws IOException {
        try {
            return this.readData(start, (int)(end - start));
        }
        catch (Throwable t) {
            logger.warn("Exception {} happened while reading data of {}", (Object)t.getMessage(), (Object)this.file);
            throw t;
        }
    }

    public int readRaw(long position, int length, ByteBuffer target) throws IOException {
        return ReadWriteIOUtils.readAsPossible(this.tsFileInput, target, position, length);
    }

    public long selfCheck(Map<Path, IMeasurementSchema> newSchema, List<ChunkGroupMetadata> chunkGroupMetadataList, boolean fastFinish) throws IOException {
        File checkFile = FSFactoryProducer.getFSFactory().getFile(this.file);
        if (!checkFile.exists()) {
            return -3L;
        }
        long fileSize = checkFile.length();
        ArrayList<ChunkMetadata> chunkMetadataList = new ArrayList<ChunkMetadata>();
        int headerLength = "TsFile".getBytes().length + 1;
        if (fileSize < (long)headerLength) {
            return -2L;
        }
        if (!"TsFile".equals(this.readHeadMagic()) || 3 != this.readVersionNumber()) {
            return -2L;
        }
        this.tsFileInput.position(headerLength);
        boolean isComplete = this.isComplete();
        if (fileSize == (long)headerLength) {
            return headerLength;
        }
        if (isComplete) {
            this.loadMetadataSize();
            if (fastFinish) {
                return 0L;
            }
        }
        long truncatedSize = headerLength;
        ArrayList<long[]> timeBatch = new ArrayList<long[]>();
        String lastDeviceId = null;
        ArrayList<MeasurementSchema> measurementSchemaList = new ArrayList<MeasurementSchema>();
        try {
            byte marker;
            block23: while ((marker = this.readMarker()) != 2) {
                switch (marker) {
                    case -127: 
                    case -123: 
                    case 1: 
                    case 5: 
                    case 65: 
                    case 69: {
                        long fileOffsetOfChunk = this.position() - 1L;
                        ChunkHeader chunkHeader = this.readChunkHeader(marker);
                        String measurementID = chunkHeader.getMeasurementID();
                        MeasurementSchema measurementSchema = new MeasurementSchema(measurementID, chunkHeader.getDataType(), chunkHeader.getEncodingType(), chunkHeader.getCompressionType());
                        measurementSchemaList.add(measurementSchema);
                        TSDataType dataType = chunkHeader.getDataType();
                        if (chunkHeader.getDataType() == TSDataType.VECTOR) {
                            timeBatch.clear();
                        }
                        Statistics<Serializable> chunkStatistics = Statistics.getStatsByType(dataType);
                        int dataSize = chunkHeader.getDataSize();
                        if (dataSize > 0) {
                            Object pageHeader;
                            if ((byte)(chunkHeader.getChunkType() & 0x3F) == 1) {
                                while (dataSize > 0) {
                                    pageHeader = this.readPageHeader(chunkHeader.getDataType(), true);
                                    if (((PageHeader)pageHeader).getUncompressedSize() != 0) {
                                        chunkStatistics.mergeStatistics(((PageHeader)pageHeader).getStatistics());
                                    }
                                    this.skipPageData((PageHeader)pageHeader);
                                    dataSize -= ((PageHeader)pageHeader).getSerializedPageSize();
                                    chunkHeader.increasePageNums(1);
                                }
                            } else {
                                pageHeader = this.readPageHeader(chunkHeader.getDataType(), false);
                                Decoder decoder = Decoder.getDecoderByType(chunkHeader.getEncodingType(), chunkHeader.getDataType());
                                ByteBuffer byteBuffer = this.readPage((PageHeader)pageHeader, chunkHeader.getCompressionType());
                                Decoder timeDecoder = Decoder.getDecoderByType(TSEncoding.valueOf(TSFileDescriptor.getInstance().getConfig().getTimeEncoder()), TSDataType.INT64);
                                if ((chunkHeader.getChunkType() & 0xFFFFFF80) == -128) {
                                    TimePageReader timePageReader = new TimePageReader((PageHeader)pageHeader, byteBuffer, timeDecoder);
                                    long[] currentTimeBatch = timePageReader.getNextTimeBatch();
                                    timeBatch.add(currentTimeBatch);
                                    for (long currentTime : currentTimeBatch) {
                                        chunkStatistics.update(currentTime);
                                    }
                                } else if ((chunkHeader.getChunkType() & 0x40) == 64) {
                                    ValuePageReader valuePageReader = new ValuePageReader((PageHeader)pageHeader, byteBuffer, chunkHeader.getDataType(), decoder);
                                    TsPrimitiveType[] valueBatch = valuePageReader.nextValueBatch((long[])timeBatch.get(0));
                                    if (valueBatch != null && valueBatch.length != 0) {
                                        block26: for (int i = 0; i < valueBatch.length; ++i) {
                                            TsPrimitiveType value = valueBatch[i];
                                            if (value == null) continue;
                                            long timeStamp = ((long[])timeBatch.get(0))[i];
                                            switch (dataType) {
                                                case INT32: {
                                                    chunkStatistics.update(timeStamp, value.getInt());
                                                    continue block26;
                                                }
                                                case INT64: {
                                                    chunkStatistics.update(timeStamp, value.getLong());
                                                    continue block26;
                                                }
                                                case FLOAT: {
                                                    chunkStatistics.update(timeStamp, value.getFloat());
                                                    continue block26;
                                                }
                                                case DOUBLE: {
                                                    chunkStatistics.update(timeStamp, value.getDouble());
                                                    continue block26;
                                                }
                                                case BOOLEAN: {
                                                    chunkStatistics.update(timeStamp, value.getBoolean());
                                                    continue block26;
                                                }
                                                case TEXT: {
                                                    chunkStatistics.update(timeStamp, value.getBinary());
                                                    continue block26;
                                                }
                                                default: {
                                                    throw new IOException("Unexpected type " + (Object)((Object)dataType));
                                                }
                                            }
                                        }
                                    }
                                } else {
                                    PageReader reader = new PageReader((PageHeader)pageHeader, byteBuffer, chunkHeader.getDataType(), decoder, timeDecoder, null);
                                    BatchData batchData = reader.getAllSatisfiedPageData();
                                    while (batchData.hasCurrent()) {
                                        switch (dataType) {
                                            case INT32: {
                                                chunkStatistics.update(batchData.currentTime(), batchData.getInt());
                                                break;
                                            }
                                            case INT64: {
                                                chunkStatistics.update(batchData.currentTime(), batchData.getLong());
                                                break;
                                            }
                                            case FLOAT: {
                                                chunkStatistics.update(batchData.currentTime(), batchData.getFloat());
                                                break;
                                            }
                                            case DOUBLE: {
                                                chunkStatistics.update(batchData.currentTime(), batchData.getDouble());
                                                break;
                                            }
                                            case BOOLEAN: {
                                                chunkStatistics.update(batchData.currentTime(), batchData.getBoolean());
                                                break;
                                            }
                                            case TEXT: {
                                                chunkStatistics.update(batchData.currentTime(), batchData.getBinary());
                                                break;
                                            }
                                            default: {
                                                throw new IOException("Unexpected type " + (Object)((Object)dataType));
                                            }
                                        }
                                        batchData.next();
                                    }
                                }
                                chunkHeader.increasePageNums(1);
                            }
                        }
                        ChunkMetadata currentChunk = new ChunkMetadata(measurementID, dataType, fileOffsetOfChunk, chunkStatistics);
                        chunkMetadataList.add(currentChunk);
                        continue block23;
                    }
                    case 0: {
                        truncatedSize = this.position() - 1L;
                        if (lastDeviceId != null) {
                            if (newSchema != null) {
                                for (IMeasurementSchema iMeasurementSchema : measurementSchemaList) {
                                    newSchema.putIfAbsent(new Path(lastDeviceId, iMeasurementSchema.getMeasurementId(), true), iMeasurementSchema);
                                }
                            }
                            measurementSchemaList = new ArrayList();
                            chunkGroupMetadataList.add(new ChunkGroupMetadata(lastDeviceId, chunkMetadataList));
                        }
                        chunkMetadataList = new ArrayList();
                        ChunkGroupHeader chunkGroupHeader = this.readChunkGroupHeader();
                        lastDeviceId = chunkGroupHeader.getDeviceID();
                        continue block23;
                    }
                    case 4: {
                        truncatedSize = this.position() - 1L;
                        if (lastDeviceId != null) {
                            if (newSchema != null) {
                                for (IMeasurementSchema iMeasurementSchema : measurementSchemaList) {
                                    newSchema.putIfAbsent(new Path(lastDeviceId, iMeasurementSchema.getMeasurementId(), true), iMeasurementSchema);
                                }
                            }
                            measurementSchemaList = new ArrayList();
                            chunkGroupMetadataList.add(new ChunkGroupMetadata(lastDeviceId, chunkMetadataList));
                            lastDeviceId = null;
                        }
                        this.readPlanIndex();
                        truncatedSize = this.position();
                        continue block23;
                    }
                }
                throw new IOException("Unexpected marker " + marker);
            }
            if (lastDeviceId != null) {
                if (newSchema != null) {
                    for (IMeasurementSchema iMeasurementSchema : measurementSchemaList) {
                        newSchema.putIfAbsent(new Path(lastDeviceId, iMeasurementSchema.getMeasurementId(), true), iMeasurementSchema);
                    }
                }
                chunkGroupMetadataList.add(new ChunkGroupMetadata(lastDeviceId, chunkMetadataList));
            }
            truncatedSize = isComplete ? 0L : this.position() - 1L;
        }
        catch (Exception e) {
            logger.warn("TsFile {} self-check cannot proceed at position {} recovered, because : {}", new Object[]{this.file, this.position(), e.getMessage()});
        }
        return truncatedSize;
    }

    public long selfCheckWithInfo(String filename, boolean fastFinish, Map<Long, Pair<Path, TimeseriesMetadata>> timeseriesMetadataMap) throws IOException, TsFileStatisticsMistakesException {
        String message = " exists statistics mistakes at position ";
        File checkFile = FSFactoryProducer.getFSFactory().getFile(filename);
        if (!checkFile.exists()) {
            return -3L;
        }
        long fileSize = checkFile.length();
        logger.info("file length: " + fileSize);
        int headerLength = "TsFile".getBytes().length + 1;
        if (fileSize < (long)headerLength) {
            return -2L;
        }
        try {
            if (!"TsFile".equals(this.readHeadMagic()) || 3 != this.readVersionNumber()) {
                return -2L;
            }
            this.tsFileInput.position(headerLength);
            if (this.isComplete()) {
                this.loadMetadataSize();
                if (fastFinish) {
                    return 0L;
                }
            }
        }
        catch (IOException e) {
            logger.error("Error occurred while fast checking TsFile.");
            throw e;
        }
        for (Map.Entry<Long, Pair<Path, TimeseriesMetadata>> entry : timeseriesMetadataMap.entrySet()) {
            TimeseriesMetadata timeseriesMetadata = (TimeseriesMetadata)entry.getValue().right;
            TSDataType dataType = timeseriesMetadata.getTSDataType();
            Statistics<? extends Serializable> timeseriesMetadataSta = timeseriesMetadata.getStatistics();
            Statistics<Serializable> chunkMetadatasSta = Statistics.getStatsByType(dataType);
            for (IChunkMetadata iChunkMetadata : this.getChunkMetadataList((Path)entry.getValue().left)) {
                long tscheckStatus = 0L;
                try {
                    tscheckStatus = this.checkChunkAndPagesStatistics(iChunkMetadata);
                }
                catch (IOException e) {
                    logger.error("Error occurred while checking the statistics of chunk and its pages");
                    throw e;
                }
                if (tscheckStatus == -1L) {
                    throw new TsFileStatisticsMistakesException("Chunk" + message + iChunkMetadata.getOffsetOfChunkHeader());
                }
                chunkMetadatasSta.mergeStatistics(iChunkMetadata.getStatistics());
            }
            if (timeseriesMetadataSta.equals(chunkMetadatasSta)) continue;
            long timeseriesMetadataPos = entry.getKey();
            throw new TsFileStatisticsMistakesException("TimeseriesMetadata" + message + timeseriesMetadataPos);
        }
        return 0L;
    }

    public long checkChunkAndPagesStatistics(IChunkMetadata chunkMetadata) throws IOException {
        long offsetOfChunkHeader = chunkMetadata.getOffsetOfChunkHeader();
        this.tsFileInput.position(offsetOfChunkHeader);
        byte marker = this.readMarker();
        ChunkHeader chunkHeader = this.readChunkHeader(marker);
        TSDataType dataType = chunkHeader.getDataType();
        Statistics<Serializable> chunkStatistics = Statistics.getStatsByType(dataType);
        if ((byte)(chunkHeader.getChunkType() & 0x3F) == 1) {
            PageHeader pageHeader;
            for (int dataSize = chunkHeader.getDataSize(); dataSize > 0; dataSize -= pageHeader.getSerializedPageSize()) {
                pageHeader = this.readPageHeader(chunkHeader.getDataType(), true);
                chunkStatistics.mergeStatistics(pageHeader.getStatistics());
                this.skipPageData(pageHeader);
                chunkHeader.increasePageNums(1);
            }
        } else {
            PageHeader pageHeader = this.readPageHeader(chunkHeader.getDataType(), false);
            Decoder valueDecoder = Decoder.getDecoderByType(chunkHeader.getEncodingType(), chunkHeader.getDataType());
            ByteBuffer pageData = this.readPage(pageHeader, chunkHeader.getCompressionType());
            Decoder timeDecoder = Decoder.getDecoderByType(TSEncoding.valueOf(TSFileDescriptor.getInstance().getConfig().getTimeEncoder()), TSDataType.INT64);
            PageReader reader = new PageReader(pageHeader, pageData, chunkHeader.getDataType(), valueDecoder, timeDecoder, null);
            BatchData batchData = reader.getAllSatisfiedPageData();
            while (batchData.hasCurrent()) {
                switch (dataType) {
                    case INT32: {
                        chunkStatistics.update(batchData.currentTime(), batchData.getInt());
                        break;
                    }
                    case INT64: {
                        chunkStatistics.update(batchData.currentTime(), batchData.getLong());
                        break;
                    }
                    case FLOAT: {
                        chunkStatistics.update(batchData.currentTime(), batchData.getFloat());
                        break;
                    }
                    case DOUBLE: {
                        chunkStatistics.update(batchData.currentTime(), batchData.getDouble());
                        break;
                    }
                    case BOOLEAN: {
                        chunkStatistics.update(batchData.currentTime(), batchData.getBoolean());
                        break;
                    }
                    case TEXT: {
                        chunkStatistics.update(batchData.currentTime(), batchData.getBinary());
                        break;
                    }
                    default: {
                        throw new IOException("Unexpected type " + (Object)((Object)dataType));
                    }
                }
                batchData.next();
            }
            chunkHeader.increasePageNums(1);
        }
        if (chunkMetadata.getStatistics().equals(chunkStatistics)) {
            return 0L;
        }
        return -1L;
    }

    public List<ChunkMetadata> getChunkMetadataList(Path path, boolean ignoreNotExists) throws IOException {
        TimeseriesMetadata timeseriesMetaData = this.readTimeseriesMetadata(path, ignoreNotExists);
        if (timeseriesMetaData == null) {
            return Collections.emptyList();
        }
        List<ChunkMetadata> chunkMetadataList = this.readChunkMetaDataList(timeseriesMetaData);
        chunkMetadataList.sort(Comparator.comparingLong(IChunkMetadata::getStartTime));
        return chunkMetadataList;
    }

    public List<IChunkMetadata> getIChunkMetadataList(Path path) throws IOException {
        ITimeSeriesMetadata timeseriesMetaData = this.readITimeseriesMetadata(path, true);
        if (timeseriesMetaData == null) {
            return Collections.emptyList();
        }
        List<IChunkMetadata> chunkMetadataList = this.readIChunkMetaDataList(timeseriesMetaData);
        chunkMetadataList.sort(Comparator.comparingLong(IChunkMetadata::getStartTime));
        return chunkMetadataList;
    }

    public List<ChunkMetadata> getChunkMetadataList(Path path) throws IOException {
        return this.getChunkMetadataList(path, false);
    }

    public List<AlignedChunkMetadata> getAlignedChunkMetadata(String device) throws IOException {
        MetadataIndexNode metadataIndexNode;
        this.readFileMetadata();
        MetadataIndexNode deviceMetadataIndexNode = this.tsFileMetaData.getMetadataIndex();
        Pair<MetadataIndexEntry, Long> metadataIndexPair = this.getMetadataAndEndOffset(deviceMetadataIndexNode, device, true, true);
        if (metadataIndexPair == null) {
            throw new IOException("Device {" + device + "} is not in tsFileMetaData");
        }
        ByteBuffer buffer = this.readData(((MetadataIndexEntry)metadataIndexPair.left).getOffset(), (Long)metadataIndexPair.right);
        try {
            metadataIndexNode = MetadataIndexNode.deserializeFrom(buffer);
        }
        catch (Exception e) {
            logger.error(METADATA_INDEX_NODE_DESERIALIZE_ERROR, (Object)this.file);
            throw e;
        }
        TimeseriesMetadata firstTimeseriesMetadata = this.tryToGetFirstTimeseriesMetadata(metadataIndexNode);
        if (firstTimeseriesMetadata == null) {
            throw new IOException("Timeseries of device {" + device + "} are not aligned");
        }
        TreeMap<String, List<TimeseriesMetadata>> timeseriesMetadataMap = new TreeMap<String, List<TimeseriesMetadata>>();
        List<MetadataIndexEntry> metadataIndexEntryList = metadataIndexNode.getChildren();
        for (int i = 0; i < metadataIndexEntryList.size(); ++i) {
            MetadataIndexEntry metadataIndexEntry = metadataIndexEntryList.get(i);
            long endOffset = metadataIndexNode.getEndOffset();
            if (i != metadataIndexEntryList.size() - 1) {
                endOffset = metadataIndexEntryList.get(i + 1).getOffset();
            }
            buffer = this.readData(metadataIndexEntry.getOffset(), endOffset);
            if (metadataIndexNode.getNodeType().equals((Object)MetadataIndexNodeType.LEAF_MEASUREMENT)) {
                ArrayList<TimeseriesMetadata> timeseriesMetadataList = new ArrayList<TimeseriesMetadata>();
                while (buffer.hasRemaining()) {
                    timeseriesMetadataList.add(TimeseriesMetadata.deserializeFrom(buffer, true));
                }
                timeseriesMetadataMap.computeIfAbsent(device, k -> new ArrayList()).addAll(timeseriesMetadataList);
                continue;
            }
            this.generateMetadataIndex(metadataIndexEntry, buffer, device, metadataIndexNode.getNodeType(), timeseriesMetadataMap, true);
        }
        Iterator iterator = timeseriesMetadataMap.values().iterator();
        if (iterator.hasNext()) {
            List timeseriesMetadataList = (List)iterator.next();
            TimeseriesMetadata timeseriesMetadata = (TimeseriesMetadata)timeseriesMetadataList.get(0);
            ArrayList<TimeseriesMetadata> valueTimeseriesMetadataList = new ArrayList<TimeseriesMetadata>();
            for (int i = 1; i < timeseriesMetadataList.size(); ++i) {
                valueTimeseriesMetadataList.add((TimeseriesMetadata)timeseriesMetadataList.get(i));
            }
            AlignedTimeSeriesMetadata alignedTimeSeriesMetadata = new AlignedTimeSeriesMetadata(timeseriesMetadata, valueTimeseriesMetadataList);
            ArrayList<AlignedChunkMetadata> chunkMetadataList = new ArrayList<AlignedChunkMetadata>();
            for (IChunkMetadata chunkMetadata : this.readIChunkMetaDataList(alignedTimeSeriesMetadata)) {
                chunkMetadataList.add((AlignedChunkMetadata)chunkMetadata);
            }
            return chunkMetadataList;
        }
        throw new IOException(String.format("Error when reading timeseriesMetadata of device %s in file %s", device, this.file));
    }

    public List<ChunkMetadata> readChunkMetaDataList(TimeseriesMetadata timeseriesMetaData) throws IOException {
        return timeseriesMetaData.getChunkMetadataList().stream().map(chunkMetadata -> (ChunkMetadata)chunkMetadata).collect(Collectors.toList());
    }

    public List<IChunkMetadata> readIChunkMetaDataList(ITimeSeriesMetadata timeseriesMetaData) {
        if (timeseriesMetaData instanceof AlignedTimeSeriesMetadata) {
            return new ArrayList<IChunkMetadata>(((AlignedTimeSeriesMetadata)timeseriesMetaData).getChunkMetadataList());
        }
        return new ArrayList<IChunkMetadata>(((TimeseriesMetadata)timeseriesMetaData).getChunkMetadataList());
    }

    public Map<String, TSDataType> getAllMeasurements() throws IOException {
        HashMap<String, TSDataType> result = new HashMap<String, TSDataType>();
        for (String device : this.getAllDevices()) {
            Map<String, TimeseriesMetadata> timeseriesMetadataMap = this.readDeviceMetadata(device);
            for (TimeseriesMetadata timeseriesMetadata : timeseriesMetadataMap.values()) {
                result.put(timeseriesMetadata.getMeasurementId(), timeseriesMetadata.getTSDataType());
            }
        }
        return result;
    }

    public Map<String, TSDataType> getFullPathDataTypeMap() throws IOException {
        HashMap<String, TSDataType> result = new HashMap<String, TSDataType>();
        for (String device : this.getAllDevices()) {
            Map<String, TimeseriesMetadata> timeseriesMetadataMap = this.readDeviceMetadata(device);
            for (TimeseriesMetadata timeseriesMetadata : timeseriesMetadataMap.values()) {
                result.put(device + "." + timeseriesMetadata.getMeasurementId(), timeseriesMetadata.getTSDataType());
            }
        }
        return result;
    }

    public Map<String, List<String>> getDeviceMeasurementsMap() throws IOException {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (String device : this.getAllDevices()) {
            Map<String, TimeseriesMetadata> timeseriesMetadataMap = this.readDeviceMetadata(device);
            for (TimeseriesMetadata timeseriesMetadata : timeseriesMetadataMap.values()) {
                result.computeIfAbsent(device, d -> new ArrayList()).add(timeseriesMetadata.getMeasurementId());
            }
        }
        return result;
    }

    public List<String> getDeviceNameInRange(long start, long end) throws IOException {
        ArrayList<String> res = new ArrayList<String>();
        for (String device : this.getAllDevices()) {
            Map<String, List<ChunkMetadata>> seriesMetadataMap = this.readChunkMetadataInDevice(device);
            if (!this.hasDataInPartition(seriesMetadataMap, start, end)) continue;
            res.add(device);
        }
        return res;
    }

    public MetadataIndexNode getMetadataIndexNode(long startOffset, long endOffset) throws IOException {
        return MetadataIndexNode.deserializeFrom(this.readData(startOffset, endOffset));
    }

    private boolean hasDataInPartition(Map<String, List<ChunkMetadata>> seriesMetadataMap, long start, long end) {
        for (List<ChunkMetadata> chunkMetadataList : seriesMetadataMap.values()) {
            for (ChunkMetadata chunkMetadata : chunkMetadataList) {
                LocateStatus location = MetadataQuerierByFileImpl.checkLocateStatus(chunkMetadata, start, end);
                if (location != LocateStatus.in) continue;
                return true;
            }
        }
        return false;
    }

    public long getMinPlanIndex() {
        return this.minPlanIndex;
    }

    public long getMaxPlanIndex() {
        return this.maxPlanIndex;
    }

    public Iterator<Map<String, List<ChunkMetadata>>> getMeasurementChunkMetadataListMapIterator(String device) throws IOException {
        this.readFileMetadata();
        MetadataIndexNode metadataIndexNode = this.tsFileMetaData.getMetadataIndex();
        Pair<MetadataIndexEntry, Long> metadataIndexPair = this.getMetadataAndEndOffset(metadataIndexNode, device, true, true);
        if (metadataIndexPair == null) {
            return new Iterator<Map<String, List<ChunkMetadata>>>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public LinkedHashMap<String, List<ChunkMetadata>> next() {
                    throw new NoSuchElementException();
                }
            };
        }
        final LinkedList<Pair<Long, Long>> queue = new LinkedList<Pair<Long, Long>>();
        ByteBuffer buffer = this.readData(((MetadataIndexEntry)metadataIndexPair.left).getOffset(), (Long)metadataIndexPair.right);
        this.collectEachLeafMeasurementNodeOffsetRange(buffer, queue);
        return new Iterator<Map<String, List<ChunkMetadata>>>(){

            @Override
            public boolean hasNext() {
                return !queue.isEmpty();
            }

            @Override
            public LinkedHashMap<String, List<ChunkMetadata>> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Pair startEndPair = (Pair)queue.remove();
                LinkedHashMap<String, List<ChunkMetadata>> measurementChunkMetadataList = new LinkedHashMap<String, List<ChunkMetadata>>();
                try {
                    ArrayList<TimeseriesMetadata> timeseriesMetadataList = new ArrayList<TimeseriesMetadata>();
                    ByteBuffer nextBuffer = TsFileSequenceReader.this.readData((long)((Long)startEndPair.left), (Long)startEndPair.right);
                    while (nextBuffer.hasRemaining()) {
                        timeseriesMetadataList.add(TimeseriesMetadata.deserializeFrom(nextBuffer, true));
                    }
                    for (TimeseriesMetadata timeseriesMetadata : timeseriesMetadataList) {
                        List list = measurementChunkMetadataList.computeIfAbsent(timeseriesMetadata.getMeasurementId(), m -> new ArrayList());
                        for (IChunkMetadata chunkMetadata : timeseriesMetadata.getChunkMetadataList()) {
                            list.add((ChunkMetadata)chunkMetadata);
                        }
                    }
                    return measurementChunkMetadataList;
                }
                catch (IOException e) {
                    throw new TsFileRuntimeException("Error occurred while reading a time series metadata block.");
                }
            }
        };
    }

    private void collectEachLeafMeasurementNodeOffsetRange(ByteBuffer buffer, Queue<Pair<Long, Long>> queue) throws IOException {
        try {
            MetadataIndexNode metadataIndexNode = MetadataIndexNode.deserializeFrom(buffer);
            MetadataIndexNodeType metadataIndexNodeType = metadataIndexNode.getNodeType();
            int metadataIndexListSize = metadataIndexNode.getChildren().size();
            for (int i = 0; i < metadataIndexListSize; ++i) {
                long startOffset = metadataIndexNode.getChildren().get(i).getOffset();
                long endOffset = metadataIndexNode.getEndOffset();
                if (i != metadataIndexListSize - 1) {
                    endOffset = metadataIndexNode.getChildren().get(i + 1).getOffset();
                }
                if (metadataIndexNodeType.equals((Object)MetadataIndexNodeType.LEAF_MEASUREMENT)) {
                    queue.add(new Pair<Long, Long>(startOffset, endOffset));
                    continue;
                }
                this.collectEachLeafMeasurementNodeOffsetRange(this.readData(startOffset, endOffset), queue);
            }
        }
        catch (Exception e) {
            logger.error("Error occurred while collecting offset ranges of measurement nodes of file {}", (Object)this.file);
            throw e;
        }
    }

    public MetadataIndexNode readMetadataIndexNode(long start, long end) throws IOException {
        return MetadataIndexNode.deserializeFrom(this.readData(start, end));
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public static enum LocateStatus {
        in,
        before,
        after;

    }
}

