/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session.pool;

import java.io.IOException;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentMap;
import org.apache.iotdb.common.rpc.thrift.TAggregationType;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.isession.ISession;
import org.apache.iotdb.isession.SessionConfig;
import org.apache.iotdb.isession.SessionDataSet;
import org.apache.iotdb.isession.pool.ISessionPool;
import org.apache.iotdb.isession.pool.SessionDataSetWrapper;
import org.apache.iotdb.isession.template.Template;
import org.apache.iotdb.isession.util.Version;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.service.rpc.thrift.TSBackupConfigurationResp;
import org.apache.iotdb.service.rpc.thrift.TSConnectionInfoResp;
import org.apache.iotdb.session.Session;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.write.record.Tablet;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionPool
implements ISessionPool {
    private static final Logger logger = LoggerFactory.getLogger(SessionPool.class);
    public static final String SESSION_POOL_IS_CLOSED = "Session pool is closed";
    public static final String CLOSE_THE_SESSION_FAILED = "close the session failed.";
    private static final int RETRY = 3;
    private static final int FINAL_RETRY = 2;
    private final ConcurrentLinkedDeque<ISession> queue = new ConcurrentLinkedDeque();
    private final ConcurrentMap<ISession, ISession> occupied = new ConcurrentHashMap<ISession, ISession>();
    private int size = 0;
    private int maxSize = 0;
    private final long waitToGetSessionTimeoutInMs;
    private final String host;
    private final int port;
    private final String user;
    private final String password;
    private int fetchSize;
    private ZoneId zoneId;
    private boolean enableRedirection;
    private boolean enableQueryRedirection = false;
    private Map<String, TEndPoint> deviceIdToEndpoint;
    private int thriftDefaultBufferSize;
    private int thriftMaxFrameSize;
    private long queryTimeoutInMs = -1L;
    private Version version;
    private final int connectionTimeoutInMs;
    private final boolean enableCompression;
    private boolean closed;
    private final List<String> nodeUrls;
    private final String formattedNodeUrls;

    public SessionPool(String host, int port, String user, String password, int maxSize) {
        this(host, port, user, password, maxSize, 5000, 60000L, false, null, true, 0, SessionConfig.DEFAULT_VERSION, 1024, 0x4000000);
    }

    public SessionPool(List<String> nodeUrls, String user, String password, int maxSize) {
        this(nodeUrls, user, password, maxSize, 5000, 60000L, false, null, true, 0, SessionConfig.DEFAULT_VERSION, 1024, 0x4000000);
    }

    public SessionPool(String host, int port, String user, String password, int maxSize, boolean enableCompression) {
        this(host, port, user, password, maxSize, 5000, 60000L, enableCompression, null, true, 0, SessionConfig.DEFAULT_VERSION, 1024, 0x4000000);
    }

    public SessionPool(List<String> nodeUrls, String user, String password, int maxSize, boolean enableCompression) {
        this(nodeUrls, user, password, maxSize, 5000, 60000L, enableCompression, null, true, 0, SessionConfig.DEFAULT_VERSION, 1024, 0x4000000);
    }

    public SessionPool(String host, int port, String user, String password, int maxSize, boolean enableCompression, boolean enableRedirection) {
        this(host, port, user, password, maxSize, 5000, 60000L, enableCompression, null, enableRedirection, 0, SessionConfig.DEFAULT_VERSION, 1024, 0x4000000);
    }

    public SessionPool(List<String> nodeUrls, String user, String password, int maxSize, boolean enableCompression, boolean enableRedirection) {
        this(nodeUrls, user, password, maxSize, 5000, 60000L, enableCompression, null, enableRedirection, 0, SessionConfig.DEFAULT_VERSION, 1024, 0x4000000);
    }

    public SessionPool(String host, int port, String user, String password, int maxSize, ZoneId zoneId) {
        this(host, port, user, password, maxSize, 5000, 60000L, false, zoneId, true, 0, SessionConfig.DEFAULT_VERSION, 1024, 0x4000000);
    }

    public SessionPool(List<String> nodeUrls, String user, String password, int maxSize, ZoneId zoneId) {
        this(nodeUrls, user, password, maxSize, 5000, 60000L, false, zoneId, true, 0, SessionConfig.DEFAULT_VERSION, 1024, 0x4000000);
    }

    public SessionPool(String host, int port, String user, String password, int maxSize, int fetchSize, long waitToGetSessionTimeoutInMs, boolean enableCompression, ZoneId zoneId, boolean enableRedirection, int connectionTimeoutInMs, Version version, int thriftDefaultBufferSize, int thriftMaxFrameSize) {
        this.maxSize = maxSize;
        this.host = host;
        this.port = port;
        this.nodeUrls = null;
        this.user = user;
        this.password = password;
        this.fetchSize = fetchSize;
        this.waitToGetSessionTimeoutInMs = waitToGetSessionTimeoutInMs;
        this.enableCompression = enableCompression;
        this.zoneId = zoneId;
        this.enableRedirection = enableRedirection;
        if (this.enableRedirection) {
            this.deviceIdToEndpoint = new ConcurrentHashMap<String, TEndPoint>();
        }
        this.connectionTimeoutInMs = connectionTimeoutInMs;
        this.version = version;
        this.thriftDefaultBufferSize = thriftDefaultBufferSize;
        this.thriftMaxFrameSize = thriftMaxFrameSize;
        this.formattedNodeUrls = String.format("%s:%s", host, port);
    }

    public SessionPool(List<String> nodeUrls, String user, String password, int maxSize, int fetchSize, long waitToGetSessionTimeoutInMs, boolean enableCompression, ZoneId zoneId, boolean enableRedirection, int connectionTimeoutInMs, Version version, int thriftDefaultBufferSize, int thriftMaxFrameSize) {
        this.maxSize = maxSize;
        this.host = null;
        this.port = -1;
        this.nodeUrls = nodeUrls;
        this.user = user;
        this.password = password;
        this.fetchSize = fetchSize;
        this.waitToGetSessionTimeoutInMs = waitToGetSessionTimeoutInMs;
        this.enableCompression = enableCompression;
        this.zoneId = zoneId;
        this.enableRedirection = enableRedirection;
        if (this.enableRedirection) {
            this.deviceIdToEndpoint = new ConcurrentHashMap<String, TEndPoint>();
        }
        this.connectionTimeoutInMs = connectionTimeoutInMs;
        this.version = version;
        this.thriftDefaultBufferSize = thriftDefaultBufferSize;
        this.thriftMaxFrameSize = thriftMaxFrameSize;
        this.formattedNodeUrls = nodeUrls.toString();
    }

    private Session constructNewSession() {
        Session session = this.nodeUrls == null ? new Session.Builder().host(this.host).port(this.port).username(this.user).password(this.password).fetchSize(this.fetchSize).zoneId(this.zoneId).thriftDefaultBufferSize(this.thriftDefaultBufferSize).thriftMaxFrameSize(this.thriftMaxFrameSize).enableRedirection(this.enableRedirection).version(this.version).build() : new Session.Builder().nodeUrls(this.nodeUrls).username(this.user).password(this.password).fetchSize(this.fetchSize).zoneId(this.zoneId).thriftDefaultBufferSize(this.thriftDefaultBufferSize).thriftMaxFrameSize(this.thriftMaxFrameSize).enableRedirection(this.enableRedirection).version(this.version).build();
        session.setEnableQueryRedirection(this.enableQueryRedirection);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISession getSession() throws IoTDBConnectionException {
        SessionPool sessionPool;
        ISession session = this.queue.poll();
        if (this.closed) {
            throw new IoTDBConnectionException(SESSION_POOL_IS_CLOSED);
        }
        if (session != null) {
            return session;
        }
        boolean shouldCreate = false;
        long start = System.currentTimeMillis();
        while (session == null) {
            sessionPool = this;
            synchronized (sessionPool) {
                if (this.size < this.maxSize) {
                    ++this.size;
                    shouldCreate = true;
                    break;
                }
                try {
                    this.wait(1000L);
                    long timeOut = Math.min(this.waitToGetSessionTimeoutInMs, 60000L);
                    if (System.currentTimeMillis() - start > timeOut) {
                        logger.warn("the SessionPool has wait for {} seconds to get a new connection: {} with {}, {}", new Object[]{(System.currentTimeMillis() - start) / 1000L, this.formattedNodeUrls, this.user, this.password});
                        logger.warn("current occupied size {}, queue size {}, considered size {} ", new Object[]{this.occupied.size(), this.queue.size(), this.size});
                        if (System.currentTimeMillis() - start > this.waitToGetSessionTimeoutInMs) {
                            throw new IoTDBConnectionException(String.format("timeout to get a connection from %s", this.formattedNodeUrls));
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                session = this.queue.poll();
                this.notify();
                if (this.closed) {
                    throw new IoTDBConnectionException(SESSION_POOL_IS_CLOSED);
                }
            }
        }
        if (shouldCreate) {
            session = this.constructNewSession();
            try {
                session.open(this.enableCompression, this.connectionTimeoutInMs, this.deviceIdToEndpoint);
                sessionPool = this;
                synchronized (sessionPool) {
                    if (this.closed) {
                        session.close();
                        throw new IoTDBConnectionException(SESSION_POOL_IS_CLOSED);
                    }
                }
            }
            catch (IoTDBConnectionException e) {
                SessionPool sessionPool2 = this;
                synchronized (sessionPool2) {
                    --this.size;
                    this.notify();
                }
                throw e;
            }
        }
        return session;
    }

    public int currentAvailableSize() {
        return this.queue.size();
    }

    public int currentOccupiedSize() {
        return this.occupied.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putBack(ISession session) {
        this.queue.push(session);
        SessionPool sessionPool = this;
        synchronized (sessionPool) {
            this.notify();
        }
    }

    private void occupy(ISession session) {
        this.occupied.put(session, session);
    }

    public synchronized void close() {
        for (ISession session : this.queue) {
            try {
                session.close();
            }
            catch (IoTDBConnectionException e) {
                logger.warn(CLOSE_THE_SESSION_FAILED, (Throwable)e);
            }
        }
        for (ISession session : this.occupied.keySet()) {
            try {
                session.close();
            }
            catch (IoTDBConnectionException e) {
                logger.warn(CLOSE_THE_SESSION_FAILED, (Throwable)e);
            }
        }
        logger.info("closing the session pool, cleaning queues...");
        this.closed = true;
        this.queue.clear();
        this.occupied.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeResultSet(SessionDataSetWrapper wrapper) {
        boolean putback = true;
        try {
            wrapper.getSessionDataSet().closeOperationHandle();
        }
        catch (IoTDBConnectionException | StatementExecutionException e) {
            this.tryConstructNewSession();
            putback = false;
        }
        finally {
            ISession session = (ISession)this.occupied.remove(wrapper.getSession());
            if (putback && session != null) {
                this.putBack(wrapper.getSession());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryConstructNewSession() {
        Session session = this.constructNewSession();
        try {
            session.open(this.enableCompression, this.connectionTimeoutInMs, this.deviceIdToEndpoint);
            SessionPool sessionPool = this;
            synchronized (sessionPool) {
                if (this.closed) {
                    session.close();
                    throw new IoTDBConnectionException(SESSION_POOL_IS_CLOSED);
                }
                this.queue.push(session);
                this.notify();
            }
        }
        catch (IoTDBConnectionException e) {
            SessionPool sessionPool = this;
            synchronized (sessionPool) {
                --this.size;
                this.notify();
            }
        }
    }

    private void closeSession(ISession session) {
        if (session != null) {
            try {
                session.close();
            }
            catch (Exception e2) {
                logger.warn(CLOSE_THE_SESSION_FAILED, (Throwable)e2);
            }
        }
    }

    private void cleanSessionAndMayThrowConnectionException(ISession session, int times, IoTDBConnectionException e) throws IoTDBConnectionException {
        this.closeSession(session);
        this.tryConstructNewSession();
        if (times == 2) {
            throw new IoTDBConnectionException(String.format("retry to execute statement on %s failed %d times: %s", this.formattedNodeUrls, 3, e.getMessage()), (Throwable)e);
        }
    }

    public void insertTablet(Tablet tablet) throws IoTDBConnectionException, StatementExecutionException {
        this.insertTablet(tablet, false);
    }

    public void insertTablet(Tablet tablet, boolean sorted) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.insertTablet(tablet, sorted);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertTablet failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in insertTablet", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public void insertAlignedTablet(Tablet tablet) throws IoTDBConnectionException, StatementExecutionException {
        this.insertAlignedTablet(tablet, false);
    }

    public void insertAlignedTablet(Tablet tablet, boolean sorted) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.insertAlignedTablet(tablet, sorted);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertAlignedTablet failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in insertAlignedTablet", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public void insertTablets(Map<String, Tablet> tablets) throws IoTDBConnectionException, StatementExecutionException {
        this.insertTablets(tablets, false);
    }

    public void insertAlignedTablets(Map<String, Tablet> tablets) throws IoTDBConnectionException, StatementExecutionException {
        this.insertAlignedTablets(tablets, false);
    }

    public void insertTablets(Map<String, Tablet> tablets, boolean sorted) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.insertTablets(tablets, sorted);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertTablets failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in insertTablets", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public void insertAlignedTablets(Map<String, Tablet> tablets, boolean sorted) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.insertAlignedTablets(tablets, sorted);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertAlignedTablets failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in insertAlignedTablets", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public void insertRecords(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.insertRecords(deviceIds, times, measurementsList, typesList, valuesList);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertRecords failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in insertRecords", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public void insertAlignedRecords(List<String> multiSeriesIds, List<Long> times, List<List<String>> multiMeasurementComponentsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.insertAlignedRecords(multiSeriesIds, times, multiMeasurementComponentsList, typesList, valuesList);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertAlignedRecords failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in insertAlignedRecords", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public void insertRecordsOfOneDevice(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.insertRecordsOfOneDevice(deviceId, times, measurementsList, typesList, valuesList, false);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertRecordsOfOneDevice failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in insertRecordsOfOneDevice", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    @Deprecated
    public void insertOneDeviceRecords(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.insertRecordsOfOneDevice(deviceId, times, measurementsList, typesList, valuesList, false);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertRecordsOfOneDevice failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in insertRecordsOfOneDevice", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public void insertStringRecordsOfOneDevice(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.insertStringRecordsOfOneDevice(deviceId, times, measurementsList, valuesList, false);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertStringRecordsOfOneDevice failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in insertStringRecordsOfOneDevice", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public void insertRecordsOfOneDevice(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList, boolean haveSorted) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.insertRecordsOfOneDevice(deviceId, times, measurementsList, typesList, valuesList, haveSorted);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertRecordsOfOneDevice failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in insertRecordsOfOneDevice", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    @Deprecated
    public void insertOneDeviceRecords(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList, boolean haveSorted) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.insertRecordsOfOneDevice(deviceId, times, measurementsList, typesList, valuesList, haveSorted);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertRecordsOfOneDevice failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in insertRecordsOfOneDevice", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public void insertStringRecordsOfOneDevice(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList, boolean haveSorted) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.insertStringRecordsOfOneDevice(deviceId, times, measurementsList, valuesList, haveSorted);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertStringRecordsOfOneDevice failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in insertStringRecordsOfOneDevice", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public void insertAlignedRecordsOfOneDevice(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.insertAlignedRecordsOfOneDevice(deviceId, times, measurementsList, typesList, valuesList, false);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertAlignedRecordsOfOneDevice failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in insertAlignedRecordsOfOneDevice", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public void insertAlignedStringRecordsOfOneDevice(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.insertAlignedStringRecordsOfOneDevice(deviceId, times, measurementsList, valuesList);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertAlignedStringRecordsOfOneDevice failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in insertAlignedStringRecordsOfOneDevice", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public void insertAlignedRecordsOfOneDevice(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList, boolean haveSorted) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.insertAlignedRecordsOfOneDevice(deviceId, times, measurementsList, typesList, valuesList, haveSorted);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertAlignedRecordsOfOneDevice failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in insertAlignedRecordsOfOneDevice", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public void insertAlignedStringRecordsOfOneDevice(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList, boolean haveSorted) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.insertAlignedStringRecordsOfOneDevice(deviceId, times, measurementsList, valuesList, haveSorted);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertAlignedStringRecordsOfOneDevice failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in insertAlignedStringRecordsOfOneDevice", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public void insertRecords(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.insertRecords(deviceIds, times, measurementsList, valuesList);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertRecords failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in insertRecords", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public void insertAlignedRecords(List<String> multiSeriesIds, List<Long> times, List<List<String>> multiMeasurementComponentsList, List<List<String>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.insertAlignedRecords(multiSeriesIds, times, multiMeasurementComponentsList, valuesList);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertAlignedRecords failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in insertAlignedRecords", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public void insertRecord(String deviceId, long time, List<String> measurements, List<TSDataType> types, Object ... values) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.insertRecord(deviceId, time, measurements, types, values);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertRecord failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in insertRecord", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public void insertRecord(String deviceId, long time, List<String> measurements, List<TSDataType> types, List<Object> values) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.insertRecord(deviceId, time, measurements, types, values);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertRecord failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in insertRecord", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public String getTimestampPrecision() throws IoTDBConnectionException, StatementExecutionException {
        String timestampPrecision = "ms";
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                timestampPrecision = session.getTimestampPrecision();
                this.putBack(session);
                return timestampPrecision;
            }
            catch (TException e) {
                logger.warn("getTimestampPrecision failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, new IoTDBConnectionException((Throwable)e));
                continue;
            }
            catch (RuntimeException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in getTimestampPrecision", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
        return timestampPrecision;
    }

    public void insertAlignedRecord(String multiSeriesId, long time, List<String> multiMeasurementComponents, List<TSDataType> types, List<Object> values) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.insertAlignedRecord(multiSeriesId, time, multiMeasurementComponents, types, values);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertAlignedRecord failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in insertAlignedRecord", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public void insertRecord(String deviceId, long time, List<String> measurements, List<String> values) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.insertRecord(deviceId, time, measurements, values);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertRecord failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in insertRecord", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public void insertAlignedRecord(String multiSeriesId, long time, List<String> multiMeasurementComponents, List<String> values) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.insertAlignedRecord(multiSeriesId, time, multiMeasurementComponents, values);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertAlignedRecord failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in insertAlignedRecord", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public void testInsertTablet(Tablet tablet) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.testInsertTablet(tablet);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("testInsertTablet failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in testInsertTablet", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public void testInsertTablet(Tablet tablet, boolean sorted) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.testInsertTablet(tablet, sorted);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("testInsertTablet failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in testInsertTablet", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public void testInsertTablets(Map<String, Tablet> tablets) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.testInsertTablets(tablets);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("testInsertTablets failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in testInsertTablets", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public void testInsertTablets(Map<String, Tablet> tablets, boolean sorted) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.testInsertTablets(tablets, sorted);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("testInsertTablets failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in testInsertTablets", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public void testInsertRecords(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.testInsertRecords(deviceIds, times, measurementsList, valuesList);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("testInsertRecords failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in testInsertRecords", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public void testInsertRecords(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.testInsertRecords(deviceIds, times, measurementsList, typesList, valuesList);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("testInsertRecords failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in testInsertRecords", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public void testInsertRecord(String deviceId, long time, List<String> measurements, List<String> values) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.testInsertRecord(deviceId, time, measurements, values);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("testInsertRecord failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in testInsertRecord", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public void testInsertRecord(String deviceId, long time, List<String> measurements, List<TSDataType> types, List<Object> values) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.testInsertRecord(deviceId, time, measurements, types, values);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("testInsertRecord failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in testInsertRecord", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public void deleteTimeseries(String path) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.deleteTimeseries(path);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("deleteTimeseries failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in deleteTimeseries", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public void deleteTimeseries(List<String> paths) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.deleteTimeseries(paths);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("deleteTimeseries failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in deleteTimeseries", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public void deleteData(String path, long time) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.deleteData(path, time);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("deleteData failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in deleteData", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public void deleteData(List<String> paths, long time) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.deleteData(paths, time);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("deleteData failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in deleteData", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public void deleteData(List<String> paths, long startTime, long endTime) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.deleteData(paths, startTime, endTime);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("deleteData failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in deleteData", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    @Deprecated
    public void setStorageGroup(String storageGroupId) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.setStorageGroup(storageGroupId);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("setStorageGroup failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in setStorageGroup", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    @Deprecated
    public void deleteStorageGroup(String storageGroup) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.deleteStorageGroup(storageGroup);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("deleteStorageGroup failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in deleteStorageGroup", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    @Deprecated
    public void deleteStorageGroups(List<String> storageGroup) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.deleteStorageGroups(storageGroup);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("deleteStorageGroups failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in deleteStorageGroups", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public void createDatabase(String database) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.createDatabase(database);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("createDatabase failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in createDatabase", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public void deleteDatabase(String database) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.deleteDatabase(database);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("deleteDatabase failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in deleteDatabase", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public void deleteDatabases(List<String> databases) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.deleteDatabases(databases);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("deleteDatabases failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in deleteDatabases", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public void createTimeseries(String path, TSDataType dataType, TSEncoding encoding, CompressionType compressor) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.createTimeseries(path, dataType, encoding, compressor);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("createTimeseries failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in createTimeseries", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public void createTimeseries(String path, TSDataType dataType, TSEncoding encoding, CompressionType compressor, Map<String, String> props, Map<String, String> tags, Map<String, String> attributes, String measurementAlias) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.createTimeseries(path, dataType, encoding, compressor, props, tags, attributes, measurementAlias);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("createTimeseries failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in createTimeseries", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public void createAlignedTimeseries(String deviceId, List<String> measurements, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, List<String> measurementAliasList) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.createAlignedTimeseries(deviceId, measurements, dataTypes, encodings, compressors, measurementAliasList);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("createAlignedTimeseries failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in createAlignedTimeseries", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public void createAlignedTimeseries(String deviceId, List<String> measurements, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, List<String> measurementAliasList, List<Map<String, String>> tagsList, List<Map<String, String>> attributesList) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.createAlignedTimeseries(deviceId, measurements, dataTypes, encodings, compressors, measurementAliasList, tagsList, attributesList);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("createAlignedTimeseries failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in createAlignedTimeseries", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public void createMultiTimeseries(List<String> paths, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, List<Map<String, String>> propsList, List<Map<String, String>> tagsList, List<Map<String, String>> attributesList, List<String> measurementAliasList) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.createMultiTimeseries(paths, dataTypes, encodings, compressors, propsList, tagsList, attributesList, measurementAliasList);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("createMultiTimeseries failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in createMultiTimeseries", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public boolean checkTimeseriesExists(String path) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                boolean resp = session.checkTimeseriesExists(path);
                this.putBack(session);
                return resp;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("checkTimeseriesExists failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in checkTimeseriesExists", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    public void createSchemaTemplate(Template template) throws IOException, IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.createSchemaTemplate(template);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("createSchemaTemplate failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in createSchemaTemplate", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public void createSchemaTemplate(String templateName, List<String> measurements, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, boolean isAligned) throws IOException, IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.createSchemaTemplate(templateName, measurements, dataTypes, encodings, compressors, isAligned);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("createSchemaTemplate failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in createSchemaTemplate", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    @Deprecated
    public void createSchemaTemplate(String name, List<String> schemaNames, List<List<String>> measurements, List<List<TSDataType>> dataTypes, List<List<TSEncoding>> encodings, List<CompressionType> compressors) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.createSchemaTemplate(name, schemaNames, measurements, dataTypes, encodings, compressors);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("createSchemaTemplate failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in createSchemaTemplate", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public void addAlignedMeasurementsInTemplate(String templateName, List<String> measurementsPath, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors) throws IOException, IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.addAlignedMeasurementsInTemplate(templateName, measurementsPath, dataTypes, encodings, compressors);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("addAlignedMeasurementsInTemplate failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in addAlignedMeasurementsInTemplate", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public void addAlignedMeasurementInTemplate(String templateName, String measurementPath, TSDataType dataType, TSEncoding encoding, CompressionType compressor) throws IOException, IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.addAlignedMeasurementInTemplate(templateName, measurementPath, dataType, encoding, compressor);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("addAlignedMeasurementInTemplate failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in addAlignedMeasurementInTemplate", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public void addUnalignedMeasurementsInTemplate(String templateName, List<String> measurementsPath, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors) throws IOException, IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.addUnalignedMeasurementsInTemplate(templateName, measurementsPath, dataTypes, encodings, compressors);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("addUnalignedMeasurementsInTemplate failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in addUnalignedMeasurementsInTemplate", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public void addUnalignedMeasurementInTemplate(String templateName, String measurementPath, TSDataType dataType, TSEncoding encoding, CompressionType compressor) throws IOException, IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.addUnalignedMeasurementInTemplate(templateName, measurementPath, dataType, encoding, compressor);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("addUnalignedMeasurementInTemplate failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in addUnalignedMeasurementInTemplate", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public void deleteNodeInTemplate(String templateName, String path) throws IOException, IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.deleteNodeInTemplate(templateName, path);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("deleteNodeInTemplate failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in deleteNodeInTemplate", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public int countMeasurementsInTemplate(String name) throws StatementExecutionException, IoTDBConnectionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                int resp = session.countMeasurementsInTemplate(name);
                this.putBack(session);
                return resp;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("countMeasurementsInTemplate failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in countMeasurementsInTemplate", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
        return -1;
    }

    public boolean isMeasurementInTemplate(String templateName, String path) throws StatementExecutionException, IoTDBConnectionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                boolean resp = session.isMeasurementInTemplate(templateName, path);
                this.putBack(session);
                return resp;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("isMeasurementInTemplate failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in isMeasurementInTemplate", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    public boolean isPathExistInTemplate(String templateName, String path) throws StatementExecutionException, IoTDBConnectionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                boolean resp = session.isPathExistInTemplate(templateName, path);
                this.putBack(session);
                return resp;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("isPathExistInTemplata failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in isPathExistInTemplate", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    public List<String> showMeasurementsInTemplate(String templateName) throws StatementExecutionException, IoTDBConnectionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                List resp = session.showMeasurementsInTemplate(templateName);
                this.putBack(session);
                return resp;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("showMeasurementsInTemplate failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in showMeasurementsInTemplate", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public List<String> showMeasurementsInTemplate(String templateName, String pattern) throws StatementExecutionException, IoTDBConnectionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                List resp = session.showMeasurementsInTemplate(templateName, pattern);
                this.putBack(session);
                return resp;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("showMeasurementsInTemplate failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in showMeasurementsInTemplate", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public List<String> showAllTemplates() throws StatementExecutionException, IoTDBConnectionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                List resp = session.showAllTemplates();
                this.putBack(session);
                return resp;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("showAllTemplates failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in showAllTemplates", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public List<String> showPathsTemplateSetOn(String templateName) throws StatementExecutionException, IoTDBConnectionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                List resp = session.showPathsTemplateSetOn(templateName);
                this.putBack(session);
                return resp;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("showPathsTemplateSetOn failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in showPathsTemplateSetOn", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public List<String> showPathsTemplateUsingOn(String templateName) throws StatementExecutionException, IoTDBConnectionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                List resp = session.showPathsTemplateUsingOn(templateName);
                this.putBack(session);
                return resp;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("showPathsTemplateUsingOn failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in showPathsTemplateUsingOn", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public void sortTablet(Tablet tablet) throws IoTDBConnectionException {
        ISession session = this.getSession();
        session.sortTablet(tablet);
        this.putBack(session);
    }

    public void setSchemaTemplate(String templateName, String prefixPath) throws StatementExecutionException, IoTDBConnectionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.setSchemaTemplate(templateName, prefixPath);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn(String.format("setSchemaTemplate [%s] on [%s] failed", templateName, prefixPath), (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in setSchemaTemplate", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public void unsetSchemaTemplate(String prefixPath, String templateName) throws StatementExecutionException, IoTDBConnectionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.unsetSchemaTemplate(prefixPath, templateName);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn(String.format("unsetSchemaTemplate [%s] on [%s] failed", templateName, prefixPath), (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in unsetSchemaTemplate", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public void dropSchemaTemplate(String templateName) throws StatementExecutionException, IoTDBConnectionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.dropSchemaTemplate(templateName);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn(String.format("dropSchemaTemplate [%s] failed", templateName), (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in dropSchemaTemplate", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public void createTimeseriesUsingSchemaTemplate(List<String> devicePathList) throws StatementExecutionException, IoTDBConnectionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.createTimeseriesUsingSchemaTemplate(devicePathList);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn(String.format("createTimeseriesOfSchemaTemplate [%s] failed", devicePathList), (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in createTimeseriesUsingSchemaTemplate", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public SessionDataSetWrapper executeQueryStatement(String sql) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                SessionDataSet resp = session.executeQueryStatement(sql);
                SessionDataSetWrapper wrapper = new SessionDataSetWrapper(resp, session, (ISessionPool)this);
                this.occupy(session);
                return wrapper;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("executeQueryStatement failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in executeQueryStatement", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public SessionDataSetWrapper executeQueryStatement(String sql, long timeoutInMs) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                SessionDataSet resp = session.executeQueryStatement(sql, timeoutInMs);
                SessionDataSetWrapper wrapper = new SessionDataSetWrapper(resp, session, (ISessionPool)this);
                this.occupy(session);
                return wrapper;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("executeQueryStatement failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in executeQueryStatement", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public void executeNonQueryStatement(String sql) throws StatementExecutionException, IoTDBConnectionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.executeNonQueryStatement(sql);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("executeNonQueryStatement failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in executeNonQueryStatement", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
    }

    public SessionDataSetWrapper executeRawDataQuery(List<String> paths, long startTime, long endTime, long timeOut) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                SessionDataSet resp = session.executeRawDataQuery(paths, startTime, endTime, timeOut);
                SessionDataSetWrapper wrapper = new SessionDataSetWrapper(resp, session, (ISessionPool)this);
                this.occupy(session);
                return wrapper;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("executeRawDataQuery failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in executeRawDataQuery", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public SessionDataSetWrapper executeLastDataQuery(List<String> paths, long LastTime) throws StatementExecutionException, IoTDBConnectionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                SessionDataSet resp = session.executeLastDataQuery(paths, LastTime);
                SessionDataSetWrapper wrapper = new SessionDataSetWrapper(resp, session, (ISessionPool)this);
                this.occupy(session);
                return wrapper;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("executeLastDataQuery failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in executeLastDataQuery", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public SessionDataSetWrapper executeLastDataQuery(List<String> paths, long LastTime, long timeOut) throws StatementExecutionException, IoTDBConnectionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                SessionDataSet resp = session.executeLastDataQuery(paths, LastTime, timeOut);
                SessionDataSetWrapper wrapper = new SessionDataSetWrapper(resp, session, (ISessionPool)this);
                this.occupy(session);
                return wrapper;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("executeLastDataQuery failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in executeLastDataQuery", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public SessionDataSetWrapper executeLastDataQuery(List<String> paths) throws StatementExecutionException, IoTDBConnectionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                SessionDataSet resp = session.executeLastDataQuery(paths);
                SessionDataSetWrapper wrapper = new SessionDataSetWrapper(resp, session, (ISessionPool)this);
                this.occupy(session);
                return wrapper;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("executeLastDataQuery failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in executeLastDataQuery", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public SessionDataSetWrapper executeAggregationQuery(List<String> paths, List<TAggregationType> aggregations) throws StatementExecutionException, IoTDBConnectionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                SessionDataSet resp = session.executeAggregationQuery(paths, aggregations);
                SessionDataSetWrapper wrapper = new SessionDataSetWrapper(resp, session, (ISessionPool)this);
                this.occupy(session);
                return wrapper;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("executeAggregationQuery failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in executeAggregationQuery", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public SessionDataSetWrapper executeAggregationQuery(List<String> paths, List<TAggregationType> aggregations, long startTime, long endTime) throws StatementExecutionException, IoTDBConnectionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                SessionDataSet resp = session.executeAggregationQuery(paths, aggregations, startTime, endTime);
                SessionDataSetWrapper wrapper = new SessionDataSetWrapper(resp, session, (ISessionPool)this);
                this.occupy(session);
                return wrapper;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("executeAggregationQuery failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in executeAggregationQuery", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public SessionDataSetWrapper executeAggregationQuery(List<String> paths, List<TAggregationType> aggregations, long startTime, long endTime, long interval) throws StatementExecutionException, IoTDBConnectionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                SessionDataSet resp = session.executeAggregationQuery(paths, aggregations, startTime, endTime, interval);
                SessionDataSetWrapper wrapper = new SessionDataSetWrapper(resp, session, (ISessionPool)this);
                this.occupy(session);
                return wrapper;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("executeAggregationQuery failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in executeAggregationQuery", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public SessionDataSetWrapper executeAggregationQuery(List<String> paths, List<TAggregationType> aggregations, long startTime, long endTime, long interval, long slidingStep) throws StatementExecutionException, IoTDBConnectionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                SessionDataSet resp = session.executeAggregationQuery(paths, aggregations, startTime, endTime, interval, slidingStep);
                SessionDataSetWrapper wrapper = new SessionDataSetWrapper(resp, session, (ISessionPool)this);
                this.occupy(session);
                return wrapper;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("executeAggregationQuery failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
            catch (Throwable e) {
                logger.error("unexpected error in executeAggregationQuery", e);
                this.putBack(session);
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        for (ISession session : this.queue) {
            session.setFetchSize(fetchSize);
        }
        for (ISession session : this.occupied.keySet()) {
            session.setFetchSize(fetchSize);
        }
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setTimeZone(String zoneId) throws StatementExecutionException, IoTDBConnectionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                session.setTimeZone(zoneId);
                this.putBack(session);
                continue;
            }
            catch (IoTDBConnectionException e) {
                logger.warn(String.format("setTimeZone to [%s] failed", zoneId), (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
        this.zoneId = ZoneId.of(zoneId);
        for (ISession session : this.queue) {
            session.setTimeZoneOfSession(zoneId);
        }
        for (ISession session : this.occupied.keySet()) {
            session.setTimeZoneOfSession(zoneId);
        }
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public long getWaitToGetSessionTimeoutInMs() {
        return this.waitToGetSessionTimeoutInMs;
    }

    public boolean isEnableCompression() {
        return this.enableCompression;
    }

    public void setEnableRedirection(boolean enableRedirection) {
        this.enableRedirection = enableRedirection;
        if (this.enableRedirection) {
            this.deviceIdToEndpoint = new ConcurrentHashMap<String, TEndPoint>();
        }
        for (ISession session : this.queue) {
            session.setEnableRedirection(enableRedirection);
        }
        for (ISession session : this.occupied.keySet()) {
            session.setEnableRedirection(enableRedirection);
        }
    }

    public boolean isEnableRedirection() {
        return this.enableRedirection;
    }

    public void setEnableQueryRedirection(boolean enableQueryRedirection) {
        this.enableQueryRedirection = enableQueryRedirection;
        for (ISession session : this.queue) {
            session.setEnableQueryRedirection(enableQueryRedirection);
        }
        for (ISession session : this.occupied.keySet()) {
            session.setEnableQueryRedirection(enableQueryRedirection);
        }
    }

    public boolean isEnableQueryRedirection() {
        return this.enableQueryRedirection;
    }

    public int getConnectionTimeoutInMs() {
        return this.connectionTimeoutInMs;
    }

    public TSBackupConfigurationResp getBackupConfiguration() throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                TSBackupConfigurationResp resp = session.getBackupConfiguration();
                this.putBack(session);
                return resp;
            }
            catch (IoTDBConnectionException e) {
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException e) {
                this.putBack(session);
                throw e;
            }
        }
        return null;
    }

    public TSConnectionInfoResp fetchAllConnections() throws IoTDBConnectionException {
        for (int i = 0; i < 3; ++i) {
            ISession session = this.getSession();
            try {
                TSConnectionInfoResp resp = session.fetchAllConnections();
                this.putBack(session);
                return resp;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("fetchAllConnections failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (Throwable t) {
                this.putBack(session);
                throw t;
            }
        }
        return null;
    }

    public void setVersion(Version version) {
        this.version = version;
        for (ISession session : this.queue) {
            session.setVersion(version);
        }
        for (ISession session : this.occupied.keySet()) {
            session.setVersion(version);
        }
    }

    public Version getVersion() {
        return this.version;
    }

    public void setQueryTimeout(long timeoutInMs) {
        this.queryTimeoutInMs = timeoutInMs;
        for (ISession session : this.queue) {
            session.setQueryTimeout(timeoutInMs);
        }
        for (ISession session : this.occupied.keySet()) {
            session.setQueryTimeout(timeoutInMs);
        }
    }

    public long getQueryTimeout() {
        return this.queryTimeoutInMs;
    }

    public static class Builder {
        private String host = "localhost";
        private int port = 6667;
        private List<String> nodeUrls = null;
        private int maxSize = 5;
        private String user = "root";
        private String password = "root";
        private int fetchSize = 5000;
        private long waitToGetSessionTimeoutInMs = 60000L;
        private int thriftDefaultBufferSize = 1024;
        private int thriftMaxFrameSize = 0x4000000;
        private boolean enableCompression = false;
        private ZoneId zoneId = null;
        private boolean enableRedirection = true;
        private int connectionTimeoutInMs = 0;
        private Version version = SessionConfig.DEFAULT_VERSION;
        private long timeOut = 60000L;

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder nodeUrls(List<String> nodeUrls) {
            this.nodeUrls = nodeUrls;
            return this;
        }

        public Builder maxSize(int maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder fetchSize(int fetchSize) {
            this.fetchSize = fetchSize;
            return this;
        }

        public Builder zoneId(ZoneId zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder waitToGetSessionTimeoutInMs(long waitToGetSessionTimeoutInMs) {
            this.waitToGetSessionTimeoutInMs = waitToGetSessionTimeoutInMs;
            return this;
        }

        public Builder thriftDefaultBufferSize(int thriftDefaultBufferSize) {
            this.thriftDefaultBufferSize = thriftDefaultBufferSize;
            return this;
        }

        public Builder thriftMaxFrameSize(int thriftMaxFrameSize) {
            this.thriftMaxFrameSize = thriftMaxFrameSize;
            return this;
        }

        public Builder enableCompression(boolean enableCompression) {
            this.enableCompression = enableCompression;
            return this;
        }

        public Builder enableRedirection(boolean enableRedirection) {
            this.enableRedirection = enableRedirection;
            return this;
        }

        public Builder connectionTimeoutInMs(int connectionTimeoutInMs) {
            this.connectionTimeoutInMs = connectionTimeoutInMs;
            return this;
        }

        public Builder version(Version version) {
            this.version = version;
            return this;
        }

        public Builder timeOut(long timeOut) {
            this.timeOut = timeOut;
            return this;
        }

        public SessionPool build() {
            if (this.nodeUrls == null) {
                return new SessionPool(this.host, this.port, this.user, this.password, this.maxSize, this.fetchSize, this.waitToGetSessionTimeoutInMs, this.enableCompression, this.zoneId, this.enableRedirection, this.connectionTimeoutInMs, this.version, this.thriftDefaultBufferSize, this.thriftMaxFrameSize);
            }
            return new SessionPool(this.nodeUrls, this.user, this.password, this.maxSize, this.fetchSize, this.waitToGetSessionTimeoutInMs, this.enableCompression, this.zoneId, this.enableRedirection, this.connectionTimeoutInMs, this.version, this.thriftDefaultBufferSize, this.thriftMaxFrameSize);
        }
    }
}

