/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.encoding.encoder;

import java.util.Map;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.encoding.encoder.DeltaBinaryEncoder;
import org.apache.iotdb.tsfile.encoding.encoder.DictionaryEncoder;
import org.apache.iotdb.tsfile.encoding.encoder.DoublePrecisionChimpEncoder;
import org.apache.iotdb.tsfile.encoding.encoder.DoublePrecisionEncoderV1;
import org.apache.iotdb.tsfile.encoding.encoder.DoublePrecisionEncoderV2;
import org.apache.iotdb.tsfile.encoding.encoder.DoubleRLBE;
import org.apache.iotdb.tsfile.encoding.encoder.DoubleSprintzEncoder;
import org.apache.iotdb.tsfile.encoding.encoder.Encoder;
import org.apache.iotdb.tsfile.encoding.encoder.FloatEncoder;
import org.apache.iotdb.tsfile.encoding.encoder.FloatRLBE;
import org.apache.iotdb.tsfile.encoding.encoder.FloatSprintzEncoder;
import org.apache.iotdb.tsfile.encoding.encoder.IntChimpEncoder;
import org.apache.iotdb.tsfile.encoding.encoder.IntGorillaEncoder;
import org.apache.iotdb.tsfile.encoding.encoder.IntRLBE;
import org.apache.iotdb.tsfile.encoding.encoder.IntRleEncoder;
import org.apache.iotdb.tsfile.encoding.encoder.IntSprintzEncoder;
import org.apache.iotdb.tsfile.encoding.encoder.IntZigzagEncoder;
import org.apache.iotdb.tsfile.encoding.encoder.LongChimpEncoder;
import org.apache.iotdb.tsfile.encoding.encoder.LongGorillaEncoder;
import org.apache.iotdb.tsfile.encoding.encoder.LongRLBE;
import org.apache.iotdb.tsfile.encoding.encoder.LongRleEncoder;
import org.apache.iotdb.tsfile.encoding.encoder.LongSprintzEncoder;
import org.apache.iotdb.tsfile.encoding.encoder.LongZigzagEncoder;
import org.apache.iotdb.tsfile.encoding.encoder.PlainEncoder;
import org.apache.iotdb.tsfile.encoding.encoder.RegularDataEncoder;
import org.apache.iotdb.tsfile.encoding.encoder.SinglePrecisionChimpEncoder;
import org.apache.iotdb.tsfile.encoding.encoder.SinglePrecisionEncoderV1;
import org.apache.iotdb.tsfile.encoding.encoder.SinglePrecisionEncoderV2;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TSEncodingBuilder {
    private static final Logger logger = LoggerFactory.getLogger(TSEncodingBuilder.class);
    protected final TSFileConfig conf = TSFileDescriptor.getInstance().getConfig();

    public static TSEncodingBuilder getEncodingBuilder(TSEncoding type) {
        switch (type) {
            case PLAIN: {
                return new Plain();
            }
            case RLE: {
                return new Rle();
            }
            case TS_2DIFF: {
                return new Ts2Diff();
            }
            case GORILLA_V1: {
                return new GorillaV1();
            }
            case REGULAR: {
                return new Regular();
            }
            case GORILLA: {
                return new GorillaV2();
            }
            case DICTIONARY: {
                return new Dictionary();
            }
            case ZIGZAG: {
                return new Zigzag();
            }
            case CHIMP: {
                return new Chimp();
            }
            case SPRINTZ: {
                return new Sprintz();
            }
            case RLBE: {
                return new RLBE();
            }
        }
        throw new UnsupportedOperationException(type.toString());
    }

    public abstract Encoder getEncoder(TSDataType var1);

    public abstract void initFromProps(Map<String, String> var1);

    public String toString() {
        return "";
    }

    public static class Chimp
    extends TSEncodingBuilder {
        @Override
        public Encoder getEncoder(TSDataType type) {
            switch (type) {
                case FLOAT: {
                    return new SinglePrecisionChimpEncoder();
                }
                case DOUBLE: {
                    return new DoublePrecisionChimpEncoder();
                }
                case INT32: {
                    return new IntChimpEncoder();
                }
                case INT64: {
                    return new LongChimpEncoder();
                }
            }
            throw new UnSupportedDataTypeException("CHIMP doesn't support data type: " + (Object)((Object)type));
        }

        @Override
        public void initFromProps(Map<String, String> props) {
        }
    }

    public static class Zigzag
    extends TSEncodingBuilder {
        @Override
        public Encoder getEncoder(TSDataType type) {
            switch (type) {
                case INT32: {
                    return new IntZigzagEncoder();
                }
                case INT64: {
                    return new LongZigzagEncoder();
                }
            }
            throw new UnSupportedDataTypeException("ZIGZAG doesn't support data type: " + (Object)((Object)type));
        }

        @Override
        public void initFromProps(Map<String, String> props) {
        }
    }

    public static class Dictionary
    extends TSEncodingBuilder {
        @Override
        public Encoder getEncoder(TSDataType type) {
            if (type == TSDataType.TEXT) {
                return new DictionaryEncoder();
            }
            throw new UnSupportedDataTypeException("DICTIONARY doesn't support data type: " + (Object)((Object)type));
        }

        @Override
        public void initFromProps(Map<String, String> props) {
        }
    }

    public static class RLBE
    extends TSEncodingBuilder {
        @Override
        public Encoder getEncoder(TSDataType type) {
            switch (type) {
                case INT32: {
                    return new IntRLBE();
                }
                case INT64: {
                    return new LongRLBE();
                }
                case FLOAT: {
                    return new FloatRLBE();
                }
                case DOUBLE: {
                    return new DoubleRLBE();
                }
            }
            throw new UnSupportedDataTypeException("RLBE doesn't support data type: " + (Object)((Object)type));
        }

        @Override
        public void initFromProps(Map<String, String> props) {
        }
    }

    public static class Sprintz
    extends TSEncodingBuilder {
        @Override
        public Encoder getEncoder(TSDataType type) {
            switch (type) {
                case INT32: {
                    return new IntSprintzEncoder();
                }
                case INT64: {
                    return new LongSprintzEncoder();
                }
                case FLOAT: {
                    return new FloatSprintzEncoder();
                }
                case DOUBLE: {
                    return new DoubleSprintzEncoder();
                }
            }
            throw new UnSupportedDataTypeException("Sprintz doesn't support data type: " + (Object)((Object)type));
        }

        @Override
        public void initFromProps(Map<String, String> props) {
        }
    }

    public static class GorillaV2
    extends TSEncodingBuilder {
        @Override
        public Encoder getEncoder(TSDataType type) {
            switch (type) {
                case FLOAT: {
                    return new SinglePrecisionEncoderV2();
                }
                case DOUBLE: {
                    return new DoublePrecisionEncoderV2();
                }
                case INT32: {
                    return new IntGorillaEncoder();
                }
                case INT64: {
                    return new LongGorillaEncoder();
                }
            }
            throw new UnSupportedDataTypeException("GORILLA doesn't support data type: " + (Object)((Object)type));
        }

        @Override
        public void initFromProps(Map<String, String> props) {
        }
    }

    public static class Regular
    extends TSEncodingBuilder {
        @Override
        public Encoder getEncoder(TSDataType type) {
            switch (type) {
                case INT32: {
                    return new RegularDataEncoder.IntRegularEncoder();
                }
                case INT64: {
                    return new RegularDataEncoder.LongRegularEncoder();
                }
            }
            throw new UnSupportedDataTypeException("REGULAR doesn't support data type: " + (Object)((Object)type));
        }

        @Override
        public void initFromProps(Map<String, String> props) {
        }
    }

    public static class GorillaV1
    extends TSEncodingBuilder {
        @Override
        public Encoder getEncoder(TSDataType type) {
            switch (type) {
                case FLOAT: {
                    return new SinglePrecisionEncoderV1();
                }
                case DOUBLE: {
                    return new DoublePrecisionEncoderV1();
                }
            }
            throw new UnSupportedDataTypeException("GORILLA_V1 doesn't support data type: " + (Object)((Object)type));
        }

        @Override
        public void initFromProps(Map<String, String> props) {
        }
    }

    public static class Ts2Diff
    extends TSEncodingBuilder {
        private int maxPointNumber = 0;

        @Override
        public Encoder getEncoder(TSDataType type) {
            switch (type) {
                case INT32: {
                    return new DeltaBinaryEncoder.IntDeltaEncoder();
                }
                case INT64: {
                    return new DeltaBinaryEncoder.LongDeltaEncoder();
                }
                case FLOAT: 
                case DOUBLE: {
                    return new FloatEncoder(TSEncoding.TS_2DIFF, type, this.maxPointNumber);
                }
            }
            throw new UnSupportedDataTypeException("TS_2DIFF doesn't support data type: " + (Object)((Object)type));
        }

        @Override
        public void initFromProps(Map<String, String> props) {
            if (props == null || !props.containsKey("max_point_number")) {
                this.maxPointNumber = TSFileDescriptor.getInstance().getConfig().getFloatPrecision();
            } else {
                try {
                    this.maxPointNumber = Integer.parseInt(props.get("max_point_number"));
                }
                catch (NumberFormatException e) {
                    logger.warn("The format of max point number {} is not correct. Using default float precision.", (Object)props.get("max_point_number"));
                }
                if (this.maxPointNumber < 0) {
                    this.maxPointNumber = TSFileDescriptor.getInstance().getConfig().getFloatPrecision();
                    logger.warn("cannot set max point number to negative value, replaced with default value:{}", (Object)this.maxPointNumber);
                }
            }
        }

        @Override
        public String toString() {
            return "max_point_number:" + this.maxPointNumber;
        }
    }

    public static class Rle
    extends TSEncodingBuilder {
        private int maxPointNumber = TSFileDescriptor.getInstance().getConfig().getFloatPrecision();

        @Override
        public Encoder getEncoder(TSDataType type) {
            switch (type) {
                case INT32: 
                case BOOLEAN: {
                    return new IntRleEncoder();
                }
                case INT64: {
                    return new LongRleEncoder();
                }
                case FLOAT: 
                case DOUBLE: {
                    return new FloatEncoder(TSEncoding.RLE, type, this.maxPointNumber);
                }
            }
            throw new UnSupportedDataTypeException("RLE doesn't support data type: " + (Object)((Object)type));
        }

        @Override
        public void initFromProps(Map<String, String> props) {
            if (props == null || !props.containsKey("max_point_number")) {
                this.maxPointNumber = TSFileDescriptor.getInstance().getConfig().getFloatPrecision();
            } else {
                try {
                    this.maxPointNumber = Integer.parseInt(props.get("max_point_number"));
                }
                catch (NumberFormatException e) {
                    logger.warn("The format of max point number {} is not correct. Using default float precision.", (Object)props.get("max_point_number"));
                }
                if (this.maxPointNumber < 0) {
                    this.maxPointNumber = TSFileDescriptor.getInstance().getConfig().getFloatPrecision();
                    logger.warn("cannot set max point number to negative value, replaced with default value:{}", (Object)this.maxPointNumber);
                }
            }
        }

        @Override
        public String toString() {
            return "max_point_number:" + this.maxPointNumber;
        }
    }

    public static class Plain
    extends TSEncodingBuilder {
        private int maxStringLength = TSFileDescriptor.getInstance().getConfig().getMaxStringLength();

        @Override
        public Encoder getEncoder(TSDataType type) {
            return new PlainEncoder(type, this.maxStringLength);
        }

        @Override
        public void initFromProps(Map<String, String> props) {
            if (props == null || !props.containsKey("max_string_length")) {
                this.maxStringLength = TSFileDescriptor.getInstance().getConfig().getMaxStringLength();
            } else {
                this.maxStringLength = Integer.valueOf(props.get("max_string_length"));
                if (this.maxStringLength < 0) {
                    this.maxStringLength = TSFileDescriptor.getInstance().getConfig().getMaxStringLength();
                    logger.warn("cannot set max string length to negative value, replaced with default value:{}", (Object)this.maxStringLength);
                }
            }
        }
    }
}

