/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.influxdb.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.binary.CompareBinaryExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.LogicAndExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.LogicBinaryExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.LogicOrExpression;
import org.apache.iotdb.db.mpp.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.mpp.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.mpp.plan.statement.component.ResultColumn;
import org.apache.iotdb.db.protocol.influxdb.constant.InfluxSqlConstant;
import org.apache.iotdb.db.protocol.influxdb.function.InfluxFunction;
import org.apache.iotdb.db.protocol.influxdb.function.InfluxFunctionFactory;
import org.apache.iotdb.db.protocol.influxdb.function.InfluxFunctionValue;
import org.apache.iotdb.db.protocol.influxdb.function.aggregator.InfluxAggregator;
import org.apache.iotdb.db.protocol.influxdb.function.selector.InfluxSelector;
import org.apache.iotdb.db.protocol.influxdb.meta.InfluxDBMetaManagerFactory;
import org.apache.iotdb.db.protocol.influxdb.statement.InfluxQueryStatement;
import org.apache.iotdb.db.protocol.influxdb.statement.InfluxSelectComponent;
import org.apache.iotdb.db.protocol.influxdb.util.FilterUtils;
import org.apache.iotdb.db.protocol.influxdb.util.JacksonUtils;
import org.apache.iotdb.db.protocol.influxdb.util.QueryResultUtils;
import org.apache.iotdb.db.protocol.influxdb.util.StringUtils;
import org.apache.iotdb.protocol.influxdb.rpc.thrift.InfluxQueryResultRsp;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.impl.SingleSeriesExpression;
import org.influxdb.dto.QueryResult;

public abstract class AbstractQueryHandler {
    abstract InfluxFunctionValue updateByIoTDBFunc(String var1, String var2, InfluxFunction var3, long var4);

    abstract QueryResult queryByConditions(String var1, String var2, String var3, Map<String, Integer> var4, Map<String, Integer> var5, long var6) throws AuthException;

    public final InfluxQueryResultRsp queryInfluxDB(String database, InfluxQueryStatement queryStatement, long sessionId) {
        String measurement = queryStatement.getFromComponent().getPrefixPaths().get(0).getFullPath();
        Map<String, Integer> fieldOrders = InfluxDBMetaManagerFactory.getInstance().getFieldOrders(database, measurement, sessionId);
        InfluxQueryResultRsp tsQueryResultRsp = new InfluxQueryResultRsp();
        try {
            QueryResult queryResult;
            if (queryStatement.hasWhere() || queryStatement.getSelectComponent().isHasCommonQuery() || queryStatement.getSelectComponent().isHasOnlyTraverseFunction()) {
                queryResult = this.queryExpr(queryStatement.hasWhere() ? queryStatement.getWhereCondition().getPredicate() : null, database, measurement, fieldOrders, sessionId);
                this.ProcessSelectComponent(queryResult, queryStatement.getSelectComponent());
            } else {
                queryResult = this.queryFuncWithoutFilter(queryStatement.getSelectComponent(), database, measurement, sessionId);
            }
            return tsQueryResultRsp.setResultJsonString(JacksonUtils.bean2Json(queryResult)).setStatus(RpcUtils.getInfluxDBStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
        }
        catch (AuthException e) {
            return tsQueryResultRsp.setStatus(RpcUtils.getInfluxDBStatus((int)e.getCode().getStatusCode(), (String)e.getMessage()));
        }
    }

    public void ProcessSelectComponent(QueryResult queryResult, InfluxSelectComponent selectComponent) {
        List columns = ((QueryResult.Series)((QueryResult.Result)queryResult.getResults().get(0)).getSeries().get(0)).getColumns();
        HashMap<String, Integer> columnOrders = new HashMap<String, Integer>();
        for (int i = 0; i < columns.size(); ++i) {
            columnOrders.put((String)columns.get(i), i);
        }
        ArrayList values = ((QueryResult.Series)((QueryResult.Result)queryResult.getResults().get(0)).getSeries().get(0)).getValues();
        ArrayList<String> newColumns = new ArrayList<String>();
        newColumns.add("time");
        if (selectComponent.isHasFunction()) {
            ArrayList<InfluxFunction> functions = new ArrayList<InfluxFunction>();
            for (ResultColumn resultColumn : selectComponent.getResultColumns()) {
                Expression expression = resultColumn.getExpression();
                if (expression instanceof FunctionExpression) {
                    String functionName = ((FunctionExpression)expression).getFunctionName();
                    functions.add(InfluxFunctionFactory.generateFunction(functionName, expression.getExpressions()));
                    newColumns.add(functionName);
                    continue;
                }
                if (!(expression instanceof TimeSeriesOperand)) continue;
                String columnName = ((TimeSeriesOperand)expression).getPath().getFullPath();
                if (!columnName.equals("*")) {
                    newColumns.add(columnName);
                    continue;
                }
                newColumns.addAll(columns.subList(1, columns.size()));
            }
            for (List list : values) {
                for (InfluxFunction function : functions) {
                    List<Expression> expressions = function.getExpressions();
                    if (expressions == null) {
                        throw new IllegalArgumentException("not support param");
                    }
                    TimeSeriesOperand parmaExpression = (TimeSeriesOperand)expressions.get(0);
                    String parmaName = parmaExpression.getPath().getFullPath();
                    if (!columnOrders.containsKey(parmaName)) continue;
                    Object selectedValue = list.get((Integer)columnOrders.get(parmaName));
                    Long selectedTimestamp = (Long)list.get(0);
                    if (selectedValue == null) continue;
                    if (function instanceof InfluxSelector) {
                        ((InfluxSelector)function).updateValueAndRelateValues(new InfluxFunctionValue(selectedValue, selectedTimestamp), list);
                        continue;
                    }
                    ((InfluxAggregator)function).updateValueBruteForce(new InfluxFunctionValue(selectedValue, selectedTimestamp));
                }
            }
            ArrayList<Object> value = new ArrayList<Object>();
            values = new ArrayList();
            if (selectComponent.isHasCommonQuery()) {
                InfluxSelector influxSelector = (InfluxSelector)functions.get(0);
                List<Object> relatedValue = influxSelector.getRelatedValues();
                for (String column : newColumns) {
                    if (InfluxSqlConstant.getNativeSelectorFunctionNames().contains(column)) {
                        value.add(influxSelector.calculateBruteForce().getValue());
                        continue;
                    }
                    if (relatedValue == null) continue;
                    value.add(relatedValue.get((Integer)columnOrders.get(column)));
                }
            } else {
                for (InfluxFunction function : functions) {
                    if (value.isEmpty()) {
                        value.add(function.calculateBruteForce().getTimestamp());
                    } else {
                        value.set(0, function.calculateBruteForce().getTimestamp());
                    }
                    value.add(function.calculateBruteForce().getValue());
                }
                if (selectComponent.isHasAggregationFunction() || selectComponent.isHasMoreFunction()) {
                    value.set(0, 0);
                }
            }
            values.add(value);
        } else if (selectComponent.isHasCommonQuery()) {
            for (ResultColumn resultColumn : selectComponent.getResultColumns()) {
                Expression expression = resultColumn.getExpression();
                if (!(expression instanceof TimeSeriesOperand)) continue;
                if (!((TimeSeriesOperand)expression).getPath().getFullPath().equals("*")) {
                    newColumns.add(((TimeSeriesOperand)expression).getPath().getFullPath());
                    continue;
                }
                newColumns.addAll(columns.subList(1, columns.size()));
            }
            ArrayList newValues = new ArrayList();
            for (List list : values) {
                ArrayList tmpValue = new ArrayList();
                for (String newColumn : newColumns) {
                    tmpValue.add(list.get((Integer)columnOrders.get(newColumn)));
                }
                newValues.add(tmpValue);
            }
            values = newValues;
        }
        QueryResultUtils.updateQueryResultColumnValue(queryResult, StringUtils.removeDuplicate(newColumns), values);
    }

    public QueryResult queryFuncWithoutFilter(InfluxSelectComponent selectComponent, String database, String measurement, long sessionid) {
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("time");
        ArrayList<InfluxFunction> functions = new ArrayList<InfluxFunction>();
        for (ResultColumn resultColumn : selectComponent.getResultColumns()) {
            Expression expression = resultColumn.getExpression();
            if (!(expression instanceof FunctionExpression)) continue;
            String functionName = ((FunctionExpression)expression).getFunctionName();
            functions.add(InfluxFunctionFactory.generateFunction(functionName, expression.getExpressions()));
            columns.add(functionName);
        }
        ArrayList<Object> value = new ArrayList<Object>();
        ArrayList<ArrayList<Object>> values = new ArrayList<ArrayList<Object>>();
        for (InfluxFunction function : functions) {
            InfluxFunctionValue functionValue = this.updateByIoTDBFunc(database, measurement, function, sessionid);
            if (value.isEmpty()) {
                value.add(functionValue.getTimestamp());
            } else {
                value.set(0, functionValue.getTimestamp());
            }
            value.add(functionValue.getValue());
        }
        if (selectComponent.isHasAggregationFunction() || selectComponent.isHasMoreFunction()) {
            value.set(0, 0);
        }
        values.add(value);
        QueryResult queryResult = new QueryResult();
        QueryResult.Series series = new QueryResult.Series();
        series.setColumns(columns);
        series.setValues(values);
        series.setName(measurement);
        QueryResult.Result result = new QueryResult.Result();
        result.setSeries(new ArrayList<QueryResult.Series>(Arrays.asList(series)));
        queryResult.setResults(new ArrayList<QueryResult.Result>(Arrays.asList(result)));
        return queryResult;
    }

    public QueryResult queryExpr(Expression predicate, String database, String measurement, Map<String, Integer> fieldOrders, Long sessionId) throws AuthException {
        if (predicate == null) {
            return this.queryByConditions(Collections.emptyList(), database, measurement, fieldOrders, sessionId);
        }
        if (predicate instanceof CompareBinaryExpression) {
            return this.queryByConditions(this.convertToIExpressions(predicate), database, measurement, fieldOrders, sessionId);
        }
        if (predicate instanceof LogicOrExpression) {
            return QueryResultUtils.orQueryResultProcess(this.queryExpr(((LogicOrExpression)predicate).getLeftExpression(), database, measurement, fieldOrders, sessionId), this.queryExpr(((LogicOrExpression)predicate).getRightExpression(), database, measurement, fieldOrders, sessionId));
        }
        if (predicate instanceof LogicAndExpression) {
            if (this.canMergePredicate(predicate)) {
                return this.queryByConditions(this.convertToIExpressions(predicate), database, measurement, fieldOrders, sessionId);
            }
            return QueryResultUtils.andQueryResultProcess(this.queryExpr(((LogicAndExpression)predicate).getLeftExpression(), database, measurement, fieldOrders, sessionId), this.queryExpr(((LogicAndExpression)predicate).getRightExpression(), database, measurement, fieldOrders, sessionId));
        }
        throw new IllegalArgumentException("unsupported expression type: " + (Object)((Object)predicate.getExpressionType()));
    }

    public QueryResult queryByConditions(List<IExpression> expressions, String database, String measurement, Map<String, Integer> fieldOrders, Long sessionId) throws AuthException {
        HashMap<Integer, SingleSeriesExpression> realTagOrders = new HashMap<Integer, SingleSeriesExpression>();
        ArrayList<SingleSeriesExpression> fieldExpressions = new ArrayList<SingleSeriesExpression>();
        int currentQueryMaxTagNum = 0;
        Map<String, Integer> tagOrders = InfluxDBMetaManagerFactory.getInstance().getTagOrders(database, measurement, sessionId);
        for (IExpression expression : expressions) {
            SingleSeriesExpression singleSeriesExpression = (SingleSeriesExpression)expression;
            if (tagOrders.containsKey(singleSeriesExpression.getSeriesPath().getFullPath())) {
                int curOrder = tagOrders.get(singleSeriesExpression.getSeriesPath().getFullPath());
                realTagOrders.put(curOrder, singleSeriesExpression);
                currentQueryMaxTagNum = Math.max(currentQueryMaxTagNum, curOrder);
                continue;
            }
            fieldExpressions.add(singleSeriesExpression);
        }
        StringBuilder curQueryPath = new StringBuilder("root." + database + "." + measurement);
        for (int i = 1; i <= currentQueryMaxTagNum; ++i) {
            if (realTagOrders.containsKey(i)) {
                curQueryPath.append(".").append(StringUtils.removeQuotation(FilterUtils.getFilterStringValue(((SingleSeriesExpression)realTagOrders.get(i)).getFilter())));
                continue;
            }
            curQueryPath.append(".").append("*");
        }
        if (currentQueryMaxTagNum < tagOrders.size()) {
            curQueryPath.append(".**");
        }
        StringBuilder realIotDBCondition = new StringBuilder();
        for (int i = 0; i < fieldExpressions.size(); ++i) {
            SingleSeriesExpression singleSeriesExpression = (SingleSeriesExpression)fieldExpressions.get(i);
            if (i != 0) {
                realIotDBCondition.append(" and ");
            }
            realIotDBCondition.append(singleSeriesExpression.getSeriesPath().getFullPath()).append(" ").append(FilterUtils.getFilerSymbol(singleSeriesExpression.getFilter())).append(" ").append(FilterUtils.getFilterStringValue(singleSeriesExpression.getFilter()));
        }
        String realQuerySql = "select * from " + curQueryPath;
        if (realIotDBCondition.length() != 0) {
            realQuerySql = realQuerySql + " where " + realIotDBCondition;
        }
        realQuerySql = realQuerySql + " align by device";
        return this.queryByConditions(realQuerySql, database, measurement, null, fieldOrders, sessionId);
    }

    public List<IExpression> convertToIExpressions(Expression predicate) {
        if (predicate instanceof CompareBinaryExpression) {
            Expression leftExpression = ((CompareBinaryExpression)predicate).getLeftExpression();
            Expression rightExpression = ((CompareBinaryExpression)predicate).getRightExpression();
            if (!(leftExpression instanceof TimeSeriesOperand) || !(rightExpression instanceof ConstantOperand)) {
                throw new SemanticException("Unsupported predicate: " + predicate);
            }
            SingleSeriesExpression singleSeriesExpression = new SingleSeriesExpression((Path)((TimeSeriesOperand)leftExpression).getPath(), FilterUtils.expressionTypeToFilter(predicate.getExpressionType(), ((ConstantOperand)rightExpression).getValueString()));
            return Collections.singletonList(singleSeriesExpression);
        }
        if (predicate instanceof LogicBinaryExpression) {
            ArrayList<IExpression> iExpressions = new ArrayList<IExpression>();
            iExpressions.addAll(this.convertToIExpressions(((LogicBinaryExpression)predicate).getLeftExpression()));
            iExpressions.addAll(this.convertToIExpressions(((LogicBinaryExpression)predicate).getRightExpression()));
            return iExpressions;
        }
        throw new IllegalArgumentException("unsupported expression type: " + (Object)((Object)predicate.getExpressionType()));
    }

    public boolean canMergePredicate(Expression predicate) {
        if (predicate instanceof CompareBinaryExpression) {
            return true;
        }
        if (predicate instanceof LogicOrExpression) {
            return false;
        }
        if (predicate instanceof LogicAndExpression) {
            return this.canMergePredicate(((LogicAndExpression)predicate).getLeftExpression()) && this.canMergePredicate(((LogicAndExpression)predicate).getRightExpression());
        }
        throw new IllegalArgumentException("unsupported expression type: " + (Object)((Object)predicate.getExpressionType()));
    }
}

