/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.memory;

import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import javax.annotation.Nullable;
import org.apache.commons.lang3.Validate;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(MemoryPool.class);
    private final String id;
    private final long maxBytes;
    private final long maxBytesPerFragmentInstance;
    private long reservedBytes = 0L;
    private final Map<String, Map<String, Map<String, Long>>> queryMemoryReservations = new HashMap<String, Map<String, Map<String, Long>>>();
    private final Queue<MemoryReservationFuture<Void>> memoryReservationFutures = new LinkedList<MemoryReservationFuture<Void>>();

    public MemoryPool(String id, long maxBytes, long maxBytesPerFragmentInstance) {
        this.id = (String)Validate.notNull((Object)id);
        Validate.isTrue((maxBytes > 0L ? 1 : 0) != 0, (String)"max bytes should be greater than zero: %d", (long)maxBytes);
        this.maxBytes = maxBytes;
        Validate.isTrue((maxBytesPerFragmentInstance > 0L && maxBytesPerFragmentInstance <= maxBytes ? 1 : 0) != 0, (String)"max bytes per query should be greater than zero while less than or equal to max bytes. maxBytesPerQuery: %d, maxBytes: %d", (Object[])new Object[]{maxBytesPerFragmentInstance, maxBytes});
        this.maxBytesPerFragmentInstance = maxBytesPerFragmentInstance;
    }

    public String getId() {
        return this.id;
    }

    public long getMaxBytes() {
        return this.maxBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<ListenableFuture<Void>, Boolean> reserve(String queryId, String fragmentInstanceId, String planNodeId, long bytesToReserve, long maxBytesCanReserve) {
        Validate.notNull((Object)queryId);
        Validate.notNull((Object)fragmentInstanceId);
        Validate.notNull((Object)planNodeId);
        Validate.isTrue((bytesToReserve > 0L && bytesToReserve <= this.maxBytesPerFragmentInstance ? 1 : 0) != 0, (String)"bytes should be greater than zero while less than or equal to max bytes per fragment instance: %d", (long)bytesToReserve);
        if (bytesToReserve > maxBytesCanReserve) {
            LOGGER.warn("Cannot reserve {}(Max: {}) bytes memory from MemoryPool for planNodeId{}", new Object[]{bytesToReserve, maxBytesCanReserve, planNodeId});
            throw new IllegalArgumentException("Query is aborted since it requests more memory than can be allocated.");
        }
        MemoryPool memoryPool = this;
        synchronized (memoryPool) {
            if (this.maxBytes - this.reservedBytes < bytesToReserve || maxBytesCanReserve - this.queryMemoryReservations.getOrDefault(queryId, Collections.emptyMap()).getOrDefault(fragmentInstanceId, Collections.emptyMap()).getOrDefault(planNodeId, 0L) < bytesToReserve) {
                LOGGER.debug("Blocked reserve request: {} bytes memory for planNodeId{}", (Object)bytesToReserve, (Object)planNodeId);
                MemoryReservationFuture result = MemoryReservationFuture.create(queryId, fragmentInstanceId, planNodeId, bytesToReserve, maxBytesCanReserve);
                this.memoryReservationFutures.add(result);
                return new Pair(result, (Object)Boolean.FALSE);
            }
            this.reservedBytes += bytesToReserve;
            this.queryMemoryReservations.computeIfAbsent(queryId, x -> new HashMap()).computeIfAbsent(fragmentInstanceId, x -> new HashMap()).merge(planNodeId, bytesToReserve, Long::sum);
            ListenableFuture result = Futures.immediateFuture(null);
            return new Pair((Object)result, (Object)Boolean.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryReserve(String queryId, String fragmentInstanceId, String planNodeId, long bytesToReserve, long maxBytesCanReserve) {
        Validate.notNull((Object)queryId);
        Validate.notNull((Object)fragmentInstanceId);
        Validate.notNull((Object)planNodeId);
        Validate.isTrue((bytesToReserve > 0L && bytesToReserve <= this.maxBytesPerFragmentInstance ? 1 : 0) != 0, (String)"bytes should be greater than zero while less than or equal to max bytes per fragment instance: %d", (long)bytesToReserve);
        if (this.maxBytes - this.reservedBytes < bytesToReserve || maxBytesCanReserve - this.queryMemoryReservations.getOrDefault(queryId, Collections.emptyMap()).getOrDefault(fragmentInstanceId, Collections.emptyMap()).getOrDefault(planNodeId, 0L) < bytesToReserve) {
            return false;
        }
        MemoryPool memoryPool = this;
        synchronized (memoryPool) {
            if (this.maxBytes - this.reservedBytes < bytesToReserve || maxBytesCanReserve - this.queryMemoryReservations.getOrDefault(queryId, Collections.emptyMap()).getOrDefault(fragmentInstanceId, Collections.emptyMap()).getOrDefault(planNodeId, 0L) < bytesToReserve) {
                return false;
            }
            this.reservedBytes += bytesToReserve;
            this.queryMemoryReservations.computeIfAbsent(queryId, x -> new HashMap()).computeIfAbsent(fragmentInstanceId, x -> new HashMap()).merge(planNodeId, bytesToReserve, Long::sum);
        }
        return true;
    }

    public synchronized long tryCancel(ListenableFuture<Void> future) {
        Validate.notNull(future);
        if (future.isDone()) {
            return 0L;
        }
        Validate.isTrue((boolean)(future instanceof MemoryReservationFuture), (String)("invalid future type " + future.getClass().getSimpleName()), (Object[])new Object[0]);
        future.cancel(true);
        return ((MemoryReservationFuture)future).getBytesToReserve();
    }

    public synchronized long tryComplete(ListenableFuture<Void> future) {
        Validate.notNull(future);
        if (future.isDone()) {
            return 0L;
        }
        Validate.isTrue((boolean)(future instanceof MemoryReservationFuture), (String)("invalid future type " + future.getClass().getSimpleName()), (Object[])new Object[0]);
        ((MemoryReservationFuture)future).set(null);
        return ((MemoryReservationFuture)future).getBytesToReserve();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free(String queryId, String fragmentInstanceId, String planNodeId, long bytes) {
        ArrayList<MemoryReservationFuture> futureList = new ArrayList<MemoryReservationFuture>();
        MemoryPool memoryPool = this;
        synchronized (memoryPool) {
            Validate.notNull((Object)queryId);
            Validate.isTrue((bytes > 0L ? 1 : 0) != 0);
            Long queryReservedBytes = (Long)this.queryMemoryReservations.getOrDefault(queryId, Collections.emptyMap()).getOrDefault(fragmentInstanceId, Collections.emptyMap()).get(planNodeId);
            Validate.notNull((Object)queryReservedBytes);
            Validate.isTrue((bytes <= queryReservedBytes ? 1 : 0) != 0);
            queryReservedBytes = queryReservedBytes - bytes;
            this.queryMemoryReservations.get(queryId).get(fragmentInstanceId).put(planNodeId, queryReservedBytes);
            this.reservedBytes -= bytes;
            if (this.memoryReservationFutures.isEmpty()) {
                return;
            }
            Iterator iterator = this.memoryReservationFutures.iterator();
            while (iterator.hasNext()) {
                MemoryReservationFuture future = (MemoryReservationFuture)((Object)iterator.next());
                if (future.isCancelled() || future.isDone()) continue;
                long bytesToReserve = future.getBytesToReserve();
                String curQueryId = future.getQueryId();
                String curFragmentInstanceId = future.getFragmentInstanceId();
                String curPlanNodeId = future.getPlanNodeId();
                if (this.maxBytes - this.reservedBytes < bytesToReserve || future.getMaxBytesCanReserve() - this.queryMemoryReservations.getOrDefault(curQueryId, Collections.emptyMap()).getOrDefault(curFragmentInstanceId, Collections.emptyMap()).getOrDefault(curPlanNodeId, 0L) < bytesToReserve) continue;
                this.reservedBytes += bytesToReserve;
                this.queryMemoryReservations.computeIfAbsent(curQueryId, x -> new HashMap()).computeIfAbsent(curFragmentInstanceId, x -> new HashMap()).merge(curPlanNodeId, bytesToReserve, Long::sum);
                futureList.add(future);
                iterator.remove();
            }
        }
        for (MemoryReservationFuture future : futureList) {
            try {
                future.set(null);
            }
            catch (Throwable t) {
                LOGGER.warn("error happened while trying to free memory: ", t);
            }
        }
    }

    public long getQueryMemoryReservedBytes(String queryId) {
        if (!this.queryMemoryReservations.containsKey(queryId)) {
            return 0L;
        }
        long sum = 0L;
        for (Map<String, Long> map : this.queryMemoryReservations.get(queryId).values()) {
            sum += map.values().stream().reduce(0L, Long::sum).longValue();
        }
        return sum;
    }

    public long getReservedBytes() {
        return this.reservedBytes;
    }

    public synchronized void clearMemoryReservationMap(String queryId, String fragmentInstanceId, String planNodeId) {
        if (this.queryMemoryReservations.get(queryId) == null || this.queryMemoryReservations.get(queryId).get(fragmentInstanceId) == null) {
            return;
        }
        Map<String, Long> planNodeIdToBytesReserved = this.queryMemoryReservations.get(queryId).get(fragmentInstanceId);
        if (planNodeIdToBytesReserved.get(planNodeId) == null || planNodeIdToBytesReserved.get(planNodeId) <= 0L) {
            planNodeIdToBytesReserved.remove(planNodeId);
            if (planNodeIdToBytesReserved.isEmpty()) {
                this.queryMemoryReservations.get(queryId).remove(fragmentInstanceId);
            }
            if (this.queryMemoryReservations.get(queryId).isEmpty()) {
                this.queryMemoryReservations.remove(queryId);
            }
        }
    }

    public static class MemoryReservationFuture<V>
    extends AbstractFuture<V> {
        private final String queryId;
        private final String fragmentInstanceId;
        private final String planNodeId;
        private final long bytesToReserve;
        private final long maxBytesCanReserve;

        private MemoryReservationFuture(String queryId, String fragmentInstanceId, String planNodeId, long bytesToReserve, long maxBytesCanReserve) {
            this.queryId = (String)Validate.notNull((Object)queryId, (String)"queryId cannot be null", (Object[])new Object[0]);
            this.fragmentInstanceId = (String)Validate.notNull((Object)fragmentInstanceId, (String)"fragmentInstanceId cannot be null", (Object[])new Object[0]);
            this.planNodeId = (String)Validate.notNull((Object)planNodeId, (String)"planNodeId cannot be null", (Object[])new Object[0]);
            Validate.isTrue((bytesToReserve > 0L ? 1 : 0) != 0, (String)"bytesToReserve should be greater than zero.", (Object[])new Object[0]);
            Validate.isTrue((maxBytesCanReserve > 0L ? 1 : 0) != 0, (String)"maxBytesCanReserve should be greater than zero.", (Object[])new Object[0]);
            this.bytesToReserve = bytesToReserve;
            this.maxBytesCanReserve = maxBytesCanReserve;
        }

        public String getQueryId() {
            return this.queryId;
        }

        public String getFragmentInstanceId() {
            return this.fragmentInstanceId;
        }

        public String getPlanNodeId() {
            return this.planNodeId;
        }

        public long getBytesToReserve() {
            return this.bytesToReserve;
        }

        public long getMaxBytesCanReserve() {
            return this.maxBytesCanReserve;
        }

        public static <V> MemoryReservationFuture<V> create(String queryId, String fragmentInstanceId, String planNodeId, long bytesToReserve, long maxBytesCanReserve) {
            return new MemoryReservationFuture<V>(queryId, fragmentInstanceId, planNodeId, bytesToReserve, maxBytesCanReserve);
        }

        public boolean set(@Nullable V value) {
            return super.set(value);
        }
    }
}

