/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.schemaregion;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.schema.ClusterSchemaQuotaLevel;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.AliasAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.PathAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.SchemaDirCreationFailureException;
import org.apache.iotdb.db.exception.metadata.SchemaQuotaExceededException;
import org.apache.iotdb.db.exception.metadata.SeriesOverflowException;
import org.apache.iotdb.db.metadata.idtable.IDTable;
import org.apache.iotdb.db.metadata.idtable.IDTableManager;
import org.apache.iotdb.db.metadata.logfile.FakeCRC32Deserializer;
import org.apache.iotdb.db.metadata.logfile.FakeCRC32Serializer;
import org.apache.iotdb.db.metadata.logfile.MLogDescriptionReader;
import org.apache.iotdb.db.metadata.logfile.MLogDescriptionWriter;
import org.apache.iotdb.db.metadata.logfile.SchemaLogReader;
import org.apache.iotdb.db.metadata.logfile.SchemaLogWriter;
import org.apache.iotdb.db.metadata.metric.ISchemaRegionMetric;
import org.apache.iotdb.db.metadata.metric.SchemaRegionCachedMetric;
import org.apache.iotdb.db.metadata.mnode.IEntityMNode;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mtree.MTreeBelowSGCachedImpl;
import org.apache.iotdb.db.metadata.mtree.store.disk.cache.CacheMemoryManager;
import org.apache.iotdb.db.metadata.plan.schemaregion.ISchemaRegionPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.SchemaRegionPlanVisitor;
import org.apache.iotdb.db.metadata.plan.schemaregion.impl.SchemaRegionPlanDeserializer;
import org.apache.iotdb.db.metadata.plan.schemaregion.impl.SchemaRegionPlanSerializer;
import org.apache.iotdb.db.metadata.plan.schemaregion.impl.write.SchemaRegionWritePlanFactory;
import org.apache.iotdb.db.metadata.plan.schemaregion.read.IShowDevicesPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.read.IShowNodesPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.read.IShowTimeSeriesPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.IActivateTemplateInClusterPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.IAutoCreateDeviceMNodePlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.IChangeAliasPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.IChangeTagOffsetPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.ICreateAlignedTimeSeriesPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.ICreateTimeSeriesPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.IDeactivateTemplatePlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.IDeleteTimeSeriesPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.IPreDeactivateTemplatePlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.IPreDeleteTimeSeriesPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.IRollbackPreDeactivateTemplatePlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.IRollbackPreDeleteTimeSeriesPlan;
import org.apache.iotdb.db.metadata.query.info.IDeviceSchemaInfo;
import org.apache.iotdb.db.metadata.query.info.INodeSchemaInfo;
import org.apache.iotdb.db.metadata.query.info.ITimeSeriesSchemaInfo;
import org.apache.iotdb.db.metadata.query.reader.ISchemaReader;
import org.apache.iotdb.db.metadata.rescon.CachedSchemaRegionStatistics;
import org.apache.iotdb.db.metadata.rescon.DataNodeSchemaQuotaManager;
import org.apache.iotdb.db.metadata.rescon.MemSchemaRegionStatistics;
import org.apache.iotdb.db.metadata.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.metadata.schemaregion.ISchemaRegionParams;
import org.apache.iotdb.db.metadata.schemaregion.SchemaRegion;
import org.apache.iotdb.db.metadata.schemaregion.SchemaRegionUtils;
import org.apache.iotdb.db.metadata.tag.TagManager;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.utils.SchemaUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SchemaRegion(mode="Schema_File")
public class SchemaRegionSchemaFileImpl
implements ISchemaRegion {
    private static final Logger logger = LoggerFactory.getLogger(SchemaRegionSchemaFileImpl.class);
    protected static IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private boolean isRecovering = true;
    private volatile boolean initialized = false;
    private boolean isClearing = false;
    private final String storageGroupDirPath;
    private final String schemaRegionDirPath;
    private final String storageGroupFullPath;
    private final SchemaRegionId schemaRegionId;
    private boolean usingMLog = true;
    private SchemaLogWriter<ISchemaRegionPlan> logWriter;
    private MLogDescriptionWriter logDescriptionWriter;
    private final CachedSchemaRegionStatistics regionStatistics;
    private final DataNodeSchemaQuotaManager schemaQuotaManager = DataNodeSchemaQuotaManager.getInstance();
    private MTreeBelowSGCachedImpl mtree;
    private TagManager tagManager;

    public SchemaRegionSchemaFileImpl(ISchemaRegionParams schemaRegionParams) throws MetadataException {
        this.storageGroupFullPath = schemaRegionParams.getDatabase().getFullPath();
        this.schemaRegionId = schemaRegionParams.getSchemaRegionId();
        this.storageGroupDirPath = config.getSchemaDir() + File.separator + this.storageGroupFullPath;
        this.schemaRegionDirPath = this.storageGroupDirPath + File.separator + this.schemaRegionId.getId();
        this.regionStatistics = new CachedSchemaRegionStatistics(this.schemaRegionId.getId(), schemaRegionParams.getSchemaEngineStatistics());
        this.init();
    }

    @Override
    public synchronized void init() throws MetadataException {
        if (this.initialized) {
            return;
        }
        this.initDir();
        try {
            this.isRecovering = true;
            this.tagManager = new TagManager(this.schemaRegionDirPath);
            this.mtree = new MTreeBelowSGCachedImpl(new PartialPath(this.storageGroupFullPath), this.tagManager::readTags, this::flushCallback, this.measurementInitProcess(), this.deviceInitProcess(), this.schemaRegionId.getId(), this.regionStatistics);
            if (!config.isClusterMode() || !config.getSchemaRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus")) {
                this.usingMLog = true;
                this.initMLog();
            } else {
                this.usingMLog = false;
            }
            this.isRecovering = false;
        }
        catch (IOException e) {
            logger.error("Cannot recover all MTree from {} file, we try to recover as possible as we can", (Object)this.storageGroupFullPath, (Object)e);
        }
        this.initialized = true;
    }

    private Consumer<IMeasurementMNode> measurementInitProcess() {
        return measurementMNode -> {
            this.regionStatistics.addTimeseries(1L);
            if (measurementMNode.getOffset() == -1L) {
                return;
            }
            try {
                this.tagManager.recoverIndex(measurementMNode.getOffset(), (IMeasurementMNode)measurementMNode);
            }
            catch (IOException e) {
                logger.error("Failed to recover tagIndex for {} in schemaRegion {}.", (Object)(this.storageGroupFullPath + "." + measurementMNode.getFullPath()), (Object)this.schemaRegionId);
            }
        };
    }

    private Consumer<IEntityMNode> deviceInitProcess() {
        return deviceMNode -> {
            this.regionStatistics.addDevice();
            if (deviceMNode.getSchemaTemplateIdWithState() >= 0) {
                this.regionStatistics.activateTemplate(deviceMNode.getSchemaTemplateId());
            }
        };
    }

    private void flushCallback() {
        if (this.usingMLog && !this.isRecovering) {
            try {
                this.logDescriptionWriter.updateCheckPoint(this.logWriter.position());
                this.regionStatistics.setMLogCheckPoint(this.logWriter.position());
            }
            catch (IOException e) {
                logger.warn("Update {} failed because {}", new Object[]{"mlog.description", e.getMessage(), e});
            }
        }
    }

    private void initDir() throws SchemaDirCreationFailureException {
        File schemaRegionFolder;
        File sgSchemaFolder = SystemFileFactory.INSTANCE.getFile(this.storageGroupDirPath);
        if (!sgSchemaFolder.exists()) {
            if (sgSchemaFolder.mkdirs()) {
                logger.info("create database schema folder {}", (Object)this.storageGroupDirPath);
            } else if (!sgSchemaFolder.exists()) {
                logger.error("create database schema folder {} failed.", (Object)this.storageGroupDirPath);
                throw new SchemaDirCreationFailureException(this.storageGroupDirPath);
            }
        }
        if (!(schemaRegionFolder = SystemFileFactory.INSTANCE.getFile(this.schemaRegionDirPath)).exists()) {
            if (schemaRegionFolder.mkdirs()) {
                logger.info("create schema region folder {}", (Object)this.schemaRegionDirPath);
            } else if (!schemaRegionFolder.exists()) {
                logger.error("create schema region folder {} failed.", (Object)this.schemaRegionDirPath);
                throw new SchemaDirCreationFailureException(this.schemaRegionDirPath);
            }
        }
    }

    private void initMLog() throws IOException {
        this.initFromLog();
        this.logWriter = new SchemaLogWriter<ISchemaRegionPlan>(this.schemaRegionDirPath, "mlog.bin", new FakeCRC32Serializer<ISchemaRegionPlan>(new SchemaRegionPlanSerializer()), config.getSyncMlogPeriodInMs() == 0L);
        this.logDescriptionWriter = new MLogDescriptionWriter(this.schemaRegionDirPath, "mlog.description");
    }

    public void writeToMLog(ISchemaRegionPlan schemaRegionPlan) throws IOException {
        if (this.usingMLog && !this.isRecovering) {
            this.logWriter.write(schemaRegionPlan);
            this.regionStatistics.setMLogLength(this.logWriter.position());
        }
    }

    @Override
    public void forceMlog() {
        if (!this.initialized) {
            return;
        }
        if (this.usingMLog) {
            try {
                SchemaLogWriter<ISchemaRegionPlan> logWriter = this.logWriter;
                if (logWriter != null) {
                    logWriter.force();
                }
            }
            catch (IOException e) {
                logger.error("Cannot force {} mlog to the schema region", (Object)this.schemaRegionId, (Object)e);
            }
        }
    }

    @Override
    public MemSchemaRegionStatistics getSchemaRegionStatistics() {
        return this.regionStatistics;
    }

    @Override
    public ISchemaRegionMetric createSchemaRegionMetric() {
        return new SchemaRegionCachedMetric(this.regionStatistics);
    }

    private void initFromLog() throws IOException {
        File logFile = SystemFileFactory.INSTANCE.getFile(this.schemaRegionDirPath + File.separator + "mlog.bin");
        File logDescriptionFile = SystemFileFactory.INSTANCE.getFile(this.schemaRegionDirPath + File.separator + "mlog.description");
        long time = System.currentTimeMillis();
        if (logFile.exists()) {
            long mLogOffset = 0L;
            try {
                MLogDescriptionReader mLogDescriptionReader = new MLogDescriptionReader(this.schemaRegionDirPath, "mlog.description");
                mLogOffset = mLogDescriptionReader.readCheckPoint();
                logger.info("MLog recovery check point: {}", (Object)mLogOffset);
            }
            catch (IOException e) {
                logger.warn("Can not get check point in MLogDescription file because {}, use default value 0.", (Object)e.getMessage());
            }
            try (SchemaLogReader<ISchemaRegionPlan> mLogReader = new SchemaLogReader<ISchemaRegionPlan>(this.schemaRegionDirPath, "mlog.bin", new FakeCRC32Deserializer<ISchemaRegionPlan>(new SchemaRegionPlanDeserializer()));){
                this.applyMLog(mLogReader, mLogOffset);
                logger.debug("spend {} ms to deserialize {} mtree from mlog.bin", (Object)(System.currentTimeMillis() - time), (Object)this.storageGroupFullPath);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IOException("Failed to parse " + this.storageGroupFullPath + " mlog.bin for err:" + e);
            }
        }
    }

    private void applyMLog(SchemaLogReader<ISchemaRegionPlan> mLogReader, long offset) {
        RecoverPlanOperator recoverPlanOperator = new RecoverPlanOperator();
        try {
            mLogReader.skip(offset);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        while (mLogReader.hasNext()) {
            ISchemaRegionPlan plan = mLogReader.next();
            RecoverOperationResult operationResult = plan.accept(recoverPlanOperator, this);
            if (!operationResult.isFailed()) continue;
            logger.error("Can not operate cmd {} for err:", (Object)plan.getPlanType().name(), (Object)operationResult.getException());
        }
        if (mLogReader.isFileCorrupted()) {
            throw new IllegalStateException("The mlog.bin has been corrupted. Please remove it or fix it, and then restart IoTDB");
        }
    }

    @Override
    public synchronized void clear() {
        this.isClearing = true;
        try {
            if (this.mtree != null) {
                this.mtree.clear();
            }
            this.regionStatistics.clear();
            if (this.logWriter != null) {
                this.logWriter.close();
                this.logWriter = null;
            }
            if (this.logDescriptionWriter != null) {
                this.logDescriptionWriter.close();
                this.logDescriptionWriter = null;
            }
            this.tagManager.clear();
            this.isRecovering = true;
            this.initialized = false;
        }
        catch (IOException e) {
            logger.error("Cannot close metadata log writer, because:", (Throwable)e);
        }
        this.isClearing = false;
    }

    @Override
    public String getStorageGroupFullPath() {
        return this.storageGroupFullPath;
    }

    @Override
    public SchemaRegionId getSchemaRegionId() {
        return this.schemaRegionId;
    }

    @Override
    public synchronized void deleteSchemaRegion() throws MetadataException {
        this.clear();
        SchemaRegionUtils.deleteSchemaRegionFolder(this.schemaRegionDirPath, logger);
    }

    @Override
    public boolean createSnapshot(File snapshotDir) {
        if (!this.initialized) {
            logger.warn("Failed to create snapshot of schemaRegion {}, because the schemaRegion has not been initialized.", (Object)this.schemaRegionId);
            return false;
        }
        logger.info("Start create snapshot of schemaRegion {}", (Object)this.schemaRegionId);
        boolean isSuccess = true;
        long startTime = System.currentTimeMillis();
        long mtreeSnapshotStartTime = System.currentTimeMillis();
        isSuccess = isSuccess && this.mtree.createSnapshot(snapshotDir);
        logger.info("MTree snapshot creation of schemaRegion {} costs {}ms.", (Object)this.schemaRegionId, (Object)(System.currentTimeMillis() - mtreeSnapshotStartTime));
        long tagSnapshotStartTime = System.currentTimeMillis();
        isSuccess = isSuccess && this.tagManager.createSnapshot(snapshotDir);
        logger.info("Tag snapshot creation of schemaRegion {} costs {}ms.", (Object)this.schemaRegionId, (Object)(System.currentTimeMillis() - tagSnapshotStartTime));
        logger.info("Snapshot creation of schemaRegion {} costs {}ms.", (Object)this.schemaRegionId, (Object)(System.currentTimeMillis() - startTime));
        logger.info("Successfully create snapshot of schemaRegion {}", (Object)this.schemaRegionId);
        return isSuccess;
    }

    @Override
    public void loadSnapshot(File latestSnapshotRootDir) {
        this.clear();
        logger.info("Start loading snapshot of schemaRegion {}", (Object)this.schemaRegionId);
        long startTime = System.currentTimeMillis();
        try {
            this.usingMLog = false;
            this.isRecovering = true;
            long tagSnapshotStartTime = System.currentTimeMillis();
            this.tagManager = TagManager.loadFromSnapshot(latestSnapshotRootDir, this.schemaRegionDirPath);
            logger.info("Tag snapshot loading of schemaRegion {} costs {}ms.", (Object)this.schemaRegionId, (Object)(System.currentTimeMillis() - tagSnapshotStartTime));
            long mtreeSnapshotStartTime = System.currentTimeMillis();
            this.mtree = MTreeBelowSGCachedImpl.loadFromSnapshot(latestSnapshotRootDir, this.storageGroupFullPath, this.schemaRegionId.getId(), this.regionStatistics, this.measurementInitProcess(), this.deviceInitProcess(), this.tagManager::readTags, this::flushCallback);
            logger.info("MTree snapshot loading of schemaRegion {} costs {}ms.", (Object)this.schemaRegionId, (Object)(System.currentTimeMillis() - mtreeSnapshotStartTime));
            this.isRecovering = false;
            this.initialized = true;
            logger.info("Snapshot loading of schemaRegion {} costs {}ms.", (Object)this.schemaRegionId, (Object)(System.currentTimeMillis() - startTime));
            logger.info("Successfully load snapshot of schemaRegion {}", (Object)this.schemaRegionId);
        }
        catch (IOException | MetadataException e) {
            logger.error("Failed to load snapshot for schemaRegion {}  due to {}. Use empty schemaRegion", new Object[]{this.schemaRegionId, e.getMessage(), e});
            try {
                this.initialized = false;
                this.isRecovering = true;
                this.init();
            }
            catch (MetadataException metadataException) {
                logger.error("Error occurred during initializing schemaRegion {}", (Object)this.schemaRegionId, (Object)metadataException);
            }
        }
    }

    public void createTimeseries(ICreateTimeSeriesPlan plan) throws MetadataException {
        this.createTimeseries(plan, -1L);
    }

    public void recoverTimeseries(ICreateTimeSeriesPlan plan, long offset) throws MetadataException {
        boolean done = false;
        while (!done) {
            try {
                this.createTimeseries(plan, offset);
                done = true;
            }
            catch (SeriesOverflowException e) {
                logger.warn("Too many timeseries during recovery from MLog, waiting for SchemaFile swapping.");
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e2) {
                    logger.error("Exception occurs during timeseries recovery.");
                    throw new MetadataException(e2.getMessage());
                }
            }
            catch (AliasAlreadyExistException | PathAlreadyExistException e) {
                done = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createTimeseries(ICreateTimeSeriesPlan plan, long offset) throws MetadataException {
        while (!this.regionStatistics.isAllowToCreateNewSeries()) {
            CacheMemoryManager.getInstance().waitIfReleasing();
        }
        try {
            PartialPath path = plan.getPath();
            SchemaUtils.checkDataTypeWithEncoding(plan.getDataType(), plan.getEncoding());
            TSDataType type = plan.getDataType();
            IMeasurementMNode leafMNode = this.mtree.createTimeseriesWithPinnedReturn(path, type, plan.getEncoding(), plan.getCompressor(), plan.getProps(), plan.getAlias());
            try {
                this.regionStatistics.addTimeseries(1L);
                if (offset != -1L && this.isRecovering) {
                    this.tagManager.recoverIndex(offset, leafMNode);
                    this.mtree.pinMNode(leafMNode);
                } else if (plan.getTags() != null) {
                    this.tagManager.addIndex(plan.getTags(), leafMNode);
                    this.mtree.pinMNode(leafMNode);
                }
                if (!this.isRecovering) {
                    if (plan.getTags() != null && !plan.getTags().isEmpty() || plan.getAttributes() != null && !plan.getAttributes().isEmpty()) {
                        offset = this.tagManager.writeTagFile(plan.getTags(), plan.getAttributes());
                    }
                    plan.setTagOffset(offset);
                    this.writeToMLog(plan);
                }
                if (offset != -1L) {
                    leafMNode.setOffset(offset);
                    this.mtree.updateMNode(leafMNode);
                }
            }
            finally {
                this.mtree.unPinMNode(leafMNode);
            }
        }
        catch (IOException e) {
            throw new MetadataException((Throwable)e);
        }
        if (!(!config.isEnableIDTable() || this.isRecovering && config.isEnableIDTableLogFile())) {
            IDTable idTable = IDTableManager.getInstance().getIDTable(plan.getPath().getDevicePath());
            idTable.createTimeseries(plan);
        }
    }

    public void createAlignedTimeSeries(PartialPath prefixPath, List<String> measurements, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors) throws MetadataException {
        this.createAlignedTimeSeries(SchemaRegionWritePlanFactory.getCreateAlignedTimeSeriesPlan(prefixPath, measurements, dataTypes, encodings, compressors, null, null, null));
    }

    public void recoverAlignedTimeSeries(ICreateAlignedTimeSeriesPlan plan) throws MetadataException {
        boolean done = false;
        while (!done) {
            try {
                this.createAlignedTimeSeries(plan);
                done = true;
            }
            catch (SeriesOverflowException e) {
                logger.warn("Too many timeseries during recovery from MLog, waiting for SchemaFile swapping.");
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e2) {
                    logger.error("Exception occurs during timeseries recovery.");
                    throw new MetadataException(e2.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createAlignedTimeSeries(ICreateAlignedTimeSeriesPlan plan) throws MetadataException {
        int seriesCount = plan.getMeasurements().size();
        while (!this.regionStatistics.isAllowToCreateNewSeries()) {
            CacheMemoryManager.getInstance().waitIfReleasing();
        }
        try {
            PartialPath prefixPath = plan.getDevicePath();
            List<String> measurements = plan.getMeasurements();
            List<TSDataType> dataTypes = plan.getDataTypes();
            List<TSEncoding> encodings = plan.getEncodings();
            List<Map<String, String>> tagsList = plan.getTagsList();
            List<Map<String, String>> attributesList = plan.getAttributesList();
            for (int i = 0; i < measurements.size(); ++i) {
                SchemaUtils.checkDataTypeWithEncoding(dataTypes.get(i), encodings.get(i));
            }
            List<IMeasurementMNode> measurementMNodeList = this.mtree.createAlignedTimeseries(prefixPath, measurements, plan.getDataTypes(), plan.getEncodings(), plan.getCompressors(), plan.getAliasList());
            try {
                int i;
                this.regionStatistics.addTimeseries(seriesCount);
                List<Long> tagOffsets = plan.getTagOffsets();
                for (i = 0; i < measurements.size(); ++i) {
                    if (tagOffsets != null && !plan.getTagOffsets().isEmpty() && this.isRecovering) {
                        if (tagOffsets.get(i) == -1L) continue;
                        this.tagManager.recoverIndex(plan.getTagOffsets().get(i), measurementMNodeList.get(i));
                        this.mtree.pinMNode(measurementMNodeList.get(i));
                        continue;
                    }
                    if (tagsList == null || tagsList.isEmpty() || tagsList.get(i) == null) continue;
                    this.tagManager.addIndex(tagsList.get(i), measurementMNodeList.get(i));
                    this.mtree.pinMNode(measurementMNodeList.get(i));
                }
                tagOffsets = new ArrayList<Long>();
                if (!this.isRecovering) {
                    if (tagsList != null && !tagsList.isEmpty() || attributesList != null && !attributesList.isEmpty()) {
                        for (int i2 = 0; i2 < measurements.size(); ++i2) {
                            Map<String, String> attributes;
                            Map<String, String> tags = tagsList == null ? null : tagsList.get(i2);
                            Map<String, String> map = attributes = attributesList == null ? null : attributesList.get(i2);
                            if (tags == null && attributes == null) {
                                tagOffsets.add(-1L);
                                continue;
                            }
                            tagOffsets.add(this.tagManager.writeTagFile(tags, attributes));
                        }
                    } else {
                        for (i = 0; i < measurements.size(); ++i) {
                            tagOffsets.add(-1L);
                        }
                    }
                    plan.setTagOffsets(tagOffsets);
                    this.writeToMLog(plan);
                }
                tagOffsets = plan.getTagOffsets();
                for (i = 0; i < measurements.size(); ++i) {
                    if (tagOffsets.get(i) == -1L) continue;
                    measurementMNodeList.get(i).setOffset(tagOffsets.get(i));
                    this.mtree.updateMNode(measurementMNodeList.get(i));
                }
            }
            finally {
                for (IMeasurementMNode measurementMNode : measurementMNodeList) {
                    this.mtree.unPinMNode(measurementMNode);
                }
            }
        }
        catch (IOException e) {
            throw new MetadataException((Throwable)e);
        }
        if (!(!config.isEnableIDTable() || this.isRecovering && config.isEnableIDTableLogFile())) {
            IDTable idTable = IDTableManager.getInstance().getIDTable(plan.getDevicePath());
            idTable.createAlignedTimeseries(plan);
        }
    }

    @Override
    public Map<Integer, MetadataException> checkMeasurementExistence(PartialPath devicePath, List<String> measurementList, List<String> aliasList) {
        return this.mtree.checkMeasurementExistence(devicePath, measurementList, aliasList);
    }

    @Override
    public void checkSchemaQuota(PartialPath devicePath, int timeSeriesNum) throws SchemaQuotaExceededException {
        if (this.schemaQuotaManager.getLevel().equals((Object)ClusterSchemaQuotaLevel.TIMESERIES)) {
            this.schemaQuotaManager.checkMeasurementLevel(timeSeriesNum);
        } else if (this.schemaQuotaManager.getLevel().equals((Object)ClusterSchemaQuotaLevel.DEVICE) && !this.mtree.checkDeviceNodeExists(devicePath)) {
            this.schemaQuotaManager.checkDeviceLevel();
        }
    }

    @Override
    public long constructSchemaBlackList(PathPatternTree patternTree) throws MetadataException {
        long preDeletedNum = 0L;
        for (PartialPath pathPattern : patternTree.getAllPathPatterns()) {
            List<PartialPath> paths = this.mtree.constructSchemaBlackList(pathPattern);
            preDeletedNum += (long)paths.size();
            for (PartialPath path : paths) {
                try {
                    this.writeToMLog(SchemaRegionWritePlanFactory.getPreDeleteTimeSeriesPlan(path));
                }
                catch (IOException e) {
                    throw new MetadataException((Throwable)e);
                }
            }
        }
        return preDeletedNum;
    }

    private void recoverPreDeleteTimeseries(PartialPath path) throws MetadataException {
        this.mtree.constructSchemaBlackList(path);
    }

    @Override
    public void rollbackSchemaBlackList(PathPatternTree patternTree) throws MetadataException {
        for (PartialPath pathPattern : patternTree.getAllPathPatterns()) {
            List<PartialPath> paths = this.mtree.rollbackSchemaBlackList(pathPattern);
            for (PartialPath path : paths) {
                try {
                    this.writeToMLog(SchemaRegionWritePlanFactory.getRollbackPreDeleteTimeSeriesPlan(path));
                }
                catch (IOException e) {
                    throw new MetadataException((Throwable)e);
                }
            }
        }
    }

    @Override
    public Set<PartialPath> fetchSchemaBlackList(PathPatternTree patternTree) throws MetadataException {
        HashSet<PartialPath> deviceBasedPathPatternSet = new HashSet<PartialPath>();
        for (PartialPath pathPattern : patternTree.getAllPathPatterns()) {
            for (PartialPath devicePath : this.mtree.getDevicesOfPreDeletedTimeseries(pathPattern)) {
                deviceBasedPathPatternSet.addAll(pathPattern.alterPrefixPath(devicePath));
            }
        }
        return deviceBasedPathPatternSet;
    }

    @Override
    public void deleteTimeseriesInBlackList(PathPatternTree patternTree) throws MetadataException {
        for (PartialPath pathPattern : patternTree.getAllPathPatterns()) {
            for (PartialPath path : this.mtree.getPreDeletedTimeseries(pathPattern)) {
                try {
                    this.deleteSingleTimeseriesInBlackList(path);
                    this.writeToMLog(SchemaRegionWritePlanFactory.getDeleteTimeSeriesPlan(Collections.singletonList(path)));
                }
                catch (IOException e) {
                    throw new MetadataException((Throwable)e);
                }
            }
        }
    }

    private void deleteSingleTimeseriesInBlackList(PartialPath path) throws MetadataException, IOException {
        IMeasurementMNode measurementMNode = this.mtree.deleteTimeseries(path);
        this.removeFromTagInvertedIndex(measurementMNode);
        this.regionStatistics.deleteTimeseries(1L);
    }

    private void recoverRollbackPreDeleteTimeseries(PartialPath path) throws MetadataException {
        this.mtree.rollbackSchemaBlackList(path);
    }

    private void deleteOneTimeseriesUpdateStatistics(PartialPath path) throws MetadataException, IOException {
        IMeasurementMNode measurementMNode = this.mtree.deleteTimeseries(path);
        this.removeFromTagInvertedIndex(measurementMNode);
        this.regionStatistics.deleteTimeseries(1L);
    }

    private IMNode getDeviceNodeWithAutoCreate(PartialPath path) throws IOException, MetadataException {
        IMNode node = this.mtree.getDeviceNodeWithAutoCreating(path);
        this.writeToMLog(SchemaRegionWritePlanFactory.getAutoCreateDeviceMNodePlan(node.getPartialPath()));
        return node;
    }

    private void autoCreateDeviceMNode(IAutoCreateDeviceMNodePlan plan) throws MetadataException {
        IMNode node = this.mtree.getDeviceNodeWithAutoCreating(plan.getPath());
        this.mtree.unPinMNode(node);
        try {
            this.writeToMLog(plan);
        }
        catch (IOException e) {
            throw new MetadataException((Throwable)e);
        }
    }

    @Override
    public List<MeasurementPath> fetchSchema(PartialPath pathPattern, Map<Integer, Template> templateMap, boolean withTags) throws MetadataException {
        return this.mtree.fetchSchema(pathPattern, templateMap, withTags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeOffset(PartialPath path, long offset) throws MetadataException {
        block6: {
            IMeasurementMNode measurementMNode = this.mtree.getMeasurementMNode(path);
            try {
                measurementMNode.setOffset(offset);
                this.mtree.updateMNode(measurementMNode);
                if (!this.isRecovering) break block6;
                try {
                    if (this.tagManager.recoverIndex(offset, measurementMNode)) {
                        this.mtree.pinMNode(measurementMNode);
                    }
                }
                catch (IOException e) {
                    throw new MetadataException((Throwable)e);
                }
            }
            finally {
                this.mtree.unPinMNode(measurementMNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeAlias(PartialPath path, String alias) throws MetadataException {
        IMeasurementMNode leafMNode = this.mtree.getMeasurementMNode(path);
        try {
            if (leafMNode.getAlias() != null) {
                leafMNode.getParent().deleteAliasChild(leafMNode.getAlias());
            }
            leafMNode.getParent().addAlias(alias, leafMNode);
            this.mtree.setAlias(leafMNode, alias);
        }
        finally {
            this.mtree.unPinMNode(leafMNode);
        }
        try {
            this.writeToMLog(SchemaRegionWritePlanFactory.getChangeAliasPlan(path, alias));
        }
        catch (IOException e) {
            throw new MetadataException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upsertAliasAndTagsAndAttributes(String alias, Map<String, String> tagsMap, Map<String, String> attributesMap, PartialPath fullPath) throws MetadataException, IOException {
        IMeasurementMNode leafMNode = this.mtree.getMeasurementMNode(fullPath);
        try {
            this.upsertAlias(alias, fullPath, leafMNode);
            if (tagsMap == null && attributesMap == null) {
                return;
            }
            if (leafMNode.getOffset() < 0L) {
                long offset = this.tagManager.writeTagFile(tagsMap, attributesMap);
                this.writeToMLog(SchemaRegionWritePlanFactory.getChangeTagOffsetPlan(fullPath, offset));
                leafMNode.setOffset(offset);
                this.mtree.updateMNode(leafMNode);
                if (tagsMap != null && !tagsMap.isEmpty()) {
                    this.tagManager.addIndex(tagsMap, leafMNode);
                    this.mtree.pinMNode(leafMNode);
                }
                return;
            }
            this.tagManager.updateTagsAndAttributes(tagsMap, attributesMap, leafMNode);
        }
        finally {
            this.mtree.unPinMNode(leafMNode);
        }
    }

    private void upsertAlias(String alias, PartialPath fullPath, IMeasurementMNode leafMNode) throws MetadataException, IOException {
        if (alias != null && !alias.equals(leafMNode.getAlias())) {
            if (!leafMNode.getParent().addAlias(alias, leafMNode)) {
                throw new MetadataException("The alias already exists.");
            }
            if (leafMNode.getAlias() != null) {
                leafMNode.getParent().deleteAliasChild(leafMNode.getAlias());
            }
            this.mtree.setAlias(leafMNode, alias);
            this.writeToMLog(SchemaRegionWritePlanFactory.getChangeAliasPlan(fullPath, alias));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAttributes(Map<String, String> attributesMap, PartialPath fullPath) throws MetadataException, IOException {
        IMeasurementMNode leafMNode = this.mtree.getMeasurementMNode(fullPath);
        try {
            if (leafMNode.getOffset() < 0L) {
                long offset = this.tagManager.writeTagFile(Collections.emptyMap(), attributesMap);
                this.writeToMLog(SchemaRegionWritePlanFactory.getChangeTagOffsetPlan(fullPath, offset));
                leafMNode.setOffset(offset);
                this.mtree.updateMNode(leafMNode);
                return;
            }
            this.tagManager.addAttributes(attributesMap, fullPath, leafMNode);
        }
        finally {
            this.mtree.updateMNode(leafMNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTags(Map<String, String> tagsMap, PartialPath fullPath) throws MetadataException, IOException {
        IMeasurementMNode leafMNode = this.mtree.getMeasurementMNode(fullPath);
        try {
            if (leafMNode.getOffset() < 0L) {
                long offset = this.tagManager.writeTagFile(tagsMap, Collections.emptyMap());
                this.writeToMLog(SchemaRegionWritePlanFactory.getChangeTagOffsetPlan(fullPath, offset));
                leafMNode.setOffset(offset);
                this.mtree.updateMNode(leafMNode);
                this.tagManager.addIndex(tagsMap, leafMNode);
                this.mtree.pinMNode(leafMNode);
                return;
            }
            this.tagManager.addTags(tagsMap, fullPath, leafMNode);
        }
        finally {
            this.mtree.unPinMNode(leafMNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropTagsOrAttributes(Set<String> keySet, PartialPath fullPath) throws MetadataException, IOException {
        IMeasurementMNode leafMNode = this.mtree.getMeasurementMNode(fullPath);
        try {
            if (leafMNode.getOffset() != -1L) {
                this.tagManager.dropTagsOrAttributes(keySet, fullPath, leafMNode);
                this.mtree.unPinMNode(leafMNode);
            }
        }
        finally {
            this.mtree.unPinMNode(leafMNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTagsOrAttributesValue(Map<String, String> alterMap, PartialPath fullPath) throws MetadataException, IOException {
        IMeasurementMNode leafMNode = this.mtree.getMeasurementMNode(fullPath);
        try {
            if (leafMNode.getOffset() < 0L) {
                throw new MetadataException(String.format("TimeSeries [%s] does not have any tag/attribute.", fullPath));
            }
            this.tagManager.setTagsOrAttributesValue(alterMap, fullPath, leafMNode);
        }
        finally {
            this.mtree.unPinMNode(leafMNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameTagOrAttributeKey(String oldKey, String newKey, PartialPath fullPath) throws MetadataException, IOException {
        IMeasurementMNode leafMNode = this.mtree.getMeasurementMNode(fullPath);
        try {
            if (leafMNode.getOffset() < 0L) {
                throw new MetadataException(String.format("TimeSeries [%s] does not have [%s] tag/attribute.", fullPath, oldKey), true);
            }
            this.tagManager.renameTagOrAttributeKey(oldKey, newKey, fullPath, leafMNode);
        }
        finally {
            this.mtree.unPinMNode(leafMNode);
        }
    }

    private void removeFromTagInvertedIndex(IMeasurementMNode node) throws IOException {
        this.tagManager.removeFromTagInvertedIndex(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activateSchemaTemplate(IActivateTemplateInClusterPlan plan, Template template) throws MetadataException {
        while (!this.regionStatistics.isAllowToCreateNewSeries()) {
            CacheMemoryManager.getInstance().waitIfReleasing();
        }
        try {
            IMNode deviceNode = this.getDeviceNodeWithAutoCreate(plan.getActivatePath());
            try {
                this.mtree.activateTemplate(plan.getActivatePath(), template);
                this.writeToMLog(plan);
            }
            finally {
                this.mtree.unPinMNode(deviceNode);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new MetadataException((Throwable)e);
        }
    }

    private void recoverActivatingSchemaTemplate(IActivateTemplateInClusterPlan plan) throws MetadataException {
        this.mtree.activateTemplateWithoutCheck(plan.getActivatePath(), plan.getTemplateId(), plan.isAligned());
    }

    @Override
    public long constructSchemaBlackListWithTemplate(IPreDeactivateTemplatePlan plan) throws MetadataException {
        Map<PartialPath, List<Integer>> resultTemplateSetInfo = this.mtree.constructSchemaBlackListWithTemplate(plan.getTemplateSetInfo());
        try {
            this.writeToMLog(SchemaRegionWritePlanFactory.getPreDeactivateTemplatePlan(resultTemplateSetInfo));
        }
        catch (IOException e) {
            throw new MetadataException((Throwable)e);
        }
        return resultTemplateSetInfo.size();
    }

    @Override
    public void rollbackSchemaBlackListWithTemplate(IRollbackPreDeactivateTemplatePlan plan) throws MetadataException {
        Map<PartialPath, List<Integer>> resultTemplateSetInfo = this.mtree.rollbackSchemaBlackListWithTemplate(plan.getTemplateSetInfo());
        try {
            this.writeToMLog(SchemaRegionWritePlanFactory.getRollbackPreDeactivateTemplatePlan(resultTemplateSetInfo));
        }
        catch (IOException e) {
            throw new MetadataException((Throwable)e);
        }
    }

    @Override
    public void deactivateTemplateInBlackList(IDeactivateTemplatePlan plan) throws MetadataException {
        Map<PartialPath, List<Integer>> resultTemplateSetInfo = this.mtree.deactivateTemplateInBlackList(plan.getTemplateSetInfo());
        try {
            this.writeToMLog(SchemaRegionWritePlanFactory.getDeactivateTemplatePlan(resultTemplateSetInfo));
        }
        catch (IOException e) {
            throw new MetadataException((Throwable)e);
        }
    }

    @Override
    public long countPathsUsingTemplate(int templateId, PathPatternTree patternTree) throws MetadataException {
        long result = 0L;
        for (PartialPath pathPattern : patternTree.getAllPathPatterns()) {
            result += this.mtree.countPathsUsingTemplate(pathPattern, templateId);
        }
        return result;
    }

    @Override
    public ISchemaReader<IDeviceSchemaInfo> getDeviceReader(IShowDevicesPlan showDevicesPlan) throws MetadataException {
        return this.mtree.getDeviceReader(showDevicesPlan);
    }

    @Override
    public ISchemaReader<ITimeSeriesSchemaInfo> getTimeSeriesReader(IShowTimeSeriesPlan showTimeSeriesPlan) throws MetadataException {
        if (showTimeSeriesPlan.getKey() != null && showTimeSeriesPlan.getValue() != null) {
            return this.tagManager.getTimeSeriesReaderWithIndex(showTimeSeriesPlan);
        }
        return this.mtree.getTimeSeriesReader(showTimeSeriesPlan, offset -> {
            try {
                return this.tagManager.readTagFile((long)offset);
            }
            catch (IOException e) {
                logger.error("Failed to read tag and attribute info because {}", (Object)e.getMessage(), (Object)e);
                return new Pair(Collections.emptyMap(), Collections.emptyMap());
            }
        });
    }

    @Override
    public ISchemaReader<INodeSchemaInfo> getNodeReader(IShowNodesPlan showNodesPlan) throws MetadataException {
        return this.mtree.getNodeReader(showNodesPlan);
    }

    private class RecoverPlanOperator
    extends SchemaRegionPlanVisitor<RecoverOperationResult, SchemaRegionSchemaFileImpl> {
        private RecoverPlanOperator() {
        }

        @Override
        public RecoverOperationResult visitSchemaRegionPlan(ISchemaRegionPlan plan, SchemaRegionSchemaFileImpl context) {
            throw new UnsupportedOperationException(String.format("SchemaRegionPlan of type %s doesn't support recover operation in SchemaRegionSchemaFileImpl.", plan.getPlanType().name()));
        }

        @Override
        public RecoverOperationResult visitCreateTimeSeries(ICreateTimeSeriesPlan createTimeSeriesPlan, SchemaRegionSchemaFileImpl context) {
            try {
                SchemaRegionSchemaFileImpl.this.recoverTimeseries(createTimeSeriesPlan, createTimeSeriesPlan.getTagOffset());
                return RecoverOperationResult.SUCCESS;
            }
            catch (MetadataException e) {
                return new RecoverOperationResult((Exception)((Object)e));
            }
        }

        @Override
        public RecoverOperationResult visitCreateAlignedTimeSeries(ICreateAlignedTimeSeriesPlan createAlignedTimeSeriesPlan, SchemaRegionSchemaFileImpl context) {
            try {
                SchemaRegionSchemaFileImpl.this.recoverAlignedTimeSeries(createAlignedTimeSeriesPlan);
                return RecoverOperationResult.SUCCESS;
            }
            catch (MetadataException e) {
                return new RecoverOperationResult((Exception)((Object)e));
            }
        }

        @Override
        public RecoverOperationResult visitDeleteTimeSeries(IDeleteTimeSeriesPlan deleteTimeSeriesPlan, SchemaRegionSchemaFileImpl context) {
            try {
                SchemaRegionSchemaFileImpl.this.deleteOneTimeseriesUpdateStatistics(deleteTimeSeriesPlan.getDeletePathList().get(0));
                return RecoverOperationResult.SUCCESS;
            }
            catch (IOException | MetadataException e) {
                return new RecoverOperationResult((Exception)e);
            }
        }

        @Override
        public RecoverOperationResult visitChangeAlias(IChangeAliasPlan changeAliasPlan, SchemaRegionSchemaFileImpl context) {
            try {
                SchemaRegionSchemaFileImpl.this.changeAlias(changeAliasPlan.getPath(), changeAliasPlan.getAlias());
                return RecoverOperationResult.SUCCESS;
            }
            catch (MetadataException e) {
                return new RecoverOperationResult((Exception)((Object)e));
            }
        }

        @Override
        public RecoverOperationResult visitChangeTagOffset(IChangeTagOffsetPlan changeTagOffsetPlan, SchemaRegionSchemaFileImpl context) {
            try {
                SchemaRegionSchemaFileImpl.this.changeOffset(changeTagOffsetPlan.getPath(), changeTagOffsetPlan.getOffset());
                return RecoverOperationResult.SUCCESS;
            }
            catch (MetadataException e) {
                return new RecoverOperationResult((Exception)((Object)e));
            }
        }

        @Override
        public RecoverOperationResult visitAutoCreateDeviceMNode(IAutoCreateDeviceMNodePlan autoCreateDeviceMNodePlan, SchemaRegionSchemaFileImpl context) {
            try {
                SchemaRegionSchemaFileImpl.this.autoCreateDeviceMNode(autoCreateDeviceMNodePlan);
                return RecoverOperationResult.SUCCESS;
            }
            catch (MetadataException e) {
                return new RecoverOperationResult((Exception)((Object)e));
            }
        }

        @Override
        public RecoverOperationResult visitActivateTemplateInCluster(IActivateTemplateInClusterPlan activateTemplateInClusterPlan, SchemaRegionSchemaFileImpl context) {
            try {
                SchemaRegionSchemaFileImpl.this.recoverActivatingSchemaTemplate(activateTemplateInClusterPlan);
                return RecoverOperationResult.SUCCESS;
            }
            catch (MetadataException e) {
                return new RecoverOperationResult((Exception)((Object)e));
            }
        }

        @Override
        public RecoverOperationResult visitPreDeleteTimeSeries(IPreDeleteTimeSeriesPlan preDeleteTimeSeriesPlan, SchemaRegionSchemaFileImpl context) {
            try {
                SchemaRegionSchemaFileImpl.this.recoverPreDeleteTimeseries(preDeleteTimeSeriesPlan.getPath());
                return RecoverOperationResult.SUCCESS;
            }
            catch (MetadataException e) {
                return new RecoverOperationResult((Exception)((Object)e));
            }
        }

        @Override
        public RecoverOperationResult visitRollbackPreDeleteTimeSeries(IRollbackPreDeleteTimeSeriesPlan rollbackPreDeleteTimeSeriesPlan, SchemaRegionSchemaFileImpl context) {
            try {
                SchemaRegionSchemaFileImpl.this.recoverRollbackPreDeleteTimeseries(rollbackPreDeleteTimeSeriesPlan.getPath());
                return RecoverOperationResult.SUCCESS;
            }
            catch (MetadataException e) {
                return new RecoverOperationResult((Exception)((Object)e));
            }
        }

        @Override
        public RecoverOperationResult visitPreDeactivateTemplate(IPreDeactivateTemplatePlan preDeactivateTemplatePlan, SchemaRegionSchemaFileImpl context) {
            try {
                SchemaRegionSchemaFileImpl.this.constructSchemaBlackListWithTemplate(preDeactivateTemplatePlan);
                return RecoverOperationResult.SUCCESS;
            }
            catch (MetadataException e) {
                return new RecoverOperationResult((Exception)((Object)e));
            }
        }

        @Override
        public RecoverOperationResult visitRollbackPreDeactivateTemplate(IRollbackPreDeactivateTemplatePlan rollbackPreDeactivateTemplatePlan, SchemaRegionSchemaFileImpl context) {
            try {
                SchemaRegionSchemaFileImpl.this.rollbackSchemaBlackListWithTemplate(rollbackPreDeactivateTemplatePlan);
                return RecoverOperationResult.SUCCESS;
            }
            catch (MetadataException e) {
                return new RecoverOperationResult((Exception)((Object)e));
            }
        }

        @Override
        public RecoverOperationResult visitDeactivateTemplate(IDeactivateTemplatePlan deactivateTemplatePlan, SchemaRegionSchemaFileImpl context) {
            try {
                SchemaRegionSchemaFileImpl.this.deactivateTemplateInBlackList(deactivateTemplatePlan);
                return RecoverOperationResult.SUCCESS;
            }
            catch (MetadataException e) {
                return new RecoverOperationResult((Exception)((Object)e));
            }
        }
    }

    private static class RecoverOperationResult {
        private static final RecoverOperationResult SUCCESS = new RecoverOperationResult(null);
        private final Exception e;

        private RecoverOperationResult(Exception e) {
            this.e = e;
        }

        private boolean isFailed() {
            return this.e != null;
        }

        private Exception getException() {
            return this.e;
        }
    }
}

