/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.traverser.basic;

import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mtree.store.IMTreeStore;
import org.apache.iotdb.db.metadata.mtree.traverser.Traverser;

public abstract class EntityTraverser<R>
extends Traverser<R> {
    private boolean usingTemplate = false;
    private int schemaTemplateId = -1;

    public EntityTraverser(IMNode startNode, PartialPath path, IMTreeStore store, boolean isPrefixMatch) throws MetadataException {
        super(startNode, path, store, isPrefixMatch);
    }

    protected boolean mayTargetNodeType(IMNode node) {
        if (node.isEntity()) {
            return !this.usingTemplate || this.schemaTemplateId == node.getAsEntityMNode().getSchemaTemplateId();
        }
        return false;
    }

    protected boolean acceptFullMatchedNode(IMNode node) {
        if (node.isEntity()) {
            return !this.usingTemplate || this.schemaTemplateId == node.getSchemaTemplateId();
        }
        return false;
    }

    protected boolean acceptInternalMatchedNode(IMNode node) {
        return false;
    }

    protected boolean shouldVisitSubtreeOfFullMatchedNode(IMNode node) {
        return !node.isMeasurement();
    }

    protected boolean shouldVisitSubtreeOfInternalMatchedNode(IMNode node) {
        return !node.isMeasurement();
    }

    public void setSchemaTemplateFilter(int schemaTemplateId) {
        this.usingTemplate = true;
        this.schemaTemplateId = schemaTemplateId;
    }
}

