/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import org.apache.iotdb.common.rpc.thrift.TSchemaNode;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.ThriftConfigNodeSerDeUtils;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseSchema;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.metadata.StorageGroupAlreadySetException;
import org.apache.iotdb.db.exception.metadata.StorageGroupNotSetException;
import org.apache.iotdb.db.metadata.MetadataConstant;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IStorageGroupMNode;
import org.apache.iotdb.db.metadata.mnode.InternalMNode;
import org.apache.iotdb.db.metadata.mnode.StorageGroupMNode;
import org.apache.iotdb.db.metadata.mnode.iterator.IMNodeIterator;
import org.apache.iotdb.db.metadata.mtree.store.IMTreeStore;
import org.apache.iotdb.db.metadata.mtree.store.MemMTreeStore;
import org.apache.iotdb.db.metadata.mtree.traverser.collector.DatabaseCollector;
import org.apache.iotdb.db.metadata.mtree.traverser.collector.MNodeAboveSGCollector;
import org.apache.iotdb.db.metadata.mtree.traverser.collector.MNodeCollector;
import org.apache.iotdb.db.metadata.mtree.traverser.counter.DatabaseCounter;
import org.apache.iotdb.db.metadata.utils.MetaFormatUtils;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigMTree {
    private final Logger logger = LoggerFactory.getLogger(ConfigMTree.class);
    private IMNode root;
    private MemMTreeStore store = new MemMTreeStore(new PartialPath("root"), false);

    public ConfigMTree() throws MetadataException {
        this.root = this.store.getRoot();
    }

    public void clear() {
        if (this.store != null) {
            this.store.clear();
            this.root = this.store.getRoot();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStorageGroup(PartialPath path) throws MetadataException {
        int i;
        String[] nodeNames = path.getNodes();
        MetaFormatUtils.checkStorageGroup(path.getFullPath());
        if (nodeNames.length <= 1 || !nodeNames[0].equals(this.root.getName())) {
            throw new IllegalPathException(path.getFullPath());
        }
        IMNode cur = this.root;
        for (i = 1; i < nodeNames.length - 1; ++i) {
            IMNode temp = cur.getChild(nodeNames[i]);
            if (temp == null) {
                cur.addChild(nodeNames[i], new InternalMNode(cur, nodeNames[i]));
            } else if (temp.isStorageGroup()) {
                throw new StorageGroupAlreadySetException(temp.getFullPath());
            }
            cur = cur.getChild(nodeNames[i]);
        }
        ConfigMTree configMTree = this;
        synchronized (configMTree) {
            if (cur.hasChild(nodeNames[i])) {
                if (cur.getChild(nodeNames[i]).isStorageGroup()) {
                    throw new StorageGroupAlreadySetException(path.getFullPath());
                }
                throw new StorageGroupAlreadySetException(path.getFullPath(), true);
            }
            StorageGroupMNode storageGroupMNode = new StorageGroupMNode(cur, nodeNames[i], CommonDescriptor.getInstance().getConfig().getDefaultTTLInMs());
            IMNode result = cur.addChild(nodeNames[i], storageGroupMNode);
            if (result != storageGroupMNode) {
                throw new StorageGroupAlreadySetException(path.getFullPath(), true);
            }
        }
    }

    public void deleteStorageGroup(PartialPath path) throws MetadataException {
        IStorageGroupMNode storageGroupMNode = this.getStorageGroupNodeByStorageGroupPath(path);
        IMNode cur = storageGroupMNode.getParent();
        cur.deleteChild(storageGroupMNode.getName());
        while (cur.getParent() != null && cur.getChildren().size() == 0) {
            cur.getParent().deleteChild(cur.getName());
            cur = cur.getParent();
        }
    }

    public List<PartialPath> getBelongedStorageGroups(PartialPath pathPattern) throws MetadataException {
        return this.collectStorageGroups(pathPattern, false, true);
    }

    public List<PartialPath> getMatchedStorageGroups(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        return this.collectStorageGroups(pathPattern, isPrefixMatch, false);
    }

    private List<PartialPath> collectStorageGroups(PartialPath pathPattern, boolean isPrefixMatch, boolean collectInternal) throws MetadataException {
        final LinkedList<PartialPath> result = new LinkedList<PartialPath>();
        try (DatabaseCollector<List<PartialPath>> collector = new DatabaseCollector<List<PartialPath>>(this.root, pathPattern, (IMTreeStore)this.store, isPrefixMatch){

            @Override
            protected void collectDatabase(IStorageGroupMNode node) {
                result.add(node.getPartialPath());
            }
        };){
            collector.setCollectInternal(collectInternal);
            collector.traverse();
        }
        return result;
    }

    public List<PartialPath> getAllStorageGroupPaths() {
        ArrayList<PartialPath> res = new ArrayList<PartialPath>();
        ArrayDeque<IMNode> nodeStack = new ArrayDeque<IMNode>();
        nodeStack.add(this.root);
        while (!nodeStack.isEmpty()) {
            IMNode current = (IMNode)nodeStack.pop();
            if (current.isStorageGroup()) {
                res.add(current.getPartialPath());
                continue;
            }
            nodeStack.addAll(current.getChildren().values());
        }
        return res;
    }

    public int getStorageGroupNum(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        try (DatabaseCounter counter = new DatabaseCounter(this.root, pathPattern, this.store, isPrefixMatch);){
            int n = (int)counter.count();
            return n;
        }
    }

    public IStorageGroupMNode getStorageGroupNodeByStorageGroupPath(PartialPath storageGroupPath) throws MetadataException {
        String[] nodes = storageGroupPath.getNodes();
        if (nodes.length == 0 || !nodes[0].equals(this.root.getName())) {
            throw new IllegalPathException(storageGroupPath.getFullPath());
        }
        IMNode cur = this.root;
        for (int i = 1; i < nodes.length - 1; ++i) {
            if ((cur = cur.getChild(nodes[i])) == null) {
                throw new StorageGroupNotSetException(storageGroupPath.getFullPath());
            }
            if (!cur.isStorageGroup()) continue;
            throw new StorageGroupAlreadySetException(cur.getFullPath());
        }
        if ((cur = cur.getChild(nodes[nodes.length - 1])) == null) {
            throw new StorageGroupNotSetException(storageGroupPath.getFullPath());
        }
        if (cur.isStorageGroup()) {
            return cur.getAsStorageGroupMNode();
        }
        throw new StorageGroupAlreadySetException(storageGroupPath.getFullPath(), true);
    }

    public IStorageGroupMNode getStorageGroupNodeByPath(PartialPath path) throws MetadataException {
        String[] nodes = path.getNodes();
        if (nodes.length == 0 || !nodes[0].equals(this.root.getName())) {
            throw new IllegalPathException(path.getFullPath());
        }
        IMNode cur = this.root;
        for (int i = 1; i < nodes.length && (cur = cur.getChild(nodes[i])) != null; ++i) {
            if (!cur.isStorageGroup()) continue;
            return cur.getAsStorageGroupMNode();
        }
        throw new StorageGroupNotSetException(path.getFullPath());
    }

    public boolean isStorageGroupAlreadySet(PartialPath path) {
        String[] nodeNames = path.getNodes();
        IMNode cur = this.root;
        if (!nodeNames[0].equals(this.root.getName())) {
            return false;
        }
        for (int i = 1; i < nodeNames.length; ++i) {
            if (!cur.hasChild(nodeNames[i])) {
                return false;
            }
            if (!(cur = cur.getChild(nodeNames[i])).isStorageGroup()) continue;
            return true;
        }
        return true;
    }

    public void checkStorageGroupAlreadySet(PartialPath path) throws StorageGroupAlreadySetException {
        String[] nodeNames = path.getNodes();
        IMNode cur = this.root;
        if (!nodeNames[0].equals(this.root.getName())) {
            return;
        }
        for (int i = 1; i < nodeNames.length; ++i) {
            if (!cur.hasChild(nodeNames[i])) {
                return;
            }
            if (!(cur = cur.getChild(nodeNames[i])).isStorageGroup()) continue;
            throw new StorageGroupAlreadySetException(cur.getFullPath());
        }
        throw new StorageGroupAlreadySetException(path.getFullPath(), true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IMNode getNodeWithAutoCreate(PartialPath path) throws StorageGroupNotSetException {
        String[] nodeNames = path.getNodes();
        IMNode cur = this.root;
        boolean hasStorageGroup = false;
        for (int i = 1; i < nodeNames.length; ++i) {
            IMNode child = cur.getChild(nodeNames[i]);
            if (child == null) {
                if (!hasStorageGroup) throw new StorageGroupNotSetException(path.getFullPath());
                child = cur.addChild(nodeNames[i], new InternalMNode(cur, nodeNames[i]));
            } else if (child.isStorageGroup()) {
                hasStorageGroup = true;
            }
            cur = child;
        }
        return cur;
    }

    public Pair<List<PartialPath>, Set<PartialPath>> getNodesListInGivenLevel(PartialPath pathPattern, int nodeLevel, boolean isPrefixMatch) throws MetadataException {
        final LinkedList result = new LinkedList();
        try (MNodeAboveSGCollector<Void> collector = new MNodeAboveSGCollector<Void>(this.root, pathPattern, (IMTreeStore)this.store, isPrefixMatch){

            @Override
            protected Void collectMNode(IMNode node) {
                result.add(this.getPartialPathFromRootToNode(node));
                return null;
            }
        };){
            collector.setTargetLevel(nodeLevel);
            collector.traverse();
            Pair pair = new Pair(result, collector.getInvolvedStorageGroupMNodes());
            return pair;
        }
    }

    public Pair<Set<TSchemaNode>, Set<PartialPath>> getChildNodePathInNextLevel(PartialPath pathPattern) throws MetadataException {
        Pair pair;
        final TreeSet result = new TreeSet();
        MNodeAboveSGCollector<Void> collector = new MNodeAboveSGCollector<Void>(this.root, pathPattern.concatNode("*"), (IMTreeStore)this.store, false){

            @Override
            protected Void collectMNode(IMNode node) {
                result.add(new TSchemaNode(this.getPartialPathFromRootToNode(node).getFullPath(), node.getMNodeType(true).getNodeType()));
                return null;
            }
        };
        try {
            collector.traverse();
            pair = new Pair(result, collector.getInvolvedStorageGroupMNodes());
        }
        catch (Throwable throwable) {
            try {
                try {
                    collector.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IllegalPathException e) {
                throw new IllegalPathException(pathPattern.getFullPath());
            }
        }
        collector.close();
        return pair;
    }

    public void checkTemplateOnPath(PartialPath path) throws MetadataException {
        String[] nodeNames = path.getNodes();
        IMNode cur = this.root;
        if (cur.getSchemaTemplateId() != -1) {
            throw new MetadataException("Template already exists on " + cur.getFullPath());
        }
        for (int i = 1; i < nodeNames.length; ++i) {
            IMNode child = cur.getChild(nodeNames[i]);
            if (child == null) {
                return;
            }
            cur = child;
            if (cur.getSchemaTemplateId() != -1) {
                throw new MetadataException("Template already exists on " + cur.getFullPath());
            }
            if (!cur.isMeasurement()) continue;
            return;
        }
        this.checkTemplateOnSubtree(cur);
    }

    private void checkTemplateOnSubtree(IMNode node) throws MetadataException {
        if (node.isMeasurement()) {
            return;
        }
        IMNodeIterator iterator = this.store.getChildrenIterator(node);
        while (iterator.hasNext()) {
            IMNode child = (IMNode)iterator.next();
            if (child.isMeasurement()) continue;
            if (child.getSchemaTemplateId() != -1) {
                throw new MetadataException("Template already exists on " + child.getFullPath());
            }
            this.checkTemplateOnSubtree(child);
        }
    }

    public List<String> getPathsSetOnTemplate(final int templateId, final boolean filterPreUnset) throws MetadataException {
        final ArrayList<String> resSet = new ArrayList<String>();
        try (MNodeCollector<Void> collector = new MNodeCollector<Void>(this.root, new PartialPath(MetadataConstant.ALL_RESULT_NODES), (IMTreeStore)this.store, false){

            @Override
            protected boolean acceptFullMatchedNode(IMNode node) {
                if (super.acceptFullMatchedNode(node) && node.getSchemaTemplateId() != -1) {
                    if (filterPreUnset && node.isSchemaTemplatePreUnset()) {
                        return false;
                    }
                    return templateId == -2 || templateId == node.getSchemaTemplateId();
                }
                return false;
            }

            @Override
            protected Void collectMNode(IMNode node) {
                resSet.add(node.getFullPath());
                return null;
            }

            @Override
            protected boolean shouldVisitSubtreeOfFullMatchedNode(IMNode node) {
                return node.getSchemaTemplateId() == -1 && super.shouldVisitSubtreeOfFullMatchedNode(node);
            }

            @Override
            protected boolean shouldVisitSubtreeOfInternalMatchedNode(IMNode node) {
                return node.getSchemaTemplateId() == -1 && super.shouldVisitSubtreeOfFullMatchedNode(node);
            }
        };){
            collector.traverse();
        }
        return resSet;
    }

    public Map<Integer, Set<PartialPath>> getTemplateSetInfo(PartialPath pathPattern) throws MetadataException {
        final HashMap<Integer, Set<PartialPath>> result = new HashMap<Integer, Set<PartialPath>>();
        try (MNodeCollector<Void> collector = new MNodeCollector<Void>(this.root, pathPattern, (IMTreeStore)this.store, false){

            @Override
            protected boolean acceptFullMatchedNode(IMNode node) {
                return node.getSchemaTemplateId() != -1 || super.acceptFullMatchedNode(node);
            }

            @Override
            protected boolean acceptInternalMatchedNode(IMNode node) {
                return node.getSchemaTemplateId() != -1 || super.acceptInternalMatchedNode(node);
            }

            @Override
            protected Void collectMNode(IMNode node) {
                result.computeIfAbsent(node.getSchemaTemplateId(), k -> new HashSet()).add(this.getPartialPathFromRootToNode(node));
                return null;
            }

            @Override
            protected boolean shouldVisitSubtreeOfFullMatchedNode(IMNode node) {
                return node.getSchemaTemplateId() == -1 && super.shouldVisitSubtreeOfFullMatchedNode(node);
            }

            @Override
            protected boolean shouldVisitSubtreeOfInternalMatchedNode(IMNode node) {
                return node.getSchemaTemplateId() == -1 && super.shouldVisitSubtreeOfFullMatchedNode(node);
            }
        };){
            collector.traverse();
        }
        return result;
    }

    public void preUnsetTemplate(int templateId, PartialPath path) throws MetadataException {
        this.getNodeSetTemplate(templateId, path).preUnsetSchemaTemplate();
    }

    public void rollbackUnsetTemplate(int templateId, PartialPath path) throws MetadataException {
        this.getNodeSetTemplate(templateId, path).rollbackUnsetSchemaTemplate();
    }

    public void unsetTemplate(int templateId, PartialPath path) throws MetadataException {
        this.getNodeSetTemplate(templateId, path).unsetSchemaTemplate();
    }

    private IMNode getNodeSetTemplate(int templateId, PartialPath path) throws MetadataException {
        String[] nodeNames = path.getNodes();
        IMNode cur = this.root;
        for (int i = 1; i < nodeNames.length; ++i) {
            if ((cur = cur.getChild(nodeNames[i])) != null) continue;
            throw new PathNotExistException(path.getFullPath());
        }
        if (cur.getSchemaTemplateId() != templateId) {
            throw new MetadataException(String.format("Template %s is not set on path %s", templateId, path));
        }
        return cur;
    }

    public void serialize(OutputStream outputStream) throws IOException {
        this.serializeInternalNode((InternalMNode)this.root, outputStream);
    }

    private void serializeInternalNode(InternalMNode node, OutputStream outputStream) throws IOException {
        this.serializeChildren(node, outputStream);
        ReadWriteIOUtils.write((byte)0, (OutputStream)outputStream);
        ReadWriteIOUtils.write((String)node.getName(), (OutputStream)outputStream);
        ReadWriteIOUtils.write((int)node.getSchemaTemplateId(), (OutputStream)outputStream);
        ReadWriteIOUtils.write((int)node.getChildren().size(), (OutputStream)outputStream);
    }

    private void serializeChildren(InternalMNode node, OutputStream outputStream) throws IOException {
        for (IMNode child : node.getChildren().values()) {
            if (child.isStorageGroup()) {
                this.serializeStorageGroupNode((StorageGroupMNode)child, outputStream);
                continue;
            }
            this.serializeInternalNode((InternalMNode)child, outputStream);
        }
    }

    private void serializeStorageGroupNode(StorageGroupMNode storageGroupNode, OutputStream outputStream) throws IOException {
        this.serializeChildren(storageGroupNode, outputStream);
        ReadWriteIOUtils.write((byte)1, (OutputStream)outputStream);
        ReadWriteIOUtils.write((String)storageGroupNode.getName(), (OutputStream)outputStream);
        ReadWriteIOUtils.write((int)storageGroupNode.getSchemaTemplateId(), (OutputStream)outputStream);
        ThriftConfigNodeSerDeUtils.serializeTStorageGroupSchema((TDatabaseSchema)storageGroupNode.getStorageGroupSchema(), (OutputStream)outputStream);
    }

    public void deserialize(InputStream inputStream) throws IOException {
        InternalMNode internalMNode;
        StorageGroupMNode storageGroupMNode;
        byte type = ReadWriteIOUtils.readByte((InputStream)inputStream);
        String name = null;
        int childNum = 0;
        Stack<Pair> stack = new Stack<Pair>();
        if (type == 1) {
            storageGroupMNode = this.deserializeStorageGroupMNode(inputStream);
            name = storageGroupMNode.getName();
            stack.push(new Pair((Object)storageGroupMNode, (Object)true));
        } else {
            internalMNode = this.deserializeInternalMNode(inputStream);
            childNum = ReadWriteIOUtils.readInt((InputStream)inputStream);
            name = internalMNode.getName();
            stack.push(new Pair((Object)internalMNode, (Object)false));
        }
        block4: while (!"root".equals(name)) {
            type = ReadWriteIOUtils.readByte((InputStream)inputStream);
            switch (type) {
                case 0: {
                    internalMNode = this.deserializeInternalMNode(inputStream);
                    boolean hasDB = false;
                    for (childNum = ReadWriteIOUtils.readInt((InputStream)inputStream); childNum > 0; --childNum) {
                        hasDB = (Boolean)((Pair)stack.peek()).right;
                        internalMNode.addChild((IMNode)((Pair)stack.pop()).left);
                    }
                    stack.push(new Pair((Object)internalMNode, (Object)hasDB));
                    name = internalMNode.getName();
                    continue block4;
                }
                case 1: {
                    storageGroupMNode = this.deserializeStorageGroupMNode(inputStream);
                    childNum = 0;
                    while (!stack.isEmpty() && !((Boolean)((Pair)stack.peek()).right).booleanValue()) {
                        storageGroupMNode.addChild((IMNode)((Pair)stack.pop()).left);
                    }
                    stack.push(new Pair((Object)storageGroupMNode, (Object)true));
                    name = storageGroupMNode.getName();
                    continue block4;
                }
            }
            this.logger.error("Unrecognized node type. Cannot deserialize MTreeAboveSG from given buffer");
            return;
        }
        this.root = (IMNode)((Pair)stack.peek()).left;
    }

    private InternalMNode deserializeInternalMNode(InputStream inputStream) throws IOException {
        InternalMNode internalMNode = new InternalMNode(null, ReadWriteIOUtils.readString((InputStream)inputStream));
        internalMNode.setSchemaTemplateId(ReadWriteIOUtils.readInt((InputStream)inputStream));
        return internalMNode;
    }

    private StorageGroupMNode deserializeStorageGroupMNode(InputStream inputStream) throws IOException {
        StorageGroupMNode storageGroupMNode = new StorageGroupMNode(null, ReadWriteIOUtils.readString((InputStream)inputStream));
        storageGroupMNode.setSchemaTemplateId(ReadWriteIOUtils.readInt((InputStream)inputStream));
        storageGroupMNode.setStorageGroupSchema(ThriftConfigNodeSerDeUtils.deserializeTStorageGroupSchema((InputStream)inputStream));
        return storageGroupMNode;
    }
}

