/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.conf;

import java.io.File;
import java.util.Properties;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.enums.HandleSystemErrorStrategy;
import org.apache.iotdb.commons.exception.BadNodeUrlException;
import org.apache.iotdb.commons.utils.NodeUrlUtils;
import org.apache.iotdb.confignode.rpc.thrift.TGlobalConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonDescriptor.class);
    private final CommonConfig config = new CommonConfig();

    private CommonDescriptor() {
    }

    public static CommonDescriptor getInstance() {
        return CommonDescriptorHolder.INSTANCE;
    }

    public CommonConfig getConfig() {
        return this.config;
    }

    public void initCommonConfigDir(String systemDir) {
        this.config.setUserFolder(systemDir + File.separator + "users");
        this.config.setRoleFolder(systemDir + File.separator + "roles");
        this.config.setProcedureWalFolder(systemDir + File.separator + "procedure");
    }

    public void loadCommonProps(Properties properties) {
        this.config.setAuthorizerProvider(properties.getProperty("authorizer_provider_class", this.config.getAuthorizerProvider()).trim());
        this.config.setOpenIdProviderUrl(properties.getProperty("openID_url", this.config.getOpenIdProviderUrl()).trim());
        this.config.setAdminName(properties.getProperty("admin_name", this.config.getAdminName()).trim());
        this.config.setAdminPassword(properties.getProperty("admin_password", this.config.getAdminPassword()).trim());
        this.config.setEncryptDecryptProvider(properties.getProperty("iotdb_server_encrypt_decrypt_provider", this.config.getEncryptDecryptProvider()).trim());
        this.config.setEncryptDecryptProviderParameter(properties.getProperty("iotdb_server_encrypt_decrypt_provider_parameter", this.config.getEncryptDecryptProviderParameter()));
        this.config.setDefaultTTLInMs(Long.parseLong(properties.getProperty("default_ttl_in_ms", String.valueOf(this.config.getDefaultTTLInMs())).trim()));
        this.config.setSyncDir(properties.getProperty("dn_sync_dir", this.config.getSyncDir()).trim());
        this.config.setWalDirs(properties.getProperty("dn_wal_dirs", String.join((CharSequence)",", this.config.getWalDirs())).trim().split(","));
        this.config.setRpcThriftCompressionEnabled(Boolean.parseBoolean(properties.getProperty("cn_rpc_thrift_compression_enable", String.valueOf(this.config.isRpcThriftCompressionEnabled())).trim()));
        this.config.setConnectionTimeoutInMS(Integer.parseInt(properties.getProperty("cn_connection_timeout_ms", String.valueOf(this.config.getConnectionTimeoutInMS())).trim()));
        this.config.setSelectorNumOfClientManager(Integer.parseInt(properties.getProperty("cn_selector_thread_nums_of_client_manager", String.valueOf(this.config.getSelectorNumOfClientManager())).trim()));
        this.config.setCoreClientNumForEachNode(Integer.parseInt(properties.getProperty("cn_core_client_count_for_each_node_in_client_manager", String.valueOf(this.config.getCoreClientNumForEachNode())).trim()));
        this.config.setMaxClientNumForEachNode(Integer.parseInt(properties.getProperty("cn_max_client_count_for_each_node_in_client_manager", String.valueOf(this.config.getMaxClientNumForEachNode())).trim()));
        this.config.setConnectionTimeoutInMS(Integer.parseInt(properties.getProperty("dn_connection_timeout_ms", String.valueOf(this.config.getConnectionTimeoutInMS())).trim()));
        this.config.setRpcThriftCompressionEnabled(Boolean.parseBoolean(properties.getProperty("dn_rpc_thrift_compression_enable", String.valueOf(this.config.isRpcThriftCompressionEnabled())).trim()));
        this.config.setSelectorNumOfClientManager(Integer.parseInt(properties.getProperty("dn_selector_thread_nums_of_client_manager", String.valueOf(this.config.getSelectorNumOfClientManager())).trim()));
        this.config.setCoreClientNumForEachNode(Integer.parseInt(properties.getProperty("dn_core_client_count_for_each_node_in_client_manager", String.valueOf(this.config.getCoreClientNumForEachNode())).trim()));
        this.config.setMaxClientNumForEachNode(Integer.parseInt(properties.getProperty("dn_max_client_count_for_each_node_in_client_manager", String.valueOf(this.config.getMaxClientNumForEachNode())).trim()));
        this.config.setHandleSystemErrorStrategy(HandleSystemErrorStrategy.valueOf(properties.getProperty("handle_system_error", String.valueOf((Object)this.config.getHandleSystemErrorStrategy())).trim()));
        this.config.setDiskSpaceWarningThreshold(Double.parseDouble(properties.getProperty("disk_space_warning_threshold", String.valueOf(this.config.getDiskSpaceWarningThreshold())).trim()));
        this.config.setTimestampPrecision(properties.getProperty("timestamp_precision", this.config.getTimestampPrecision()).trim());
        String endPointUrl = properties.getProperty("target_ml_node_endpoint", NodeUrlUtils.convertTEndPointUrl(this.config.getTargetMLNodeEndPoint()));
        try {
            this.config.setTargetMLNodeEndPoint(NodeUrlUtils.parseTEndPointUrl(endPointUrl));
        }
        catch (BadNodeUrlException e) {
            LOGGER.warn("Illegal target MLNode endpoint url format in config file: {}, use default configuration.", (Object)endPointUrl);
        }
        this.config.setDatabaseLimitThreshold(Integer.parseInt(properties.getProperty("database_limit_threshold", String.valueOf(this.config.getDatabaseLimitThreshold()))));
    }

    public void loadGlobalConfig(TGlobalConfig globalConfig) {
        this.config.setDiskSpaceWarningThreshold(globalConfig.getDiskSpaceWarningThreshold());
    }

    private static class CommonDescriptorHolder {
        private static final CommonDescriptor INSTANCE = new CommonDescriptor();

        private CommonDescriptorHolder() {
        }
    }
}

