/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.service;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.JMXService;
import org.apache.iotdb.commons.service.RegisterManager;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.confignode.client.ConfigNodeRequestType;
import org.apache.iotdb.confignode.client.sync.SyncConfigNodeClientPool;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.conf.SystemPropertiesUtils;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeRegisterReq;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeRegisterResp;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeRestartReq;
import org.apache.iotdb.confignode.service.ConfigNodeCommandLine;
import org.apache.iotdb.confignode.service.ConfigNodeMBean;
import org.apache.iotdb.confignode.service.ConfigNodeShutdownHook;
import org.apache.iotdb.confignode.service.thrift.ConfigNodeRPCService;
import org.apache.iotdb.confignode.service.thrift.ConfigNodeRPCServiceProcessor;
import org.apache.iotdb.db.service.metrics.ProcessMetrics;
import org.apache.iotdb.db.service.metrics.SystemMetrics;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.metricsets.UpTimeMetrics;
import org.apache.iotdb.metrics.metricsets.disk.DiskMetrics;
import org.apache.iotdb.metrics.metricsets.jvm.JvmMetrics;
import org.apache.iotdb.metrics.metricsets.logback.LogbackMetrics;
import org.apache.iotdb.metrics.metricsets.net.NetMetrics;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigNode
implements ConfigNodeMBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigNode.class);
    private static final ConfigNodeConfig CONF = ConfigNodeDescriptor.getInstance().getConf();
    private static final int STARTUP_RETRY_NUM = 10;
    private static final int SCHEDULE_WAITING_RETRY_NUM = 20;
    private static final long STARTUP_RETRY_INTERVAL_IN_MS = TimeUnit.SECONDS.toMillis(3L);
    private static final int SEED_CONFIG_NODE_ID = 0;
    private static final int INIT_NON_SEED_CONFIG_NODE_ID = -1;
    private final String mbeanName = String.format("%s:%s=%s", "org.apache.iotdb.confignode.service", "type", "ConfigNode");
    private final RegisterManager registerManager = new RegisterManager();
    private ConfigManager configManager;

    private ConfigNode() {
    }

    public static void main(String[] args) {
        LOGGER.info("IoTDB-ConfigNode environment variables: " + ConfigNodeConfig.getEnvironmentVariables());
        LOGGER.info("{} default charset is: {}", (Object)"IoTDB-ConfigNode", (Object)Charset.defaultCharset().displayName());
        new ConfigNodeCommandLine().doMain(args);
    }

    public void active() {
        LOGGER.info("Activating {}...", (Object)"IoTDB-ConfigNode");
        try {
            this.processPid();
            Runtime.getRuntime().addShutdownHook(new ConfigNodeShutdownHook());
            this.setUpInternalServices();
            this.initConfigManager();
            if (SystemPropertiesUtils.isRestarted()) {
                LOGGER.info("{} is in restarting process...", (Object)"IoTDB-ConfigNode");
                CONF.setClusterName(SystemPropertiesUtils.loadClusterNameWhenRestarted());
                CONF.setConfigNodeId(SystemPropertiesUtils.loadConfigNodeIdWhenRestarted());
                if (!SystemPropertiesUtils.isSeedConfigNode()) {
                    this.sendRestartConfigNodeRequest();
                }
                this.configManager.initConsensusManager();
                this.setUpMetricService();
                this.setUpRPCService();
                LOGGER.info("{} has successfully restarted and joined the cluster: {}.", (Object)"IoTDB-ConfigNode", (Object)CONF.getClusterName());
                return;
            }
            if (ConfigNodeDescriptor.getInstance().isSeedConfigNode()) {
                LOGGER.info("The current {} is now starting as the Seed-ConfigNode.", (Object)"IoTDB-ConfigNode");
                CONF.setConfigNodeId(0);
                this.configManager.initConsensusManager();
                SystemPropertiesUtils.storeSystemParameters();
                this.configManager.getNodeManager().applyConfigNode(new TConfigNodeLocation(0, new TEndPoint(CONF.getInternalAddress(), CONF.getInternalPort()), new TEndPoint(CONF.getInternalAddress(), CONF.getConsensusPort())));
                this.setUpMetricService();
                this.setUpRPCService();
                LOGGER.info("{} has successfully started and joined the cluster: {}.", (Object)"IoTDB-ConfigNode", (Object)CONF.getClusterName());
                return;
            }
            this.setUpRPCService();
            this.sendRegisterConfigNodeRequest();
            LOGGER.info("{} {} has registered successfully. Waiting for the leader's scheduling to join the cluster: {}.", new Object[]{"IoTDB-ConfigNode", CONF.getConfigNodeId(), CONF.getClusterName()});
            this.setUpMetricService();
            boolean isJoinedCluster = false;
            for (int retry = 0; retry < 20; ++retry) {
                if (!this.configManager.getConsensusManager().getConsensusImpl().getAllConsensusGroupIds().isEmpty()) {
                    isJoinedCluster = true;
                    break;
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(STARTUP_RETRY_INTERVAL_IN_MS);
                    continue;
                }
                catch (InterruptedException e) {
                    LOGGER.warn("Waiting leader's scheduling is interrupted.");
                    Thread.currentThread().interrupt();
                }
            }
            if (!isJoinedCluster) {
                LOGGER.error("The current ConfigNode can't joined the cluster because leader's scheduling failed. The possible cause is that the ip:port configuration is incorrect.");
                this.stop();
            }
        }
        catch (IOException | StartupException e) {
            LOGGER.error("Meet error while starting up.", e);
            this.stop();
        }
    }

    void processPid() {
        String pidFile = System.getProperty("iotdb-pidfile");
        if (pidFile != null) {
            new File(pidFile).deleteOnExit();
        }
    }

    private void setUpInternalServices() throws StartupException, IOException {
        this.registerManager.register((IService)new JMXService());
        JMXService.registerMBean((Object)this, (String)this.mbeanName);
        LOGGER.info("Successfully setup internal services.");
    }

    private void setUpMetricService() throws StartupException {
        MetricConfigDescriptor.getInstance().getMetricConfig().setNodeId(CONF.getConfigNodeId());
        this.registerManager.register((IService)MetricService.getInstance());
        MetricService.getInstance().addMetricSet((IMetricSet)new UpTimeMetrics());
        MetricService.getInstance().addMetricSet((IMetricSet)new JvmMetrics());
        MetricService.getInstance().addMetricSet((IMetricSet)new LogbackMetrics());
        MetricService.getInstance().addMetricSet((IMetricSet)new ProcessMetrics());
        MetricService.getInstance().addMetricSet((IMetricSet)new SystemMetrics(false));
        MetricService.getInstance().addMetricSet((IMetricSet)new DiskMetrics("confignode"));
        MetricService.getInstance().addMetricSet((IMetricSet)new NetMetrics());
        LOGGER.info("Successfully setup internal services.");
    }

    private void initConfigManager() {
        try {
            this.configManager = new ConfigManager();
        }
        catch (IOException e) {
            LOGGER.error("Can't start ConfigNode consensus group!", (Throwable)e);
            this.stop();
        }
        this.configManager.addMetrics();
        LOGGER.info("Successfully initialize ConfigManager.");
    }

    private void sendRegisterConfigNodeRequest() throws StartupException, IOException {
        TConfigNodeRegisterReq req = new TConfigNodeRegisterReq(this.configManager.getClusterParameters(), new TConfigNodeLocation(-1, new TEndPoint(CONF.getInternalAddress(), CONF.getInternalPort()), new TEndPoint(CONF.getInternalAddress(), CONF.getConsensusPort())));
        TEndPoint targetConfigNode = CONF.getTargetConfigNode();
        if (targetConfigNode == null) {
            LOGGER.error("Please set the cn_target_config_node_list parameter in iotdb-confignode.properties file.");
            throw new StartupException("The targetConfigNode setting in conf is empty");
        }
        for (int retry = 0; retry < 10; ++retry) {
            TSStatus status;
            TConfigNodeRegisterResp resp = null;
            Object obj = SyncConfigNodeClientPool.getInstance().sendSyncRequestToConfigNodeWithRetry(targetConfigNode, req, ConfigNodeRequestType.REGISTER_CONFIG_NODE);
            if (obj instanceof TConfigNodeRegisterResp) {
                resp = (TConfigNodeRegisterResp)obj;
                status = resp.getStatus();
            } else {
                status = (TSStatus)obj;
            }
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                if (resp == null) {
                    LOGGER.error("The result of register ConfigNode is empty!");
                    throw new StartupException("The result of register ConfigNode is empty!");
                }
                CONF.setConfigNodeId(resp.getConfigNodeId());
                this.configManager.initConsensusManager();
                return;
            }
            if (status.getCode() != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
                throw new StartupException(status.getMessage());
            }
            targetConfigNode = status.getRedirectNode();
            LOGGER.info("ConfigNode need redirect to  {}.", (Object)targetConfigNode);
            try {
                TimeUnit.MILLISECONDS.sleep(STARTUP_RETRY_INTERVAL_IN_MS);
                continue;
            }
            catch (InterruptedException e) {
                throw new StartupException("Register ConfigNode failed!");
            }
        }
        LOGGER.error("The current ConfigNode can't send register request to the ConfigNode-leader after all retries!");
        this.stop();
    }

    private void sendRestartConfigNodeRequest() throws IOException, StartupException {
        TConfigNodeRestartReq req = new TConfigNodeRestartReq(CONF.getClusterName(), new TConfigNodeLocation(CONF.getConfigNodeId(), new TEndPoint(CONF.getInternalAddress(), CONF.getInternalPort()), new TEndPoint(CONF.getInternalAddress(), CONF.getConsensusPort())));
        TEndPoint targetConfigNode = CONF.getTargetConfigNode();
        if (targetConfigNode == null) {
            LOGGER.error("Please set the cn_target_config_node_list parameter in iotdb-confignode.properties file.");
            throw new StartupException("The targetConfigNode setting in conf is empty");
        }
        for (int retry = 0; retry < 10; ++retry) {
            TSStatus status = (TSStatus)SyncConfigNodeClientPool.getInstance().sendSyncRequestToConfigNodeWithRetry(targetConfigNode, req, ConfigNodeRequestType.RESTART_CONFIG_NODE);
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                LOGGER.info("Registration request of current ConfigNode is accepted.");
                return;
            }
            if (status.getCode() != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
                throw new StartupException(status.getMessage());
            }
            targetConfigNode = status.getRedirectNode();
            LOGGER.info("ConfigNode need redirect to  {}.", (Object)targetConfigNode);
            try {
                TimeUnit.MILLISECONDS.sleep(STARTUP_RETRY_INTERVAL_IN_MS);
                continue;
            }
            catch (InterruptedException e) {
                throw new StartupException("Register ConfigNode failed!");
            }
        }
    }

    private void setUpRPCService() throws StartupException {
        ConfigNodeRPCService configNodeRPCService = new ConfigNodeRPCService();
        ConfigNodeRPCServiceProcessor configNodeRPCServiceProcessor = new ConfigNodeRPCServiceProcessor(this.configManager);
        configNodeRPCService.initSyncedServiceImpl(configNodeRPCServiceProcessor);
        this.registerManager.register((IService)configNodeRPCService);
    }

    public void deactivate() throws IOException {
        LOGGER.info("Deactivating {}...", (Object)"IoTDB-ConfigNode");
        this.registerManager.deregisterAll();
        JMXService.deregisterMBean((String)this.mbeanName);
        if (this.configManager != null) {
            this.configManager.close();
        }
        LOGGER.info("{} is deactivated.", (Object)"IoTDB-ConfigNode");
    }

    public void stop() {
        try {
            this.deactivate();
        }
        catch (IOException e) {
            LOGGER.error("Meet error when deactivate ConfigNode", (Throwable)e);
        }
        System.exit(-1);
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public void setConfigManager(ConfigManager configManager) {
        this.configManager = configManager;
    }

    public static ConfigNode getInstance() {
        return ConfigNodeHolder.INSTANCE;
    }

    private static class ConfigNodeHolder {
        private static final ConfigNode INSTANCE = new ConfigNode();

        private ConfigNodeHolder() {
        }
    }
}

