/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.node;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.commons.exception.runtime.ThriftSerDeException;
import org.apache.iotdb.commons.utils.ThriftConfigNodeSerDeUtils;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.impl.node.AbstractNodeProcedure;
import org.apache.iotdb.confignode.procedure.impl.statemachine.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.state.AddConfigNodeState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddConfigNodeProcedure
extends AbstractNodeProcedure<AddConfigNodeState> {
    private static final Logger LOG = LoggerFactory.getLogger(AddConfigNodeProcedure.class);
    private static final int RETRY_THRESHOLD = 5;
    private TConfigNodeLocation tConfigNodeLocation;

    public AddConfigNodeProcedure() {
    }

    public AddConfigNodeProcedure(TConfigNodeLocation tConfigNodeLocation) {
        this.tConfigNodeLocation = tConfigNodeLocation;
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, AddConfigNodeState state) {
        block10: {
            if (this.tConfigNodeLocation == null) {
                return StateMachineProcedure.Flow.NO_MORE_STATE;
            }
            try {
                switch (state) {
                    case ADD_CONFIG_NODE_PREPARE: {
                        this.setNextState(AddConfigNodeState.CREATE_PEER);
                        break;
                    }
                    case CREATE_PEER: {
                        LOG.info("Executing CREATE_PEER on {}...", (Object)this.tConfigNodeLocation);
                        env.addConsensusGroup(this.tConfigNodeLocation);
                        this.setNextState(AddConfigNodeState.ADD_PEER);
                        LOG.info("Successfully CREATE_PEER on {}", (Object)this.tConfigNodeLocation);
                        break;
                    }
                    case ADD_PEER: {
                        LOG.info("Executing ADD_PEER {}...", (Object)this.tConfigNodeLocation);
                        env.addConfigNodePeer(this.tConfigNodeLocation);
                        this.setNextState(AddConfigNodeState.REGISTER_SUCCESS);
                        LOG.info("Successfully ADD_PEER {}", (Object)this.tConfigNodeLocation);
                        break;
                    }
                    case REGISTER_SUCCESS: {
                        env.notifyRegisterSuccess(this.tConfigNodeLocation);
                        env.applyConfigNode(this.tConfigNodeLocation);
                        env.broadCastTheLatestConfigNodeGroup();
                        LOG.info("The ConfigNode: {} is successfully added to the cluster", (Object)this.tConfigNodeLocation);
                        return StateMachineProcedure.Flow.NO_MORE_STATE;
                    }
                }
            }
            catch (Exception e) {
                if (this.isRollbackSupported(state)) {
                    this.setFailure(new ProcedureException("Add ConfigNode failed " + (Object)((Object)state)));
                }
                LOG.error("Retrievable error trying to add config node {}, state {}", new Object[]{this.tConfigNodeLocation, state, e});
                if (this.getCycles() <= 5) break block10;
                this.setFailure(new ProcedureException("State stuck at " + (Object)((Object)state)));
            }
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv env, AddConfigNodeState state) throws ProcedureException {
        switch (state) {
            case CREATE_PEER: {
                env.deleteConfigNodePeer(this.tConfigNodeLocation);
                LOG.info("Rollback CREATE_PEER for: {}", (Object)this.tConfigNodeLocation);
                break;
            }
            case ADD_PEER: {
                env.removeConfigNodePeer(this.tConfigNodeLocation);
                LOG.info("Rollback ADD_PEER for: {}", (Object)this.tConfigNodeLocation);
                break;
            }
        }
    }

    @Override
    protected boolean isRollbackSupported(AddConfigNodeState state) {
        switch (state) {
            case CREATE_PEER: 
            case ADD_PEER: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected AddConfigNodeState getState(int stateId) {
        return AddConfigNodeState.values()[stateId];
    }

    @Override
    protected int getStateId(AddConfigNodeState deleteStorageGroupState) {
        return deleteStorageGroupState.ordinal();
    }

    @Override
    protected AddConfigNodeState getInitialState() {
        return AddConfigNodeState.ADD_CONFIG_NODE_PREPARE;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(ProcedureType.ADD_CONFIG_NODE_PROCEDURE.getTypeCode());
        super.serialize(stream);
        ThriftConfigNodeSerDeUtils.serializeTConfigNodeLocation((TConfigNodeLocation)this.tConfigNodeLocation, (DataOutputStream)stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        try {
            this.tConfigNodeLocation = ThriftConfigNodeSerDeUtils.deserializeTConfigNodeLocation((ByteBuffer)byteBuffer);
        }
        catch (ThriftSerDeException e) {
            LOG.error("Error in deserialize AddConfigNodeProcedure", (Throwable)e);
        }
    }

    public boolean equals(Object that) {
        if (that instanceof AddConfigNodeProcedure) {
            AddConfigNodeProcedure thatProc = (AddConfigNodeProcedure)that;
            return thatProc.getProcId() == this.getProcId() && thatProc.getState() == this.getState() && thatProc.tConfigNodeLocation.equals(this.tConfigNodeLocation);
        }
        return false;
    }
}

