/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.schema;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TSchemaNode;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.snapshot.SnapshotProcessor;
import org.apache.iotdb.commons.utils.StatusUtils;
import org.apache.iotdb.confignode.consensus.request.read.database.CountDatabasePlan;
import org.apache.iotdb.confignode.consensus.request.read.database.GetDatabasePlan;
import org.apache.iotdb.confignode.consensus.request.read.template.CheckTemplateSettablePlan;
import org.apache.iotdb.confignode.consensus.request.read.template.GetPathsSetTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.read.template.GetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.read.template.GetTemplateSetInfoPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.AdjustMaxRegionGroupNumPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.DatabaseSchemaPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.DeleteDatabasePlan;
import org.apache.iotdb.confignode.consensus.request.write.database.SetDataReplicationFactorPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.SetSchemaReplicationFactorPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.SetTTLPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.SetTimePartitionIntervalPlan;
import org.apache.iotdb.confignode.consensus.request.write.template.CreateSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.DropSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.PreUnsetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.RollbackPreUnsetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.SetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.UnsetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.response.database.CountDatabaseResp;
import org.apache.iotdb.confignode.consensus.response.database.DatabaseSchemaResp;
import org.apache.iotdb.confignode.consensus.response.partition.PathInfoResp;
import org.apache.iotdb.confignode.consensus.response.template.AllTemplateSetInfoResp;
import org.apache.iotdb.confignode.consensus.response.template.TemplateInfoResp;
import org.apache.iotdb.confignode.consensus.response.template.TemplateSetInfoResp;
import org.apache.iotdb.confignode.exception.DatabaseNotExistsException;
import org.apache.iotdb.confignode.persistence.schema.TemplateTable;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseSchema;
import org.apache.iotdb.db.exception.metadata.SchemaQuotaExceededException;
import org.apache.iotdb.db.metadata.MetadataConstant;
import org.apache.iotdb.db.metadata.mtree.ConfigMTree;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.metadata.template.TemplateInternalRPCUtil;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterSchemaInfo
implements SnapshotProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterSchemaInfo.class);
    private static final CommonConfig COMMON_CONFIG = CommonDescriptor.getInstance().getConfig();
    private final ReentrantReadWriteLock databaseReadWriteLock = new ReentrantReadWriteLock();
    private final ConfigMTree mTree;
    private static final String SNAPSHOT_FILENAME = "cluster_schema.bin";
    private final String ERROR_NAME = "Error Database name";
    private final TemplateTable templateTable;

    public ClusterSchemaInfo() throws IOException {
        try {
            this.mTree = new ConfigMTree();
            this.templateTable = new TemplateTable();
        }
        catch (MetadataException e) {
            LOGGER.error("Can't construct ClusterSchemaInfo", (Throwable)e);
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus createDatabase(DatabaseSchemaPlan plan) {
        TSStatus result = new TSStatus();
        this.databaseReadWriteLock.writeLock().lock();
        try {
            TDatabaseSchema databaseSchema = plan.getSchema();
            PartialPath partialPathName = new PartialPath(databaseSchema.getName());
            this.mTree.setStorageGroup(partialPathName);
            this.mTree.getStorageGroupNodeByStorageGroupPath(partialPathName).setStorageGroupSchema(databaseSchema);
            result.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (MetadataException e) {
            LOGGER.error("Error Database name", (Throwable)e);
            result.setCode(e.getErrorCode()).setMessage(e.getMessage());
        }
        finally {
            this.databaseReadWriteLock.writeLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus alterDatabase(DatabaseSchemaPlan plan) {
        TSStatus result = new TSStatus();
        this.databaseReadWriteLock.writeLock().lock();
        try {
            TDatabaseSchema alterSchema = plan.getSchema();
            PartialPath partialPathName = new PartialPath(alterSchema.getName());
            TDatabaseSchema currentSchema = this.mTree.getStorageGroupNodeByStorageGroupPath(partialPathName).getStorageGroupSchema();
            if (alterSchema.isSetMinSchemaRegionGroupNum()) {
                currentSchema.setMinSchemaRegionGroupNum(alterSchema.getMinSchemaRegionGroupNum());
                currentSchema.setMaxSchemaRegionGroupNum(Math.max(currentSchema.getMinSchemaRegionGroupNum(), currentSchema.getMaxSchemaRegionGroupNum()));
                LOGGER.info("[AdjustRegionGroupNum] The minimum number of SchemaRegionGroups for Database: {} is adjusted to: {}", (Object)currentSchema.getName(), (Object)currentSchema.getMinSchemaRegionGroupNum());
                LOGGER.info("[AdjustRegionGroupNum] The maximum number of SchemaRegionGroups for Database: {} is adjusted to: {}", (Object)currentSchema.getName(), (Object)currentSchema.getMaxSchemaRegionGroupNum());
            }
            if (alterSchema.isSetMinDataRegionGroupNum()) {
                currentSchema.setMinDataRegionGroupNum(alterSchema.getMinDataRegionGroupNum());
                currentSchema.setMaxDataRegionGroupNum(Math.max(currentSchema.getMinDataRegionGroupNum(), currentSchema.getMaxDataRegionGroupNum()));
                LOGGER.info("[AdjustRegionGroupNum] The minimum number of DataRegionGroups for Database: {} is adjusted to: {}", (Object)currentSchema.getName(), (Object)currentSchema.getMinDataRegionGroupNum());
                LOGGER.info("[AdjustRegionGroupNum] The maximum number of DataRegionGroups for Database: {} is adjusted to: {}", (Object)currentSchema.getName(), (Object)currentSchema.getMaxDataRegionGroupNum());
            }
            this.mTree.getStorageGroupNodeByStorageGroupPath(partialPathName).setStorageGroupSchema(currentSchema);
            result.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (MetadataException e) {
            LOGGER.error("Error Database name", (Throwable)e);
            result.setCode(e.getErrorCode()).setMessage(e.getMessage());
        }
        finally {
            this.databaseReadWriteLock.writeLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus deleteDatabase(DeleteDatabasePlan plan) {
        TSStatus result = new TSStatus();
        this.databaseReadWriteLock.writeLock().lock();
        try {
            String storageGroup = plan.getName();
            PartialPath partialPathName = new PartialPath(storageGroup);
            this.mTree.deleteStorageGroup(partialPathName);
            result.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (MetadataException e) {
            LOGGER.warn("Database not exist", (Throwable)e);
            result.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode()).setMessage("Database not exist: " + e.getMessage());
        }
        finally {
            this.databaseReadWriteLock.writeLock().unlock();
        }
        return result;
    }

    public void checkDatabaseLimit() throws MetadataException {
        int limit = COMMON_CONFIG.getDatabaseLimitThreshold();
        if (limit > 0) {
            this.databaseReadWriteLock.readLock().lock();
            try {
                int count = this.mTree.getStorageGroupNum(MetadataConstant.ALL_MATCH_PATTERN, false) - this.mTree.getStorageGroupNum(MetadataConstant.SYSTEM_DATABASE_PATTERN, false);
                if (count >= limit) {
                    throw new SchemaQuotaExceededException((long)limit);
                }
            }
            finally {
                this.databaseReadWriteLock.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CountDatabaseResp countMatchedDatabases(CountDatabasePlan plan) {
        CountDatabaseResp result = new CountDatabaseResp();
        this.databaseReadWriteLock.readLock().lock();
        try {
            PartialPath patternPath = new PartialPath(plan.getDatabasePattern());
            result.setCount(this.mTree.getStorageGroupNum(patternPath, false));
            result.setStatus(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()));
        }
        catch (MetadataException e) {
            LOGGER.error("Error Database name", (Throwable)e);
            result.setStatus(new TSStatus(TSStatusCode.DATABASE_NOT_EXIST.getStatusCode()).setMessage("Error Database name: " + e.getMessage()));
        }
        finally {
            this.databaseReadWriteLock.readLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseSchemaResp getMatchedDatabaseSchemas(GetDatabasePlan plan) {
        DatabaseSchemaResp result = new DatabaseSchemaResp();
        this.databaseReadWriteLock.readLock().lock();
        try {
            HashMap<String, TDatabaseSchema> schemaMap = new HashMap<String, TDatabaseSchema>();
            PartialPath patternPath = new PartialPath(plan.getDatabasePattern());
            List matchedPaths = this.mTree.getMatchedStorageGroups(patternPath, false);
            for (PartialPath path : matchedPaths) {
                schemaMap.put(path.getFullPath(), this.mTree.getStorageGroupNodeByStorageGroupPath(path).getStorageGroupSchema());
            }
            result.setSchemaMap(schemaMap);
            result.setStatus(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()));
        }
        catch (MetadataException e) {
            LOGGER.error("Error Database name", (Throwable)e);
            result.setStatus(new TSStatus(TSStatusCode.DATABASE_NOT_EXIST.getStatusCode()).setMessage("Error Database name: " + e.getMessage()));
        }
        finally {
            this.databaseReadWriteLock.readLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus setTTL(SetTTLPlan plan) {
        TSStatus result = new TSStatus();
        this.databaseReadWriteLock.writeLock().lock();
        try {
            PartialPath patternPath = new PartialPath(plan.getStorageGroupPathPattern());
            List matchedPaths = this.mTree.getBelongedStorageGroups(patternPath);
            if (!matchedPaths.isEmpty()) {
                for (PartialPath path : matchedPaths) {
                    this.mTree.getStorageGroupNodeByStorageGroupPath(path).getStorageGroupSchema().setTTL(plan.getTTL());
                }
                result.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            } else {
                result.setCode(TSStatusCode.DATABASE_NOT_EXIST.getStatusCode());
                result.setMessage("Database does not exist");
            }
        }
        catch (MetadataException e) {
            LOGGER.error("Error Database name", (Throwable)e);
            result.setCode(TSStatusCode.DATABASE_NOT_EXIST.getStatusCode()).setMessage("Error Database name");
        }
        finally {
            this.databaseReadWriteLock.writeLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus setSchemaReplicationFactor(SetSchemaReplicationFactorPlan plan) {
        TSStatus result = new TSStatus();
        this.databaseReadWriteLock.writeLock().lock();
        try {
            PartialPath path = new PartialPath(plan.getStorageGroup());
            if (this.mTree.isStorageGroupAlreadySet(path)) {
                this.mTree.getStorageGroupNodeByStorageGroupPath(path).getStorageGroupSchema().setSchemaReplicationFactor(plan.getSchemaReplicationFactor());
                result.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            } else {
                result.setCode(TSStatusCode.DATABASE_NOT_EXIST.getStatusCode());
            }
        }
        catch (MetadataException e) {
            LOGGER.error("Error Database name", (Throwable)e);
            result.setCode(TSStatusCode.DATABASE_NOT_EXIST.getStatusCode()).setMessage("Error Database name");
        }
        finally {
            this.databaseReadWriteLock.writeLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus setDataReplicationFactor(SetDataReplicationFactorPlan plan) {
        TSStatus result = new TSStatus();
        this.databaseReadWriteLock.writeLock().lock();
        try {
            PartialPath path = new PartialPath(plan.getDatabase());
            if (this.mTree.isStorageGroupAlreadySet(path)) {
                this.mTree.getStorageGroupNodeByStorageGroupPath(path).getStorageGroupSchema().setDataReplicationFactor(plan.getDataReplicationFactor());
                result.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            } else {
                result.setCode(TSStatusCode.DATABASE_NOT_EXIST.getStatusCode());
            }
        }
        catch (MetadataException e) {
            LOGGER.error("Error Database name", (Throwable)e);
            result.setCode(TSStatusCode.DATABASE_NOT_EXIST.getStatusCode()).setMessage("Error Database name");
        }
        finally {
            this.databaseReadWriteLock.writeLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus setTimePartitionInterval(SetTimePartitionIntervalPlan plan) {
        TSStatus result = new TSStatus();
        this.databaseReadWriteLock.writeLock().lock();
        try {
            PartialPath path = new PartialPath(plan.getDatabase());
            if (this.mTree.isStorageGroupAlreadySet(path)) {
                this.mTree.getStorageGroupNodeByStorageGroupPath(path).getStorageGroupSchema().setTimePartitionInterval(plan.getTimePartitionInterval());
                result.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            } else {
                result.setCode(TSStatusCode.DATABASE_NOT_EXIST.getStatusCode());
            }
        }
        catch (MetadataException e) {
            LOGGER.error("Error Database name", (Throwable)e);
            result.setCode(TSStatusCode.DATABASE_NOT_EXIST.getStatusCode()).setMessage("Error Database name");
        }
        finally {
            this.databaseReadWriteLock.writeLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus adjustMaxRegionGroupCount(AdjustMaxRegionGroupNumPlan plan) {
        TSStatus result = new TSStatus();
        this.databaseReadWriteLock.writeLock().lock();
        try {
            for (Map.Entry<String, Pair<Integer, Integer>> entry : plan.getMaxRegionGroupNumMap().entrySet()) {
                PartialPath path = new PartialPath(entry.getKey());
                TDatabaseSchema databaseSchema = this.mTree.getStorageGroupNodeByStorageGroupPath(path).getStorageGroupSchema();
                databaseSchema.setMaxSchemaRegionGroupNum(((Integer)entry.getValue().getLeft()).intValue());
                databaseSchema.setMaxDataRegionGroupNum(((Integer)entry.getValue().getRight()).intValue());
            }
            result.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (MetadataException e) {
            LOGGER.error("Error Database name", (Throwable)e);
            result.setCode(TSStatusCode.DATABASE_NOT_EXIST.getStatusCode());
        }
        finally {
            this.databaseReadWriteLock.writeLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getDatabaseNames() {
        ArrayList<String> databases = new ArrayList<String>();
        this.databaseReadWriteLock.readLock().lock();
        try {
            List namePaths = this.mTree.getAllStorageGroupPaths();
            for (PartialPath path : namePaths) {
                databases.add(path.getFullPath());
            }
        }
        finally {
            this.databaseReadWriteLock.readLock().unlock();
        }
        return databases;
    }

    public void isDatabaseNameValid(String databaseName) throws MetadataException {
        this.databaseReadWriteLock.readLock().lock();
        try {
            this.mTree.checkStorageGroupAlreadySet(new PartialPath(databaseName));
        }
        finally {
            this.databaseReadWriteLock.readLock().unlock();
        }
    }

    public TDatabaseSchema getMatchedDatabaseSchemaByName(String storageGroup) throws DatabaseNotExistsException {
        this.databaseReadWriteLock.readLock().lock();
        try {
            TDatabaseSchema tDatabaseSchema = this.mTree.getStorageGroupNodeByStorageGroupPath(new PartialPath(storageGroup)).getStorageGroupSchema();
            return tDatabaseSchema;
        }
        catch (MetadataException e) {
            throw new DatabaseNotExistsException(storageGroup);
        }
        finally {
            this.databaseReadWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, TDatabaseSchema> getMatchedDatabaseSchemasByName(List<String> rawPathList) {
        HashMap<String, TDatabaseSchema> schemaMap = new HashMap<String, TDatabaseSchema>();
        this.databaseReadWriteLock.readLock().lock();
        try {
            for (String rawPath : rawPathList) {
                PartialPath patternPath = new PartialPath(rawPath);
                List matchedPaths = this.mTree.getMatchedStorageGroups(patternPath, false);
                for (PartialPath path : matchedPaths) {
                    schemaMap.put(path.getFullPath(), this.mTree.getStorageGroupNodeByPath(path).getStorageGroupSchema());
                }
            }
        }
        catch (MetadataException e) {
            LOGGER.warn("Error Database name", (Throwable)e);
        }
        finally {
            this.databaseReadWriteLock.readLock().unlock();
        }
        return schemaMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMinRegionGroupNum(String database, TConsensusGroupType consensusGroupType) {
        this.databaseReadWriteLock.readLock().lock();
        try {
            PartialPath path = new PartialPath(database);
            TDatabaseSchema storageGroupSchema = this.mTree.getStorageGroupNodeByStorageGroupPath(path).getStorageGroupSchema();
            switch (consensusGroupType) {
                case SchemaRegion: {
                    int n = storageGroupSchema.getMinSchemaRegionGroupNum();
                    return n;
                }
            }
            int n = storageGroupSchema.getMinDataRegionGroupNum();
            return n;
        }
        catch (MetadataException e) {
            LOGGER.warn("Error Database name", (Throwable)e);
            int n = -1;
            return n;
        }
        finally {
            this.databaseReadWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxRegionGroupNum(String database, TConsensusGroupType consensusGroupType) {
        this.databaseReadWriteLock.readLock().lock();
        try {
            PartialPath path = new PartialPath(database);
            TDatabaseSchema storageGroupSchema = this.mTree.getStorageGroupNodeByStorageGroupPath(path).getStorageGroupSchema();
            switch (consensusGroupType) {
                case SchemaRegion: {
                    int n = storageGroupSchema.getMaxSchemaRegionGroupNum();
                    return n;
                }
            }
            int n = storageGroupSchema.getMaxDataRegionGroupNum();
            return n;
        }
        catch (MetadataException e) {
            LOGGER.warn("Error Database name", (Throwable)e);
            int n = -1;
            return n;
        }
        finally {
            this.databaseReadWriteLock.readLock().unlock();
        }
    }

    public boolean processTakeSnapshot(File snapshotDir) throws IOException {
        return this.processMTreeTakeSnapshot(snapshotDir) && this.templateTable.processTakeSnapshot(snapshotDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processMTreeTakeSnapshot(File snapshotDir) throws IOException {
        File snapshotFile = new File(snapshotDir, SNAPSHOT_FILENAME);
        if (snapshotFile.exists() && snapshotFile.isFile()) {
            LOGGER.error("Failed to take snapshot, because snapshot file [{}] is already exist.", (Object)snapshotFile.getAbsolutePath());
            return false;
        }
        File tmpFile = new File(snapshotFile.getAbsolutePath() + "-" + UUID.randomUUID());
        this.databaseReadWriteLock.readLock().lock();
        try {
            try (FileOutputStream fileOutputStream = new FileOutputStream(tmpFile);
                 BufferedOutputStream outputStream = new BufferedOutputStream(fileOutputStream);){
                this.mTree.serialize((OutputStream)outputStream);
                outputStream.flush();
            }
            boolean bl = tmpFile.renameTo(snapshotFile);
            return bl;
        }
        finally {
            for (int retry = 0; retry < 5 && tmpFile.exists() && !tmpFile.delete(); ++retry) {
                LOGGER.warn("Can't delete temporary snapshot file: {}, retrying...", (Object)tmpFile.getAbsolutePath());
            }
            this.databaseReadWriteLock.readLock().unlock();
        }
    }

    public void processLoadSnapshot(File snapshotDir) throws IOException {
        this.processMTreeLoadSnapshot(snapshotDir);
        this.templateTable.processLoadSnapshot(snapshotDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMTreeLoadSnapshot(File snapshotDir) throws IOException {
        File snapshotFile = new File(snapshotDir, SNAPSHOT_FILENAME);
        if (!snapshotFile.exists() || !snapshotFile.isFile()) {
            LOGGER.error("Failed to load snapshot,snapshot file [{}] is not exist.", (Object)snapshotFile.getAbsolutePath());
            return;
        }
        this.databaseReadWriteLock.writeLock().lock();
        try (FileInputStream fileInputStream = new FileInputStream(snapshotFile);
             BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);){
            this.mTree.clear();
            this.mTree.deserialize((InputStream)bufferedInputStream);
        }
        finally {
            this.databaseReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<List<PartialPath>, Set<PartialPath>> getNodesListInGivenLevel(PartialPath partialPath, int level) {
        Pair matchedPathsInNextLevel = new Pair(new HashSet(), new HashSet());
        this.databaseReadWriteLock.readLock().lock();
        try {
            matchedPathsInNextLevel = this.mTree.getNodesListInGivenLevel(partialPath, level, true);
        }
        catch (MetadataException e) {
            LOGGER.error("Error get matched paths in given level.", (Throwable)e);
        }
        finally {
            this.databaseReadWriteLock.readLock().unlock();
        }
        return matchedPathsInNextLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Set<TSchemaNode>, Set<PartialPath>> getChildNodePathInNextLevel(PartialPath partialPath) {
        Pair matchedPathsInNextLevel = new Pair(new HashSet(), new HashSet());
        this.databaseReadWriteLock.readLock().lock();
        try {
            matchedPathsInNextLevel = this.mTree.getChildNodePathInNextLevel(partialPath);
        }
        catch (MetadataException e) {
            LOGGER.error("Error get matched paths in next level.", (Throwable)e);
        }
        finally {
            this.databaseReadWriteLock.readLock().unlock();
        }
        return matchedPathsInNextLevel;
    }

    public TSStatus createSchemaTemplate(CreateSchemaTemplatePlan createSchemaTemplatePlan) {
        try {
            Template template = createSchemaTemplatePlan.getTemplate();
            this.templateTable.createTemplate(template);
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (MetadataException e) {
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
    }

    public TemplateInfoResp getAllTemplates() {
        TemplateInfoResp result = new TemplateInfoResp();
        List<Template> resp = this.templateTable.getAllTemplate();
        result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
        result.setTemplateList(resp);
        return result;
    }

    public TemplateInfoResp getTemplate(GetSchemaTemplatePlan getSchemaTemplatePlan) {
        TemplateInfoResp result = new TemplateInfoResp();
        ArrayList<Template> list = new ArrayList<Template>();
        try {
            String templateName = getSchemaTemplatePlan.getTemplateName();
            if (templateName.equals("*")) {
                list.addAll(this.templateTable.getAllTemplate());
            } else {
                list.add(this.templateTable.getTemplate(templateName));
            }
            result.setTemplateList(list);
            result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
        }
        catch (MetadataException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            result.setStatus(RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
        }
        return result;
    }

    public synchronized TemplateInfoResp checkTemplateSettable(CheckTemplateSettablePlan checkTemplateSettablePlan) {
        PartialPath path;
        TemplateInfoResp resp = new TemplateInfoResp();
        try {
            path = new PartialPath(checkTemplateSettablePlan.getPath());
        }
        catch (IllegalPathException e) {
            LOGGER.error(e.getMessage());
            resp.setStatus(RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
            return resp;
        }
        try {
            this.mTree.checkTemplateOnPath(path);
            resp.setStatus(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()));
            resp.setTemplateList(Collections.singletonList(this.templateTable.getTemplate(checkTemplateSettablePlan.getName())));
        }
        catch (MetadataException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            resp.setStatus(RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
        }
        return resp;
    }

    public synchronized TSStatus setSchemaTemplate(SetSchemaTemplatePlan setSchemaTemplatePlan) {
        PartialPath path;
        try {
            path = new PartialPath(setSchemaTemplatePlan.getPath());
        }
        catch (IllegalPathException e) {
            LOGGER.error(e.getMessage());
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
        try {
            int templateId = this.templateTable.getTemplate(setSchemaTemplatePlan.getName()).getId();
            this.mTree.getNodeWithAutoCreate(path).setSchemaTemplateId(templateId);
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (MetadataException e) {
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
    }

    public PathInfoResp getPathsSetTemplate(GetPathsSetTemplatePlan getPathsSetTemplatePlan) {
        TSStatus status;
        PathInfoResp pathInfoResp = new PathInfoResp();
        try {
            String templateName = getPathsSetTemplatePlan.getName();
            int templateId = templateName.equals("*") ? -2 : this.templateTable.getTemplate(templateName).getId();
            pathInfoResp.setPathList(this.mTree.getPathsSetOnTemplate(templateId, false));
            status = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (MetadataException e) {
            status = RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
        pathInfoResp.setStatus(status);
        return pathInfoResp;
    }

    public AllTemplateSetInfoResp getAllTemplateSetInfo() {
        List<Template> templateList = this.templateTable.getAllTemplate();
        HashMap<Integer, List> templateSetInfo = new HashMap<Integer, List>();
        for (Template template : templateList) {
            int id = template.getId();
            try {
                List pathList = this.mTree.getPathsSetOnTemplate(id, true);
                if (pathList.isEmpty()) continue;
                templateSetInfo.put(id, pathList);
            }
            catch (MetadataException e) {
                LOGGER.error("Error occurred when get paths set on template {}", (Object)id, (Object)e);
            }
        }
        HashMap<Template, List> templateSetInfoMap = new HashMap<Template, List>();
        for (Template template : templateList) {
            if (!templateSetInfo.containsKey(template.getId())) continue;
            templateSetInfoMap.put(template, (List)templateSetInfo.get(template.getId()));
        }
        return new AllTemplateSetInfoResp(TemplateInternalRPCUtil.generateAddTemplateSetInfoBytes(templateSetInfoMap));
    }

    public TemplateSetInfoResp getTemplateSetInfo(GetTemplateSetInfoPlan plan) {
        TemplateSetInfoResp resp = new TemplateSetInfoResp();
        try {
            HashMap allTemplateSetInfo = new HashMap();
            for (PartialPath pattern : plan.getPatternList()) {
                Map templateSetInfo = this.mTree.getTemplateSetInfo(pattern);
                if (templateSetInfo.isEmpty()) continue;
                templateSetInfo.forEach((templateId, templateSetPathList) -> {
                    for (PartialPath templateSetPath : templateSetPathList) {
                        pattern.alterPrefixPath(templateSetPath).forEach(path -> allTemplateSetInfo.computeIfAbsent(path, k -> new HashSet()).add(templateId));
                    }
                });
            }
            HashMap<PartialPath, List<Template>> result = new HashMap<PartialPath, List<Template>>();
            for (Map.Entry entry : allTemplateSetInfo.entrySet()) {
                ArrayList<Template> templateList = new ArrayList<Template>(((Set)entry.getValue()).size());
                Iterator iterator = ((Set)entry.getValue()).iterator();
                while (iterator.hasNext()) {
                    int templateId2 = (Integer)iterator.next();
                    templateList.add(this.templateTable.getTemplate(templateId2));
                }
                result.put((PartialPath)entry.getKey(), templateList);
            }
            resp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
            resp.setPatternTemplateMap(result);
            return resp;
        }
        catch (MetadataException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            resp.setStatus(RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
            return resp;
        }
    }

    public TSStatus preUnsetSchemaTemplate(PreUnsetSchemaTemplatePlan plan) {
        try {
            this.mTree.preUnsetTemplate(plan.getTemplateId(), plan.getPath());
            return StatusUtils.OK;
        }
        catch (MetadataException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
    }

    public TSStatus rollbackUnsetSchemaTemplate(RollbackPreUnsetSchemaTemplatePlan plan) {
        try {
            this.mTree.rollbackUnsetTemplate(plan.getTemplateId(), plan.getPath());
            return StatusUtils.OK;
        }
        catch (MetadataException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
    }

    public TSStatus unsetSchemaTemplate(UnsetSchemaTemplatePlan plan) {
        try {
            this.mTree.unsetTemplate(plan.getTemplateId(), plan.getPath());
            return StatusUtils.OK;
        }
        catch (MetadataException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
    }

    public TSStatus dropSchemaTemplate(DropSchemaTemplatePlan dropSchemaTemplatePlan) {
        try {
            this.templateTable.dropTemplate(dropSchemaTemplatePlan.getTemplateName());
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (MetadataException e) {
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, TDatabaseSchema> getMatchedStorageGroupSchemasByOneName(String[] storageGroupPathPattern) {
        HashMap<String, TDatabaseSchema> schemaMap = new HashMap<String, TDatabaseSchema>();
        this.databaseReadWriteLock.readLock().lock();
        try {
            PartialPath patternPath = new PartialPath(storageGroupPathPattern);
            List matchedPaths = this.mTree.getBelongedStorageGroups(patternPath);
            for (PartialPath path : matchedPaths) {
                schemaMap.put(path.getFullPath(), this.mTree.getStorageGroupNodeByPath(path).getStorageGroupSchema());
            }
        }
        catch (MetadataException e) {
            LOGGER.warn("Error Database name", (Throwable)e);
        }
        finally {
            this.databaseReadWriteLock.readLock().unlock();
        }
        return schemaMap;
    }

    public void clear() {
        this.mTree.clear();
    }
}

