/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.client.sync;

import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.ClientPoolFactory;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.commons.client.exception.ClientManagerException;
import org.apache.iotdb.commons.client.sync.SyncConfigNodeIServiceClient;
import org.apache.iotdb.confignode.client.ConfigNodeRequestType;
import org.apache.iotdb.confignode.rpc.thrift.TAddConsensusGroupReq;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeRegisterReq;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeRegisterResp;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeRestartReq;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncConfigNodeClientPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncConfigNodeClientPool.class);
    private static final int MAX_RETRY_NUM = 6;
    private final IClientManager<TEndPoint, SyncConfigNodeIServiceClient> clientManager = new IClientManager.Factory().createClientManager((IClientPoolFactory)new ClientPoolFactory.SyncConfigNodeIServiceClientPoolFactory());
    private TEndPoint configNodeLeader = new TEndPoint();

    private SyncConfigNodeClientPool() {
    }

    private void updateConfigNodeLeader(TSStatus status) {
        this.configNodeLeader = status.isSetRedirectNode() ? status.getRedirectNode() : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object sendSyncRequestToConfigNodeWithRetry(TEndPoint endPoint, Object req, ConfigNodeRequestType requestType) {
        Exception lastException = null;
        int retry = 0;
        while (true) {
            if (retry >= 6) {
                LOGGER.error("{} failed on ConfigNode {}", new Object[]{requestType, endPoint, lastException});
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_REQUEST_RETRY_ERROR, (String)("All retry failed due to: " + lastException.getMessage()));
            }
            try (SyncConfigNodeIServiceClient client = (SyncConfigNodeIServiceClient)this.clientManager.borrowClient((Object)endPoint);){
                switch (requestType) {
                    case REGISTER_CONFIG_NODE: {
                        TConfigNodeRegisterResp tConfigNodeRegisterResp = client.registerConfigNode((TConfigNodeRegisterReq)req);
                        return tConfigNodeRegisterResp;
                    }
                    case ADD_CONSENSUS_GROUP: {
                        TSStatus tSStatus = client.addConsensusGroup((TAddConsensusGroupReq)req);
                        return tSStatus;
                    }
                    case NOTIFY_REGISTER_SUCCESS: {
                        client.notifyRegisterSuccess();
                        Object var7_10 = null;
                        return var7_10;
                    }
                    case RESTART_CONFIG_NODE: {
                        TSStatus tSStatus = client.restartConfigNode((TConfigNodeRestartReq)req);
                        return tSStatus;
                    }
                    case REMOVE_CONFIG_NODE: {
                        TSStatus tSStatus = this.removeConfigNode((TConfigNodeLocation)req, client);
                        return tSStatus;
                    }
                    case DELETE_CONFIG_NODE_PEER: {
                        TSStatus tSStatus = client.deleteConfigNodePeer((TConfigNodeLocation)req);
                        return tSStatus;
                    }
                    case REPORT_CONFIG_NODE_SHUTDOWN: {
                        TSStatus tSStatus = client.reportConfigNodeShutdown((TConfigNodeLocation)req);
                        return tSStatus;
                    }
                    case STOP_CONFIG_NODE: {
                        TSStatus tSStatus = client.stopConfigNode((TConfigNodeLocation)req);
                        return tSStatus;
                    }
                }
                TSStatus tSStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)("Unknown request type: " + (Object)((Object)requestType)));
                return tSStatus;
            }
            catch (Exception e) {
                lastException = e;
                LOGGER.warn("{} failed on ConfigNode {}, because {}, retrying {}...", new Object[]{requestType, endPoint, e.getMessage(), retry});
                this.doRetryWait(retry);
                ++retry;
                continue;
            }
            break;
        }
    }

    public TSStatus removeConfigNode(TConfigNodeLocation configNodeLocation, SyncConfigNodeIServiceClient client) throws ClientManagerException, TException, InterruptedException {
        TSStatus status = client.removeConfigNode(configNodeLocation);
        while (status.getCode() == TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
            TimeUnit.MILLISECONDS.sleep(2000L);
            this.updateConfigNodeLeader(status);
            SyncConfigNodeIServiceClient clientLeader = (SyncConfigNodeIServiceClient)this.clientManager.borrowClient((Object)this.configNodeLeader);
            try {
                status = clientLeader.removeConfigNode(configNodeLocation);
            }
            finally {
                if (clientLeader == null) continue;
                clientLeader.close();
            }
        }
        return status;
    }

    private void doRetryWait(int retryNum) {
        try {
            TimeUnit.MILLISECONDS.sleep(100L * (long)Math.pow(2.0, retryNum));
        }
        catch (InterruptedException e) {
            LOGGER.error("Retry wait failed.", (Throwable)e);
        }
    }

    public static SyncConfigNodeClientPool getInstance() {
        return SyncConfigNodeClientPoolHolder.INSTANCE;
    }

    private static class SyncConfigNodeClientPoolHolder {
        private static final SyncConfigNodeClientPool INSTANCE = new SyncConfigNodeClientPool();

        private SyncConfigNodeClientPoolHolder() {
        }
    }
}

