/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.thirdparty.info.ganglia.gmetric4j;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.ratis.thirdparty.info.ganglia.gmetric4j.CoreSampler;
import org.apache.ratis.thirdparty.info.ganglia.gmetric4j.DefaultGScheduler;
import org.apache.ratis.thirdparty.info.ganglia.gmetric4j.GSampler;
import org.apache.ratis.thirdparty.info.ganglia.gmetric4j.GScheduler;
import org.apache.ratis.thirdparty.info.ganglia.gmetric4j.gmetric.GMetric;
import org.apache.ratis.thirdparty.info.ganglia.gmetric4j.gmetric.GMetricPublisher;

public class GMonitor {
    private List<GSampler> samplers = new ArrayList<GSampler>();
    private boolean daemon = true;
    private GMetric gmetric = null;
    private GScheduler scheduler;

    public GMonitor() {
        this.scheduler = new DefaultGScheduler();
    }

    public GMonitor(GScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void start() {
        this.scheduler.onStart();
        for (GSampler s2 : this.samplers) {
            this.scheduler.scheduleAtFixedRate(s2, s2.getInitialDelay(), s2.getDelay(), TimeUnit.SECONDS);
        }
    }

    public void stop() {
        this.scheduler.onStop();
    }

    public void addSampler(GSampler s2) {
        this.samplers.add(s2);
        s2.setPublisher(new GMetricPublisher(this.gmetric));
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public GMetric getGmetric() {
        return this.gmetric;
    }

    public void setGmetric(GMetric gmetric) {
        this.gmetric = gmetric;
    }

    public static void main(String[] args) throws Exception {
        GMonitor a = null;
        try {
            a = new GMonitor();
            a.setGmetric(new GMetric("239.2.11.71", 8649, GMetric.UDPAddressingMode.MULTICAST, 1));
            a.addSampler(new CoreSampler());
            a.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        while (true) {
            Thread.sleep(300000L);
            System.out.println("Test wakeup");
        }
    }
}

