/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.auth.entity;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.auth.entity.PathPrivilege;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.AuthUtils;
import org.apache.iotdb.commons.utils.SerializeUtils;

public class Role {
    private String name;
    private List<PathPrivilege> privilegeList;

    public Role() {
    }

    public Role(String name) {
        this.name = name;
        this.privilegeList = new ArrayList<PathPrivilege>();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<PathPrivilege> getPrivilegeList() {
        return this.privilegeList;
    }

    public void setPrivilegeList(List<PathPrivilege> privilegeList) {
        this.privilegeList = privilegeList;
    }

    public boolean hasPrivilege(PartialPath path, int privilegeId) {
        return AuthUtils.hasPrivilege(path, privilegeId, this.privilegeList);
    }

    public void addPrivilege(PartialPath path, int privilegeId) {
        AuthUtils.addPrivilege(path, privilegeId, this.privilegeList);
    }

    public void removePrivilege(PartialPath path, int privilegeId) {
        AuthUtils.removePrivilege(path, privilegeId, this.privilegeList);
    }

    public void setPrivileges(PartialPath path, Set<Integer> privileges) {
        for (PathPrivilege pathPrivilege : this.privilegeList) {
            if (!pathPrivilege.getPath().equals(path)) continue;
            pathPrivilege.setPrivileges(privileges);
        }
    }

    public Set<Integer> getPrivileges(PartialPath path) throws AuthException {
        return AuthUtils.getPrivileges(path, this.privilegeList);
    }

    public boolean checkPrivilege(PartialPath path, int privilegeId) throws AuthException {
        return AuthUtils.checkPrivilege(path, privilegeId, this.privilegeList);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Role role = (Role)o;
        return Objects.equals(this.name, role.name) && Objects.equals(this.privilegeList, role.privilegeList);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.privilegeList);
    }

    public ByteBuffer serialize() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        SerializeUtils.serialize(this.name, dataOutputStream);
        try {
            dataOutputStream.writeInt(this.privilegeList.size());
            for (PathPrivilege pathPrivilege : this.privilegeList) {
                dataOutputStream.write(pathPrivilege.serialize().array());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    public void deserialize(ByteBuffer buffer) {
        this.name = SerializeUtils.deserializeString(buffer);
        int privilegeListSize = buffer.getInt();
        this.privilegeList = new ArrayList<PathPrivilege>(privilegeListSize);
        for (int i = 0; i < privilegeListSize; ++i) {
            PathPrivilege pathPrivilege = new PathPrivilege();
            pathPrivilege.deserialize(buffer);
            this.privilegeList.add(pathPrivilege);
        }
    }

    public String toString() {
        return "Role{name='" + this.name + '\'' + ", privilegeList=" + this.privilegeList + '}';
    }
}

