/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.common;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.iotdb.commons.exception.sync.PipeException;
import org.apache.iotdb.commons.exception.sync.PipeSinkException;
import org.apache.iotdb.commons.sync.metadata.SyncMetadata;
import org.apache.iotdb.commons.sync.persistence.SyncLogReader;
import org.apache.iotdb.commons.sync.persistence.SyncLogWriter;
import org.apache.iotdb.commons.sync.pipe.PipeInfo;
import org.apache.iotdb.commons.sync.pipe.PipeMessage;
import org.apache.iotdb.commons.sync.pipe.PipeStatus;
import org.apache.iotdb.commons.sync.pipe.SyncOperation;
import org.apache.iotdb.commons.sync.pipesink.PipeSink;
import org.apache.iotdb.commons.sync.utils.SyncPathUtil;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.CreatePipeSinkStatement;
import org.apache.iotdb.db.utils.sync.SyncPipeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalSyncInfo {
    protected static final Logger LOGGER = LoggerFactory.getLogger(LocalSyncInfo.class);
    protected SyncLogWriter syncLogWriter = new SyncLogWriter(new File(SyncPathUtil.getSysDir()));
    private final SyncMetadata syncMetadata = new SyncMetadata();

    public LocalSyncInfo() {
        SyncLogReader logReader = new SyncLogReader(new File(SyncPathUtil.getSysDir()));
        try {
            logReader.recover();
            this.syncMetadata.setPipes(logReader.getPipes());
            this.syncMetadata.setPipeSinks(logReader.getAllPipeSinks());
        }
        catch (IOException e) {
            LOGGER.error("Cannot recover ReceiverInfo because {}. Use default info values.", (Object)e.getMessage());
        }
    }

    public void close() throws IOException {
        this.syncLogWriter.close();
    }

    public void addPipeSink(CreatePipeSinkStatement createPipeSinkStatement) throws PipeSinkException, IOException {
        this.syncMetadata.checkPipeSinkNoExist(createPipeSinkStatement.getPipeSinkName());
        PipeSink pipeSink = SyncPipeUtil.parseCreatePipeSinkStatement(createPipeSinkStatement);
        this.syncMetadata.addPipeSink(pipeSink);
        this.syncLogWriter.addPipeSink(pipeSink);
    }

    public void dropPipeSink(String name) throws PipeSinkException, IOException {
        this.syncMetadata.checkDropPipeSink(name);
        this.syncMetadata.dropPipeSink(name);
        this.syncLogWriter.dropPipeSink(name);
    }

    public PipeSink getPipeSink(String name) {
        return this.syncMetadata.getPipeSink(name);
    }

    public List<PipeSink> getAllPipeSink() {
        return this.syncMetadata.getAllPipeSink();
    }

    public void addPipe(PipeInfo pipeInfo) throws PipeException, IOException, PipeSinkException {
        this.syncMetadata.checkAddPipe(pipeInfo);
        this.syncMetadata.addPipe(pipeInfo);
        this.syncLogWriter.addPipe(pipeInfo);
    }

    public void operatePipe(String pipeName, SyncOperation syncOperation) throws PipeException, IOException {
        this.syncMetadata.checkIfPipeExist(pipeName);
        switch (syncOperation) {
            case START_PIPE: {
                this.syncMetadata.setPipeStatus(pipeName, PipeStatus.RUNNING);
                break;
            }
            case STOP_PIPE: {
                this.syncMetadata.setPipeStatus(pipeName, PipeStatus.STOP);
                break;
            }
            case DROP_PIPE: {
                this.syncMetadata.dropPipe(pipeName);
                break;
            }
            default: {
                throw new PipeException("Unknown operatorType " + syncOperation);
            }
        }
        this.syncLogWriter.operatePipe(pipeName, syncOperation);
    }

    public PipeInfo getPipeInfo(String pipeName) {
        return this.syncMetadata.getPipeInfo(pipeName);
    }

    public List<PipeInfo> getAllPipeInfos() {
        return this.syncMetadata.getAllPipeInfos();
    }

    public void changePipeMessage(String pipeName, PipeMessage.PipeMessageType messageType) {
        this.syncMetadata.changePipeMessage(pipeName, messageType);
    }
}

