/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.rest.v2.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.core.Response;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.db.mpp.common.header.DatasetHeader;
import org.apache.iotdb.db.mpp.plan.execution.IQueryExecution;
import org.apache.iotdb.db.mpp.plan.statement.Statement;
import org.apache.iotdb.db.mpp.plan.statement.crud.QueryStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowChildPathsStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.AuthorStatement;
import org.apache.iotdb.db.protocol.rest.model.ExecutionStatus;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;

public class QueryDataSetHandler {
    private QueryDataSetHandler() {
    }

    public static Response fillQueryDataSet(IQueryExecution queryExecution, Statement statement, int actualRowSizeLimit) throws IoTDBException {
        if (statement instanceof ShowStatement || statement instanceof AuthorStatement) {
            return QueryDataSetHandler.fillShowPlanDataSet(queryExecution, actualRowSizeLimit);
        }
        if (statement instanceof QueryStatement) {
            if (((QueryStatement)statement).isAggregationQuery() && !((QueryStatement)statement).isGroupByTime()) {
                return QueryDataSetHandler.fillAggregationPlanDataSet(queryExecution, actualRowSizeLimit);
            }
            return QueryDataSetHandler.fillDataSetWithTimestamps(queryExecution, actualRowSizeLimit, 1L);
        }
        return Response.ok().entity((Object)new ExecutionStatus().code(Integer.valueOf(TSStatusCode.QUERY_PROCESS_ERROR.getStatusCode())).message(String.format("unsupported query data type: %s", statement.getType().toString()))).build();
    }

    public static Response fillDataSetWithTimestamps(IQueryExecution queryExecution, int actualRowSizeLimit, long timePrecision) throws IoTDBException {
        org.apache.iotdb.db.protocol.rest.v2.model.QueryDataSet targetDataSet = new org.apache.iotdb.db.protocol.rest.v2.model.QueryDataSet();
        return QueryDataSetHandler.fillQueryDataSetWithTimestamps(queryExecution, actualRowSizeLimit, targetDataSet, timePrecision);
    }

    public static Response fillAggregationPlanDataSet(IQueryExecution queryExecution, int actualRowSizeLimit) throws IoTDBException {
        org.apache.iotdb.db.protocol.rest.v2.model.QueryDataSet targetDataSet = new org.apache.iotdb.db.protocol.rest.v2.model.QueryDataSet();
        DatasetHeader datasetHeader = queryExecution.getDatasetHeader();
        int[] targetDataSetIndexToSourceDataSetIndex = new int[datasetHeader.getRespColumns().size()];
        for (int i = 0; i < datasetHeader.getRespColumns().size(); ++i) {
            targetDataSet.addExpressionsItem(datasetHeader.getRespColumns().get(i));
            targetDataSet.addValuesItem(new ArrayList());
            targetDataSetIndexToSourceDataSetIndex[i] = datasetHeader.getColumnNameIndexMap().get(datasetHeader.getRespColumns().get(i));
        }
        return QueryDataSetHandler.fillQueryDataSetWithoutTimestamps(queryExecution, targetDataSetIndexToSourceDataSetIndex, actualRowSizeLimit, targetDataSet);
    }

    private static Response fillShowPlanDataSet(IQueryExecution queryExecution, int actualRowSizeLimit) throws IoTDBException {
        org.apache.iotdb.db.protocol.rest.v2.model.QueryDataSet targetDataSet = new org.apache.iotdb.db.protocol.rest.v2.model.QueryDataSet();
        int[] targetDataSetIndexToSourceDataSetIndex = new int[queryExecution.getDatasetHeader().getRespColumns().size()];
        QueryDataSetHandler.initTargetDatasetOrderByOrderWithSourceDataSet(queryExecution.getDatasetHeader(), targetDataSetIndexToSourceDataSetIndex, targetDataSet);
        return QueryDataSetHandler.fillQueryDataSetWithoutTimestamps(queryExecution, targetDataSetIndexToSourceDataSetIndex, actualRowSizeLimit, targetDataSet);
    }

    private static void initTargetDatasetOrderByOrderWithSourceDataSet(DatasetHeader datasetHeader, int[] targetDataSetIndexToSourceDataSetIndex, org.apache.iotdb.db.protocol.rest.v2.model.QueryDataSet targetDataSet) {
        if (datasetHeader.getRespColumns() != null) {
            for (int i = 0; i < datasetHeader.getRespColumns().size(); ++i) {
                targetDataSet.addColumnNamesItem(datasetHeader.getRespColumns().get(i));
                targetDataSet.addValuesItem(new ArrayList());
                targetDataSetIndexToSourceDataSetIndex[i] = i;
            }
        }
    }

    private static void initTargetDatasetExpByOrderWithSourceDataSet(QueryDataSet sourceDataSet, int[] targetDataSetIndexToSourceDataSetIndex, org.apache.iotdb.db.protocol.rest.v2.model.QueryDataSet targetDataSet) {
        if (sourceDataSet.getPaths() != null) {
            for (int i = 0; i < sourceDataSet.getPaths().size(); ++i) {
                Path path = (Path)sourceDataSet.getPaths().get(i);
                targetDataSet.addExpressionsItem(path.getFullPath());
                targetDataSet.addValuesItem(new ArrayList());
                targetDataSetIndexToSourceDataSetIndex[i] = i;
            }
        }
    }

    private static Response fillQueryDataSetWithTimestamps(IQueryExecution queryExecution, int actualRowSizeLimit, org.apache.iotdb.db.protocol.rest.v2.model.QueryDataSet targetDataSet, long timePrecision) throws IoTDBException {
        int fetched = 0;
        int columnNum = queryExecution.getOutputValueColumnCount();
        DatasetHeader header = queryExecution.getDatasetHeader();
        List<String> resultColumns = header.getRespColumns();
        Map<String, Integer> headerMap = header.getColumnNameIndexMap();
        for (String resultColumn : resultColumns) {
            targetDataSet.addExpressionsItem(resultColumn);
            targetDataSet.addValuesItem(new ArrayList());
        }
        block1: while (true) {
            if (0 < actualRowSizeLimit && actualRowSizeLimit <= fetched) {
                return Response.ok().entity((Object)new ExecutionStatus().code(Integer.valueOf(TSStatusCode.QUERY_PROCESS_ERROR.getStatusCode())).message(String.format("Dataset row size exceeded the given max row size (%d)", actualRowSizeLimit))).build();
            }
            Optional<TsBlock> optionalTsBlock = queryExecution.getBatchResult();
            if (!optionalTsBlock.isPresent() || optionalTsBlock.get().isEmpty()) {
                if (fetched != 0) break;
                targetDataSet.setTimestamps(new ArrayList());
                targetDataSet.setValues(new ArrayList());
                return Response.ok().entity((Object)targetDataSet).build();
            }
            TsBlock tsBlock = optionalTsBlock.get();
            int currentCount = tsBlock.getPositionCount();
            for (int i = 0; i < currentCount; ++i) {
                targetDataSet.addTimestampsItem(Long.valueOf(timePrecision == 1L ? tsBlock.getTimeByIndex(i) : tsBlock.getTimeByIndex(i) / timePrecision));
            }
            int k = 0;
            while (true) {
                if (k >= resultColumns.size()) continue block1;
                Column column = tsBlock.getColumn(headerMap.get(resultColumns.get(k)).intValue());
                List targetDataSetColumn = (List)targetDataSet.getValues().get(k);
                for (int i = 0; i < currentCount; ++i) {
                    ++fetched;
                    if (column.isNull(i)) {
                        targetDataSetColumn.add(null);
                        continue;
                    }
                    targetDataSetColumn.add(column.getDataType().equals((Object)TSDataType.TEXT) ? column.getBinary(i).getStringValue() : column.getObject(i));
                }
                if (k != columnNum - 1) {
                    fetched -= currentCount;
                }
                ++k;
            }
            break;
        }
        return Response.ok().entity((Object)targetDataSet).build();
    }

    private static Response fillQueryDataSetWithoutTimestamps(IQueryExecution queryExecution, int[] targetDataSetIndexToSourceDataSetIndex, int actualRowSizeLimit, org.apache.iotdb.db.protocol.rest.v2.model.QueryDataSet targetDataSet) throws IoTDBException {
        int fetched = 0;
        int columnNum = queryExecution.getOutputValueColumnCount();
        block0: while (true) {
            if (0 < actualRowSizeLimit && actualRowSizeLimit <= fetched) {
                return Response.ok().entity((Object)new ExecutionStatus().code(Integer.valueOf(TSStatusCode.QUERY_PROCESS_ERROR.getStatusCode())).message(String.format("Dataset row size exceeded the given max row size (%d)", actualRowSizeLimit))).build();
            }
            Optional<TsBlock> optionalTsBlock = queryExecution.getBatchResult();
            if (!optionalTsBlock.isPresent()) {
                if (fetched != 0) break;
                targetDataSet.setValues(new ArrayList());
                return Response.ok().entity((Object)targetDataSet).build();
            }
            TsBlock tsBlock = optionalTsBlock.get();
            int currentCount = tsBlock.getPositionCount();
            if (currentCount == 0) {
                targetDataSet.setValues(new ArrayList());
                return Response.ok().entity((Object)targetDataSet).build();
            }
            int k = 0;
            while (true) {
                if (k >= columnNum) continue block0;
                Column column = tsBlock.getColumn(targetDataSetIndexToSourceDataSetIndex[k]);
                List targetDataSetColumn = (List)targetDataSet.getValues().get(k);
                for (int i = 0; i < currentCount; ++i) {
                    ++fetched;
                    if (column.isNull(i)) {
                        targetDataSetColumn.add(null);
                        continue;
                    }
                    targetDataSetColumn.add(column.getDataType().equals((Object)TSDataType.TEXT) ? column.getBinary(i).getStringValue() : column.getObject(i));
                }
                if (k != columnNum - 1) {
                    fetched -= currentCount;
                }
                ++k;
            }
            break;
        }
        return Response.ok().entity((Object)targetDataSet).build();
    }

    public static Response fillGrafanaVariablesResult(IQueryExecution queryExecution, Statement statement) throws IoTDBException {
        ArrayList<String> results = new ArrayList<String>();
        Optional<TsBlock> optionalTsBlock = queryExecution.getBatchResult();
        if (!optionalTsBlock.isPresent()) {
            return Response.ok().entity(results).build();
        }
        TsBlock tsBlock = optionalTsBlock.get();
        int currentCount = tsBlock.getPositionCount();
        Column column = tsBlock.getColumn(0);
        for (int i = 0; i < currentCount; ++i) {
            String nodePaths = column.getObject(i).toString();
            if (statement instanceof ShowChildPathsStatement) {
                String[] nodeSubPath = nodePaths.split("\\.");
                results.add(nodeSubPath[nodeSubPath.length - 1]);
                continue;
            }
            results.add(nodePaths);
        }
        return Response.ok().entity(results).build();
    }

    public static Response fillGrafanaNodesResult(IQueryExecution queryExecution) throws IoTDBException {
        ArrayList<String> nodes = new ArrayList<String>();
        Optional<TsBlock> optionalTsBlock = queryExecution.getBatchResult();
        if (!optionalTsBlock.isPresent()) {
            return Response.ok().entity(nodes).build();
        }
        TsBlock tsBlock = optionalTsBlock.get();
        int currentCount = tsBlock.getPositionCount();
        Column column = tsBlock.getColumn(0);
        for (int i = 0; i < currentCount; ++i) {
            String nodePaths = column.getObject(i).toString();
            String[] nodeSubPath = nodePaths.split("\\.");
            nodes.add(nodeSubPath[nodeSubPath.length - 1]);
        }
        return Response.ok().entity(nodes).build();
    }
}

