/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.transformation.dag.transformer.binary;

import java.io.IOException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.mpp.transformation.api.LayerPointReader;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.binary.BinaryTransformer;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public abstract class CompareBinaryTransformer
extends BinaryTransformer {
    protected final Evaluator evaluator;

    protected CompareBinaryTransformer(LayerPointReader leftPointReader, LayerPointReader rightPointReader) throws UnSupportedDataTypeException {
        super(leftPointReader, rightPointReader);
        this.evaluator = TSDataType.TEXT.equals((Object)this.leftPointReaderDataType) ? this.constructTextEvaluator() : this.constructNumberEvaluator();
    }

    protected abstract Evaluator constructNumberEvaluator();

    protected abstract Evaluator constructTextEvaluator();

    @Override
    protected final void checkType() {
        if (this.leftPointReaderDataType.equals((Object)this.rightPointReaderDataType)) {
            return;
        }
        if (this.leftPointReaderDataType.equals((Object)TSDataType.BOOLEAN) || this.rightPointReaderDataType.equals((Object)TSDataType.BOOLEAN)) {
            throw new UnSupportedDataTypeException(TSDataType.BOOLEAN.toString());
        }
        if (this.leftPointReaderDataType.equals((Object)TSDataType.TEXT) || this.rightPointReaderDataType.equals((Object)TSDataType.TEXT)) {
            throw new UnSupportedDataTypeException(TSDataType.TEXT.toString());
        }
    }

    @Override
    protected final void transformAndCache() throws QueryProcessException, IOException {
        this.cachedBoolean = this.evaluator.evaluate();
    }

    @Override
    public TSDataType getDataType() {
        return TSDataType.BOOLEAN;
    }

    @FunctionalInterface
    protected static interface Evaluator {
        public boolean evaluate() throws QueryProcessException, IOException;
    }
}

