/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.execution.config.sys.sync;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.confignode.rpc.thrift.TShowPipeInfo;
import org.apache.iotdb.db.mpp.common.header.ColumnHeader;
import org.apache.iotdb.db.mpp.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.mpp.common.header.DatasetHeader;
import org.apache.iotdb.db.mpp.common.header.DatasetHeaderFactory;
import org.apache.iotdb.db.mpp.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.mpp.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.mpp.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.ShowPipeStatement;
import org.apache.iotdb.db.utils.DateTimeUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.utils.Binary;

public class ShowPipeTask
implements IConfigTask {
    private final ShowPipeStatement showPipeStatement;

    public ShowPipeTask(ShowPipeStatement showPipeStatement) {
        this.showPipeStatement = showPipeStatement;
    }

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) throws InterruptedException {
        return configTaskExecutor.showPipe(this.showPipeStatement);
    }

    public static void buildTSBlock(List<TShowPipeInfo> pipeInfoList, SettableFuture<ConfigTaskResult> future) {
        List outputDataTypes = ColumnHeaderConstant.showPipeColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        TsBlockBuilder builder = new TsBlockBuilder(outputDataTypes);
        for (TShowPipeInfo tPipeInfo : pipeInfoList) {
            builder.getTimeColumnBuilder().writeLong(0L);
            builder.getColumnBuilder(0).writeBinary(new Binary(DateTimeUtils.convertLongToDate(tPipeInfo.getCreateTime(), "ms")));
            builder.getColumnBuilder(1).writeBinary(new Binary(tPipeInfo.getPipeName()));
            builder.getColumnBuilder(2).writeBinary(new Binary(tPipeInfo.getRole()));
            builder.getColumnBuilder(3).writeBinary(new Binary(tPipeInfo.getRemote()));
            builder.getColumnBuilder(4).writeBinary(new Binary(tPipeInfo.getStatus()));
            builder.getColumnBuilder(5).writeBinary(new Binary(tPipeInfo.getAttributes()));
            builder.getColumnBuilder(6).writeBinary(new Binary(tPipeInfo.getMessage()));
            builder.declarePosition();
        }
        DatasetHeader datasetHeader = DatasetHeaderFactory.getShowPipeHeader();
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, builder.build(), datasetHeader));
    }
}

