/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.analyze.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.metadata.template.ITemplateManager;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.mpp.common.schematree.ClusterSchemaTree;
import org.apache.iotdb.db.mpp.plan.execution.ExecutionResult;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.MeasurementGroup;
import org.apache.iotdb.db.mpp.plan.statement.Statement;
import org.apache.iotdb.db.mpp.plan.statement.internal.InternalBatchActivateTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.internal.InternalCreateMultiTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.internal.InternalCreateTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.ActivateTemplateStatement;
import org.apache.iotdb.db.utils.EncodingInferenceUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

class AutoCreateSchemaExecutor {
    private final ITemplateManager templateManager;
    private final Function<Statement, ExecutionResult> statementExecutor;

    AutoCreateSchemaExecutor(ITemplateManager templateManager, Function<Statement, ExecutionResult> statementExecutor) {
        this.templateManager = templateManager;
        this.statementExecutor = statementExecutor;
    }

    void autoCreateMissingMeasurements(ClusterSchemaTree schemaTree, PartialPath devicePath, List<Integer> indexOfTargetMeasurements, String[] measurements, Function<Integer, TSDataType> getDataType, boolean isAligned) {
        Pair<Template, PartialPath> templateInfo = this.templateManager.checkTemplateSetInfo(devicePath);
        if (templateInfo != null) {
            Template template = (Template)templateInfo.left;
            List<Integer> indexOfMeasurementsNotInTemplate = this.checkMeasurementsInSchemaTemplate(devicePath, indexOfTargetMeasurements, measurements, isAligned, template);
            if (indexOfMeasurementsNotInTemplate.size() < indexOfTargetMeasurements.size()) {
                this.internalActivateTemplate(devicePath);
                for (Map.Entry<String, IMeasurementSchema> entry : template.getSchemaMap().entrySet()) {
                    schemaTree.appendSingleMeasurement(devicePath.concatNode(entry.getKey()), (MeasurementSchema)entry.getValue(), null, null, template.isDirectAligned());
                }
            }
            if (indexOfMeasurementsNotInTemplate.isEmpty()) {
                return;
            }
            indexOfTargetMeasurements = indexOfMeasurementsNotInTemplate;
        }
        ArrayList<String> missingMeasurements = new ArrayList<String>(indexOfTargetMeasurements.size());
        ArrayList<TSDataType> dataTypesOfMissingMeasurement = new ArrayList<TSDataType>(indexOfTargetMeasurements.size());
        ArrayList<TSEncoding> encodingsOfMissingMeasurement = new ArrayList<TSEncoding>(indexOfTargetMeasurements.size());
        ArrayList<CompressionType> compressionTypesOfMissingMeasurement = new ArrayList<CompressionType>(indexOfTargetMeasurements.size());
        indexOfTargetMeasurements.forEach(index -> {
            TSDataType tsDataType = (TSDataType)getDataType.apply((Integer)index);
            if (tsDataType != null) {
                missingMeasurements.add(measurements[index]);
                dataTypesOfMissingMeasurement.add(tsDataType);
                encodingsOfMissingMeasurement.add(EncodingInferenceUtils.getDefaultEncoding(tsDataType));
                compressionTypesOfMissingMeasurement.add(TSFileDescriptor.getInstance().getConfig().getCompressor());
            }
        });
        if (!missingMeasurements.isEmpty()) {
            this.internalCreateTimeSeries(schemaTree, devicePath, missingMeasurements, dataTypesOfMissingMeasurement, encodingsOfMissingMeasurement, compressionTypesOfMissingMeasurement, isAligned);
        }
    }

    void autoCreateMissingMeasurements(ClusterSchemaTree schemaTree, List<PartialPath> devicePathList, List<Integer> indexOfTargetDevices, List<List<Integer>> indexOfTargetMeasurementsList, List<String[]> measurementsList, List<TSDataType[]> tsDataTypesList, List<TSEncoding[]> encodingsList, List<CompressionType[]> compressionTypesList, List<Boolean> isAlignedList) {
        Template template;
        PartialPath devicePath;
        HashMap<PartialPath, Pair<Template, PartialPath>> devicesNeedActivateTemplate = new HashMap<PartialPath, Pair<Template, PartialPath>>();
        HashMap<PartialPath, Pair<Boolean, MeasurementGroup>> devicesNeedAutoCreateTimeSeries = new HashMap<PartialPath, Pair<Boolean, MeasurementGroup>>();
        int size = indexOfTargetDevices.size();
        for (int i = 0; i < size; ++i) {
            List<Integer> indexOfMeasurementsNotInTemplate;
            int deviceIndex = indexOfTargetDevices.get(i);
            devicePath = devicePathList.get(deviceIndex);
            List<Integer> indexOfTargetMeasurements = indexOfTargetMeasurementsList.get(i);
            Pair<Template, PartialPath> templateInfo = (Pair<Template, PartialPath>)devicesNeedActivateTemplate.get(devicePath);
            if (templateInfo == null) {
                templateInfo = this.templateManager.checkTemplateSetInfo(devicePath);
            }
            if (templateInfo == null) {
                indexOfMeasurementsNotInTemplate = indexOfTargetMeasurements;
            } else {
                template = (Template)templateInfo.left;
                indexOfMeasurementsNotInTemplate = this.checkMeasurementsInSchemaTemplate(devicePath, indexOfTargetMeasurements, measurementsList.get(deviceIndex), isAlignedList.get(deviceIndex), template);
                if (indexOfMeasurementsNotInTemplate.size() < indexOfTargetMeasurements.size()) {
                    devicesNeedActivateTemplate.putIfAbsent(devicePath, templateInfo);
                }
            }
            if (indexOfMeasurementsNotInTemplate.isEmpty()) continue;
            int finalDeviceIndex = deviceIndex;
            List<Integer> finalIndexOfMeasurementsNotInTemplate = indexOfMeasurementsNotInTemplate;
            devicesNeedAutoCreateTimeSeries.compute(devicePath, (k, v) -> {
                if (v == null) {
                    v = new Pair((Object)((Boolean)isAlignedList.get(finalDeviceIndex)), (Object)new MeasurementGroup());
                }
                MeasurementGroup measurementGroup = (MeasurementGroup)v.right;
                String[] measurements = (String[])measurementsList.get(finalDeviceIndex);
                TSDataType[] tsDataTypes = (TSDataType[])tsDataTypesList.get(finalDeviceIndex);
                TSEncoding[] encodings = encodingsList == null ? null : (TSEncoding[])encodingsList.get(finalDeviceIndex);
                CompressionType[] compressionTypes = compressionTypesList == null ? null : (CompressionType[])compressionTypesList.get(finalDeviceIndex);
                Iterator iterator = finalIndexOfMeasurementsNotInTemplate.iterator();
                while (iterator.hasNext()) {
                    int measurementIndex = (Integer)iterator.next();
                    if (tsDataTypes[measurementIndex] == null) continue;
                    measurementGroup.addMeasurement(measurements[measurementIndex], tsDataTypes[measurementIndex], encodings == null ? EncodingInferenceUtils.getDefaultEncoding(tsDataTypes[measurementIndex]) : encodings[measurementIndex], compressionTypes == null ? TSFileDescriptor.getInstance().getConfig().getCompressor() : compressionTypes[measurementIndex]);
                }
                return v;
            });
        }
        if (!devicesNeedActivateTemplate.isEmpty()) {
            this.internalActivateTemplate(devicesNeedActivateTemplate);
            for (Map.Entry entry : devicesNeedActivateTemplate.entrySet()) {
                devicePath = (PartialPath)entry.getKey();
                template = (Template)((Pair)entry.getValue()).left;
                for (Map.Entry<String, IMeasurementSchema> measurementEntry : template.getSchemaMap().entrySet()) {
                    schemaTree.appendSingleMeasurement(devicePath.concatNode(measurementEntry.getKey()), (MeasurementSchema)measurementEntry.getValue(), null, null, template.isDirectAligned());
                }
            }
        }
        if (!devicesNeedAutoCreateTimeSeries.isEmpty()) {
            this.internalCreateTimeSeries(schemaTree, devicesNeedAutoCreateTimeSeries);
        }
    }

    private List<Integer> checkMeasurementsInSchemaTemplate(PartialPath devicePath, List<Integer> indexOfTargetMeasurements, String[] measurements, boolean isAligned, Template template) {
        boolean shouldActivateTemplate = false;
        for (int index : indexOfTargetMeasurements) {
            if (!template.hasSchema(measurements[index])) continue;
            shouldActivateTemplate = true;
            break;
        }
        if (shouldActivateTemplate) {
            ArrayList<Integer> recheckedIndexOfMissingMeasurements = new ArrayList<Integer>();
            for (int index : indexOfTargetMeasurements) {
                if (template.hasSchema(measurements[index])) continue;
                recheckedIndexOfMissingMeasurements.add(index);
            }
            return recheckedIndexOfMissingMeasurements;
        }
        return indexOfTargetMeasurements;
    }

    private void internalCreateTimeSeries(ClusterSchemaTree schemaTree, PartialPath devicePath, List<String> measurements, List<TSDataType> tsDataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, boolean isAligned) {
        List<MeasurementPath> measurementPathList = this.executeInternalCreateTimeseriesStatement(new InternalCreateTimeSeriesStatement(devicePath, measurements, tsDataTypes, encodings, compressors, isAligned));
        Set alreadyExistingMeasurementIndexSet = measurementPathList.stream().map(o -> measurements.indexOf(o.getMeasurement())).collect(Collectors.toSet());
        schemaTree.appendMeasurementPaths(measurementPathList);
        int size = measurements.size();
        for (int i = 0; i < size; ++i) {
            if (alreadyExistingMeasurementIndexSet.contains(i)) continue;
            schemaTree.appendSingleMeasurement(devicePath.concatNode(measurements.get(i)), new MeasurementSchema(measurements.get(i), tsDataTypes.get(i), encodings.get(i), compressors.get(i)), null, null, isAligned);
        }
    }

    private List<MeasurementPath> executeInternalCreateTimeseriesStatement(Statement statement) {
        ExecutionResult executionResult = this.statementExecutor.apply(statement);
        int statusCode = executionResult.status.getCode();
        if (statusCode == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return Collections.emptyList();
        }
        if (statusCode != TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
            throw new RuntimeException((Throwable)new IoTDBException(executionResult.status.getMessage(), statusCode));
        }
        HashSet<String> failedCreationSet = new HashSet<String>();
        ArrayList<MeasurementPath> alreadyExistingMeasurements = new ArrayList<MeasurementPath>();
        for (TSStatus subStatus : executionResult.status.subStatus) {
            if (subStatus.code == TSStatusCode.TIMESERIES_ALREADY_EXIST.getStatusCode()) {
                alreadyExistingMeasurements.add(MeasurementPath.parseDataFromString((String)subStatus.getMessage()));
                continue;
            }
            failedCreationSet.add(subStatus.message);
        }
        if (!failedCreationSet.isEmpty()) {
            throw new SemanticException(new MetadataException(String.join((CharSequence)"; ", failedCreationSet)));
        }
        return alreadyExistingMeasurements;
    }

    private void internalActivateTemplate(PartialPath devicePath) {
        ExecutionResult executionResult = this.statementExecutor.apply(new ActivateTemplateStatement(devicePath));
        TSStatus status = executionResult.status;
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode() && status.getCode() != TSStatusCode.TEMPLATE_IS_IN_USE.getStatusCode()) {
            throw new SemanticException((Throwable)new IoTDBException(status.getMessage(), status.getCode()));
        }
    }

    private void internalActivateTemplate(Map<PartialPath, Pair<Template, PartialPath>> devicesNeedActivateTemplate) {
        ExecutionResult executionResult = this.statementExecutor.apply(new InternalBatchActivateTemplateStatement(devicesNeedActivateTemplate));
        TSStatus status = executionResult.status;
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() || status.getCode() == TSStatusCode.TEMPLATE_IS_IN_USE.getStatusCode()) {
            return;
        }
        if (status.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
            HashSet<String> failedActivationSet = new HashSet<String>();
            for (TSStatus subStatus : status.subStatus) {
                if (subStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() || subStatus.getCode() == TSStatusCode.TEMPLATE_IS_IN_USE.getStatusCode()) continue;
                failedActivationSet.add(subStatus.message);
            }
            if (!failedActivationSet.isEmpty()) {
                throw new SemanticException(new MetadataException(String.join((CharSequence)"; ", failedActivationSet)));
            }
        } else {
            throw new SemanticException((Throwable)new IoTDBException(status.getMessage(), status.getCode()));
        }
    }

    private void internalCreateTimeSeries(ClusterSchemaTree schemaTree, Map<PartialPath, Pair<Boolean, MeasurementGroup>> devicesNeedAutoCreateTimeSeries) {
        List<MeasurementPath> measurementPathList = this.executeInternalCreateTimeseriesStatement(new InternalCreateMultiTimeSeriesStatement(devicesNeedAutoCreateTimeSeries));
        schemaTree.appendMeasurementPaths(measurementPathList);
        HashMap<PartialPath, Set> alreadyExistingMeasurementMap = new HashMap<PartialPath, Set>();
        for (MeasurementPath measurementPath : measurementPathList) {
            alreadyExistingMeasurementMap.computeIfAbsent(measurementPath.getDevicePath(), k -> new HashSet()).add(measurementPath.getMeasurement());
        }
        for (Map.Entry<PartialPath, Pair<Boolean, MeasurementGroup>> entry : devicesNeedAutoCreateTimeSeries.entrySet()) {
            Set measurementSet = (Set)alreadyExistingMeasurementMap.get(entry.getKey());
            MeasurementGroup measurementGroup = (MeasurementGroup)entry.getValue().right;
            int size = measurementGroup.size();
            for (int i = 0; i < size; ++i) {
                if (measurementSet != null && measurementSet.contains(measurementGroup.getMeasurements().get(i))) continue;
                schemaTree.appendSingleMeasurement(entry.getKey().concatNode(measurementGroup.getMeasurements().get(i)), new MeasurementSchema(measurementGroup.getMeasurements().get(i), measurementGroup.getDataTypes().get(i), measurementGroup.getEncodings().get(i), measurementGroup.getCompressors().get(i)), null, null, (Boolean)entry.getValue().left);
            }
        }
    }
}

