/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.source;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.mpp.common.header.DatasetHeaderFactory;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.source.SourceOperator;
import org.apache.iotdb.db.mpp.plan.Coordinator;
import org.apache.iotdb.db.mpp.plan.execution.IQueryExecution;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.utils.TimestampPrecisionUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilderStatus;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumnBuilder;
import org.apache.iotdb.tsfile.utils.Binary;

public class ShowQueriesOperator
implements SourceOperator {
    private final OperatorContext operatorContext;
    private final PlanNodeId sourceId;
    private TsBlock tsBlock;
    private boolean hasConsumed;
    private final Coordinator coordinator;

    public ShowQueriesOperator(OperatorContext operatorContext, PlanNodeId sourceId, Coordinator coordinator) {
        this.operatorContext = operatorContext;
        this.sourceId = sourceId;
        this.coordinator = coordinator;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public TsBlock next() throws Exception {
        TsBlock res = this.tsBlock;
        this.hasConsumed = true;
        this.tsBlock = null;
        return res;
    }

    @Override
    public boolean hasNext() throws Exception {
        if (this.hasConsumed) {
            return false;
        }
        if (this.tsBlock == null) {
            this.tsBlock = this.buildTsBlock();
        }
        return true;
    }

    @Override
    public boolean isFinished() throws Exception {
        return this.hasConsumed;
    }

    @Override
    public long calculateMaxPeekMemory() {
        return TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES;
    }

    @Override
    public long calculateMaxReturnSize() {
        return TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return 0L;
    }

    @Override
    public PlanNodeId getSourceId() {
        return this.sourceId;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return NOT_BLOCKED;
    }

    @Override
    public void close() throws Exception {
    }

    private TsBlock buildTsBlock() {
        List<TSDataType> outputDataTypes = DatasetHeaderFactory.getShowQueriesHeader().getRespDataTypes();
        TsBlockBuilder builder = new TsBlockBuilder(outputDataTypes);
        List<IQueryExecution> queryExecutions = this.coordinator.getAllQueryExecutions();
        if (!queryExecutions.isEmpty()) {
            TimeColumnBuilder timeColumnBuilder = builder.getTimeColumnBuilder();
            ColumnBuilder[] columnBuilders = builder.getValueColumnBuilders();
            long currTime = System.currentTimeMillis();
            String[] splits = queryExecutions.get(0).getQueryId().split("_");
            int DataNodeId = Integer.parseInt(splits[splits.length - 1]);
            for (IQueryExecution queryExecution : queryExecutions) {
                timeColumnBuilder.writeLong(TimestampPrecisionUtils.convertToCurrPrecision(queryExecution.getStartExecutionTime(), TimeUnit.MILLISECONDS));
                columnBuilders[0].writeBinary(Binary.valueOf((String)queryExecution.getQueryId()));
                columnBuilders[1].writeInt(DataNodeId);
                columnBuilders[2].writeFloat((float)(currTime - queryExecution.getStartExecutionTime()) / 1000.0f);
                columnBuilders[3].writeBinary(Binary.valueOf((String)queryExecution.getExecuteSQL().orElse("UNKNOWN")));
                builder.declarePosition();
            }
        }
        return builder.build();
    }
}

