/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.template;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public enum TemplateInternalRPCUpdateType {
    ADD_TEMPLATE_SET_INFO(0),
    INVALIDATE_TEMPLATE_SET_INFO(1);

    private final byte operationType;

    private TemplateInternalRPCUpdateType(byte operationType) {
        this.operationType = operationType;
    }

    public byte toByte() {
        return this.operationType;
    }

    public void serialize(OutputStream stream) throws IOException {
        ReadWriteIOUtils.write((byte)this.operationType, (OutputStream)stream);
    }

    public static TemplateInternalRPCUpdateType deserialize(ByteBuffer buffer) {
        byte type = ReadWriteIOUtils.readByte((ByteBuffer)buffer);
        switch (type) {
            case 0: {
                return ADD_TEMPLATE_SET_INFO;
            }
            case 1: {
                return INVALIDATE_TEMPLATE_SET_INFO;
            }
        }
        throw new IllegalArgumentException("Unknown template update operation type" + type);
    }

    public static TemplateInternalRPCUpdateType getType(byte type) {
        switch (type) {
            case 0: {
                return ADD_TEMPLATE_SET_INFO;
            }
            case 1: {
                return INVALIDATE_TEMPLATE_SET_INFO;
            }
        }
        throw new IllegalArgumentException("Unknown template update operation type" + type);
    }
}

