/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.client;

import java.lang.reflect.InvocationTargetException;
import java.net.SocketException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ThriftClient {
    public static final Logger logger = LoggerFactory.getLogger(ThriftClient.class);

    public void invalidate();

    public void invalidateAll();

    public static void resolveException(Throwable t, ThriftClient o) {
        Throwable rootCause;
        Throwable cur;
        Throwable origin = t;
        if (t instanceof InvocationTargetException) {
            origin = ((InvocationTargetException)t).getTargetException();
        }
        if ((cur = origin) instanceof TException) {
            int level = 0;
            while (cur != null) {
                logger.debug("level-{} Exception class {}, message {}", new Object[]{level, cur.getClass().getName(), cur.getMessage()});
                cur = cur.getCause();
                ++level;
            }
            o.invalidate();
        }
        if ((rootCause = ExceptionUtils.getRootCause((Throwable)origin)) != null) {
            logger.debug("root cause message {}, LocalizedMessage {}, ", new Object[]{rootCause.getMessage(), rootCause.getLocalizedMessage(), rootCause});
            if (ThriftClient.isConnectionBroken(rootCause)) {
                logger.debug("Broken pipe error happened in sending RPC, we need to clear all previous cached connection", t);
                o.invalidateAll();
            }
        }
    }

    public static boolean isConnectionBroken(Throwable cause) {
        return cause instanceof SocketException && cause.getMessage().contains("Broken pipe") || cause instanceof TTransportException && cause.getMessage().contains("Socket is closed by peer");
    }
}

