/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.wal.buffer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.db.wal.WALManager;
import org.apache.iotdb.db.wal.buffer.IWALBuffer;
import org.apache.iotdb.db.wal.io.WALWriter;
import org.apache.iotdb.db.wal.utils.WALFileStatus;
import org.apache.iotdb.db.wal.utils.WALFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWALBuffer
implements IWALBuffer {
    private static final Logger logger = LoggerFactory.getLogger(AbstractWALBuffer.class);
    protected final String identifier;
    protected final String logDirectory;
    protected long diskUsage = 0L;
    protected long fileNum = 0L;
    protected volatile long currentWALFileVersion;
    protected volatile long currentSearchIndex;
    protected volatile WALWriter currentWALFileWriter;

    protected AbstractWALBuffer(String identifier, String logDirectory, long startFileVersion, long startSearchIndex) throws FileNotFoundException {
        this.identifier = identifier;
        this.logDirectory = logDirectory;
        File logDirFile = SystemFileFactory.INSTANCE.getFile(logDirectory);
        if (!logDirFile.exists() && logDirFile.mkdirs()) {
            logger.info("Create folder {} for wal node-{}'s buffer.", (Object)logDirectory, (Object)identifier);
        }
        File[] walFiles = WALFileUtils.listAllWALFiles(logDirFile);
        this.addDiskUsage(Arrays.stream(walFiles).mapToLong(File::length).sum());
        this.addFileNum(walFiles.length);
        this.currentSearchIndex = startSearchIndex;
        this.currentWALFileWriter = new WALWriter(SystemFileFactory.INSTANCE.getFile(logDirectory, WALFileUtils.getLogFileName(startFileVersion, this.currentSearchIndex, WALFileStatus.CONTAINS_SEARCH_INDEX)));
        this.currentWALFileVersion = startFileVersion;
    }

    @Override
    public long getCurrentWALFileVersion() {
        return this.currentWALFileVersion;
    }

    @Override
    public long getCurrentWALFileSize() {
        return this.currentWALFileWriter.size();
    }

    protected void rollLogWriter(long searchIndex, WALFileStatus fileStatus) throws IOException {
        String targetName;
        File currentFile = this.currentWALFileWriter.getLogFile();
        String currentName = currentFile.getName();
        this.currentWALFileWriter.close();
        this.addDiskUsage(this.currentWALFileWriter.size());
        this.addFileNum(1L);
        if (WALFileUtils.parseStatusCode(currentName) != fileStatus && !currentFile.renameTo(SystemFileFactory.INSTANCE.getFile(this.logDirectory, targetName = WALFileUtils.getLogFileName(WALFileUtils.parseVersionId(currentName), WALFileUtils.parseStartSearchIndex(currentName), fileStatus)))) {
            logger.error("Fail to rename file {} to {}", (Object)currentName, (Object)targetName);
        }
        long nextFileVersion = this.currentWALFileVersion + 1L;
        File nextLogFile = SystemFileFactory.INSTANCE.getFile(this.logDirectory, WALFileUtils.getLogFileName(nextFileVersion, searchIndex, WALFileStatus.CONTAINS_SEARCH_INDEX));
        this.currentWALFileWriter = new WALWriter(nextLogFile);
        this.currentWALFileVersion = nextFileVersion;
        logger.debug("Open new wal file {} for wal node-{}'s buffer.", (Object)nextLogFile, (Object)this.identifier);
    }

    public long getDiskUsage() {
        return this.diskUsage;
    }

    public void addDiskUsage(long size) {
        this.diskUsage += size;
        WALManager.getInstance().addTotalDiskUsage(size);
    }

    public void subtractDiskUsage(long size) {
        this.diskUsage -= size;
        WALManager.getInstance().subtractTotalDiskUsage(size);
    }

    public long getFileNum() {
        return this.fileNum;
    }

    public void addFileNum(long num) {
        this.fileNum += num;
        WALManager.getInstance().addTotalFileNum(num);
    }

    public void subtractFileNum(long num) {
        this.fileNum -= num;
        WALManager.getInstance().subtractTotalFileNum(num);
    }

    @Override
    public long getCurrentSearchIndex() {
        return this.currentSearchIndex;
    }
}

