/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.statement.component;

import org.apache.iotdb.db.mpp.plan.statement.StatementNode;

public class GroupByTimeComponent
extends StatementNode {
    private long startTime;
    private long endTime;
    private long interval;
    private long slidingStep;
    private boolean isIntervalByMonth = false;
    private boolean isSlidingStepByMonth = false;
    private boolean leftCRightO = true;

    public boolean isLeftCRightO() {
        return this.leftCRightO;
    }

    public void setLeftCRightO(boolean leftCRightO) {
        this.leftCRightO = leftCRightO;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public long getSlidingStep() {
        return this.slidingStep;
    }

    public void setSlidingStep(long slidingStep) {
        this.slidingStep = slidingStep;
    }

    public boolean isSlidingStepByMonth() {
        return this.isSlidingStepByMonth;
    }

    public void setSlidingStepByMonth(boolean isSlidingStepByMonth) {
        this.isSlidingStepByMonth = isSlidingStepByMonth;
    }

    public boolean isIntervalByMonth() {
        return this.isIntervalByMonth;
    }

    public void setIntervalByMonth(boolean isIntervalByMonth) {
        this.isIntervalByMonth = isIntervalByMonth;
    }

    public String toSQLString() {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("GROUP BY TIME").append(' ');
        sqlBuilder.append('(');
        if (this.startTime != 0L || this.endTime != 0L) {
            if (this.isLeftCRightO()) {
                sqlBuilder.append('[').append(this.startTime).append(',').append(' ').append(this.endTime).append(')');
            } else {
                sqlBuilder.append('(').append(this.startTime).append(',').append(' ').append(this.endTime).append(']');
            }
            sqlBuilder.append(',').append(' ');
        }
        String intervalStr = this.interval + (this.isIntervalByMonth ? "mo" : "ms");
        String slidingStepStr = this.slidingStep + (this.isSlidingStepByMonth ? "mo" : "ms");
        sqlBuilder.append(intervalStr);
        if (!slidingStepStr.equals(intervalStr)) {
            sqlBuilder.append(',').append(' ');
            sqlBuilder.append(slidingStepStr);
        }
        sqlBuilder.append(')');
        return sqlBuilder.toString();
    }
}

