/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.process;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.SingleChildProcessNode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class ProjectNode
extends SingleChildProcessNode {
    private final List<String> outputColumnNames;

    public ProjectNode(PlanNodeId id, List<String> outputColumnNames) {
        super(id);
        this.outputColumnNames = outputColumnNames;
    }

    public ProjectNode(PlanNodeId id, PlanNode child, List<String> outputColumnNames) {
        super(id, child);
        this.outputColumnNames = outputColumnNames;
    }

    @Override
    public PlanNode clone() {
        return new ProjectNode(this.getPlanNodeId(), this.getOutputColumnNames());
    }

    @Override
    public List<String> getOutputColumnNames() {
        return this.outputColumnNames;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitProject(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.PROJECT.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.outputColumnNames.size(), (ByteBuffer)byteBuffer);
        for (String outputColumnName : this.outputColumnNames) {
            ReadWriteIOUtils.write((String)outputColumnName, (ByteBuffer)byteBuffer);
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.PROJECT.serialize(stream);
        ReadWriteIOUtils.write((int)this.outputColumnNames.size(), (OutputStream)stream);
        for (String outputColumnName : this.outputColumnNames) {
            ReadWriteIOUtils.write((String)outputColumnName, (OutputStream)stream);
        }
    }

    public static ProjectNode deserialize(ByteBuffer byteBuffer) {
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        for (int outputColumnNamesSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer); outputColumnNamesSize > 0; --outputColumnNamesSize) {
            outputColumnNames.add(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
        }
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new ProjectNode(planNodeId, outputColumnNames);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProjectNode that = (ProjectNode)o;
        return this.outputColumnNames.equals(that.outputColumnNames);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.outputColumnNames);
    }
}

