/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.process;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.ProcessOperator;
import org.apache.iotdb.db.utils.datastructure.MergeSortKey;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumnBuilder;

public class SortOperator
implements ProcessOperator {
    private final OperatorContext operatorContext;
    private final Operator inputOperator;
    private final TsBlockBuilder tsBlockBuilder;
    private List<MergeSortKey> cachedData;
    private final Comparator<MergeSortKey> comparator;

    public SortOperator(OperatorContext operatorContext, Operator inputOperator, List<TSDataType> dataTypes, Comparator<MergeSortKey> comparator) {
        this.operatorContext = operatorContext;
        this.inputOperator = inputOperator;
        this.tsBlockBuilder = new TsBlockBuilder(dataTypes);
        this.cachedData = new ArrayList<MergeSortKey>();
        this.comparator = comparator;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.inputOperator.isBlocked();
    }

    @Override
    public TsBlock next() throws Exception {
        TsBlock tsBlock = this.inputOperator.nextWithTimer();
        if (tsBlock == null) {
            return null;
        }
        for (int i = 0; i < tsBlock.getPositionCount(); ++i) {
            this.cachedData.add(new MergeSortKey(tsBlock, i));
        }
        if (this.inputOperator.hasNextWithTimer()) {
            return null;
        }
        if (this.cachedData.size() > 1) {
            this.cachedData.sort(this.comparator);
        }
        TsBlock result = this.buildTsBlock();
        this.cachedData = null;
        return result;
    }

    private TsBlock buildTsBlock() {
        TimeColumnBuilder timeColumnBuilder = this.tsBlockBuilder.getTimeColumnBuilder();
        ColumnBuilder[] valueColumnBuilders = this.tsBlockBuilder.getValueColumnBuilders();
        this.cachedData.forEach(mergeSortKey -> {
            TsBlock tsBlock = mergeSortKey.tsBlock;
            int row = mergeSortKey.rowIndex;
            timeColumnBuilder.writeLong(tsBlock.getTimeByIndex(row));
            for (int i = 0; i < valueColumnBuilders.length; ++i) {
                valueColumnBuilders[i].write(tsBlock.getColumn(i), row);
            }
            this.tsBlockBuilder.declarePosition();
        });
        return this.tsBlockBuilder.build();
    }

    @Override
    public boolean hasNext() throws Exception {
        return this.inputOperator.hasNextWithTimer();
    }

    @Override
    public void close() throws Exception {
        this.inputOperator.close();
    }

    @Override
    public boolean isFinished() throws Exception {
        return this.cachedData == null;
    }

    @Override
    public long calculateMaxPeekMemory() {
        return this.inputOperator.calculateMaxPeekMemory() + this.inputOperator.calculateRetainedSizeAfterCallingNext();
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.inputOperator.calculateMaxReturnSize();
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.inputOperator.calculateRetainedSizeAfterCallingNext();
    }
}

