/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.process;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.ProcessOperator;
import org.apache.iotdb.db.mpp.execution.operator.process.join.merge.TimeComparator;
import org.apache.iotdb.db.utils.datastructure.TimeSelector;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumnBuilder;

@Deprecated
public class DeviceMergeOperator
implements ProcessOperator {
    private final OperatorContext operatorContext;
    private final List<String> devices;
    private final List<Operator> deviceOperators;
    private final List<TSDataType> dataTypes;
    private final TsBlockBuilder tsBlockBuilder;
    private final int inputOperatorsCount;
    private final TsBlock[] inputTsBlocks;
    private final String[] deviceOfInputTsBlocks;
    private final boolean[] noMoreTsBlocks;
    private int curDeviceIndex;
    private LinkedList<Integer> curDeviceTsBlockIndexList = new LinkedList();
    private boolean finished;
    private final TimeSelector timeSelector;
    private final TimeComparator comparator;

    public DeviceMergeOperator(OperatorContext operatorContext, List<String> devices, List<Operator> deviceOperators, List<TSDataType> dataTypes, TimeSelector selector, TimeComparator comparator) {
        this.operatorContext = operatorContext;
        this.devices = devices;
        this.deviceOperators = deviceOperators;
        this.inputOperatorsCount = deviceOperators.size();
        this.inputTsBlocks = new TsBlock[this.inputOperatorsCount];
        this.deviceOfInputTsBlocks = new String[this.inputOperatorsCount];
        this.noMoreTsBlocks = new boolean[this.inputOperatorsCount];
        this.dataTypes = dataTypes;
        this.tsBlockBuilder = new TsBlockBuilder(dataTypes);
        this.timeSelector = selector;
        this.comparator = comparator;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        ArrayList listenableFutures = new ArrayList();
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            ListenableFuture<?> blocked;
            if (this.noMoreTsBlocks[i] || !this.isTsBlockEmpty(i) || (blocked = this.deviceOperators.get(i).isBlocked()).isDone()) continue;
            listenableFutures.add(blocked);
        }
        return listenableFutures.isEmpty() ? NOT_BLOCKED : Futures.successfulAsList(listenableFutures);
    }

    @Override
    public TsBlock next() throws Exception {
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            if (this.noMoreTsBlocks[i] || !this.isTsBlockEmpty(i) || !this.deviceOperators.get(i).hasNextWithTimer()) continue;
            this.inputTsBlocks[i] = this.deviceOperators.get(i).nextWithTimer();
            if (this.inputTsBlocks[i] == null || this.inputTsBlocks[i].isEmpty()) {
                return null;
            }
            this.deviceOfInputTsBlocks[i] = this.getDeviceNameFromTsBlock(this.inputTsBlocks[i]);
            this.tryToAddCurDeviceTsBlockList(i);
        }
        while (this.curDeviceTsBlockIndexList.isEmpty() && this.curDeviceIndex + 1 < this.devices.size()) {
            this.getNextDeviceTsBlocks();
        }
        if (this.curDeviceTsBlockIndexList.size() == 1) {
            TsBlock resultTsBlock = this.inputTsBlocks[this.curDeviceTsBlockIndexList.get(0)];
            this.inputTsBlocks[this.curDeviceTsBlockIndexList.get((int)0).intValue()] = null;
            this.curDeviceTsBlockIndexList.clear();
            return resultTsBlock;
        }
        this.tsBlockBuilder.reset();
        int tsBlockSizeOfCurDevice = this.curDeviceTsBlockIndexList.size();
        TsBlock[] deviceTsBlocks = new TsBlock[tsBlockSizeOfCurDevice];
        TsBlock.TsBlockSingleColumnIterator[] tsBlockIterators = new TsBlock.TsBlockSingleColumnIterator[tsBlockSizeOfCurDevice];
        for (int i = 0; i < tsBlockSizeOfCurDevice; ++i) {
            deviceTsBlocks[i] = this.inputTsBlocks[this.curDeviceTsBlockIndexList.get(i)];
            tsBlockIterators[i] = deviceTsBlocks[i].getTsBlockSingleColumnIterator();
        }
        long currentEndTime = deviceTsBlocks[0].getEndTime();
        for (int i = 1; i < tsBlockSizeOfCurDevice; ++i) {
            currentEndTime = this.comparator.getCurrentEndTime(currentEndTime, deviceTsBlocks[i].getEndTime());
        }
        TimeColumnBuilder timeBuilder = this.tsBlockBuilder.getTimeColumnBuilder();
        ColumnBuilder[] valueColumnBuilders = this.tsBlockBuilder.getValueColumnBuilders();
        while (!this.timeSelector.isEmpty() && this.comparator.satisfyCurEndTime(this.timeSelector.first(), currentEndTime)) {
            long timestamp = this.timeSelector.pollFirst();
            timeBuilder.writeLong(timestamp);
            for (int i = 0; i < tsBlockSizeOfCurDevice; ++i) {
                if (!tsBlockIterators[i].hasNext() || tsBlockIterators[i].currentTime() != timestamp) continue;
                int rowIndex = tsBlockIterators[i].getRowIndex();
                for (int j = 0; j < valueColumnBuilders.length; ++j) {
                    if (deviceTsBlocks[i].getColumn(j).isNull(rowIndex)) {
                        valueColumnBuilders[j].appendNull();
                        continue;
                    }
                    valueColumnBuilders[j].write(deviceTsBlocks[i].getColumn(j), rowIndex);
                }
                tsBlockIterators[i].next();
                break;
            }
            this.tsBlockBuilder.declarePosition();
        }
        int consumedTsBlockIndex = 0;
        for (int i = 0; i < tsBlockSizeOfCurDevice; ++i) {
            if (tsBlockIterators[i].hasNext()) {
                int rowIndex = tsBlockIterators[i].getRowIndex();
                this.inputTsBlocks[this.curDeviceTsBlockIndexList.get((int)i).intValue()] = this.inputTsBlocks[this.curDeviceTsBlockIndexList.get(i)].subTsBlock(rowIndex);
                continue;
            }
            this.inputTsBlocks[this.curDeviceTsBlockIndexList.get((int)i).intValue()] = null;
            consumedTsBlockIndex = i;
        }
        this.curDeviceTsBlockIndexList.remove(consumedTsBlockIndex);
        return this.tsBlockBuilder.build();
    }

    @Override
    public boolean hasNext() throws Exception {
        if (this.finished) {
            return false;
        }
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            if (!this.isTsBlockEmpty(i)) {
                return true;
            }
            if (this.noMoreTsBlocks[i]) continue;
            if (this.deviceOperators.get(i).hasNextWithTimer()) {
                return true;
            }
            this.noMoreTsBlocks[i] = true;
            this.inputTsBlocks[i] = null;
        }
        return false;
    }

    @Override
    public void close() throws Exception {
        for (Operator deviceOperator : this.deviceOperators) {
            deviceOperator.close();
        }
    }

    @Override
    public boolean isFinished() throws Exception {
        if (this.finished) {
            return true;
        }
        this.finished = true;
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            if (this.noMoreTsBlocks[i] && this.isTsBlockEmpty(i)) continue;
            this.finished = false;
            break;
        }
        return this.finished;
    }

    private String getDeviceNameFromTsBlock(TsBlock tsBlock) {
        if (tsBlock == null || tsBlock.getPositionCount() == 0 || tsBlock.getColumn(0).isNull(0)) {
            return null;
        }
        return tsBlock.getColumn(0).getBinary(0).toString();
    }

    private String getCurDeviceName() {
        return this.devices.get(this.curDeviceIndex);
    }

    private void getNextDeviceTsBlocks() {
        ++this.curDeviceIndex;
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            this.tryToAddCurDeviceTsBlockList(i);
        }
    }

    private void tryToAddCurDeviceTsBlockList(int tsBlockIndex) {
        if (this.deviceOfInputTsBlocks[tsBlockIndex] != null && this.deviceOfInputTsBlocks[tsBlockIndex].equals(this.getCurDeviceName())) {
            this.curDeviceTsBlockIndexList.add(tsBlockIndex);
            int rowSize = this.inputTsBlocks[tsBlockIndex].getPositionCount();
            for (int row = 0; row < rowSize; ++row) {
                this.timeSelector.add(this.inputTsBlocks[tsBlockIndex].getTimeByIndex(row));
            }
        }
    }

    private boolean isTsBlockEmpty(int tsBlockIndex) {
        return this.inputTsBlocks[tsBlockIndex] == null || this.inputTsBlocks[tsBlockIndex].getPositionCount() == 0;
    }

    @Override
    public long calculateMaxPeekMemory() {
        long maxPeekMemory = TSFileDescriptor.getInstance().getConfig().getPageSizeInByte();
        for (Operator operator : this.deviceOperators) {
            maxPeekMemory += operator.calculateMaxReturnSize();
            maxPeekMemory += operator.calculateRetainedSizeAfterCallingNext();
        }
        for (Operator operator : this.deviceOperators) {
            maxPeekMemory = Math.max(maxPeekMemory, operator.calculateMaxPeekMemory());
        }
        return Math.max(maxPeekMemory, this.calculateMaxReturnSize());
    }

    @Override
    public long calculateMaxReturnSize() {
        return (1L + (long)this.dataTypes.size()) * (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte();
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        long currentRetainedSize = 0L;
        long minChildReturnSize = Long.MAX_VALUE;
        for (Operator child : this.deviceOperators) {
            long maxReturnSize = child.calculateMaxReturnSize();
            currentRetainedSize += maxReturnSize + child.calculateRetainedSizeAfterCallingNext();
            minChildReturnSize = Math.min(minChildReturnSize, maxReturnSize);
        }
        return currentRetainedSize - minChildReturnSize;
    }
}

