/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.store.disk.schemafile;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Iterator;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.db.exception.metadata.schemafile.SchemaFileNotExists;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IStorageGroupMNode;
import org.apache.iotdb.db.metadata.mnode.StorageGroupEntityMNode;
import org.apache.iotdb.db.metadata.mnode.StorageGroupMNode;
import org.apache.iotdb.db.metadata.mtree.store.disk.ICachedMNodeContainer;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.ISchemaFile;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.ISchemaPage;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.SchemaFileConfig;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.pagemgr.BTreePageManager;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.pagemgr.IPageManager;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.pagemgr.PageManager;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaFile
implements ISchemaFile {
    private static final Logger logger = LoggerFactory.getLogger(SchemaFile.class);
    private final String filePath;
    private final String logPath;
    private String storageGroupName;
    private long dataTTL;
    private boolean isEntity;
    private int sgNodeTemplateIdWithState;
    private ByteBuffer headerContent;
    private int lastPageIndex;
    private long lastSGAddr;
    private IPageManager pageManager;
    private File pmtFile;
    private FileChannel channel;

    private SchemaFile(String sgName, int schemaRegionId, boolean override, long ttl, boolean isEntity) throws IOException, MetadataException {
        String dirPath = SchemaFile.getDirPath(sgName, schemaRegionId);
        this.storageGroupName = sgName;
        this.filePath = dirPath + File.separator + "schema_file.pst";
        this.logPath = dirPath + File.separator + "schema_file_log.bin";
        this.pmtFile = SystemFileFactory.INSTANCE.getFile(this.filePath);
        if (!this.pmtFile.exists() && !override) {
            throw new SchemaFileNotExists(this.filePath);
        }
        if (this.pmtFile.exists() && override) {
            logger.warn("Schema File [{}] will be overwritten since already exists.", (Object)this.filePath);
            Files.delete(Paths.get(this.pmtFile.toURI()));
            this.pmtFile.createNewFile();
        }
        if (!this.pmtFile.exists() || !this.pmtFile.isFile()) {
            File dir = SystemFileFactory.INSTANCE.getFile(dirPath);
            dir.mkdirs();
            this.pmtFile.createNewFile();
        }
        this.channel = new RandomAccessFile(this.pmtFile, "rw").getChannel();
        this.headerContent = ByteBuffer.allocate(SchemaFileConfig.FILE_HEADER_SIZE);
        this.dataTTL = ttl;
        this.isEntity = isEntity;
        this.sgNodeTemplateIdWithState = -1;
        this.initFileHeader();
    }

    private SchemaFile(File file) throws IOException, MetadataException {
        this.pmtFile = file;
        this.filePath = this.pmtFile.getPath();
        this.logPath = file.getParent() + File.separator + "schema_file_log.bin";
        this.channel = new RandomAccessFile(file, "rw").getChannel();
        this.headerContent = ByteBuffer.allocate(SchemaFileConfig.FILE_HEADER_SIZE);
        if (this.channel.size() <= 0L) {
            this.channel.close();
            throw new SchemaFileNotExists(file.getAbsolutePath());
        }
        this.initFileHeader();
    }

    public static ISchemaFile initSchemaFile(String sgName, int schemaRegionId) throws IOException, MetadataException {
        File pmtFile = SystemFileFactory.INSTANCE.getFile(SchemaFile.getDirPath(sgName, schemaRegionId) + File.separator + "schema_file.pst");
        return new SchemaFile(sgName, schemaRegionId, !pmtFile.exists(), CommonDescriptor.getInstance().getConfig().getDefaultTTLInMs(), false);
    }

    public static ISchemaFile loadSchemaFile(String sgName, int schemaRegionId) throws IOException, MetadataException {
        return new SchemaFile(sgName, schemaRegionId, false, -1L, false);
    }

    public static ISchemaFile loadSchemaFile(File file) throws IOException, MetadataException {
        return new SchemaFile(file);
    }

    private static String getDirPath(String sgName, int schemaRegionId) {
        return SchemaFileConfig.SCHEMA_FOLDER + File.separator + sgName + File.separator + schemaRegionId;
    }

    @Override
    public IMNode init() throws MetadataException {
        String[] stringArray;
        if (this.storageGroupName == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "noName";
        } else {
            stringArray = PathUtils.splitPathToDetachedNodes((String)this.storageGroupName);
        }
        String[] sgPathNodes = stringArray;
        IMNode resNode = this.isEntity ? SchemaFile.setNodeAddress(new StorageGroupEntityMNode(null, sgPathNodes[sgPathNodes.length - 1], this.dataTTL), 0L) : SchemaFile.setNodeAddress(new StorageGroupMNode(null, sgPathNodes[sgPathNodes.length - 1], this.dataTTL), 0L);
        resNode.setFullPath(this.storageGroupName);
        resNode.setSchemaTemplateId(this.sgNodeTemplateIdWithState);
        resNode.setUseTemplate(this.sgNodeTemplateIdWithState > -1);
        return resNode;
    }

    @Override
    public boolean updateStorageGroupNode(IStorageGroupMNode sgNode) throws IOException {
        this.dataTTL = sgNode.getDataTTL();
        this.isEntity = sgNode.isEntity();
        this.sgNodeTemplateIdWithState = sgNode.getSchemaTemplateIdWithState();
        this.updateHeaderBuffer();
        return true;
    }

    @Override
    public void delete(IMNode node) throws IOException, MetadataException {
        if (node.isStorageGroup()) {
            this.clear();
        } else {
            this.pageManager.delete(node);
        }
    }

    @Override
    public void writeMNode(IMNode node) throws MetadataException, IOException {
        long curSegAddr = SchemaFile.getNodeAddress(node);
        if (node.isStorageGroup()) {
            this.isEntity = node.isEntity();
            SchemaFile.setNodeAddress(node, this.lastSGAddr);
        } else if (curSegAddr < 0L) {
            throw new MetadataException(String.format("Cannot store a node with segment address [%s] except for StorageGroupNode.", curSegAddr));
        }
        this.pageManager.writeNewChildren(node);
        this.pageManager.writeUpdatedChildren(node);
        this.pageManager.flushDirtyPages();
        this.updateHeaderBuffer();
    }

    @Override
    public IMNode getChildNode(IMNode parent, String childName) throws MetadataException, IOException {
        return this.pageManager.getChildNode(parent, childName);
    }

    @Override
    public Iterator<IMNode> getChildren(IMNode parent) throws MetadataException, IOException {
        if (parent.isMeasurement() || SchemaFile.getNodeAddress(parent) < 0L) {
            throw new MetadataException(String.format("Node [%s] has no child in schema file.", parent.getFullPath()));
        }
        return this.pageManager.getChildren(parent);
    }

    @Override
    public void close() throws IOException {
        this.updateHeaderBuffer();
        this.pageManager.flushDirtyPages();
        this.pageManager.close();
        this.forceChannel();
        this.channel.close();
    }

    @Override
    public void sync() throws IOException {
        this.updateHeaderBuffer();
        this.pageManager.flushDirtyPages();
        this.forceChannel();
    }

    @Override
    public void clear() throws IOException, MetadataException {
        this.pageManager.clear();
        this.pageManager.close();
        this.channel.close();
        if (this.pmtFile.exists()) {
            Files.delete(Paths.get(this.pmtFile.toURI()));
        }
        this.pmtFile.createNewFile();
        this.channel = new RandomAccessFile(this.pmtFile, "rw").getChannel();
        this.headerContent = ByteBuffer.allocate(SchemaFileConfig.FILE_HEADER_SIZE);
        this.initFileHeader();
    }

    public String inspect() throws MetadataException, IOException {
        return this.inspect(null);
    }

    public String inspect(PrintWriter pw) throws MetadataException, IOException {
        String header = String.format("=============================\n== Schema File Sketch Tool ==\n=============================\n== Notice: \n==  Internal/Entity presents as (name, is_aligned, child_segment_address)\n==  Measurement presents as (name, data_type, encoding, compressor, alias_if_exist)\n=============================\nBelong to StorageGroup: [%s], segment of SG:%s, total pages:%d\n", this.storageGroupName == null ? "NOT SPECIFIED" : this.storageGroupName, Long.toHexString(this.lastSGAddr), this.lastPageIndex + 1);
        if (pw == null) {
            pw = new PrintWriter(System.out);
        }
        pw.print(header);
        this.pageManager.inspect(pw);
        return String.format("SchemaFile[%s] had been inspected.", this.filePath);
    }

    private void initFileHeader() throws IOException, MetadataException {
        if (this.channel.size() == 0L) {
            this.lastPageIndex = 0;
            ReadWriteIOUtils.write((int)this.lastPageIndex, (ByteBuffer)this.headerContent);
            ReadWriteIOUtils.write((long)this.dataTTL, (ByteBuffer)this.headerContent);
            ReadWriteIOUtils.write((Boolean)this.isEntity, (ByteBuffer)this.headerContent);
            ReadWriteIOUtils.write((int)this.sgNodeTemplateIdWithState, (ByteBuffer)this.headerContent);
            ReadWriteIOUtils.write((int)1, (ByteBuffer)this.headerContent);
            this.lastSGAddr = 0L;
            this.pageManager = new BTreePageManager(this.channel, this.pmtFile, -1, this.logPath);
        } else {
            this.channel.read(this.headerContent);
            this.headerContent.clear();
            this.lastPageIndex = ReadWriteIOUtils.readInt((ByteBuffer)this.headerContent);
            this.dataTTL = ReadWriteIOUtils.readLong((ByteBuffer)this.headerContent);
            this.isEntity = ReadWriteIOUtils.readBool((ByteBuffer)this.headerContent);
            this.sgNodeTemplateIdWithState = ReadWriteIOUtils.readInt((ByteBuffer)this.headerContent);
            this.lastSGAddr = ReadWriteIOUtils.readLong((ByteBuffer)this.headerContent);
            if (ReadWriteIOUtils.readInt((ByteBuffer)this.headerContent) != 1) {
                this.channel.close();
                throw new MetadataException("SchemaFile with wrong version, please check or upgrade.");
            }
            this.pageManager = new BTreePageManager(this.channel, this.pmtFile, this.lastPageIndex, this.logPath);
        }
    }

    private void updateHeaderBuffer() throws IOException {
        this.headerContent.clear();
        ReadWriteIOUtils.write((int)this.pageManager.getLastPageIndex(), (ByteBuffer)this.headerContent);
        ReadWriteIOUtils.write((long)this.dataTTL, (ByteBuffer)this.headerContent);
        ReadWriteIOUtils.write((Boolean)this.isEntity, (ByteBuffer)this.headerContent);
        ReadWriteIOUtils.write((int)this.sgNodeTemplateIdWithState, (ByteBuffer)this.headerContent);
        ReadWriteIOUtils.write((long)this.lastSGAddr, (ByteBuffer)this.headerContent);
        ReadWriteIOUtils.write((int)1, (ByteBuffer)this.headerContent);
        this.headerContent.flip();
        this.channel.write(this.headerContent, 0L);
    }

    private void forceChannel() throws IOException {
        this.channel.force(true);
    }

    public static long getGlobalIndex(int pageIndex, short segIndex) {
        return (0xFFFFFFFFL & (long)pageIndex) << 16 | (long)segIndex & 0xFFFFL;
    }

    public static int getPageIndex(long globalIndex) {
        return (int)((globalIndex & 0xFFFFFFFF0000L) >> 16);
    }

    public static short getSegIndex(long globalIndex) {
        return (short)(globalIndex & 0xFFFFL);
    }

    static short reEstimateSegSize(int oldSize) {
        for (short size : SchemaFileConfig.SEG_SIZE_LST) {
            if (oldSize >= size) continue;
            return size;
        }
        return 16350;
    }

    public static long getPageAddress(int pageIndex) {
        return (0xFFFFFFFFL & (long)pageIndex) * 16384L + (long)SchemaFileConfig.FILE_HEADER_SIZE;
    }

    public static long getNodeAddress(IMNode node) {
        return ICachedMNodeContainer.getCachedMNodeContainer(node).getSegmentAddress();
    }

    public static IMNode setNodeAddress(IMNode node, long addr) {
        ICachedMNodeContainer.getCachedMNodeContainer(node).setSegmentAddress(addr);
        return node;
    }

    public ISchemaPage getPageOnTest(int index) throws IOException, MetadataException {
        return ((PageManager)this.pageManager).getPageInstanceOnTest(index);
    }

    public long getTargetSegmentOnTest(long srcSegAddr, String key) throws IOException, MetadataException {
        return ((PageManager)this.pageManager).getTargetSegmentAddressOnTest(srcSegAddr, key);
    }

    @Override
    public boolean createSnapshot(File snapshotDir) {
        File schemaFileSnapshot = SystemFileFactory.INSTANCE.getFile(snapshotDir, "schema_file.pst.snapshot");
        try {
            this.sync();
            if (schemaFileSnapshot.exists() && !schemaFileSnapshot.delete()) {
                logger.error("Failed to delete old snapshot {} while creating schema file snapshot.", (Object)schemaFileSnapshot.getName());
                return false;
            }
            Files.copy(Paths.get(this.filePath, new String[0]), schemaFileSnapshot.toPath(), new CopyOption[0]);
            return true;
        }
        catch (IOException e) {
            logger.error("Failed to create SchemaFile snapshot due to {}", (Object)e.getMessage(), (Object)e);
            schemaFileSnapshot.delete();
            return false;
        }
    }

    public static ISchemaFile loadSnapshot(File snapshotDir, String sgName, int schemaRegionId) throws IOException, MetadataException {
        File snapshot = SystemFileFactory.INSTANCE.getFile(snapshotDir, "schema_file.pst.snapshot");
        if (!snapshot.exists()) {
            throw new SchemaFileNotExists(snapshot.getPath());
        }
        File schemaFile = SystemFileFactory.INSTANCE.getFile(SchemaFile.getDirPath(sgName, schemaRegionId), "schema_file.pst");
        File schemaLogFile = SystemFileFactory.INSTANCE.getFile(SchemaFile.getDirPath(sgName, schemaRegionId), "schema_file_log.bin");
        Files.deleteIfExists(schemaFile.toPath());
        Files.deleteIfExists(schemaLogFile.toPath());
        Files.copy(snapshot.toPath(), schemaFile.toPath(), new CopyOption[0]);
        return new SchemaFile(sgName, schemaRegionId, false, CommonDescriptor.getInstance().getConfig().getDefaultTTLInMs(), false);
    }
}

