/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.selector;

import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.engine.compaction.execute.performer.constant.CrossCompactionPerformer;
import org.apache.iotdb.db.engine.compaction.selector.estimator.AbstractCompactionEstimator;
import org.apache.iotdb.db.engine.compaction.selector.estimator.ReadPointCrossCompactionEstimator;
import org.apache.iotdb.db.engine.compaction.selector.utils.CrossCompactionTaskResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;

public interface ICompactionSelector {
    default public List<List<TsFileResource>> selectInnerSpaceTask(List<TsFileResource> resources) {
        throw new RuntimeException("This kind of selector cannot be used to select inner space task");
    }

    default public List<CrossCompactionTaskResource> selectCrossSpaceTask(List<TsFileResource> seqFiles, List<TsFileResource> unseqFiles) {
        throw new RuntimeException("This kind of selector cannot be used to select cross space task");
    }

    default public List<Long> getCompactionMemoryCost() {
        return Collections.emptyList();
    }

    public static AbstractCompactionEstimator getCompactionEstimator(CrossCompactionPerformer compactionPerformer, boolean isInnerSpace) {
        switch (compactionPerformer) {
            case READ_POINT: 
            case FAST: {
                if (isInnerSpace) break;
                return new ReadPointCrossCompactionEstimator();
            }
        }
        throw new RuntimeException("Corresponding memory estimator for " + (Object)((Object)compactionPerformer) + " performer of " + (isInnerSpace ? "inner" : "cross") + " space compaction is not existed.");
    }
}

