/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.execute.utils;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.db.engine.TsFileMetricManager;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.timeindex.DeviceTimeIndex;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)"COMPACTION");

    public static void moveTargetFile(List<TsFileResource> targetResources, boolean isInnerSpace, String fullStorageGroupName) throws IOException, WriteProcessException {
        String fileSuffix = isInnerSpace ? ".inner" : ".cross";
        for (TsFileResource targetResource : targetResources) {
            if (targetResource == null) continue;
            CompactionUtils.moveOneTargetFile(targetResource, fileSuffix, fullStorageGroupName);
        }
    }

    private static void moveOneTargetFile(TsFileResource targetResource, String tmpFileSuffix, String fullStorageGroupName) throws IOException {
        if (!targetResource.getTsFile().exists()) {
            logger.info("{} [Compaction] Tmp target tsfile {} may be deleted after compaction.", (Object)fullStorageGroupName, (Object)targetResource.getTsFilePath());
            return;
        }
        File newFile = new File(targetResource.getTsFilePath().replace(tmpFileSuffix, ".tsfile"));
        if (!newFile.exists()) {
            FSFactoryProducer.getFSFactory().moveFile(targetResource.getTsFile(), newFile);
        }
        targetResource.setFile(newFile);
        targetResource.serialize();
        targetResource.closeWithoutSettingStatus();
    }

    public static void combineModsInCrossCompaction(List<TsFileResource> seqResources, List<TsFileResource> unseqResources, List<TsFileResource> targetResources) throws IOException {
        HashSet<Modification> modifications = new HashSet<Modification>();
        for (TsFileResource unseqFile : unseqResources) {
            modifications.addAll(ModificationFile.getCompactionMods(unseqFile).getModifications());
        }
        for (int i = 0; i < targetResources.size(); ++i) {
            TsFileResource targetResource = targetResources.get(i);
            if (targetResource == null) continue;
            HashSet<Modification> seqModifications = new HashSet<Modification>(ModificationFile.getCompactionMods(seqResources.get(i)).getModifications());
            modifications.addAll(seqModifications);
            CompactionUtils.updateOneTargetMods(targetResource, modifications);
            if (modifications.size() > 0) {
                TsFileMetricManager.getInstance().increaseModFileNum(1);
                TsFileMetricManager.getInstance().increaseModFileSize(targetResource.getModFile().getSize());
            }
            modifications.removeAll(seqModifications);
        }
    }

    public static void combineModsInInnerCompaction(Collection<TsFileResource> sourceFiles, TsFileResource targetTsFile) throws IOException {
        HashSet<Modification> modifications = new HashSet<Modification>();
        for (TsFileResource mergeTsFile : sourceFiles) {
            ModificationFile sourceCompactionModificationFile = ModificationFile.getCompactionMods(mergeTsFile);
            try {
                modifications.addAll(sourceCompactionModificationFile.getModifications());
            }
            finally {
                if (sourceCompactionModificationFile == null) continue;
                sourceCompactionModificationFile.close();
            }
        }
        CompactionUtils.updateOneTargetMods(targetTsFile, modifications);
        if (modifications.size() > 0) {
            TsFileMetricManager.getInstance().increaseModFileNum(1);
            TsFileMetricManager.getInstance().increaseModFileSize(targetTsFile.getModFile().getSize());
        }
    }

    private static void updateOneTargetMods(TsFileResource targetFile, Set<Modification> modifications) throws IOException {
        if (!modifications.isEmpty()) {
            try (ModificationFile modificationFile = ModificationFile.getNormalMods(targetFile);){
                for (Modification modification : modifications) {
                    modification.setFileOffset(Long.MAX_VALUE);
                    modificationFile.write(modification);
                }
            }
        }
    }

    public static void deleteCompactionModsFile(List<TsFileResource> selectedSeqTsFileResourceList, List<TsFileResource> selectedUnSeqTsFileResourceList) throws IOException {
        ModificationFile modificationFile;
        for (TsFileResource seqFile : selectedSeqTsFileResourceList) {
            modificationFile = seqFile.getCompactionModFile();
            if (!modificationFile.exists()) continue;
            modificationFile.remove();
        }
        for (TsFileResource unseqFile : selectedUnSeqTsFileResourceList) {
            modificationFile = unseqFile.getCompactionModFile();
            if (!modificationFile.exists()) continue;
            modificationFile.remove();
        }
    }

    public static boolean deleteTsFilesInDisk(Collection<TsFileResource> mergeTsFiles, String storageGroupName) {
        logger.info("{} [Compaction] Compaction starts to delete real file ", (Object)storageGroupName);
        boolean result = true;
        for (TsFileResource mergeTsFile : mergeTsFiles) {
            if (!mergeTsFile.remove()) {
                result = false;
            }
            logger.info("{} [Compaction] delete TsFile {}", (Object)storageGroupName, (Object)mergeTsFile.getTsFilePath());
        }
        return result;
    }

    public static void deleteModificationForSourceFile(Collection<TsFileResource> sourceFiles, String storageGroupName) throws IOException {
        logger.info("{} [Compaction] Start to delete modifications of source files", (Object)storageGroupName);
        for (TsFileResource tsFileResource : sourceFiles) {
            ModificationFile normalModification;
            ModificationFile compactionModificationFile = ModificationFile.getCompactionMods(tsFileResource);
            if (compactionModificationFile.exists()) {
                compactionModificationFile.remove();
            }
            if (!(normalModification = ModificationFile.getNormalMods(tsFileResource)).exists()) continue;
            TsFileMetricManager.getInstance().decreaseModFileNum(1);
            TsFileMetricManager.getInstance().decreaseModFileSize(tsFileResource.getModFile().getSize());
            normalModification.remove();
        }
    }

    public static void updateResource(TsFileResource resource, TsFileIOWriter tsFileIOWriter, String deviceId) {
        List chunkMetadatasOfCurrentDevice = tsFileIOWriter.getChunkMetadataListOfCurrentDeviceInMemory();
        if (chunkMetadatasOfCurrentDevice != null) {
            for (ChunkMetadata chunkMetadata : chunkMetadatasOfCurrentDevice) {
                if (chunkMetadata.getMask() == 64) continue;
                resource.updateStartTime(deviceId, chunkMetadata.getStatistics().getStartTime());
                resource.updateEndTime(deviceId, chunkMetadata.getStatistics().getEndTime());
            }
        }
    }

    public static void updatePlanIndexes(List<TsFileResource> targetResources, List<TsFileResource> seqResources, List<TsFileResource> unseqResources) {
        for (int i = 0; i < targetResources.size(); ++i) {
            TsFileResource targetResource = targetResources.get(i);
            for (TsFileResource unseqResource : unseqResources) {
                targetResource.updatePlanIndexes(unseqResource);
            }
            for (TsFileResource seqResource : seqResources) {
                targetResource.updatePlanIndexes(seqResource);
            }
        }
    }

    public static boolean validateTsFileResources(TsFileManager manager, String storageGroupName, long timePartition) throws IOException {
        List<TsFileResource> resources = manager.getOrCreateSequenceListByTimePartition(timePartition).getArrayList();
        HashMap<String, Pair> lastEndTimeMap = new HashMap<String, Pair>();
        for (TsFileResource resource : resources) {
            DeviceTimeIndex timeIndex = resource.getTimeIndexType() != 1 ? resource.buildDeviceTimeIndex() : (DeviceTimeIndex)resource.getTimeIndex();
            Set<String> devices = timeIndex.getDevices();
            for (String device : devices) {
                long currentStartTime = timeIndex.getStartTime(device);
                long currentEndTime = timeIndex.getEndTime(device);
                Pair lastDeviceInfo = lastEndTimeMap.computeIfAbsent(device, x -> new Pair(null, (Object)Long.MIN_VALUE));
                long lastEndTime = (Long)lastDeviceInfo.right;
                if (lastEndTime >= currentStartTime) {
                    logger.error("{} Device {} is overlapped between {} and {}, end time in {} is {}, start time in {} is {}", new Object[]{storageGroupName, device, lastDeviceInfo.left, resource, lastDeviceInfo.left, lastEndTime, resource, currentStartTime});
                    return false;
                }
                lastDeviceInfo.left = resource;
                lastDeviceInfo.right = currentEndTime;
                lastEndTimeMap.put(device, lastDeviceInfo);
            }
        }
        return true;
    }
}

