/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.partition;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.partition.SeriesPartitionTable;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.confignode.rpc.thrift.TTimeSlotList;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;

public class DataPartitionTable {
    private final Map<TSeriesPartitionSlot, SeriesPartitionTable> dataPartitionMap;

    public DataPartitionTable() {
        this.dataPartitionMap = new ConcurrentHashMap<TSeriesPartitionSlot, SeriesPartitionTable>();
    }

    public DataPartitionTable(Map<TSeriesPartitionSlot, SeriesPartitionTable> dataPartitionMap) {
        this.dataPartitionMap = dataPartitionMap;
    }

    public Map<TSeriesPartitionSlot, SeriesPartitionTable> getDataPartitionMap() {
        return this.dataPartitionMap;
    }

    public boolean getDataPartition(Map<TSeriesPartitionSlot, TTimeSlotList> partitionSlots, DataPartitionTable dataPartitionTable) {
        AtomicBoolean result = new AtomicBoolean(true);
        if (partitionSlots.isEmpty()) {
            dataPartitionTable.getDataPartitionMap().putAll(this.dataPartitionMap);
        } else {
            partitionSlots.forEach((seriesPartitionSlot, timePartitionSlotList) -> {
                if (this.dataPartitionMap.containsKey(seriesPartitionSlot)) {
                    SeriesPartitionTable seriesPartitionTable = new SeriesPartitionTable();
                    if (!this.dataPartitionMap.get(seriesPartitionSlot).getDataPartition((TTimeSlotList)timePartitionSlotList, seriesPartitionTable)) {
                        result.set(false);
                    }
                    if (!seriesPartitionTable.getSeriesPartitionMap().isEmpty()) {
                        dataPartitionTable.getDataPartitionMap().put((TSeriesPartitionSlot)seriesPartitionSlot, seriesPartitionTable);
                    }
                } else {
                    result.set(false);
                }
            });
        }
        return result.get();
    }

    public TConsensusGroupId getPrecededDataPartition(TSeriesPartitionSlot seriesPartitionSlot, TTimePartitionSlot timePartitionSlot, long timePartitionInterval) {
        if (this.dataPartitionMap.containsKey(seriesPartitionSlot)) {
            return this.dataPartitionMap.get(seriesPartitionSlot).getPrecededDataPartition(timePartitionSlot, timePartitionInterval);
        }
        return null;
    }

    public Map<TConsensusGroupId, Map<TSeriesPartitionSlot, AtomicLong>> createDataPartition(DataPartitionTable assignedDataPartition) {
        ConcurrentHashMap<TConsensusGroupId, Map<TSeriesPartitionSlot, AtomicLong>> groupDeltaMap = new ConcurrentHashMap<TConsensusGroupId, Map<TSeriesPartitionSlot, AtomicLong>>();
        assignedDataPartition.getDataPartitionMap().forEach((seriesPartitionSlot, seriesPartitionTable) -> this.dataPartitionMap.computeIfAbsent((TSeriesPartitionSlot)seriesPartitionSlot, empty -> new SeriesPartitionTable()).createDataPartition((SeriesPartitionTable)seriesPartitionTable, (TSeriesPartitionSlot)seriesPartitionSlot, (Map<TConsensusGroupId, Map<TSeriesPartitionSlot, AtomicLong>>)groupDeltaMap));
        return groupDeltaMap;
    }

    public Map<TSeriesPartitionSlot, TTimeSlotList> filterUnassignedDataPartitionSlots(Map<TSeriesPartitionSlot, TTimeSlotList> partitionSlots) {
        ConcurrentHashMap<TSeriesPartitionSlot, TTimeSlotList> result = new ConcurrentHashMap<TSeriesPartitionSlot, TTimeSlotList>();
        partitionSlots.forEach((seriesPartitionSlot, timePartitionSlots) -> result.put((TSeriesPartitionSlot)seriesPartitionSlot, new TTimeSlotList(this.dataPartitionMap.computeIfAbsent((TSeriesPartitionSlot)seriesPartitionSlot, empty -> new SeriesPartitionTable()).filterUnassignedDataPartitionSlots(timePartitionSlots.getTimePartitionSlots()), false, false)));
        return result;
    }

    public List<TConsensusGroupId> getRegionId(TSeriesPartitionSlot seriesSlotId, TTimePartitionSlot timeSlotId) {
        if (!this.dataPartitionMap.containsKey(seriesSlotId)) {
            return new ArrayList<TConsensusGroupId>();
        }
        SeriesPartitionTable seriesPartitionTable = this.dataPartitionMap.get(seriesSlotId);
        return seriesPartitionTable.getRegionId(timeSlotId);
    }

    public List<TTimePartitionSlot> getTimeSlotList(TSeriesPartitionSlot seriesSlotId, long startTime, long endTime) {
        if (!this.dataPartitionMap.containsKey(seriesSlotId)) {
            return new ArrayList<TTimePartitionSlot>();
        }
        SeriesPartitionTable seriesPartitionTable = this.dataPartitionMap.get(seriesSlotId);
        return seriesPartitionTable.getTimeSlotList(startTime, endTime);
    }

    public List<TSeriesPartitionSlot> getSeriesSlotList() {
        return this.dataPartitionMap.keySet().stream().sorted(Comparator.comparing(TSeriesPartitionSlot::getSlotId)).collect(Collectors.toList());
    }

    public void serialize(OutputStream outputStream, TProtocol protocol) throws IOException, TException {
        ReadWriteIOUtils.write((int)this.dataPartitionMap.size(), (OutputStream)outputStream);
        for (Map.Entry<TSeriesPartitionSlot, SeriesPartitionTable> seriesPartitionTableEntry : this.dataPartitionMap.entrySet()) {
            seriesPartitionTableEntry.getKey().write(protocol);
            seriesPartitionTableEntry.getValue().serialize(outputStream, protocol);
        }
    }

    public void deserialize(ByteBuffer buffer) {
        int length = buffer.getInt();
        for (int i = 0; i < length; ++i) {
            TSeriesPartitionSlot seriesPartitionSlot = ThriftCommonsSerDeUtils.deserializeTSeriesPartitionSlot(buffer);
            SeriesPartitionTable seriesPartitionTable = new SeriesPartitionTable();
            seriesPartitionTable.deserialize(buffer);
            this.dataPartitionMap.put(seriesPartitionSlot, seriesPartitionTable);
        }
    }

    public void deserialize(InputStream inputStream, TProtocol protocol) throws IOException, TException {
        int length = ReadWriteIOUtils.readInt((InputStream)inputStream);
        for (int i = 0; i < length; ++i) {
            TSeriesPartitionSlot seriesPartitionSlot = new TSeriesPartitionSlot();
            seriesPartitionSlot.read(protocol);
            SeriesPartitionTable seriesPartitionTable = new SeriesPartitionTable();
            seriesPartitionTable.deserialize(inputStream, protocol);
            this.dataPartitionMap.put(seriesPartitionSlot, seriesPartitionTable);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataPartitionTable that = (DataPartitionTable)o;
        return this.dataPartitionMap.equals(that.dataPartitionMap);
    }

    public int hashCode() {
        return Objects.hash(this.dataPartitionMap);
    }
}

