/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.filter.operator;

import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.basic.UnaryFilter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterSerializeId;
import org.apache.iotdb.tsfile.read.filter.factory.FilterType;
import org.apache.iotdb.tsfile.read.filter.operator.LtEq;

public class Gt<T extends Comparable<T>>
extends UnaryFilter<T> {
    private static final long serialVersionUID = -2088181659871608986L;

    public Gt() {
    }

    public Gt(T value, FilterType filterType) {
        super(value, filterType);
    }

    @Override
    public boolean satisfy(Statistics statistics) {
        if (this.filterType == FilterType.TIME_FILTER) {
            return this.satisfyStartEndTime(statistics.getStartTime(), statistics.getEndTime());
        }
        if (statistics.getType() == TSDataType.TEXT || statistics.getType() == TSDataType.BOOLEAN) {
            return true;
        }
        return this.value.compareTo((Comparable)statistics.getMaxValue()) < 0;
    }

    @Override
    public boolean allSatisfy(Statistics statistics) {
        if (this.filterType == FilterType.TIME_FILTER) {
            return this.containStartEndTime(statistics.getStartTime(), statistics.getEndTime());
        }
        if (statistics.getType() == TSDataType.TEXT || statistics.getType() == TSDataType.BOOLEAN) {
            return false;
        }
        return this.value.compareTo((Comparable)statistics.getMinValue()) < 0;
    }

    @Override
    public boolean satisfy(long time, Object value) {
        Object v = this.filterType == FilterType.TIME_FILTER ? Long.valueOf(time) : value;
        return this.value.compareTo((Comparable)v) < 0;
    }

    @Override
    public boolean satisfyStartEndTime(long startTime, long endTime) {
        if (this.filterType == FilterType.TIME_FILTER) {
            long time = (Long)this.value;
            return time < endTime;
        }
        return true;
    }

    @Override
    public boolean containStartEndTime(long startTime, long endTime) {
        if (this.filterType == FilterType.TIME_FILTER) {
            long time = (Long)this.value;
            return startTime > time;
        }
        return false;
    }

    @Override
    public Filter copy() {
        return new Gt<Comparable>(this.value, this.filterType);
    }

    @Override
    public String toString() {
        return (Object)((Object)this.getFilterType()) + " > " + this.value;
    }

    @Override
    public FilterSerializeId getSerializeId() {
        return FilterSerializeId.GT;
    }

    @Override
    public Filter reverse() {
        return new LtEq<Comparable>(this.value, this.filterType);
    }
}

