/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.filter;

import java.util.Set;
import org.apache.iotdb.tsfile.read.filter.factory.FilterType;
import org.apache.iotdb.tsfile.read.filter.operator.Between;
import org.apache.iotdb.tsfile.read.filter.operator.Eq;
import org.apache.iotdb.tsfile.read.filter.operator.Gt;
import org.apache.iotdb.tsfile.read.filter.operator.GtEq;
import org.apache.iotdb.tsfile.read.filter.operator.In;
import org.apache.iotdb.tsfile.read.filter.operator.Like;
import org.apache.iotdb.tsfile.read.filter.operator.Lt;
import org.apache.iotdb.tsfile.read.filter.operator.LtEq;
import org.apache.iotdb.tsfile.read.filter.operator.NotEq;
import org.apache.iotdb.tsfile.read.filter.operator.Regexp;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public class ValueFilter {
    private ValueFilter() {
    }

    public static <T extends Comparable<T>> ValueGt<T> gt(T value) {
        return new ValueGt(value, null);
    }

    public static <T extends Comparable<T>> ValueGtEq<T> gtEq(T value) {
        return new ValueGtEq(value, null);
    }

    public static <T extends Comparable<T>> ValueLt<T> lt(T value) {
        return new ValueLt(value, null);
    }

    public static <T extends Comparable<T>> ValueLtEq<T> ltEq(T value) {
        return new ValueLtEq(value, null);
    }

    public static <T extends Comparable<T>> ValueEq<T> eq(T value) {
        return new ValueEq(value, null);
    }

    public static <T extends Comparable<T>> ValueNotEq<T> notEq(T value) {
        return new ValueNotEq(value, null);
    }

    public static <T extends Comparable<T>> ValueBetween<T> between(T value1, T value2) {
        return new ValueBetween(value1, value2, false, null);
    }

    public static <T extends Comparable<T>> ValueBetween<T> notBetween(T value1, T value2) {
        return new ValueBetween(value1, value2, true, null);
    }

    public static <T extends Comparable<T>> ValueLike<T> like(String value) {
        return new ValueLike(value, false);
    }

    public static <T extends Comparable<T>> ValueLike<T> notLike(String value) {
        return new ValueLike(value, true);
    }

    public static <T extends Comparable<T>> ValueRegexp<T> regexp(String value) {
        return new ValueRegexp(value, false);
    }

    public static <T extends Comparable<T>> ValueRegexp<T> notRegexp(String value) {
        return new ValueRegexp(value, true);
    }

    public static <T extends Comparable<T>> ValueIn<T> in(Set<T> values) {
        return new ValueIn(values, false);
    }

    public static <T extends Comparable<T>> ValueIn<T> notIn(Set<T> values) {
        return new ValueIn(values, true);
    }

    public static class VectorValueIn<T extends Comparable<T>>
    extends ValueIn<T> {
        private final int index;

        private VectorValueIn(Set<T> values, boolean not, int index) {
            super(values, not);
            this.index = index;
        }

        public boolean satisfy(long time, TsPrimitiveType[] values) {
            Long v = this.filterType == FilterType.TIME_FILTER ? Long.valueOf(time) : values[this.index].getValue();
            return this.values.contains(v) != this.not;
        }
    }

    public static class ValueIn<T extends Comparable<T>>
    extends In<T> {
        private ValueIn(Set<T> values, boolean not) {
            super(values, FilterType.VALUE_FILTER, not);
        }
    }

    public static class VectorValueRegexp<T extends Comparable<T>>
    extends ValueRegexp<T> {
        private final int index;

        private VectorValueRegexp(String value, int index, boolean not) {
            super(value, not);
            this.index = index;
        }

        public boolean satisfy(long time, TsPrimitiveType[] values) {
            if (this.filterType != FilterType.VALUE_FILTER) {
                return false;
            }
            Object value = values[this.index].getValue();
            return this.pattern.matcher(new Regexp.MatcherInput(value.toString(), new Regexp.AccessCount())).find() != this.not;
        }
    }

    public static class ValueRegexp<T extends Comparable<T>>
    extends Regexp<T> {
        private ValueRegexp(String value, boolean not) {
            super(value, FilterType.VALUE_FILTER, not);
        }
    }

    public static class VectorValueLike<T extends Comparable<T>>
    extends ValueLike<T> {
        private final int index;

        private VectorValueLike(String value, int index, boolean not) {
            super(value, not);
            this.index = index;
        }

        public boolean satisfy(long time, TsPrimitiveType[] values) {
            if (this.filterType != FilterType.VALUE_FILTER) {
                return false;
            }
            Object value = values[this.index].getValue();
            return this.pattern.matcher(value.toString()).find() != this.not;
        }
    }

    public static class ValueLike<T extends Comparable<T>>
    extends Like<T> {
        private ValueLike(String value, boolean not) {
            super(value, FilterType.VALUE_FILTER, not);
        }
    }

    public static class VectorValueBetween<T extends Comparable<T>>
    extends ValueBetween<T> {
        private final int index;

        private VectorValueBetween(T value1, T value2, boolean not, int index) {
            super((Comparable)value1, (Comparable)value2, not, null);
            this.index = index;
        }

        public boolean satisfy(long time, TsPrimitiveType[] values) {
            if (this.filterType != FilterType.VALUE_FILTER) {
                return false;
            }
            Object v = values[this.index].getValue();
            return (this.value1.compareTo((Comparable)v) <= 0 && ((Comparable)v).compareTo(this.value2) <= 0) ^ this.not;
        }
    }

    public static class ValueBetween<T extends Comparable<T>>
    extends Between<T> {
        private ValueBetween(T value1, T value2, boolean not) {
            super(value1, value2, FilterType.VALUE_FILTER, not);
        }

        /* synthetic */ ValueBetween(Comparable x0, Comparable x1, boolean x2, 1 x3) {
            this(x0, x1, x2);
        }
    }

    public static class VectorValueNotEq<T extends Comparable<T>>
    extends ValueNotEq<T> {
        private final int index;

        private VectorValueNotEq(T value, int index) {
            super((Comparable)value, null);
            this.index = index;
        }

        public boolean satisfy(long time, TsPrimitiveType[] values) {
            Long v = this.filterType == FilterType.TIME_FILTER ? Long.valueOf(time) : values[this.index].getValue();
            return !this.value.equals(v);
        }
    }

    public static class ValueNotEq<T extends Comparable<T>>
    extends NotEq<T> {
        private ValueNotEq(T value) {
            super(value, FilterType.VALUE_FILTER);
        }

        /* synthetic */ ValueNotEq(Comparable x0, 1 x1) {
            this(x0);
        }
    }

    public static class VectorValueEq<T extends Comparable<T>>
    extends ValueEq<T> {
        private final int index;

        private VectorValueEq(T value, int index) {
            super((Comparable)value, null);
            this.index = index;
        }

        public boolean satisfy(long time, TsPrimitiveType[] values) {
            Long v = this.filterType == FilterType.TIME_FILTER ? Long.valueOf(time) : values[this.index].getValue();
            return this.value.equals(v);
        }
    }

    public static class ValueEq<T extends Comparable<T>>
    extends Eq<T> {
        private ValueEq(T value) {
            super(value, FilterType.VALUE_FILTER);
        }

        /* synthetic */ ValueEq(Comparable x0, 1 x1) {
            this(x0);
        }
    }

    public static class VectorValueLtEq<T extends Comparable<T>>
    extends ValueLtEq<T> {
        private final int index;

        private VectorValueLtEq(T value, int index) {
            super((Comparable)value, null);
            this.index = index;
        }

        public boolean satisfy(long time, TsPrimitiveType[] values) {
            Long v = this.filterType == FilterType.TIME_FILTER ? Long.valueOf(time) : values[this.index].getValue();
            return this.value.compareTo((Comparable)v) >= 0;
        }
    }

    public static class ValueLtEq<T extends Comparable<T>>
    extends LtEq<T> {
        private ValueLtEq(T value) {
            super(value, FilterType.VALUE_FILTER);
        }

        /* synthetic */ ValueLtEq(Comparable x0, 1 x1) {
            this(x0);
        }
    }

    public static class VectorValueLt<T extends Comparable<T>>
    extends ValueLt<T> {
        private final int index;

        private VectorValueLt(T value, int index) {
            super((Comparable)value, null);
            this.index = index;
        }

        public boolean satisfy(long time, TsPrimitiveType[] values) {
            Long v = this.filterType == FilterType.TIME_FILTER ? Long.valueOf(time) : values[this.index].getValue();
            return this.value.compareTo((Comparable)v) > 0;
        }
    }

    public static class ValueLt<T extends Comparable<T>>
    extends Lt<T> {
        private ValueLt(T value) {
            super(value, FilterType.VALUE_FILTER);
        }

        /* synthetic */ ValueLt(Comparable x0, 1 x1) {
            this(x0);
        }
    }

    public static class VectorValueGtEq<T extends Comparable<T>>
    extends ValueGtEq<T> {
        private final int index;

        private VectorValueGtEq(T value, int index) {
            super((Comparable)value, null);
            this.index = index;
        }

        public boolean satisfy(long time, TsPrimitiveType[] values) {
            Long v = this.filterType == FilterType.TIME_FILTER ? Long.valueOf(time) : values[this.index].getValue();
            return this.value.compareTo((Comparable)v) <= 0;
        }
    }

    public static class ValueGtEq<T extends Comparable<T>>
    extends GtEq<T> {
        private ValueGtEq(T value) {
            super(value, FilterType.VALUE_FILTER);
        }

        /* synthetic */ ValueGtEq(Comparable x0, 1 x1) {
            this(x0);
        }
    }

    public static class VectorValueGt<T extends Comparable<T>>
    extends ValueGt<T> {
        private final int index;

        private VectorValueGt(T value, int index) {
            super((Comparable)value, null);
            this.index = index;
        }

        public boolean satisfy(long time, TsPrimitiveType[] values) {
            Long v = this.filterType == FilterType.TIME_FILTER ? Long.valueOf(time) : values[this.index].getValue();
            return this.value.compareTo((Comparable)v) < 0;
        }
    }

    public static class ValueGt<T extends Comparable<T>>
    extends Gt<T> {
        private ValueGt(T value) {
            super(value, FilterType.VALUE_FILTER);
        }

        /* synthetic */ ValueGt(Comparable x0, 1 x1) {
            this(x0);
        }
    }
}

