/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.wal.node;

import org.apache.iotdb.consensus.iot.wal.ConsensusReqReader;
import org.apache.iotdb.db.engine.memtable.IMemTable;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.DeleteDataNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.wal.exception.WALException;
import org.apache.iotdb.db.wal.node.IWALNode;
import org.apache.iotdb.db.wal.utils.listener.AbstractResultListener;
import org.apache.iotdb.db.wal.utils.listener.WALFlushListener;

public class WALFakeNode
implements IWALNode {
    private final AbstractResultListener.Status status;
    private final Exception cause;

    private WALFakeNode(AbstractResultListener.Status status) {
        this(status, (Exception)null);
    }

    public WALFakeNode(AbstractResultListener.Status status, Exception cause) {
        this.status = status;
        this.cause = cause;
    }

    @Override
    public WALFlushListener log(long memTableId, InsertRowNode insertRowNode) {
        return this.getResult();
    }

    @Override
    public WALFlushListener log(long memTableId, InsertTabletNode insertTabletNode, int start, int end) {
        return this.getResult();
    }

    @Override
    public WALFlushListener log(long memTableId, DeleteDataNode deleteDataNode) {
        return this.getResult();
    }

    private WALFlushListener getResult() {
        WALFlushListener walFlushListener = new WALFlushListener(false);
        switch (this.status) {
            case SUCCESS: {
                walFlushListener.succeed();
                break;
            }
            case FAILURE: {
                walFlushListener.fail(this.cause);
                break;
            }
        }
        return walFlushListener;
    }

    @Override
    public void onMemTableFlushStarted(IMemTable memTable) {
    }

    @Override
    public void onMemTableFlushed(IMemTable memTable) {
    }

    @Override
    public void onMemTableCreated(IMemTable memTable, String targetTsFile) {
    }

    public void setSafelyDeletedSearchIndex(long safelyDeletedSearchIndex) {
        throw new UnsupportedOperationException();
    }

    public ConsensusReqReader.ReqIterator getReqIterator(long startIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
    }

    public long getCurrentSearchIndex() {
        throw new UnsupportedOperationException();
    }

    public long getTotalSize() {
        return 0L;
    }

    public static WALFakeNode getFailureInstance(Exception e) {
        return new WALFakeNode(AbstractResultListener.Status.FAILURE, (Exception)((Object)new WALException("Cannot write wal into a fake node. ", e)));
    }

    public static WALFakeNode getSuccessInstance() {
        return WALFakeNodeHolder.SUCCESS_INSTANCE;
    }

    private static class WALFakeNodeHolder {
        private static final WALFakeNode SUCCESS_INSTANCE = new WALFakeNode(AbstractResultListener.Status.SUCCESS);

        private WALFakeNodeHolder() {
        }
    }
}

