/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.wal.buffer;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.db.engine.memtable.AbstractMemTable;
import org.apache.iotdb.db.engine.memtable.IMemTable;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.DeleteDataNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.utils.SerializedSize;
import org.apache.iotdb.db.wal.buffer.IWALByteBufferView;
import org.apache.iotdb.db.wal.buffer.WALEntryType;
import org.apache.iotdb.db.wal.buffer.WALEntryValue;
import org.apache.iotdb.db.wal.buffer.WALInfoEntry;
import org.apache.iotdb.db.wal.buffer.WALSignalEntry;
import org.apache.iotdb.db.wal.utils.listener.WALFlushListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WALEntry
implements SerializedSize {
    private static final Logger logger = LoggerFactory.getLogger(WALEntry.class);
    protected final WALEntryType type;
    protected final long memTableId;
    protected final WALEntryValue value;
    protected final WALFlushListener walFlushListener;

    protected WALEntry(long memTableId, WALEntryValue value, boolean wait) {
        this.memTableId = memTableId;
        this.value = value;
        if (value instanceof IMemTable) {
            this.type = WALEntryType.MEMORY_TABLE_SNAPSHOT;
        } else if (value instanceof InsertRowNode) {
            this.type = WALEntryType.INSERT_ROW_NODE;
        } else if (value instanceof InsertTabletNode) {
            this.type = WALEntryType.INSERT_TABLET_NODE;
        } else if (value instanceof DeleteDataNode) {
            this.type = WALEntryType.DELETE_DATA_NODE;
        } else {
            throw new RuntimeException("Unknown WALEntry type");
        }
        this.walFlushListener = new WALFlushListener(wait);
    }

    protected WALEntry(WALEntryType type, long memTableId, WALEntryValue value, boolean wait) {
        this.type = type;
        this.memTableId = memTableId;
        this.value = value;
        this.walFlushListener = new WALFlushListener(wait);
    }

    public abstract void serialize(IWALByteBufferView var1);

    public static WALEntry deserialize(DataInputStream stream) throws IllegalPathException, IOException {
        byte typeNum = stream.readByte();
        WALEntryType type = WALEntryType.valueOf(typeNum);
        switch (type) {
            case CLOSE_SIGNAL: 
            case ROLL_WAL_LOG_WRITER_SIGNAL: 
            case WAL_FILE_INFO_END_MARKER: {
                return new WALSignalEntry(type);
            }
        }
        long memTableId = stream.readLong();
        WALEntryValue value = null;
        switch (type) {
            case MEMORY_TABLE_SNAPSHOT: {
                value = AbstractMemTable.Factory.create(stream);
                break;
            }
            case INSERT_ROW_NODE: {
                value = (InsertRowNode)PlanNodeType.deserializeFromWAL(stream);
                break;
            }
            case INSERT_TABLET_NODE: {
                value = (InsertTabletNode)PlanNodeType.deserializeFromWAL(stream);
                break;
            }
            case DELETE_DATA_NODE: {
                value = (DeleteDataNode)PlanNodeType.deserializeFromWAL(stream);
                break;
            }
            default: {
                throw new RuntimeException("Unknown WALEntry type " + (Object)((Object)type));
            }
        }
        return new WALInfoEntry(type, memTableId, value);
    }

    public static PlanNode deserializeForConsensus(ByteBuffer buffer) {
        logger.debug("buffer capacity is: {}, limit is: {}, position is: {}", new Object[]{buffer.capacity(), buffer.limit(), buffer.position()});
        buffer.get();
        buffer.getLong();
        return PlanNodeType.deserializeFromWAL(buffer);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WALEntry)) {
            return false;
        }
        WALEntry other = (WALEntry)obj;
        return this.type == other.type && this.memTableId == other.memTableId && Objects.equals(this.value, other.value);
    }

    public WALEntryType getType() {
        return this.type;
    }

    public long getMemTableId() {
        return this.memTableId;
    }

    public WALEntryValue getValue() {
        return this.value;
    }

    public WALFlushListener getWalFlushListener() {
        return this.walFlushListener;
    }

    public abstract boolean isSignal();
}

