/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.query.control.SessionManager;

public class DateTimeUtils {
    public static final DateTimeFormatter ISO_LOCAL_DATE_WIDTH_1_2 = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 19, SignStyle.NEVER).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 1, 2, SignStyle.NEVER).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NEVER).toFormatter();
    public static final DateTimeFormatter ISO_LOCAL_DATE_WITH_SLASH = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 19, SignStyle.NEVER).appendLiteral('/').appendValue(ChronoField.MONTH_OF_YEAR, 1, 2, SignStyle.NEVER).appendLiteral('/').appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NEVER).toFormatter();
    public static final DateTimeFormatter ISO_LOCAL_DATE_WITH_DOT = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 19, SignStyle.NEVER).appendLiteral('.').appendValue(ChronoField.MONTH_OF_YEAR, 1, 2, SignStyle.NEVER).appendLiteral('.').appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NEVER).toFormatter();
    public static final DateTimeFormatter ISO_LOCAL_TIME_WITH_MS = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendLiteral('.').appendValue(ChronoField.MILLI_OF_SECOND, 3).optionalEnd().toFormatter();
    public static final DateTimeFormatter ISO_LOCAL_TIME_WITH_US = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendLiteral('.').appendValue(ChronoField.MICRO_OF_SECOND, 6).optionalEnd().toFormatter();
    public static final DateTimeFormatter ISO_LOCAL_TIME_WITH_NS = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendLiteral('.').appendValue(ChronoField.NANO_OF_SECOND, 9).optionalEnd().toFormatter();
    public static final DateTimeFormatter ISO_OFFSET_DATE_TIME_WITH_MS = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_DATE_WIDTH_1_2).appendLiteral('T').append(ISO_LOCAL_TIME_WITH_MS).appendOffsetId().toFormatter();
    public static final DateTimeFormatter ISO_OFFSET_DATE_TIME_WITH_US = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_DATE_WIDTH_1_2).appendLiteral('T').append(ISO_LOCAL_TIME_WITH_US).appendOffsetId().toFormatter();
    public static final DateTimeFormatter ISO_OFFSET_DATE_TIME_WITH_NS = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_DATE_WIDTH_1_2).appendLiteral('T').append(ISO_LOCAL_TIME_WITH_NS).appendOffsetId().toFormatter();
    public static final DateTimeFormatter ISO_OFFSET_DATE_TIME_WITH_SLASH = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_DATE_WITH_SLASH).appendLiteral('T').append(ISO_LOCAL_TIME_WITH_MS).appendOffsetId().toFormatter();
    public static final DateTimeFormatter ISO_OFFSET_DATE_TIME_WITH_SLASH_US = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_DATE_WITH_SLASH).appendLiteral('T').append(ISO_LOCAL_TIME_WITH_US).appendOffsetId().toFormatter();
    public static final DateTimeFormatter ISO_OFFSET_DATE_TIME_WITH_SLASH_NS = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_DATE_WITH_SLASH).appendLiteral('T').append(ISO_LOCAL_TIME_WITH_NS).appendOffsetId().toFormatter();
    public static final DateTimeFormatter ISO_OFFSET_DATE_TIME_WITH_DOT = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_DATE_WITH_DOT).appendLiteral('T').append(ISO_LOCAL_TIME_WITH_MS).appendOffsetId().toFormatter();
    public static final DateTimeFormatter ISO_OFFSET_DATE_TIME_WITH_DOT_US = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_DATE_WITH_DOT).appendLiteral('T').append(ISO_LOCAL_TIME_WITH_US).appendOffsetId().toFormatter();
    public static final DateTimeFormatter ISO_OFFSET_DATE_TIME_WITH_DOT_NS = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_DATE_WITH_DOT).appendLiteral('T').append(ISO_LOCAL_TIME_WITH_NS).appendOffsetId().toFormatter();
    public static final DateTimeFormatter ISO_OFFSET_DATE_TIME_WITH_SPACE = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(ISO_LOCAL_TIME_WITH_MS).appendOffsetId().toFormatter();
    public static final DateTimeFormatter ISO_OFFSET_DATE_TIME_WITH_SPACE_US = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(ISO_LOCAL_TIME_WITH_US).appendOffsetId().toFormatter();
    public static final DateTimeFormatter ISO_OFFSET_DATE_TIME_WITH_SPACE_NS = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(ISO_LOCAL_TIME_WITH_NS).appendOffsetId().toFormatter();
    public static final DateTimeFormatter ISO_OFFSET_DATE_TIME_WITH_SLASH_WITH_SPACE = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_DATE_WITH_SLASH).appendLiteral(' ').append(ISO_LOCAL_TIME_WITH_MS).appendOffsetId().toFormatter();
    public static final DateTimeFormatter ISO_OFFSET_DATE_TIME_WITH_SLASH_WITH_SPACE_US = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_DATE_WITH_SLASH).appendLiteral(' ').append(ISO_LOCAL_TIME_WITH_US).appendOffsetId().toFormatter();
    public static final DateTimeFormatter ISO_OFFSET_DATE_TIME_WITH_SLASH_WITH_SPACE_NS = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_DATE_WITH_SLASH).appendLiteral(' ').append(ISO_LOCAL_TIME_WITH_NS).appendOffsetId().toFormatter();
    public static final DateTimeFormatter ISO_OFFSET_DATE_TIME_WITH_DOT_WITH_SPACE = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_DATE_WITH_DOT).appendLiteral(' ').append(ISO_LOCAL_TIME_WITH_MS).appendOffsetId().toFormatter();
    public static final DateTimeFormatter ISO_OFFSET_DATE_TIME_WITH_DOT_WITH_SPACE_US = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_DATE_WITH_DOT).appendLiteral(' ').append(ISO_LOCAL_TIME_WITH_US).appendOffsetId().toFormatter();
    public static final DateTimeFormatter ISO_OFFSET_DATE_TIME_WITH_DOT_WITH_SPACE_NS = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_DATE_WITH_DOT).appendLiteral(' ').append(ISO_LOCAL_TIME_WITH_NS).appendOffsetId().toFormatter();
    public static final DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendOptional(ISO_OFFSET_DATE_TIME_WITH_MS).appendOptional(ISO_OFFSET_DATE_TIME_WITH_US).appendOptional(ISO_OFFSET_DATE_TIME_WITH_NS).appendOptional(ISO_OFFSET_DATE_TIME_WITH_SLASH).appendOptional(ISO_OFFSET_DATE_TIME_WITH_SLASH_US).appendOptional(ISO_OFFSET_DATE_TIME_WITH_SLASH_NS).appendOptional(ISO_OFFSET_DATE_TIME_WITH_DOT).appendOptional(ISO_OFFSET_DATE_TIME_WITH_DOT_US).appendOptional(ISO_OFFSET_DATE_TIME_WITH_DOT_NS).appendOptional(ISO_OFFSET_DATE_TIME_WITH_SPACE).appendOptional(ISO_OFFSET_DATE_TIME_WITH_SPACE_US).appendOptional(ISO_OFFSET_DATE_TIME_WITH_SPACE_NS).appendOptional(ISO_OFFSET_DATE_TIME_WITH_SLASH_WITH_SPACE).appendOptional(ISO_OFFSET_DATE_TIME_WITH_SLASH_WITH_SPACE_US).appendOptional(ISO_OFFSET_DATE_TIME_WITH_SLASH_WITH_SPACE_NS).appendOptional(ISO_OFFSET_DATE_TIME_WITH_DOT_WITH_SPACE).appendOptional(ISO_OFFSET_DATE_TIME_WITH_DOT_WITH_SPACE_US).appendOptional(ISO_OFFSET_DATE_TIME_WITH_DOT_WITH_SPACE_NS).toFormatter();
    public static final long MS_TO_MONTH = 2592000000L;

    private DateTimeUtils() {
    }

    public static long convertDatetimeStrToLong(String str, ZoneId zoneId) {
        return DateTimeUtils.convertDatetimeStrToLong(str, DateTimeUtils.toZoneOffset(zoneId), 0, IoTDBDescriptor.getInstance().getConfig().getTimestampPrecision());
    }

    public static long convertDatetimeStrToLong(String str, ZoneId zoneId, String timestampPrecision) {
        return DateTimeUtils.convertDatetimeStrToLong(str, DateTimeUtils.toZoneOffset(zoneId), 0, timestampPrecision);
    }

    public static long getInstantWithPrecision(String str, String timestampPrecision) {
        try {
            ZonedDateTime zonedDateTime = ZonedDateTime.parse(str, formatter);
            Instant instant = zonedDateTime.toInstant();
            if ("us".equals(timestampPrecision)) {
                if (instant.getEpochSecond() < 0L && instant.getNano() > 0) {
                    long millis = Math.multiplyExact(instant.getEpochSecond() + 1L, 1000000L);
                    long adjustment = (long)(instant.getNano() / 1000) - 1L;
                    return Math.addExact(millis, adjustment);
                }
                long millis = Math.multiplyExact(instant.getEpochSecond(), 1000000L);
                return Math.addExact(millis, (long)(instant.getNano() / 1000));
            }
            if ("ns".equals(timestampPrecision)) {
                long millis = Math.multiplyExact(instant.getEpochSecond(), 1000000000L);
                return Math.addExact(millis, (long)instant.getNano());
            }
            return instant.toEpochMilli();
        }
        catch (DateTimeParseException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static long convertDatetimeStrToLong(String str, ZoneOffset offset, int depth, String timestampPrecision) {
        if (depth >= 2) {
            throw new DateTimeException(String.format("Failed to convert %s to millisecond, zone offset is %s, please input like 2011-12-03T10:15:30 or 2011-12-03T10:15:30+01:00", str, offset));
        }
        if (str.contains("Z")) {
            return DateTimeUtils.convertDatetimeStrToLong(str.substring(0, str.indexOf(90)) + "+00:00", offset, depth, timestampPrecision);
        }
        if (str.length() == 10) {
            return DateTimeUtils.convertDatetimeStrToLong(str + "T00:00:00", offset, depth, timestampPrecision);
        }
        if (str.length() - str.lastIndexOf(43) != 6 && str.length() - str.lastIndexOf(45) != 6) {
            return DateTimeUtils.convertDatetimeStrToLong(str + offset, offset, depth + 1, timestampPrecision);
        }
        if (str.contains("[") || str.contains("]")) {
            throw new DateTimeException(String.format("%s with [time-region] at end is not supported now, please input like 2011-12-03T10:15:30 or 2011-12-03T10:15:30+01:00", str));
        }
        return DateTimeUtils.getInstantWithPrecision(str, timestampPrecision);
    }

    public static long convertDurationStrToLong(String duration) {
        return DateTimeUtils.convertDurationStrToLong(-1L, duration);
    }

    public static long convertDurationStrToLong(String duration, String timestampPrecision) {
        return DateTimeUtils.convertDurationStrToLong(-1L, duration, timestampPrecision);
    }

    public static long convertDurationStrToLong(long currentTime, String duration) {
        return DateTimeUtils.convertDurationStrToLong(currentTime, duration, IoTDBDescriptor.getInstance().getConfig().getTimestampPrecision());
    }

    public static long convertDurationStrToLong(long currentTime, String duration, String timestampPrecision) {
        long total = 0L;
        long temp = 0L;
        for (int i = 0; i < duration.length(); ++i) {
            char ch = duration.charAt(i);
            if (Character.isDigit(ch)) {
                temp *= 10L;
                temp += (long)(ch - 48);
                continue;
            }
            String unit = duration.charAt(i) + "";
            if (i + 1 < duration.length() && !Character.isDigit(duration.charAt(i + 1))) {
                unit = unit + duration.charAt(++i);
            }
            total += DateTimeUtils.convertDurationStrToLong(currentTime == -1L ? -1L : currentTime + total, temp, unit.toLowerCase(), timestampPrecision);
            temp = 0L;
        }
        return total;
    }

    public static long convertDurationStrToLongForTest(long value, String unit, String timestampPrecision) {
        return DateTimeUtils.convertDurationStrToLong(-1L, value, unit, timestampPrecision);
    }

    public static long convertDurationStrToLong(long currentTime, long value, String unit, String timestampPrecision) {
        DurationUnit durationUnit = DurationUnit.valueOf(unit);
        long res = value;
        switch (durationUnit) {
            case y: {
                res *= 31536000000L;
                break;
            }
            case mo: {
                if (currentTime == -1L) {
                    res *= 2592000000L;
                    break;
                }
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeZone(SessionManager.getInstance().getSessionTimeZone());
                calendar.setTimeInMillis(currentTime);
                calendar.add(2, (int)value);
                res = calendar.getTimeInMillis() - currentTime;
                break;
            }
            case w: {
                res *= 604800000L;
                break;
            }
            case d: {
                res *= 86400000L;
                break;
            }
            case h: {
                res *= 3600000L;
                break;
            }
            case m: {
                res *= 60000L;
                break;
            }
            case s: {
                res *= 1000L;
                break;
            }
        }
        if ("us".equals(timestampPrecision)) {
            if (unit.equals(DurationUnit.ns.toString())) {
                return value / 1000L;
            }
            if (unit.equals(DurationUnit.us.toString())) {
                return value;
            }
            return res * 1000L;
        }
        if ("ns".equals(timestampPrecision)) {
            if (unit.equals(DurationUnit.ns.toString())) {
                return value;
            }
            if (unit.equals(DurationUnit.us.toString())) {
                return value * 1000L;
            }
            return res * 1000000L;
        }
        if (unit.equals(DurationUnit.ns.toString())) {
            return value / 1000000L;
        }
        if (unit.equals(DurationUnit.us.toString())) {
            return value / 1000L;
        }
        return res;
    }

    public static TimeUnit timestampPrecisionStringToTimeUnit(String timestampPrecision) {
        if ("us".equals(timestampPrecision)) {
            return TimeUnit.MICROSECONDS;
        }
        if ("ns".equals(timestampPrecision)) {
            return TimeUnit.NANOSECONDS;
        }
        return TimeUnit.MILLISECONDS;
    }

    public static long currentTime() {
        String timePrecision;
        long startupNano = IoTDBDescriptor.getInstance().getConfig().getStartUpNanosecond();
        switch (timePrecision = IoTDBDescriptor.getInstance().getConfig().getTimestampPrecision()) {
            case "ns": {
                return System.currentTimeMillis() * 1000000L + (System.nanoTime() - startupNano) % 1000000L;
            }
            case "us": {
                return System.currentTimeMillis() * 1000L + (System.nanoTime() - startupNano) / 1000L % 1000L;
            }
        }
        return System.currentTimeMillis();
    }

    public static String convertLongToDate(long timestamp) {
        String timePrecision;
        switch (timePrecision = IoTDBDescriptor.getInstance().getConfig().getTimestampPrecision()) {
            case "ns": {
                timestamp /= 1000000000L;
                break;
            }
            case "us": {
                timestamp /= 1000000L;
            }
        }
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault()).toString();
    }

    public static ZoneOffset toZoneOffset(ZoneId zoneId) {
        return zoneId.getRules().getOffset(Instant.now());
    }

    public static ZonedDateTime convertMillsecondToZonedDateTime(long millisecond) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(millisecond), ZoneId.systemDefault());
    }

    public static long convertMilliTimeWithPrecision(long milliTime, String timePrecision) {
        long result = milliTime;
        switch (timePrecision) {
            case "ns": {
                result = milliTime * 1000000L;
                break;
            }
            case "us": {
                result = milliTime * 1000L;
                break;
            }
        }
        return result;
    }

    public static TimeUnit toTimeUnit(String t) {
        switch (t) {
            case "h": {
                return TimeUnit.HOURS;
            }
            case "m": {
                return TimeUnit.MINUTES;
            }
            case "s": {
                return TimeUnit.SECONDS;
            }
            case "ms": {
                return TimeUnit.MILLISECONDS;
            }
            case "u": {
                return TimeUnit.MICROSECONDS;
            }
            case "n": {
                return TimeUnit.NANOSECONDS;
            }
        }
        throw new IllegalArgumentException("time precision must be one of: h,m,s,ms,u,n");
    }

    public static long calcIntervalByMonth(long startTime, long numMonths) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(SessionManager.getInstance().getSessionTimeZone());
        calendar.setTimeInMillis(startTime);
        boolean isLastDayOfMonth = calendar.get(5) == calendar.getActualMaximum(5);
        calendar.add(2, (int)numMonths);
        if (isLastDayOfMonth) {
            calendar.set(5, calendar.getActualMaximum(5));
        }
        return calendar.getTimeInMillis();
    }

    public static enum DurationUnit {
        y,
        mo,
        w,
        d,
        h,
        m,
        s,
        ms,
        us,
        ns;

    }
}

