/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.datasource;

import java.io.IOException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.sync.datasource.AbstractOpBlock;
import org.apache.iotdb.db.sync.externalpipe.operation.DeleteOperation;
import org.apache.iotdb.db.sync.externalpipe.operation.Operation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeletionOpBlock
extends AbstractOpBlock {
    private static final Logger logger = LoggerFactory.getLogger(DeletionOpBlock.class);
    private PartialPath deletePath;
    private long startTime;
    private long endTime;

    public DeletionOpBlock(String sg, PartialPath deletePath, long startTime, long endTime, long pipeDataSerialNumber) {
        this(sg, deletePath, startTime, endTime, pipeDataSerialNumber, 0L);
    }

    public DeletionOpBlock(String sg, PartialPath deletePath, long startTime, long endTime, long pipeDataSerialNumber, long beginIndex) {
        super(sg, pipeDataSerialNumber, beginIndex);
        this.deletePath = deletePath;
        this.startTime = startTime;
        this.endTime = endTime;
        this.dataCount = 1L;
    }

    @Override
    public Operation getOperation(long index, long length) throws IOException {
        if (this.closed) {
            logger.error("DeletionOpBlock.getOperation(), can not access closed DeletionOpBlock: {}.", (Object)this);
            throw new IOException("Can not access closed DeletionOpBlock: " + this);
        }
        if (index != this.beginIndex) {
            return null;
        }
        return new DeleteOperation(this.storageGroup, index, index + 1L, this.deletePath, this.startTime, this.endTime);
    }

    @Override
    public void close() {
        super.close();
    }

    @Override
    public String toString() {
        return super.toString() + ", deletePath=" + this.deletePath + ", startTime=" + this.startTime + ", endTime=" + this.endTime;
    }
}

