/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.metrics.recorder;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.engine.compaction.constant.CompactionTaskStatus;
import org.apache.iotdb.db.engine.compaction.constant.CompactionTaskType;
import org.apache.iotdb.db.engine.compaction.execute.task.CompactionTaskSummary;
import org.apache.iotdb.db.engine.compaction.schedule.CompactionTaskManager;
import org.apache.iotdb.db.engine.compaction.schedule.constant.CompactionType;
import org.apache.iotdb.db.engine.compaction.schedule.constant.ProcessChunkType;
import org.apache.iotdb.metrics.utils.MetricLevel;

public class CompactionMetricsManager {
    private static final CompactionMetricsManager INSTANCE = new CompactionMetricsManager();
    private long lastUpdateTime = 0L;
    private static final long UPDATE_INTERVAL = 10000L;
    private final AtomicInteger waitingSeqInnerCompactionTaskNum = new AtomicInteger(0);
    private final AtomicInteger waitingUnseqInnerCompactionTaskNum = new AtomicInteger(0);
    private final AtomicInteger waitingCrossCompactionTaskNum = new AtomicInteger(0);
    private final AtomicInteger runningSeqInnerCompactionTaskNum = new AtomicInteger(0);
    private final AtomicInteger runningUnseqInnerCompactionTaskNum = new AtomicInteger(0);
    private final AtomicInteger runningCrossCompactionTaskNum = new AtomicInteger(0);
    private final AtomicInteger finishSeqInnerCompactionTaskNum = new AtomicInteger(0);
    private final AtomicInteger finishUnseqInnerCompactionTaskNum = new AtomicInteger(0);
    private final AtomicInteger finishCrossCompactionTaskNum = new AtomicInteger(0);

    private CompactionMetricsManager() {
    }

    public static CompactionMetricsManager getInstance() {
        return INSTANCE;
    }

    public void recordWriteInfo(CompactionType compactionType, ProcessChunkType processChunkType, boolean aligned, long byteNum) {
        MetricService.getInstance().count(byteNum / 1024L, Metric.DATA_WRITTEN.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "compaction_" + compactionType.toString(), Tag.TYPE.toString(), (aligned ? "ALIGNED" : "NOT_ALIGNED") + "_" + processChunkType.toString()});
        MetricService.getInstance().count(byteNum / 1024L, Metric.DATA_WRITTEN.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "compaction", Tag.TYPE.toString(), "total"});
    }

    public void recordReadInfo(long byteNum) {
        MetricService.getInstance().count(byteNum, Metric.DATA_READ.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "compaction"});
    }

    public void updateSummary(CompactionTaskSummary summary) {
        MetricService.getInstance().count(summary.getProcessPointNum(), "Compacted_Point_Num", MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "compaction"});
        MetricService.getInstance().count((long)summary.getProcessChunkNum(), "Compacted_Chunk_Num", MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "compaction"});
        MetricService.getInstance().count((long)summary.getDirectlyFlushChunkNum(), "Directly_Flush_Chunk_Num", MetricLevel.NORMAL, new String[]{Tag.NAME.toString(), "compaction"});
        MetricService.getInstance().count((long)summary.getDeserializeChunkCount(), "Deserialized_Chunk_Num", MetricLevel.NORMAL, new String[]{Tag.NAME.toString(), "compaction"});
        MetricService.getInstance().count((long)summary.getMergedChunkNum(), "Merged_Chunk_Num", MetricLevel.NORMAL, new String[]{Tag.NAME.toString(), "compaction"});
    }

    public void reportTaskFinishOrAbort(boolean isCrossTask, boolean isSeq, long timeCost) {
        if (isCrossTask) {
            this.finishCrossCompactionTaskNum.incrementAndGet();
            MetricService.getInstance().timer(timeCost, TimeUnit.MILLISECONDS, Metric.COST_TASK.toString(), MetricLevel.CORE, new String[]{Tag.NAME.toString(), "cross_compaction"});
        } else if (isSeq) {
            this.finishSeqInnerCompactionTaskNum.incrementAndGet();
            MetricService.getInstance().timer(timeCost, TimeUnit.MILLISECONDS, Metric.COST_TASK.toString(), MetricLevel.CORE, new String[]{Tag.NAME.toString(), "inner_seq_compaction"});
        } else {
            this.finishUnseqInnerCompactionTaskNum.incrementAndGet();
            MetricService.getInstance().timer(timeCost, TimeUnit.MILLISECONDS, Metric.COST_TASK.toString(), MetricLevel.CORE, new String[]{Tag.NAME.toString(), "inner_unseq_compaction"});
        }
    }

    public int getWaitingSeqInnerCompactionTaskNum() {
        return this.waitingSeqInnerCompactionTaskNum.get();
    }

    public int getWaitingUnseqInnerCompactionTaskNum() {
        this.updateCompactionTaskInfo();
        return this.waitingUnseqInnerCompactionTaskNum.get();
    }

    public int getWaitingCrossCompactionTaskNum() {
        this.updateCompactionTaskInfo();
        return this.waitingCrossCompactionTaskNum.get();
    }

    public int getRunningSeqInnerCompactionTaskNum() {
        this.updateCompactionTaskInfo();
        return this.runningSeqInnerCompactionTaskNum.get();
    }

    public int getRunningUnseqInnerCompactionTaskNum() {
        this.updateCompactionTaskInfo();
        return this.runningUnseqInnerCompactionTaskNum.get();
    }

    public int getRunningCrossCompactionTaskNum() {
        this.updateCompactionTaskInfo();
        return this.runningCrossCompactionTaskNum.get();
    }

    public int getFinishSeqInnerCompactionTaskNum() {
        this.updateCompactionTaskInfo();
        return this.finishSeqInnerCompactionTaskNum.get();
    }

    public int getFinishUnseqInnerCompactionTaskNum() {
        this.updateCompactionTaskInfo();
        return this.finishUnseqInnerCompactionTaskNum.get();
    }

    public int getFinishCrossCompactionTaskNum() {
        this.updateCompactionTaskInfo();
        return this.finishCrossCompactionTaskNum.get();
    }

    private void updateCompactionTaskInfo() {
        if (System.currentTimeMillis() - this.lastUpdateTime < 10000L) {
            return;
        }
        this.lastUpdateTime = System.currentTimeMillis();
        Map<CompactionTaskType, Map<CompactionTaskStatus, Integer>> compactionTaskStatisticMap = CompactionTaskManager.getInstance().getCompactionTaskStatistic();
        this.waitingSeqInnerCompactionTaskNum.set(compactionTaskStatisticMap.getOrDefault((Object)CompactionTaskType.INNER_SEQ, Collections.emptyMap()).getOrDefault((Object)CompactionTaskStatus.WAITING, 0));
        this.waitingUnseqInnerCompactionTaskNum.set(compactionTaskStatisticMap.getOrDefault((Object)CompactionTaskType.INNER_UNSEQ, Collections.emptyMap()).getOrDefault((Object)CompactionTaskStatus.WAITING, 0));
        this.waitingCrossCompactionTaskNum.set(compactionTaskStatisticMap.getOrDefault((Object)CompactionTaskType.CROSS, Collections.emptyMap()).getOrDefault((Object)CompactionTaskStatus.WAITING, 0));
        this.runningSeqInnerCompactionTaskNum.set(compactionTaskStatisticMap.getOrDefault((Object)CompactionTaskType.INNER_SEQ, Collections.emptyMap()).getOrDefault((Object)CompactionTaskStatus.RUNNING, 0));
        this.runningUnseqInnerCompactionTaskNum.set(compactionTaskStatisticMap.getOrDefault((Object)CompactionTaskType.INNER_UNSEQ, Collections.emptyMap()).getOrDefault((Object)CompactionTaskStatus.RUNNING, 0));
        this.runningCrossCompactionTaskNum.set(compactionTaskStatisticMap.getOrDefault((Object)CompactionTaskType.CROSS, Collections.emptyMap()).getOrDefault((Object)CompactionTaskStatus.RUNNING, 0));
    }
}

