/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.metrics;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.engine.TsFileMetricManager;
import org.apache.iotdb.db.wal.WALManager;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.config.MetricConfig;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.apache.iotdb.metrics.utils.SystemType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileMetrics
implements IMetricSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileMetrics.class);
    private static final MetricConfig METRIC_CONFIG = MetricConfigDescriptor.getInstance().getMetricConfig();
    private static final TsFileMetricManager TS_FILE_METRIC_MANAGER = TsFileMetricManager.getInstance();
    private static final WALManager WAL_MANAGER = WALManager.getInstance();
    private final Runtime runtime = Runtime.getRuntime();
    private String[] getOpenFileNumberCommand;
    private String fileHandlerCntPathInLinux = String.format(this.fileHandlerCntPathInLinux, METRIC_CONFIG.getPid());

    public void bindTo(AbstractMetricService metricService) {
        this.bindTsFileMetrics(metricService);
        this.bindWalFileMetrics(metricService);
        this.bindCompactionFileMetrics(metricService);
        this.bindSystemRelatedMetrics(metricService);
    }

    private void bindTsFileMetrics(AbstractMetricService metricService) {
        metricService.createAutoGauge(Metric.FILE_SIZE.toString(), MetricLevel.CORE, (Object)TS_FILE_METRIC_MANAGER, o -> o.getFileSize(true), new String[]{Tag.NAME.toString(), "seq"});
        metricService.createAutoGauge(Metric.FILE_SIZE.toString(), MetricLevel.CORE, (Object)TS_FILE_METRIC_MANAGER, o -> o.getFileSize(false), new String[]{Tag.NAME.toString(), "unseq"});
        metricService.createAutoGauge(Metric.FILE_SIZE.toString(), MetricLevel.CORE, (Object)TS_FILE_METRIC_MANAGER, TsFileMetricManager::getModFileSize, new String[]{Tag.NAME.toString(), "mods"});
        metricService.createAutoGauge(Metric.FILE_COUNT.toString(), MetricLevel.CORE, (Object)TS_FILE_METRIC_MANAGER, o -> o.getFileNum(true), new String[]{Tag.NAME.toString(), "seq"});
        metricService.createAutoGauge(Metric.FILE_COUNT.toString(), MetricLevel.CORE, (Object)TS_FILE_METRIC_MANAGER, o -> o.getFileNum(false), new String[]{Tag.NAME.toString(), "unseq"});
        metricService.createAutoGauge(Metric.FILE_COUNT.toString(), MetricLevel.CORE, (Object)TS_FILE_METRIC_MANAGER, TsFileMetricManager::getModFileNum, new String[]{Tag.NAME.toString(), "mods"});
    }

    private void bindWalFileMetrics(AbstractMetricService metricService) {
        metricService.createAutoGauge(Metric.FILE_SIZE.toString(), MetricLevel.CORE, (Object)WAL_MANAGER, WALManager::getTotalDiskUsage, new String[]{Tag.NAME.toString(), "wal"});
        metricService.createAutoGauge(Metric.FILE_COUNT.toString(), MetricLevel.CORE, (Object)WAL_MANAGER, WALManager::getTotalFileNum, new String[]{Tag.NAME.toString(), "wal"});
    }

    private void bindCompactionFileMetrics(AbstractMetricService metricService) {
        metricService.createAutoGauge(Metric.FILE_SIZE.toString(), MetricLevel.CORE, (Object)TS_FILE_METRIC_MANAGER, o -> o.getInnerCompactionTempFileSize(true), new String[]{Tag.NAME.toString(), "inner-seq-temp"});
        metricService.createAutoGauge(Metric.FILE_SIZE.toString(), MetricLevel.CORE, (Object)TS_FILE_METRIC_MANAGER, o -> o.getInnerCompactionTempFileSize(false), new String[]{Tag.NAME.toString(), "inner-unseq-temp"});
        metricService.createAutoGauge(Metric.FILE_SIZE.toString(), MetricLevel.CORE, (Object)TS_FILE_METRIC_MANAGER, TsFileMetricManager::getCrossCompactionTempFileSize, new String[]{Tag.NAME.toString(), "cross-temp"});
        metricService.createAutoGauge(Metric.FILE_COUNT.toString(), MetricLevel.CORE, (Object)TS_FILE_METRIC_MANAGER, o -> o.getInnerCompactionTempFileNum(true), new String[]{Tag.NAME.toString(), "inner-seq-temp"});
        metricService.createAutoGauge(Metric.FILE_COUNT.toString(), MetricLevel.CORE, (Object)TS_FILE_METRIC_MANAGER, o -> o.getInnerCompactionTempFileNum(false), new String[]{Tag.NAME.toString(), "inner-unseq-temp"});
        metricService.createAutoGauge(Metric.FILE_COUNT.toString(), MetricLevel.CORE, (Object)TS_FILE_METRIC_MANAGER, TsFileMetricManager::getCrossCompactionTempFileNum, new String[]{Tag.NAME.toString(), "cross-temp"});
    }

    private void bindSystemRelatedMetrics(AbstractMetricService metricService) {
        if ((METRIC_CONFIG.getSystemType() == SystemType.LINUX || METRIC_CONFIG.getSystemType() == SystemType.MAC) && METRIC_CONFIG.getPid().length() != 0) {
            this.getOpenFileNumberCommand = new String[]{"/bin/sh", "-c", String.format("lsof -p %s | wc -l", METRIC_CONFIG.getPid())};
            metricService.createAutoGauge(Metric.FILE_COUNT.toString(), MetricLevel.IMPORTANT, (Object)this, FileMetrics::getOpenFileHandlersNumber, new String[]{Tag.NAME.toString(), "open_file_handlers"});
        }
    }

    public void unbindFrom(AbstractMetricService metricService) {
        this.unbindTsFileMetrics(metricService);
        this.unbindWalMetrics(metricService);
        this.unbindCompactionMetrics(metricService);
        this.unbindSystemRelatedMetrics(metricService);
    }

    private void unbindTsFileMetrics(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_SIZE.toString(), new String[]{Tag.NAME.toString(), "seq"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_SIZE.toString(), new String[]{Tag.NAME.toString(), "unseq"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_SIZE.toString(), new String[]{Tag.NAME.toString(), "mods"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_COUNT.toString(), new String[]{Tag.NAME.toString(), "seq"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_COUNT.toString(), new String[]{Tag.NAME.toString(), "unseq"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_COUNT.toString(), new String[]{Tag.NAME.toString(), "mods"});
    }

    private void unbindWalMetrics(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_SIZE.toString(), new String[]{Tag.NAME.toString(), "wal"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_COUNT.toString(), new String[]{Tag.NAME.toString(), "wal"});
    }

    private void unbindCompactionMetrics(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_COUNT.toString(), new String[]{Tag.NAME.toString(), "inner-seq-temp"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_COUNT.toString(), new String[]{Tag.NAME.toString(), "inner-unseq-temp"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_COUNT.toString(), new String[]{Tag.NAME.toString(), "cross-temp"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_SIZE.toString(), new String[]{Tag.NAME.toString(), "inner-seq-temp"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_SIZE.toString(), new String[]{Tag.NAME.toString(), "inner-unseq-temp"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_SIZE.toString(), new String[]{Tag.NAME.toString(), "cross-temp"});
    }

    private void unbindSystemRelatedMetrics(AbstractMetricService metricService) {
        if ((METRIC_CONFIG.getSystemType() == SystemType.LINUX || METRIC_CONFIG.getSystemType() == SystemType.MAC) && METRIC_CONFIG.getPid().length() != 0) {
            metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_COUNT.toString(), new String[]{Tag.NAME.toString(), "open_file_handlers"});
        }
    }

    private long getOpenFileHandlersNumber() {
        long fdCount;
        block10: {
            fdCount = 0L;
            try {
                if (METRIC_CONFIG.getSystemType() == SystemType.LINUX) {
                    File fdDir = new File(this.fileHandlerCntPathInLinux);
                    if (fdDir.exists()) {
                        File[] fds = fdDir.listFiles();
                        fdCount = fds == null ? 0L : (long)fds.length;
                    }
                    break block10;
                }
                if (METRIC_CONFIG.getSystemType() != SystemType.MAC || METRIC_CONFIG.getPid().length() == 0) break block10;
                Process process = this.runtime.exec(this.getOpenFileNumberCommand);
                StringBuilder result = new StringBuilder();
                try (BufferedReader input = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                    String line;
                    while ((line = input.readLine()) != null) {
                        result.append(line);
                    }
                }
                fdCount = Long.parseLong(result.toString().trim());
            }
            catch (IOException e) {
                LOGGER.warn("Failed to get open file number, because ", (Throwable)e);
            }
        }
        return fdCount;
    }
}

