/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.influxdb.function.aggregator;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.protocol.influxdb.function.InfluxFunctionValue;
import org.apache.iotdb.db.protocol.influxdb.function.aggregator.InfluxAggregator;
import org.apache.iotdb.db.utils.MathUtils;

public class InfluxMeanFunction
extends InfluxAggregator {
    private final List<Double> numbers = new ArrayList<Double>();
    double sum = 0.0;
    long count = 0L;

    public InfluxMeanFunction(List<Expression> expressionList) {
        super(expressionList);
    }

    @Override
    public InfluxFunctionValue calculateBruteForce() {
        return new InfluxFunctionValue(this.numbers.isEmpty() ? this.numbers : Double.valueOf(MathUtils.mean(this.numbers)), 0L);
    }

    @Override
    public InfluxFunctionValue calculateByIoTDBFunc() {
        return new InfluxFunctionValue(this.count != 0L ? Double.valueOf(this.sum / (double)this.count) : null, this.count != 0L ? Long.valueOf(0L) : null);
    }

    @Override
    public String getFunctionName() {
        return "mean";
    }

    @Override
    public void updateValueBruteForce(InfluxFunctionValue functionValue) {
        Object value = functionValue.getValue();
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException("mean is not a valid type");
        }
        this.numbers.add(((Number)value).doubleValue());
    }

    @Override
    public void updateValueIoTDBFunc(InfluxFunctionValue ... functionValues) {
        if (functionValues.length == 1) {
            this.count += ((Long)functionValues[0].getValue()).longValue();
        } else if (functionValues.length == 2) {
            this.sum += ((Double)functionValues[1].getValue()).doubleValue();
        }
    }
}

