/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.transformation.dag.util;

import java.io.IOException;
import org.apache.iotdb.commons.udf.utils.UDFBinaryTransformer;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.mpp.transformation.api.LayerPointReader;
import org.apache.iotdb.db.mpp.transformation.api.YieldableState;
import org.apache.iotdb.db.mpp.transformation.dag.input.IUDFInputDataSet;
import org.apache.iotdb.db.mpp.transformation.datastructure.row.ElasticSerializableRowRecordList;
import org.apache.iotdb.db.mpp.transformation.datastructure.tv.ElasticSerializableTVList;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;

public class LayerCacheUtils {
    private LayerCacheUtils() {
    }

    public static YieldableState yieldPoints(TSDataType dataType, LayerPointReader source, ElasticSerializableTVList target, int pointNumber) throws Exception {
        for (int count = 0; count < pointNumber; ++count) {
            YieldableState yieldableState = LayerCacheUtils.yieldPoint(dataType, source, target);
            if (yieldableState == YieldableState.YIELDABLE) continue;
            return yieldableState;
        }
        return YieldableState.YIELDABLE;
    }

    public static YieldableState yieldPoint(TSDataType dataType, LayerPointReader source, ElasticSerializableTVList target) throws Exception {
        YieldableState yieldableState = source.yield();
        if (yieldableState != YieldableState.YIELDABLE) {
            return yieldableState;
        }
        if (source.isCurrentNull()) {
            target.putNull(source.currentTime());
        } else {
            switch (dataType) {
                case INT32: {
                    target.putInt(source.currentTime(), source.currentInt());
                    break;
                }
                case INT64: {
                    target.putLong(source.currentTime(), source.currentLong());
                    break;
                }
                case FLOAT: {
                    target.putFloat(source.currentTime(), source.currentFloat());
                    break;
                }
                case DOUBLE: {
                    target.putDouble(source.currentTime(), source.currentDouble());
                    break;
                }
                case BOOLEAN: {
                    target.putBoolean(source.currentTime(), source.currentBoolean());
                    break;
                }
                case TEXT: {
                    target.putBinary(source.currentTime(), UDFBinaryTransformer.transformToUDFBinary((Binary)source.currentBinary()));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(dataType.name());
                }
            }
        }
        source.readyForNext();
        return YieldableState.YIELDABLE;
    }

    public static YieldableState yieldRows(IUDFInputDataSet source, ElasticSerializableRowRecordList target, int rowsNumber) throws Exception {
        for (int count = 0; count < rowsNumber; ++count) {
            YieldableState yieldableState = LayerCacheUtils.yieldRow(source, target);
            if (yieldableState == YieldableState.YIELDABLE) continue;
            return yieldableState;
        }
        return YieldableState.YIELDABLE;
    }

    public static YieldableState yieldRow(IUDFInputDataSet source, ElasticSerializableRowRecordList target) throws Exception {
        YieldableState yieldableState = source.canYieldNextRowInObjects();
        if (yieldableState == YieldableState.YIELDABLE) {
            target.put(source.nextRowInObjects());
        }
        return yieldableState;
    }

    public static int cachePoints(TSDataType dataType, LayerPointReader source, ElasticSerializableTVList target, int pointNumber) throws QueryProcessException, IOException {
        int count;
        for (count = 0; count < pointNumber && LayerCacheUtils.cachePoint(dataType, source, target); ++count) {
        }
        return count;
    }

    public static boolean cachePoint(TSDataType dataType, LayerPointReader source, ElasticSerializableTVList target) throws IOException, QueryProcessException {
        if (!source.next()) {
            return false;
        }
        if (source.isCurrentNull()) {
            target.putNull(source.currentTime());
        } else {
            switch (dataType) {
                case INT32: {
                    target.putInt(source.currentTime(), source.currentInt());
                    break;
                }
                case INT64: {
                    target.putLong(source.currentTime(), source.currentLong());
                    break;
                }
                case FLOAT: {
                    target.putFloat(source.currentTime(), source.currentFloat());
                    break;
                }
                case DOUBLE: {
                    target.putDouble(source.currentTime(), source.currentDouble());
                    break;
                }
                case BOOLEAN: {
                    target.putBoolean(source.currentTime(), source.currentBoolean());
                    break;
                }
                case TEXT: {
                    target.putBinary(source.currentTime(), UDFBinaryTransformer.transformToUDFBinary((Binary)source.currentBinary()));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(dataType.name());
                }
            }
        }
        source.readyForNext();
        return true;
    }

    public static int cacheRows(IUDFInputDataSet source, ElasticSerializableRowRecordList target, int rowsNumber) throws QueryProcessException, IOException {
        int count;
        for (count = 0; count < rowsNumber && LayerCacheUtils.cacheRow(source, target); ++count) {
        }
        return count;
    }

    public static boolean cacheRow(IUDFInputDataSet source, ElasticSerializableRowRecordList target) throws IOException, QueryProcessException {
        if (source.hasNextRowInObjects()) {
            target.put(source.nextRowInObjects());
            return true;
        }
        return false;
    }
}

