/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.transformation.dag.transformer.unary;

import java.io.IOException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.mpp.transformation.api.LayerPointReader;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.unary.UnaryTransformer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class ArithmeticNegationTransformer
extends UnaryTransformer {
    public ArithmeticNegationTransformer(LayerPointReader layerPointReader) {
        super(layerPointReader);
    }

    @Override
    public TSDataType getDataType() {
        return this.layerPointReaderDataType;
    }

    @Override
    protected void transformAndCache() throws QueryProcessException, IOException {
        switch (this.layerPointReaderDataType) {
            case INT32: {
                this.cachedInt = -this.layerPointReader.currentInt();
                break;
            }
            case INT64: {
                this.cachedLong = -this.layerPointReader.currentLong();
                break;
            }
            case FLOAT: {
                this.cachedFloat = -this.layerPointReader.currentFloat();
                break;
            }
            case DOUBLE: {
                this.cachedDouble = -this.layerPointReader.currentDouble();
                break;
            }
            default: {
                throw new QueryProcessException("Unsupported data type: " + this.layerPointReader.getDataType().toString());
            }
        }
    }
}

